# Contract Term Type Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contract Term Type Codes**

## CodeSystem: Contract Term Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/contracttermtypecodes | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ContractTermTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1199 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes sample Contract Term Type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContractTermTypeCodes](ValueSet-contract-term-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "contracttermtypecodes",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/contracttermtypecodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1199"
    }
  ],
  "version" : "1.0.1",
  "name" : "ContractTermTypeCodes",
  "title" : "Contract Term Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes sample Contract Term Type codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/contract-term-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "statutory",
      "display" : "Statutory",
      "definition" : "Based on specialized statutes that deal with particular subjects."
    },
    {
      "code" : "subject-to",
      "display" : "Subject To",
      "definition" : "Execution of the term in the contract is conditional on the execution of other actions."
    }
  ]
}

```
