# ConditionState - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ConditionState**

## CodeSystem: ConditionState 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/condition-state | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ConditionState |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1287 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Enumeration indicating whether the condition is currently active, inactive, or has been resolved. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ConditionState](ValueSet-condition-state.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "condition-state",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/condition-state",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1287"
    }
  ],
  "version" : "1.0.0",
  "name" : "ConditionState",
  "title" : "ConditionState",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Enumeration indicating whether the condition is currently active, inactive, or has been resolved.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/condition-state",
  "content" : "complete",
  "concept" : [
    {
      "code" : "active",
      "display" : "Active",
      "definition" : "The condition is active."
    },
    {
      "code" : "inactive",
      "display" : "Inactive",
      "definition" : "The condition is inactive, but not resolved."
    },
    {
      "code" : "resolved",
      "display" : "Resolved",
      "definition" : "The condition is resolved."
    }
  ]
}

```
