# Claim Care Team Role Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Claim Care Team Role Codes**

## CodeSystem: Claim Care Team Role Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/claimcareteamrole | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ClaimCareTeamRoleCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1165 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Claim roles of the care team members providing products and services. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ClaimCareTeamRoleCodes](ValueSet-claim-careteamrole.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "claimcareteamrole",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/claimcareteamrole",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1165"
    }
  ],
  "version" : "1.0.1",
  "name" : "ClaimCareTeamRoleCodes",
  "title" : "Claim Care Team Role Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Claim roles of the care team members providing products and services.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/claim-careteamrole",
  "content" : "complete",
  "concept" : [
    {
      "code" : "primary",
      "display" : "Primary provider",
      "definition" : "The primary care provider."
    },
    {
      "code" : "assist",
      "display" : "Assisting Provider",
      "definition" : "Assisting care provider."
    },
    {
      "code" : "supervisor",
      "display" : "Supervising Provider",
      "definition" : "Supervising care provider."
    },
    {
      "code" : "attending",
      "display" : "Attending",
      "definition" : "The attending physician."
    },
    {
      "code" : "referring",
      "display" : "Referring",
      "definition" : "The referring provider."
    },
    {
      "code" : "operating",
      "display" : "Operating",
      "definition" : "The operating physician."
    },
    {
      "code" : "otheroperating",
      "display" : "Other Operating",
      "definition" : "The other operating physician."
    },
    {
      "code" : "prescribing",
      "display" : "Prescribing provider",
      "definition" : "The prescribing provider."
    },
    {
      "code" : "purchasedservice",
      "display" : "Purchased Service",
      "definition" : "The provider from which a service was purchased by another provider."
    },
    {
      "code" : "rendering",
      "display" : "Rendering provider",
      "definition" : "The rendering/performing provider."
    },
    {
      "code" : "other",
      "display" : "Other",
      "definition" : "Other role on the care team."
    }
  ]
}

```
