# AuditEventOutcome - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AuditEventOutcome**

## CodeSystem: AuditEventOutcome 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/audit-event-outcome | *Version*:1.0.1 | | |
| Active as of 2024-06-28 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AuditEventOutcome |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.0 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Indicates whether the event succeeded or failed. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AuditEventOutcome](ValueSet-audit-event-outcome.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "audit-event-outcome",
  "meta" : {
    "lastUpdated" : "2024-06-28T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sec"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/audit-event-outcome",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.0"
    }
  ],
  "version" : "1.0.1",
  "name" : "AuditEventOutcome",
  "title" : "AuditEventOutcome",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-06-28T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates whether the event succeeded or failed.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/audit-event-outcome",
  "content" : "complete",
  "concept" : [
    {
      "code" : "0",
      "display" : "Success",
      "definition" : "The operation completed successfully (whether with warnings or not)."
    },
    {
      "code" : "4",
      "display" : "Minor failure",
      "definition" : "The action was not successful due to some kind of minor failure (often equivalent to an HTTP 400 response)."
    },
    {
      "code" : "8",
      "display" : "Serious failure",
      "definition" : "The action was not successful due to some kind of unexpected error (often equivalent to an HTTP 500 response)."
    },
    {
      "code" : "12",
      "display" : "Major failure",
      "definition" : "An error of such magnitude occurred that the system is no longer available for use (i.e. the system died)."
    }
  ]
}

```
