# Artifact Version Policy Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Artifact Version Policy Codes**

## CodeSystem: Artifact Version Policy Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/artifact-version-policy-codes | *Version*:2.0.0 | | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[HL7 International](http://hl7.org) | *Computable Name*:ArtifactVersionPolicyCodes |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The versioning policy of an artifact (metadata, strict, loose, package) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ArtifactVersionPolicy](ValueSet-artifact-version-policy.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "artifact-version-policy-codes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/artifact-version-policy-codes",
  "version" : "2.0.0",
  "name" : "ArtifactVersionPolicyCodes",
  "title" : "Artifact Version Policy Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-13",
  "publisher" : "HL7 International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The versioning policy of an artifact (metadata, strict, loose, package)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/artifact-version-policy",
  "content" : "complete",
  "concept" : [
    {
      "code" : "metadata",
      "display" : "Metadata",
      "definition" : "A versioning policy that allows non-substantive changes to the metadata elements of an artifact without requiring a change to the value of the version element."
    },
    {
      "code" : "strict",
      "display" : "Strict",
      "definition" : "A versioning policy that indicates that any change to the content of an artifact, including non-substantive and metadata changes, requires a change to the value of the version element of the artifact."
    },
    {
      "code" : "loose",
      "display" : "Loose",
      "definition" : "A versioning policy that indicates that only breaking changes require a change to the value of the version element of the artifact."
    },
    {
      "code" : "package",
      "display" : "Package",
      "definition" : "A versioning policy that indicates that version of the artifact is managed as the version of the package in which the artifact appears. This is a common versioning policy often used when artifacts are published as part of an implementation guide, and is important to consider as it indicates that there may be version changes _without_ corresponding changes in the content of a particular artifact. For example, if an implementation guide includes questionnaires, new versions of that implementation guide may include new questionnaires, but not change existing ones, and in this case, with package-managed versions, the existing questionnaires that had no actual changes would still be published with a new version."
    }
  ]
}

```
