# Artifact Identifier Type Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Artifact Identifier Type Codes**

## CodeSystem: Artifact Identifier Type Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/artifact-identifier-type | *Version*:1.0.0 | |
| Active as of 2024-02-20 | *Responsible:*[HL7 International](http://hl7.org) | *Computable Name*:ArtifactIdentifierType |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Identifier types for an artifact (e.g. version-independent, version-specific, short-name, endorser, publisher) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ArtifactIdentifierType](ValueSet-artifact-identifier-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "artifact-identifier-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/artifact-identifier-type",
  "version" : "1.0.0",
  "name" : "ArtifactIdentifierType",
  "title" : "Artifact Identifier Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-02-20",
  "publisher" : "HL7 International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Identifier types for an artifact (e.g. version-independent, version-specific, short-name, endorser, publisher)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/artifact-identifier-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "version-independent",
      "display" : "Version Independent",
      "definition" : "The version independent globally unique identifier (guid) for the artifact."
    },
    {
      "code" : "version-specific",
      "display" : "Version Specific",
      "definition" : "The version specific globally unique identifier (guid) for the artifact."
    },
    {
      "code" : "short-name",
      "display" : "Short Name",
      "definition" : "The short name identifier for the artifact (e.g. CMS104v8)."
    },
    {
      "code" : "endorser",
      "display" : "Endorser",
      "definition" : "The version-independent endorser identifier for the artifact (e.g. 0002)."
    },
    {
      "code" : "publisher",
      "display" : "Publisher",
      "definition" : "The version-independent publisher identifier for the artifact (e.g. 104)."
    }
  ]
}

```
