# Adjudication Error Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Adjudication Error Codes**

## CodeSystem: Adjudication Error Codes (Experimental) 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/adjudication-error | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdjudicationErrorCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1053 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes a smattering of adjudication codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdjudicationErrorCodes](ValueSet-adjudication-error.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "adjudication-error",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/adjudication-error",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1053"
    }
  ],
  "version" : "1.0.1",
  "name" : "AdjudicationErrorCodes",
  "title" : "Adjudication Error Codes",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes a smattering of adjudication codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/adjudication-error",
  "content" : "complete",
  "concept" : [
    {
      "code" : "a001",
      "display" : "Missing Identifier",
      "definition" : "Missing Identifier"
    },
    {
      "code" : "a002",
      "display" : "Missing Creation Date",
      "definition" : "Missing Creation Date"
    }
  ]
}

```
