# Accepting Patients - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Accepting Patients**

## CodeSystem: Accepting Patients 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/accepting-patients | *Version*:1.0.0 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AcceptingPatients |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes that can be used to indicate a practice is accepting new patients. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AcceptingPatients](ValueSet-accepting-patients.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "accepting-patients",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/accepting-patients",
  "version" : "1.0.0",
  "name" : "AcceptingPatients",
  "title" : "Accepting Patients",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes that can be used to indicate a practice is accepting new patients.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/accepting-patients",
  "content" : "complete",
  "concept" : [
    {
      "code" : "nopt",
      "display" : "Not Accepting",
      "definition" : "Not accepting patients"
    },
    {
      "code" : "newpt",
      "display" : "Accepting new and existing patients",
      "definition" : "Accepting new and existing patients"
    },
    {
      "code" : "existptonly",
      "display" : "Accepting existing patients only",
      "definition" : "Accepting existing patients only"
    },
    {
      "code" : "existptfam",
      "display" : "Accepting existing patients and their families only",
      "definition" : "Accepting existing patients and members of their families only"
    }
  ]
}

```
