# Interagency Language Roundtable Speaking Skill Scale - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Interagency Language Roundtable Speaking Skill Scale**

## CodeSystem: Interagency Language Roundtable Speaking Skill Scale 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ILRSpeakingSkillScale | *Version*:May 2021 Edition | |
| Active as of 2024-07-01 | *Responsible:*[Interagency Language Roundtable; Defense Language Institute; 2530 Crystal Drive, Suite 1600, Arlington, VA 22202](https://www.govtilr.org/) | *Computable Name*:ILRSpeakingSkillScale |
| **Copyright/Legal**: The ILR Speaking Skill codes are in the public domain and are free to use without restriction. | | |

 
The following Interagency Language Roundtable (ILR) Skill Level Descriptions (SLDs) describe proficiency as the functional ability to produce spoken language that reflects current usage. The SLDs characterize proficiency ranging from no communicative ability to mastery. They constitute an ordinal scale that includes six ranked base levels from 0 to 5. They illustrate, but do not exhaustively characterize, the proficiency a person may demonstrate at a given level on the scale. 
Control of a base level (Levels 1, 2, 3, 4, and 5) typically implies control of the previous levels' aspects. A higher level of performance in one aspect does not justify a higher general proficiency rating. Level 5 includes the features of all levels. Still, as with all levels, Level 5 is a range and performance will vary. 
There are plus levels for levels 0 through 4. Plus levels describe proficiency that substantially exceeds one base level and does not fully meet the criteria of the next base level. To merit a plus level, the demonstrated proficiency must match the plus level description and not be merely a strong performance at the base level. 
The SLDs describe four aspects of language proficiency: functional ability (color coded green), precision of forms and meanings (red), content meaningfulness (black), and contextual appropriateness (blue). Functional ability refers to the communicative acts or tasks that an individual can accomplish. There are no functional abilities specific to the plus levels. Precision of forms and meanings refers to accuracy, range, and complexity. Content meaningfulness refers to the relevance and substantive coverage of topics. Contextual appropriateness refers to register, acceptability, and appropriateness of language for the intended audience. 
The SLDs are presented in an official prose version as well as a supplementary crosswalk matrix. Each level description begins with a bolded main statement that summarizes the features of that level. Color coded supporting statements follow the main statement and describe the four aspects in detail. The crosswalk matrix shows the structure of the SLDs explicitly across the four skills. 
For more information, including the source content, please see [https://www.govtilr.org/Skills/Speaking.htm](https://www.govtilr.org/Skills/Speaking.htm). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ILRSpeakingSkillScale](ValueSet-ILRSpeakingSkillScale.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ILRSpeakingSkillScale",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/artifact-version",
      "valueString" : "20240701"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ILRSpeakingSkillScale",
  "version" : "May 2021 Edition",
  "name" : "ILRSpeakingSkillScale",
  "title" : "Interagency Language Roundtable Speaking Skill Scale",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-07-01T00:00:00-00:00",
  "publisher" : "Interagency Language Roundtable; Defense Language Institute; 2530 Crystal Drive, Suite 1600, Arlington, VA 22202",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.govtilr.org/"
        },
        {
          "system" : "email",
          "value" : "govtilr@gmail.com"
        },
        {
          "system" : "phone",
          "value" : "703-692-5397"
        }
      ]
    }
  ],
  "description" : "The following Interagency Language Roundtable (ILR) Skill Level Descriptions (SLDs) describe proficiency as the functional ability to produce spoken language that reflects current usage. The SLDs characterize proficiency ranging from no communicative ability to mastery. They constitute an ordinal scale that includes six ranked base levels from 0 to 5. They illustrate, but do not exhaustively characterize, the proficiency a person may demonstrate at a given level on the scale.\r\n\r\nControl of a base level (Levels 1, 2, 3, 4, and 5) typically implies control of the previous levels' aspects. A higher level of performance in one aspect does not justify a higher general proficiency rating. Level 5 includes the features of all levels. Still, as with all levels, Level 5 is a range and performance will vary.\r\n\r\nThere are plus levels for levels 0 through 4. Plus levels describe proficiency that substantially exceeds one base level and does not fully meet the criteria of the next base level. To merit a plus level, the demonstrated proficiency must match the plus level description and not be merely a strong performance at the base level.\r\n\r\nThe SLDs describe four aspects of language proficiency: functional ability (color coded green), precision of forms and meanings (red), content meaningfulness (black), and contextual appropriateness (blue). Functional ability refers to the communicative acts or tasks that an individual can accomplish. There are no functional abilities specific to the plus levels. Precision of forms and meanings refers to accuracy, range, and complexity. Content meaningfulness refers to the relevance and substantive coverage of topics. Contextual appropriateness refers to register, acceptability, and appropriateness of language for the intended audience.\r\n\r\nThe SLDs are presented in an official prose version as well as a supplementary crosswalk matrix. Each level description begins with a bolded main statement that summarizes the features of that level. Color coded supporting statements follow the main statement and describe the four aspects in detail. The crosswalk matrix shows the structure of the SLDs explicitly across the four skills.\r\n\r\nFor more information, including the source content, please see [https://www.govtilr.org/Skills/Speaking.htm](https://www.govtilr.org/Skills/Speaking.htm).",
  "copyright" : "The ILR Speaking Skill codes are in the public domain and are free to use without restriction.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/ILRSpeakingSkillScale",
  "content" : "complete",
  "concept" : [
    {
      "code" : "Level 0",
      "display" : "Unable to speak the language in almost any context.",
      "definition" : "Has essentially no functional communicative ability. Oral production is limited to occasional isolated words."
    },
    {
      "code" : "Level 0+",
      "display" : "Able to produce some memorized, isolated words and phrases with random accuracy and little regard to context.",
      "definition" : "Able to list some simple words and produce minimal exchanges, such as asking formulaic questions and making memorized statements. Most utterances are telegraphic. Has almost no ability to employ organizational or rhetorical devices. Vocabulary is extremely limited and random. Some use of structures may be evident in memorized phrases but has no control of structures otherwise. Pronunciation, stress, intonation, and tone (in tonal languages) are usually quite faulty. Range of topics is extremely limited. Lacks linguistic resources to stay on topic. Utterances are minimal and often insufficient. Has almost no ability to demonstrate cultural appropriateness or to articulate mood, feeling, or emotion. May be able to produce rehearsed expressions of courtesy, greetings, introductions, or isolated instances of politeness. Has almost no ability to manage turn-taking. May exhibit some fluency in prepared material, but long pauses between words and phrases are frequent."
    },
    {
      "code" : "Level 1",
      "display" : "Able to maintain simple exchanges on topics related to self, despite pervasive errors and limited contextual appropriateness.",
      "definition" : "Can conduct daily activities or state in a simple manner action to be taken. Able to formulate some brief questions. Can elicit and provide minimal biographical information. Speaks in disconnected or loosely connected phrases and short sentences with unrehearsed material. With rehearsed material, may be able to produce more coherent discourse. Has little to no ability to employ organizational devices. Vocabulary is frequently inaccurate and generally restricted to the highest frequency items. Little ability to make cultural references. Displays some use of basic structural relations, although errors mark almost every statement; accuracy is limited. Pronunciation, stress, intonation, and tone (in tonal languages) are generally poor and often interfere with communication. Topics are usually limited to self, family, or immediate environment, including basic needs and activities, such as meals, time, simple transactions or directions, or personal information. Often lacks linguistic resources to stay on topic. Conveys basic ideas with little to no details. Demonstrates an extremely limited command of cultural norms and expectations and an extremely limited ability to express register other than in basic courtesy requirements. Little ability to manage turn-taking. Operates mostly in a reactive mode. Cannot easily articulate mood, feeling, or emotion. Often speaks with great difficulty and false starts."
    },
    {
      "code" : "Level 1+",
      "display" : "Able to initiate and maintain simple conversations in areas beyond most basic needs, though inaccurately and not always appropriately.",
      "definition" : "May exhibit some frequently used organizational devices. Usually, cannot sustain cohesiveness in longer utterances. Shows good control of most high frequency vocabulary, but vocabulary is typically inaccurate elsewhere. May make some cultural references. Accuracy in basic grammatical relations is inconsistent. Use of person, place, and time references is often incorrect. Can speak about personal life, such as family and activities, and a limited ability to discuss work or major current events. Sometimes able to speak on topic in routine content, but with limited ability to give details. Shows little ability to apply social norms and etiquette, though may have little command of cultural norms and expectations. Demonstrates some turn-taking management; however, transitions between turns are often abrupt or unnatural. May convey some isolated instances of mood, feeling, or emotion. Pauses may be infrequent on some topics, but speech is typically labored elsewhere."
    },
    {
      "code" : "Level 2",
      "display" : "Able to communicate intended meaning in straightforward, everyday conversations and routine, work-related interactions.",
      "definition" : "Can typically report facts, make simple recommendations, and provide straightforward descriptions, directions, instructions, and narrations across timeframes. Additionally, can participate in everyday interactions and can handle complications in otherwise routine transactions. Speech consists of connected statements that are minimally cohesive yet demonstrates sequencing and linking of phrases. Has some ability to employ frequently used rhetorical devices, such as repetition and exaggeration. Can readily produce high frequency vocabulary that is appropriate for routine interactions, but vocabulary may be unusual, imprecise, or lead to paraphrasing elsewhere. Can sometimes make references to historical or cultural events, such as movies, famous people, books, or major holidays. Generally, has command of simple structures and basic grammatical relations. Errors in complex structures are frequent and may be patterned or cause misunderstanding. Pronunciation occasionally interferes with communication. Can sustain, with some repair, most normal, frequently occurring social conversations, including casual conversations about personal life, such as family, activities, or work, or major current events. Often able to speak on topic in routine content. Can provide some supporting details, but does not always make the message clear or cover the topic thoroughly. Generally, language is culturally awkward. May demonstrate some command of common cultural and social norms, albeit inconsistently. Does not control register shifts. Is often able to manage turn-taking and use some collaborative features in interactions such as topic initiation or development of topics initiated by interlocutor; however, transitions between turns may sometimes be abrupt or unnatural. May be able to verbally convey some mood, feeling, emotion, or position, though not always appropriate to the context. Speaks easily, but at times speech production may be labored."
    },
    {
      "code" : "Level 2+",
      "display" : "Able to communicate fully in many informal and everyday contexts; in some formal and professional contexts, speaks with language that is often, but not always, acceptable and effective.",
      "definition" : "Often communicates a coherent message; however, the message conveyed is not consistently clear or there may be occasional instances of miscommunication. May employ some common rhetorical devices. Uses high frequency and some mid frequency vocabulary but cannot always make appropriate lexical choices. May use some widely used idiomatic expressions and cultural references, though not always accurately. Controls most basic structures. Control of complex structures is limited. Speech may contain awkward or inaccurate phrasing of ideas and mistaken time, space, or person references. Shows considerable ability to communicate effectively on topics relating to interests and special fields of competence. Information conveyed is typically on topic. Generally, provides supporting details, but not consistently. Often shows a high degree of fluency and ease of speech. Is often able to adhere to social norms and etiquette, but not consistently. May be able to fulfill common cultural norms and expectations in routine and some professional interactions. Is almost always able to manage turn-taking and use some collaborative features in interactions such as topic initiation or development of topics initiated by interlocutor. Demonstrates high ability to start turns. Can verbally convey some mood, feeling, emotion, or position, though not consistently."
    },
    {
      "code" : "Level 3",
      "display" : "Able to speak with sufficient accuracy to participate effectively in formal and informal contexts on general social and professional topics and tasks.",
      "definition" : "Can perform a range of tasks, such as discuss and compare societal issues and their implications, state and defend a position or policy, support opinions, hypothesize, elicit information and informed opinion, resolve unexpected situations, or present on a topic. Able to produce cohesive discourse with clear relationships of ideas. May employ some common rhetorical devices, such as simile and metaphor. Uses mid frequency vocabulary that is sufficiently broad to clearly discuss a range of professional matters and abstract or societal issues. May make cultural references or use widely known proverbs and idiomatic expressions. Uses a variety of structures, including basic and some complex structures. In general, basic structures are controlled, though there are occasional structural errors that minimally interfere with communication. Pronunciation, stress, intonation, and tone (in tonal languages) rarely impede communication. Can discuss own interests and fields of competence. Otherwise, linguistic limitations in depth and precision generally restrict language use to matters of general interest. Information conveyed is on topic and supports ideas in a clear manner without much unnecessary information. Able to fulfill common cultural norms and expectations in routine and professional interactions. Speech may be culturally awkward at times. Can usually control formal and informal registers in various settings and has command of most social conventions of conversations. Able to manage turn-taking smoothly and naturally. Can frequently use turn-taking devices such as rapid speaker changes and invitations to participate in turn closings. Assumes joint responsibility in maintaining the interaction. Can convey some mood, feeling, emotion, or position appropriate to the context. Speaks readily, at a rate of speech that does not impede comprehension."
    },
    {
      "code" : "Level 3+",
      "display" : "Able to speak with accuracy using some culturally appropriate language tailored to some audiences on a range of topics.",
      "definition" : "Employs some complex discourse strategies to organize thoughts and present a clear, coherent message. Can use some rhetorical devices for targeted effect or emphasis. Lexicon is broad and includes a range of nuanced words and phrases, with some inaccuracies. Uses some appropriate idiomatic expressions and cultural references. Uses some complex structures although not all are accurate or controlled. Weakness or unevenness in language use may result in loss of precision. Can speak on many professional topics, and to some degree on concepts relating to social, cultural, and theoretical topics. Supports ideas thoroughly without unnecessary information. Able to fulfill some cultural norms and expectations in a variety of interactions, although there may be instances of awkwardness. Controls formal and informal registers and can sometimes use register to tailor the message or make it more effective. Is sometimes able to engage with interlocutor's contributions and develop a joint discourse. Mood, feeling, emotion, or stance sometimes enhances the message conveyed. Often speaks effortlessly and smoothly."
    },
    {
      "code" : "Level 4",
      "display" : "Able to speak with considerable precision using culturally appropriate language tailored to a variety of audiences on a wide range of topics.",
      "definition" : "Can advise, persuade, negotiate, or counsel effectively. Can participate in or give a formal speech at a conference, lecture, or debate. Can advocate a position at length and represent a point of view other than one’s own, both in prepared and unprepared remarks. Employs discourse strategies to organize thoughts and present them in a convincing manner, such as appropriate rhetorical speech devices or intentional shifts of topic and tone. Can use many rhetorical devices for targeted effect or emphasis. Vocabulary is consistently extensive and includes low frequency items. Uses cultural references appropriately to further an argument or add emphasis. Controls many complex structures, including complex embedding. Errors are sporadic and may be part of acceptable language use in certain contexts. Pronunciation, stress, intonation, and tone (in tonal languages) do not hinder communication. Can speak on many social, cultural, and theoretical topics, including those which do not bear directly on a professional specialty. May incorporate another relevant topic or make additional informative points to present a broader view. Presents information to support ideas clearly and extensively. Able to fulfill many cultural norms and expectations in a variety of interactions, although there may be instances of awkwardness. Demonstrates an ability to shift register or tailor speech to meet many situational norms and expectations, though may not sustain shifts under all circumstances. Adheres to most social conventions of conversations and presentations. Able to engage with interlocutor's contributions and develop a joint discourse. Is generally able to verbally convey mood, feeling, emotion, or stance to add effect, such as emphasis, certainty, uncertainty, or authority. Speaks effortlessly and smoothly."
    },
    {
      "code" : "Level 4+",
      "display" : "Able to speak with precision, using diverse linguistic resources to produce articulate, tailored, and nuanced language in most contexts with only rare mistakes.",
      "definition" : "Uses discourse strategies flexibly to enhance the effectiveness of the message conveyed. Employs a wide range of rhetorical devices. Incorporates nuanced phrasing and low frequency vocabulary that are rarely imprecise, but sometimes with weaknesses, for example in idioms, colloquialisms, or cultural references. Has a wide range and control of complex structures, including complex embedding. Makes few mistakes. Can address most topics to some extent. Can elaborate on the implications of most societal issues. Able to fulfill most cultural norms and expectations in a variety of interactions, although there may be rare instances of awkwardness. Shifts register and tailors speech to provide convincing arguments on most occasions. No further expectations for turn taking. Mood, feeling, emotion, or stance usually enhances the message conveyed. Uses the language with flexibility."
    },
    {
      "code" : "Level 5",
      "display" : "Able to speak with clarity of expression and precision, using diverse linguistic resources to produce articulate, nuanced, and engaging language in almost any context.",
      "definition" : "Can set the tone of interpersonal official, semi-official and non-professional verbal exchanges for varied audiences, purposes, tasks, and settings. Can effectively weave together different concepts to create novel ideas and perspectives. Demonstrates a mastery of the language. Employs a wide range of rhetorical devices exceptionally well to achieve a desired goal or effect. Able to speak in an articulate and precise manner, although the rare error may occur. Demonstrates a precise and extensive control of nuanced, low frequency vocabulary, as well as idioms, colloquialisms, and cultural references. Controls almost all structures of the language at all levels. Can elaborate extensively on the implications of many topics and address almost any topic to some extent. Information presented is relevant and often incorporates other topics to present a broader view or new perspective. Presents information to support ideas clearly, thoroughly, and concisely. Able to fulfill cultural norms and expectations in a wide variety of interactions. Can tailor speech skillfully to an audience, shifting between registers for effect and impact. Able to articulate mood, feeling, emotion, or stance effectively to set a mood, persuade the listener, or produce an emotional response. Can use intonation, tone, stress patterns, humor, and other features to add emphasis, certainty, uncertainty, authority, or other stances. Uses the language with complete flexibility."
    }
  ]
}

```
