#  - HL7 Terminology (THO) v7.0.1

## : 



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "hxutg1-1-0-6",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1e-utg-concept-properties-cs-1-0-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1e-utg-concept-properties-cs-1-0-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1e-utg-concept-properties-cs-1-0-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1e-utg-concept-properties-cs-1-0-6</b></p><a name=\"hx1e-utg-concept-properties-cs-1-0-6\"> </a><a name=\"hchx1e-utg-concept-properties-cs-1-0-6\"> </a><p>Provenance for <a href=\"CodeSystem-utg-concept-properties.html\">CodeSystem UTG Specific Concept Properties</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-05-18</td></tr><tr><td>Recorded</td><td>2020-05-18 16:10:37+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/utg-concept-properties"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-05-18"
        },
        "recorded" : "2020-05-18T16:10:37+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix the v2 tables status property name"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1e-v2-tables-cs-1-0-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1e-v2-tables-cs-1-0-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1e-v2-tables-cs-1-0-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1e-v2-tables-cs-1-0-6</b></p><a name=\"hx1e-v2-tables-cs-1-0-6\"> </a><a name=\"hchx1e-v2-tables-cs-1-0-6\"> </a><p>Provenance for <a href=\"CodeSystem-v2-tables.html\">CodeSystem V2 Table List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-05-18</td></tr><tr><td>Recorded</td><td>2020-05-18 16:13:24+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-tables"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-05-18"
        },
        "recorded" : "2020-05-18T16:13:24+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix the v2 tables status property name, and add a code system version"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1e-icd10-ns-1-0-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1e-icd10-ns-1-0-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1e-icd10-ns-1-0-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1e-icd10-ns-1-0-6</b></p><a name=\"hx1e-icd10-ns-1-0-6\"> </a><a name=\"hchx1e-icd10-ns-1-0-6\"> </a><p>Provenance for <a href=\"NamingSystem-icd10.html\">NamingSystem ICD-10</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-05-19</td></tr><tr><td>Recorded</td><td>2020-05-19 09:13:24+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd10"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-05-19"
        },
        "recorded" : "2020-05-19T09:13:24+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add the additional identifier IDs."
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1e-nic-ns-1-0-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1e-nic-ns-1-0-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1e-nic-ns-1-0-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1e-nic-ns-1-0-6</b></p><a name=\"hx1e-nic-ns-1-0-6\"> </a><a name=\"hchx1e-nic-ns-1-0-6\"> </a><p>Provenance for <a href=\"NamingSystem-nic.html\">NamingSystem Nursing Intervention Classification</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-05-26</td></tr><tr><td>Recorded</td><td>2020-05-26 15:14:45+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/nic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-05-26"
        },
        "recorded" : "2020-05-26T15:14:45+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add corrected canonical URL."
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1e-ICD10dut-ns-1-1-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1e-ICD10dut-ns-1-1-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1e-ICD10dut-ns-1-1-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1e-ICD10dut-ns-1-1-8</b></p><a name=\"hx1e-ICD10dut-ns-1-1-8\"> </a><a name=\"hchx1e-ICD10dut-ns-1-1-8\"> </a><p>Provenance for <a href=\"NamingSystem-ICD10dut.html\">NamingSystem ICD10, Dutch Translation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-06-04</td></tr><tr><td>Recorded</td><td>2020-06-04 15:41:53+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICD10dut"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-06-04"
        },
        "recorded" : "2020-06-04T15:41:53+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update to oomments on URI entries"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-action-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-action-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-action-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-action-type</b></p><a name=\"hx-fhir-1.0.51-cs-action-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-action-type\"> </a><p>Provenance for <a href=\"CodeSystem-action-type.html\">CodeSystem ActionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/action-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-activity-definition-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-activity-definition-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-activity-definition-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-activity-definition-category</b></p><a name=\"hx-fhir-1.0.51-cs-activity-definition-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-activity-definition-category\"> </a><p>Provenance for <a href=\"CodeSystem-activity-definition-category.html\">CodeSystem ActivityDefinitionCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/activity-definition-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-adjudication-error",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-adjudication-error",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-adjudication-error\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-adjudication-error</b></p><a name=\"hx-fhir-1.0.51-cs-adjudication-error\"> </a><a name=\"hchx-fhir-1.0.51-cs-adjudication-error\"> </a><p>Provenance for <a href=\"CodeSystem-adjudication-error.html\">CodeSystem Adjudication Error Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adjudication-error"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-adjudication-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-adjudication-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-adjudication-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-adjudication-reason</b></p><a name=\"hx-fhir-1.0.51-cs-adjudication-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-adjudication-reason\"> </a><p>Provenance for <a href=\"CodeSystem-adjudication-reason.html\">CodeSystem Adjudication Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adjudication-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-adjudication",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-adjudication",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-adjudication\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-adjudication</b></p><a name=\"hx-fhir-1.0.51-cs-adjudication\"> </a><a name=\"hchx-fhir-1.0.51-cs-adjudication\"> </a><p>Provenance for <a href=\"CodeSystem-adjudication.html\">CodeSystem Adjudication Value Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adjudication"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-admit-source",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-admit-source",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-admit-source\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-admit-source</b></p><a name=\"hx-fhir-1.0.51-cs-admit-source\"> </a><a name=\"hchx-fhir-1.0.51-cs-admit-source\"> </a><p>Provenance for <a href=\"CodeSystem-admit-source.html\">CodeSystem Admit source</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/admit-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-adverse-event-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-adverse-event-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-adverse-event-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-adverse-event-category</b></p><a name=\"hx-fhir-1.0.51-cs-adverse-event-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-adverse-event-category\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-category.html\">CodeSystem AdverseEventCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-adverse-event-causality-assess",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-adverse-event-causality-assess",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-adverse-event-causality-assess\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-adverse-event-causality-assess</b></p><a name=\"hx-fhir-1.0.51-cs-adverse-event-causality-assess\"> </a><a name=\"hchx-fhir-1.0.51-cs-adverse-event-causality-assess\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-causality-assess.html\">CodeSystem AdverseEventCausalityAssessment</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-causality-assess"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-adverse-event-causality-method",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-adverse-event-causality-method",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-adverse-event-causality-method\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-adverse-event-causality-method</b></p><a name=\"hx-fhir-1.0.51-cs-adverse-event-causality-method\"> </a><a name=\"hchx-fhir-1.0.51-cs-adverse-event-causality-method\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-causality-method.html\">CodeSystem AdverseEventCausalityMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-causality-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-adverse-event-seriousness",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-adverse-event-seriousness",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-adverse-event-seriousness\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-adverse-event-seriousness</b></p><a name=\"hx-fhir-1.0.51-cs-adverse-event-seriousness\"> </a><a name=\"hchx-fhir-1.0.51-cs-adverse-event-seriousness\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-seriousness.html\">CodeSystem AdverseEventSeriousness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-seriousness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-adverse-event-severity",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-adverse-event-severity",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-adverse-event-severity\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-adverse-event-severity</b></p><a name=\"hx-fhir-1.0.51-cs-adverse-event-severity\"> </a><a name=\"hchx-fhir-1.0.51-cs-adverse-event-severity\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-severity.html\">CodeSystem AdverseEventSeverity</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-severity"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-allerg-intol-substance-exp-risk",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-allerg-intol-substance-exp-risk",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-allerg-intol-substance-exp-risk\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-allerg-intol-substance-exp-risk</b></p><a name=\"hx-fhir-1.0.51-cs-allerg-intol-substance-exp-risk\"> </a><a name=\"hchx-fhir-1.0.51-cs-allerg-intol-substance-exp-risk\"> </a><p>Provenance for <a href=\"CodeSystem-allerg-intol-substance-exp-risk.html\">CodeSystem AllergyIntoleranceSubstanceExposureRisk</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/allerg-intol-substance-exp-risk"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-allergyintolerance-clinical",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-allergyintolerance-clinical",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-allergyintolerance-clinical\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-allergyintolerance-clinical</b></p><a name=\"hx-fhir-1.0.51-cs-allergyintolerance-clinical\"> </a><a name=\"hchx-fhir-1.0.51-cs-allergyintolerance-clinical\"> </a><p>Provenance for <a href=\"CodeSystem-allergyintolerance-clinical.html\">CodeSystem AllergyIntolerance Clinical Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/allergyintolerance-clinical"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-allergyintolerance-verification",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-allergyintolerance-verification",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-allergyintolerance-verification\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-allergyintolerance-verification</b></p><a name=\"hx-fhir-1.0.51-cs-allergyintolerance-verification\"> </a><a name=\"hchx-fhir-1.0.51-cs-allergyintolerance-verification\"> </a><p>Provenance for <a href=\"CodeSystem-allergyintolerance-verification.html\">CodeSystem AllergyIntolerance Verification Status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/allergyintolerance-verification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-applicability",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-applicability",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-applicability\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-applicability</b></p><a name=\"hx-fhir-1.0.51-cs-applicability\"> </a><a name=\"hchx-fhir-1.0.51-cs-applicability\"> </a><p>Provenance for <a href=\"CodeSystem-applicability.html\">CodeSystem Benefit cost applicability</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/applicability"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-appointment-cancellation-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-appointment-cancellation-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-appointment-cancellation-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-appointment-cancellation-reason</b></p><a name=\"hx-fhir-1.0.51-cs-appointment-cancellation-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-appointment-cancellation-reason\"> </a><p>Provenance for <a href=\"CodeSystem-appointment-cancellation-reason.html\">CodeSystem Appointment cancellation reason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/appointment-cancellation-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-attribute-estimate-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-attribute-estimate-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-attribute-estimate-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-attribute-estimate-type</b></p><a name=\"hx-fhir-1.0.51-cs-attribute-estimate-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-attribute-estimate-type\"> </a><p>Provenance for <a href=\"CodeSystem-attribute-estimate-type.html\">CodeSystem StatisticAttribute Estimate Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/attribute-estimate-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-audit-entity-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-audit-entity-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-audit-entity-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-audit-entity-type</b></p><a name=\"hx-fhir-1.0.51-cs-audit-entity-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-audit-entity-type\"> </a><p>Provenance for <a href=\"CodeSystem-audit-entity-type.html\">CodeSystem Audit event entity type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/audit-entity-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-audit-event-outcome",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-audit-event-outcome",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-audit-event-outcome\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-audit-event-outcome</b></p><a name=\"hx-fhir-1.0.51-cs-audit-event-outcome\"> </a><a name=\"hchx-fhir-1.0.51-cs-audit-event-outcome\"> </a><p>Provenance for <a href=\"CodeSystem-audit-event-outcome.html\">CodeSystem AuditEventOutcome</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/audit-event-outcome"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-audit-event-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-audit-event-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-audit-event-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-audit-event-type</b></p><a name=\"hx-fhir-1.0.51-cs-audit-event-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-audit-event-type\"> </a><p>Provenance for <a href=\"CodeSystem-audit-event-type.html\">CodeSystem Audit Event ID</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/audit-event-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-basic-resource-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-basic-resource-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-basic-resource-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-basic-resource-type</b></p><a name=\"hx-fhir-1.0.51-cs-basic-resource-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-basic-resource-type\"> </a><p>Provenance for <a href=\"CodeSystem-basic-resource-type.html\">CodeSystem Basic Resource Types</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/basic-resource-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-benefit-network",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-benefit-network",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-benefit-network\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-benefit-network</b></p><a name=\"hx-fhir-1.0.51-cs-benefit-network\"> </a><a name=\"hchx-fhir-1.0.51-cs-benefit-network\"> </a><p>Provenance for <a href=\"CodeSystem-benefit-network.html\">CodeSystem Network Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/benefit-network"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-benefit-term",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-benefit-term",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-benefit-term\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-benefit-term</b></p><a name=\"hx-fhir-1.0.51-cs-benefit-term\"> </a><a name=\"hchx-fhir-1.0.51-cs-benefit-term\"> </a><p>Provenance for <a href=\"CodeSystem-benefit-term.html\">CodeSystem Benefit Term Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/benefit-term"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-benefit-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-benefit-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-benefit-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-benefit-type</b></p><a name=\"hx-fhir-1.0.51-cs-benefit-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-benefit-type\"> </a><p>Provenance for <a href=\"CodeSystem-benefit-type.html\">CodeSystem Benefit Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/benefit-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-benefit-unit",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-benefit-unit",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-benefit-unit\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-benefit-unit</b></p><a name=\"hx-fhir-1.0.51-cs-benefit-unit\"> </a><a name=\"hchx-fhir-1.0.51-cs-benefit-unit\"> </a><p>Provenance for <a href=\"CodeSystem-benefit-unit.html\">CodeSystem Unit Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/benefit-unit"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-can-push-updates",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-can-push-updates",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-can-push-updates\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-can-push-updates</b></p><a name=\"hx-fhir-1.0.51-cs-can-push-updates\"> </a><a name=\"hchx-fhir-1.0.51-cs-can-push-updates\"> </a><p>Provenance for <a href=\"CodeSystem-can-push-updates.html\">CodeSystem Can-push-updates</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/can-push-updates"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-catalogType",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-catalogType",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-catalogType\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-catalogType</b></p><a name=\"hx-fhir-1.0.51-cs-catalogType\"> </a><a name=\"hchx-fhir-1.0.51-cs-catalogType\"> </a><p>Provenance for <a href=\"CodeSystem-catalogType.html\">CodeSystem CatalogType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/catalogType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-certainty-rating",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-certainty-rating",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-certainty-rating\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-certainty-rating</b></p><a name=\"hx-fhir-1.0.51-cs-certainty-rating\"> </a><a name=\"hchx-fhir-1.0.51-cs-certainty-rating\"> </a><p>Provenance for <a href=\"CodeSystem-certainty-rating.html\">CodeSystem StatisticCertaintyRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/certainty-rating"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-certainty-subcomponent-rating",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-certainty-subcomponent-rating",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-certainty-subcomponent-rating\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-certainty-subcomponent-rating</b></p><a name=\"hx-fhir-1.0.51-cs-certainty-subcomponent-rating\"> </a><a name=\"hchx-fhir-1.0.51-cs-certainty-subcomponent-rating\"> </a><p>Provenance for <a href=\"CodeSystem-certainty-subcomponent-rating.html\">CodeSystem StatisticCertaintySubcomponentRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/certainty-subcomponent-rating"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-certainty-subcomponent-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-certainty-subcomponent-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-certainty-subcomponent-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-certainty-subcomponent-type</b></p><a name=\"hx-fhir-1.0.51-cs-certainty-subcomponent-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-certainty-subcomponent-type\"> </a><p>Provenance for <a href=\"CodeSystem-certainty-subcomponent-type.html\">CodeSystem StatisticCertaintySubcomponentType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/certainty-subcomponent-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-characteristic-method",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-characteristic-method",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-characteristic-method\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-characteristic-method</b></p><a name=\"hx-fhir-1.0.51-cs-characteristic-method\"> </a><a name=\"hchx-fhir-1.0.51-cs-characteristic-method\"> </a><p>Provenance for <a href=\"CodeSystem-characteristic-method.html\">CodeSystem CharacteristicMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/characteristic-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-chargeitem-billingcodes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-chargeitem-billingcodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-chargeitem-billingcodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-chargeitem-billingcodes</b></p><a name=\"hx-fhir-1.0.51-cs-chargeitem-billingcodes\"> </a><a name=\"hchx-fhir-1.0.51-cs-chargeitem-billingcodes\"> </a><p>Provenance for <a href=\"CodeSystem-chargeitem-billingcodes.html\">CodeSystem ChargeItemCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/chargeitem-billingcodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-choice-list-orientation",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-choice-list-orientation",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-choice-list-orientation\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-choice-list-orientation</b></p><a name=\"hx-fhir-1.0.51-cs-choice-list-orientation\"> </a><a name=\"hchx-fhir-1.0.51-cs-choice-list-orientation\"> </a><p>Provenance for <a href=\"CodeSystem-choice-list-orientation.html\">CodeSystem ChoiceListOrientation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/choice-list-orientation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-chromosome-human",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-chromosome-human",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-chromosome-human\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-chromosome-human</b></p><a name=\"hx-fhir-1.0.51-cs-chromosome-human\"> </a><a name=\"hchx-fhir-1.0.51-cs-chromosome-human\"> </a><p>Provenance for <a href=\"CodeSystem-chromosome-human.html\">CodeSystem chromosome-human</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/chromosome-human"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-claim-exception",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-claim-exception",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-claim-exception\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-claim-exception</b></p><a name=\"hx-fhir-1.0.51-cs-claim-exception\"> </a><a name=\"hchx-fhir-1.0.51-cs-claim-exception\"> </a><p>Provenance for <a href=\"CodeSystem-claim-exception.html\">CodeSystem Exception Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/claim-exception"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-claim-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-claim-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-claim-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-claim-type</b></p><a name=\"hx-fhir-1.0.51-cs-claim-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-claim-type\"> </a><p>Provenance for <a href=\"CodeSystem-claim-type.html\">CodeSystem Claim Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/claim-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-claimcareteamrole",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-claimcareteamrole",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-claimcareteamrole\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-claimcareteamrole</b></p><a name=\"hx-fhir-1.0.51-cs-claimcareteamrole\"> </a><a name=\"hchx-fhir-1.0.51-cs-claimcareteamrole\"> </a><p>Provenance for <a href=\"CodeSystem-claimcareteamrole.html\">CodeSystem Claim Care Team Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/claimcareteamrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-claiminformationcategory",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-claiminformationcategory",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-claiminformationcategory\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-claiminformationcategory</b></p><a name=\"hx-fhir-1.0.51-cs-claiminformationcategory\"> </a><a name=\"hchx-fhir-1.0.51-cs-claiminformationcategory\"> </a><p>Provenance for <a href=\"CodeSystem-claiminformationcategory.html\">CodeSystem Claim Information Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/claiminformationcategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-codesystem-altcode-kind",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-codesystem-altcode-kind",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-codesystem-altcode-kind\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-codesystem-altcode-kind</b></p><a name=\"hx-fhir-1.0.51-cs-codesystem-altcode-kind\"> </a><a name=\"hchx-fhir-1.0.51-cs-codesystem-altcode-kind\"> </a><p>Provenance for <a href=\"CodeSystem-codesystem-altcode-kind.html\">CodeSystem AlternativeCodeKind</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/codesystem-altcode-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-common-tags",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-common-tags",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-common-tags\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-common-tags</b></p><a name=\"hx-fhir-1.0.51-cs-common-tags\"> </a><a name=\"hchx-fhir-1.0.51-cs-common-tags\"> </a><p>Provenance for <a href=\"CodeSystem-common-tags.html\">CodeSystem Common Tags</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/common-tags"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-communication-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-communication-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-communication-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-communication-category</b></p><a name=\"hx-fhir-1.0.51-cs-communication-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-communication-category\"> </a><p>Provenance for <a href=\"CodeSystem-communication-category.html\">CodeSystem CommunicationCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/communication-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-communication-not-done-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-communication-not-done-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-communication-not-done-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-communication-not-done-reason</b></p><a name=\"hx-fhir-1.0.51-cs-communication-not-done-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-communication-not-done-reason\"> </a><p>Provenance for <a href=\"CodeSystem-communication-not-done-reason.html\">CodeSystem CommunicationNotDoneReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/communication-not-done-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-communication-topic",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-communication-topic",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-communication-topic\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-communication-topic</b></p><a name=\"hx-fhir-1.0.51-cs-communication-topic\"> </a><a name=\"hchx-fhir-1.0.51-cs-communication-topic\"> </a><p>Provenance for <a href=\"CodeSystem-communication-topic.html\">CodeSystem CommunicationTopic</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/communication-topic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-composite-measure-scoring",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-composite-measure-scoring",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-composite-measure-scoring\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-composite-measure-scoring</b></p><a name=\"hx-fhir-1.0.51-cs-composite-measure-scoring\"> </a><a name=\"hchx-fhir-1.0.51-cs-composite-measure-scoring\"> </a><p>Provenance for <a href=\"CodeSystem-composite-measure-scoring.html\">CodeSystem CompositeMeasureScoring</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/composite-measure-scoring"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-composition-altcode-kind",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-composition-altcode-kind",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-composition-altcode-kind\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-composition-altcode-kind</b></p><a name=\"hx-fhir-1.0.51-cs-composition-altcode-kind\"> </a><a name=\"hchx-fhir-1.0.51-cs-composition-altcode-kind\"> </a><p>Provenance for <a href=\"CodeSystem-composition-altcode-kind.html\">CodeSystem AlternativeCodeKind</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/composition-altcode-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-condition-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-condition-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-condition-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-condition-category</b></p><a name=\"hx-fhir-1.0.51-cs-condition-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-condition-category\"> </a><p>Provenance for <a href=\"CodeSystem-condition-category.html\">CodeSystem Condition Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/condition-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-condition-clinical",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-condition-clinical",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-condition-clinical\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-condition-clinical</b></p><a name=\"hx-fhir-1.0.51-cs-condition-clinical\"> </a><a name=\"hchx-fhir-1.0.51-cs-condition-clinical\"> </a><p>Provenance for <a href=\"CodeSystem-condition-clinical.html\">CodeSystem Condition Clinical Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/condition-clinical"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-condition-state",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-condition-state",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-condition-state\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-condition-state</b></p><a name=\"hx-fhir-1.0.51-cs-condition-state\"> </a><a name=\"hchx-fhir-1.0.51-cs-condition-state\"> </a><p>Provenance for <a href=\"CodeSystem-condition-state.html\">CodeSystem ConditionState</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/condition-state"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-condition-ver-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-condition-ver-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-condition-ver-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-condition-ver-status</b></p><a name=\"hx-fhir-1.0.51-cs-condition-ver-status\"> </a><a name=\"hchx-fhir-1.0.51-cs-condition-ver-status\"> </a><p>Provenance for <a href=\"CodeSystem-condition-ver-status.html\">CodeSystem ConditionVerificationStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/condition-ver-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-conformance-expectation",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-conformance-expectation",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-conformance-expectation\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-conformance-expectation</b></p><a name=\"hx-fhir-1.0.51-cs-conformance-expectation\"> </a><a name=\"hchx-fhir-1.0.51-cs-conformance-expectation\"> </a><p>Provenance for <a href=\"CodeSystem-conformance-expectation.html\">CodeSystem ConformanceExpectation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/conformance-expectation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-consentaction",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-consentaction",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-consentaction\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-consentaction</b></p><a name=\"hx-fhir-1.0.51-cs-consentaction\"> </a><a name=\"hchx-fhir-1.0.51-cs-consentaction\"> </a><p>Provenance for <a href=\"CodeSystem-consentaction.html\">CodeSystem Consent Action Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentaction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-consentcategorycodes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-consentcategorycodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-consentcategorycodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-consentcategorycodes</b></p><a name=\"hx-fhir-1.0.51-cs-consentcategorycodes\"> </a><a name=\"hchx-fhir-1.0.51-cs-consentcategorycodes\"> </a><p>Provenance for <a href=\"CodeSystem-consentcategorycodes.html\">CodeSystem Consent Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentcategorycodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-consentpolicycodes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-consentpolicycodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-consentpolicycodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-consentpolicycodes</b></p><a name=\"hx-fhir-1.0.51-cs-consentpolicycodes\"> </a><a name=\"hchx-fhir-1.0.51-cs-consentpolicycodes\"> </a><p>Provenance for <a href=\"CodeSystem-consentpolicycodes.html\">CodeSystem Consent PolicyRule Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentpolicycodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-consentscope",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-consentscope",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-consentscope\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-consentscope</b></p><a name=\"hx-fhir-1.0.51-cs-consentscope\"> </a><a name=\"hchx-fhir-1.0.51-cs-consentscope\"> </a><p>Provenance for <a href=\"CodeSystem-consentscope.html\">CodeSystem Consent Scope Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentscope"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-consentverification",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-consentverification",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-consentverification\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-consentverification</b></p><a name=\"hx-fhir-1.0.51-cs-consentverification\"> </a><a name=\"hchx-fhir-1.0.51-cs-consentverification\"> </a><p>Provenance for <a href=\"CodeSystem-consentverification.html\">CodeSystem Consent Verification Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentverification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contactentity-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contactentity-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contactentity-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contactentity-type</b></p><a name=\"hx-fhir-1.0.51-cs-contactentity-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-contactentity-type\"> </a><p>Provenance for <a href=\"CodeSystem-contactentity-type.html\">CodeSystem Contact entity type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contactentity-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-container-cap",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-container-cap",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-container-cap\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-container-cap</b></p><a name=\"hx-fhir-1.0.51-cs-container-cap\"> </a><a name=\"hchx-fhir-1.0.51-cs-container-cap\"> </a><p>Provenance for <a href=\"CodeSystem-container-cap.html\">CodeSystem ContainerCap</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/container-cap"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contract-content-derivative",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contract-content-derivative",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contract-content-derivative\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contract-content-derivative</b></p><a name=\"hx-fhir-1.0.51-cs-contract-content-derivative\"> </a><a name=\"hchx-fhir-1.0.51-cs-contract-content-derivative\"> </a><p>Provenance for <a href=\"CodeSystem-contract-content-derivative.html\">CodeSystem Contract Content Derivation Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contract-content-derivative"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contract-data-meaning",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contract-data-meaning",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contract-data-meaning\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contract-data-meaning</b></p><a name=\"hx-fhir-1.0.51-cs-contract-data-meaning\"> </a><a name=\"hchx-fhir-1.0.51-cs-contract-data-meaning\"> </a><p>Provenance for <a href=\"CodeSystem-contract-data-meaning.html\">CodeSystem ContractDataMeaning</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contract-data-meaning"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contract-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contract-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contract-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contract-type</b></p><a name=\"hx-fhir-1.0.51-cs-contract-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-contract-type\"> </a><p>Provenance for <a href=\"CodeSystem-contract-type.html\">CodeSystem Contract Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contract-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contractaction",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contractaction",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contractaction\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contractaction</b></p><a name=\"hx-fhir-1.0.51-cs-contractaction\"> </a><a name=\"hchx-fhir-1.0.51-cs-contractaction\"> </a><p>Provenance for <a href=\"CodeSystem-contractaction.html\">CodeSystem Contract Action Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contractaction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contractactorrole",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contractactorrole",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contractactorrole\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contractactorrole</b></p><a name=\"hx-fhir-1.0.51-cs-contractactorrole\"> </a><a name=\"hchx-fhir-1.0.51-cs-contractactorrole\"> </a><p>Provenance for <a href=\"CodeSystem-contractactorrole.html\">CodeSystem Contract Actor Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contractactorrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contractsignertypecodes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contractsignertypecodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contractsignertypecodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contractsignertypecodes</b></p><a name=\"hx-fhir-1.0.51-cs-contractsignertypecodes\"> </a><a name=\"hchx-fhir-1.0.51-cs-contractsignertypecodes\"> </a><p>Provenance for <a href=\"CodeSystem-contractsignertypecodes.html\">CodeSystem Contract Signer Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contractsignertypecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contractsubtypecodes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contractsubtypecodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contractsubtypecodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contractsubtypecodes</b></p><a name=\"hx-fhir-1.0.51-cs-contractsubtypecodes\"> </a><a name=\"hchx-fhir-1.0.51-cs-contractsubtypecodes\"> </a><p>Provenance for <a href=\"CodeSystem-contractsubtypecodes.html\">CodeSystem Contract Subtype Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contractsubtypecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contracttermsubtypecodes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contracttermsubtypecodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contracttermsubtypecodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contracttermsubtypecodes</b></p><a name=\"hx-fhir-1.0.51-cs-contracttermsubtypecodes\"> </a><a name=\"hchx-fhir-1.0.51-cs-contracttermsubtypecodes\"> </a><p>Provenance for <a href=\"CodeSystem-contracttermsubtypecodes.html\">CodeSystem Contract Term Subtype Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contracttermsubtypecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-contracttermtypecodes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-contracttermtypecodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-contracttermtypecodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-contracttermtypecodes</b></p><a name=\"hx-fhir-1.0.51-cs-contracttermtypecodes\"> </a><a name=\"hchx-fhir-1.0.51-cs-contracttermtypecodes\"> </a><p>Provenance for <a href=\"CodeSystem-contracttermtypecodes.html\">CodeSystem Contract Term Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contracttermtypecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-copy-number-event",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-copy-number-event",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-copy-number-event\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-copy-number-event</b></p><a name=\"hx-fhir-1.0.51-cs-copy-number-event\"> </a><a name=\"hchx-fhir-1.0.51-cs-copy-number-event\"> </a><p>Provenance for <a href=\"CodeSystem-copy-number-event.html\">CodeSystem CopyNumberEvent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/copy-number-event"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-coverage-class",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-coverage-class",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-coverage-class\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-coverage-class</b></p><a name=\"hx-fhir-1.0.51-cs-coverage-class\"> </a><a name=\"hchx-fhir-1.0.51-cs-coverage-class\"> </a><p>Provenance for <a href=\"CodeSystem-coverage-class.html\">CodeSystem Coverage Class Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/coverage-class"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-coverage-copay-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-coverage-copay-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-coverage-copay-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-coverage-copay-type</b></p><a name=\"hx-fhir-1.0.51-cs-coverage-copay-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-coverage-copay-type\"> </a><p>Provenance for <a href=\"CodeSystem-coverage-copay-type.html\">CodeSystem Coverage Copay Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/coverage-copay-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-coverage-selfpay",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-coverage-selfpay",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-coverage-selfpay\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-coverage-selfpay</b></p><a name=\"hx-fhir-1.0.51-cs-coverage-selfpay\"> </a><a name=\"hchx-fhir-1.0.51-cs-coverage-selfpay\"> </a><p>Provenance for <a href=\"CodeSystem-coverage-selfpay.html\">CodeSystem Coverage SelfPay Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/coverage-selfpay"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-coverageeligibilityresponse-ex-auth-support",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-coverageeligibilityresponse-ex-auth-support",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-coverageeligibilityresponse-ex-auth-support\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-coverageeligibilityresponse-ex-auth-support</b></p><a name=\"hx-fhir-1.0.51-cs-coverageeligibilityresponse-ex-auth-support\"> </a><a name=\"hchx-fhir-1.0.51-cs-coverageeligibilityresponse-ex-auth-support\"> </a><p>Provenance for <a href=\"CodeSystem-coverageeligibilityresponse-ex-auth-support.html\">CodeSystem CoverageEligibilityResponse Auth Support Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/coverageeligibilityresponse-ex-auth-support"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-definition-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-definition-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-definition-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-definition-status</b></p><a name=\"hx-fhir-1.0.51-cs-definition-status\"> </a><a name=\"hchx-fhir-1.0.51-cs-definition-status\"> </a><p>Provenance for <a href=\"CodeSystem-definition-status.html\">CodeSystem DefinitionStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/definition-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-definition-topic",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-definition-topic",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-definition-topic\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-definition-topic</b></p><a name=\"hx-fhir-1.0.51-cs-definition-topic\"> </a><a name=\"hchx-fhir-1.0.51-cs-definition-topic\"> </a><p>Provenance for <a href=\"CodeSystem-definition-topic.html\">CodeSystem DefinitionTopic</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/definition-topic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-definition-use",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-definition-use",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-definition-use\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-definition-use</b></p><a name=\"hx-fhir-1.0.51-cs-definition-use\"> </a><a name=\"hchx-fhir-1.0.51-cs-definition-use\"> </a><p>Provenance for <a href=\"CodeSystem-definition-use.html\">CodeSystem Structure Definition Use Codes / Keywords</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/definition-use"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-device-status-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-device-status-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-device-status-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-device-status-reason</b></p><a name=\"hx-fhir-1.0.51-cs-device-status-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-device-status-reason\"> </a><p>Provenance for <a href=\"CodeSystem-device-status-reason.html\">CodeSystem FHIRDeviceStatusReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/device-status-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-diagnosis-role",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-diagnosis-role",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-diagnosis-role\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-diagnosis-role</b></p><a name=\"hx-fhir-1.0.51-cs-diagnosis-role\"> </a><a name=\"hchx-fhir-1.0.51-cs-diagnosis-role\"> </a><p>Provenance for <a href=\"CodeSystem-diagnosis-role.html\">CodeSystem Diagnosis Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/diagnosis-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-diet",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-diet",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-diet\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-diet</b></p><a name=\"hx-fhir-1.0.51-cs-diet\"> </a><a name=\"hchx-fhir-1.0.51-cs-diet\"> </a><p>Provenance for <a href=\"CodeSystem-diet.html\">CodeSystem Diet</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/diet"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-directness",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-directness",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-directness\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-directness</b></p><a name=\"hx-fhir-1.0.51-cs-directness\"> </a><a name=\"hchx-fhir-1.0.51-cs-directness\"> </a><p>Provenance for <a href=\"CodeSystem-directness.html\">CodeSystem EvidenceDirectness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/directness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-discharge-disposition",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-discharge-disposition",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-discharge-disposition\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-discharge-disposition</b></p><a name=\"hx-fhir-1.0.51-cs-discharge-disposition\"> </a><a name=\"hchx-fhir-1.0.51-cs-discharge-disposition\"> </a><p>Provenance for <a href=\"CodeSystem-discharge-disposition.html\">CodeSystem Discharge disposition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/discharge-disposition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-dose-rate-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-dose-rate-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-dose-rate-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-dose-rate-type</b></p><a name=\"hx-fhir-1.0.51-cs-dose-rate-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-dose-rate-type\"> </a><p>Provenance for <a href=\"CodeSystem-dose-rate-type.html\">CodeSystem DoseAndRateType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/dose-rate-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-encounter-special-arrangements",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-encounter-special-arrangements",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-encounter-special-arrangements\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-encounter-special-arrangements</b></p><a name=\"hx-fhir-1.0.51-cs-encounter-special-arrangements\"> </a><a name=\"hchx-fhir-1.0.51-cs-encounter-special-arrangements\"> </a><p>Provenance for <a href=\"CodeSystem-encounter-special-arrangements.html\">CodeSystem Special arrangements</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/encounter-special-arrangements"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-encounter-subject-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-encounter-subject-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-encounter-subject-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-encounter-subject-status</b></p><a name=\"hx-fhir-1.0.51-cs-encounter-subject-status\"> </a><a name=\"hchx-fhir-1.0.51-cs-encounter-subject-status\"> </a><p>Provenance for <a href=\"CodeSystem-encounter-subject-status.html\">CodeSystem Encounter subject status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/encounter-subject-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-encounter-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-encounter-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-encounter-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-encounter-type</b></p><a name=\"hx-fhir-1.0.51-cs-encounter-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-encounter-type\"> </a><p>Provenance for <a href=\"CodeSystem-encounter-type.html\">CodeSystem Encounter type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/encounter-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-endpoint-connection-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-endpoint-connection-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-endpoint-connection-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-endpoint-connection-type</b></p><a name=\"hx-fhir-1.0.51-cs-endpoint-connection-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-endpoint-connection-type\"> </a><p>Provenance for <a href=\"CodeSystem-endpoint-connection-type.html\">CodeSystem Endpoint Connection Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/endpoint-connection-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-endpoint-payload-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-endpoint-payload-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-endpoint-payload-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-endpoint-payload-type</b></p><a name=\"hx-fhir-1.0.51-cs-endpoint-payload-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-endpoint-payload-type\"> </a><p>Provenance for <a href=\"CodeSystem-endpoint-payload-type.html\">CodeSystem Endpoint Payload Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/endpoint-payload-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-entformula-additive",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-entformula-additive",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-entformula-additive\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-entformula-additive</b></p><a name=\"hx-fhir-1.0.51-cs-entformula-additive\"> </a><a name=\"hchx-fhir-1.0.51-cs-entformula-additive\"> </a><p>Provenance for <a href=\"CodeSystem-entformula-additive.html\">CodeSystem Enteral Formula Additive Type Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/entformula-additive"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-episodeofcare-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-episodeofcare-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-episodeofcare-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-episodeofcare-type</b></p><a name=\"hx-fhir-1.0.51-cs-episodeofcare-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-episodeofcare-type\"> </a><p>Provenance for <a href=\"CodeSystem-episodeofcare-type.html\">CodeSystem Episode of care type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/episodeofcare-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-evidence-quality",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-evidence-quality",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-evidence-quality\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-evidence-quality</b></p><a name=\"hx-fhir-1.0.51-cs-evidence-quality\"> </a><a name=\"hchx-fhir-1.0.51-cs-evidence-quality\"> </a><p>Provenance for <a href=\"CodeSystem-evidence-quality.html\">CodeSystem QualityOfEvidenceRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/evidence-quality"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-benefitcategory",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-benefitcategory",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-benefitcategory\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-benefitcategory</b></p><a name=\"hx-fhir-1.0.51-cs-ex-benefitcategory\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-benefitcategory\"> </a><p>Provenance for <a href=\"CodeSystem-ex-benefitcategory.html\">CodeSystem Benefit Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-benefitcategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-claimsubtype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-claimsubtype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-claimsubtype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-claimsubtype</b></p><a name=\"hx-fhir-1.0.51-cs-ex-claimsubtype\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-claimsubtype\"> </a><p>Provenance for <a href=\"CodeSystem-ex-claimsubtype.html\">CodeSystem Example Claim SubType Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-claimsubtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-coverage-financial-exception",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-coverage-financial-exception",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-coverage-financial-exception\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-coverage-financial-exception</b></p><a name=\"hx-fhir-1.0.51-cs-ex-coverage-financial-exception\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-coverage-financial-exception\"> </a><p>Provenance for <a href=\"CodeSystem-ex-coverage-financial-exception.html\">CodeSystem Example Coverage Financial Exception Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-coverage-financial-exception"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-diagnosis-on-admission",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-diagnosis-on-admission",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-diagnosis-on-admission\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-diagnosis-on-admission</b></p><a name=\"hx-fhir-1.0.51-cs-ex-diagnosis-on-admission\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-diagnosis-on-admission\"> </a><p>Provenance for <a href=\"CodeSystem-ex-diagnosis-on-admission.html\">CodeSystem Example Diagnosis on Admission Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-diagnosis-on-admission"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-diagnosisrelatedgroup",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-diagnosisrelatedgroup",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-diagnosisrelatedgroup\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-diagnosisrelatedgroup</b></p><a name=\"hx-fhir-1.0.51-cs-ex-diagnosisrelatedgroup\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-diagnosisrelatedgroup\"> </a><p>Provenance for <a href=\"CodeSystem-ex-diagnosisrelatedgroup.html\">CodeSystem Example Diagnosis Related Group Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-diagnosisrelatedgroup"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-diagnosistype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-diagnosistype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-diagnosistype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-diagnosistype</b></p><a name=\"hx-fhir-1.0.51-cs-ex-diagnosistype\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-diagnosistype\"> </a><p>Provenance for <a href=\"CodeSystem-ex-diagnosistype.html\">CodeSystem Example Diagnosis Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-diagnosistype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-payee-resource-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-payee-resource-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-payee-resource-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-payee-resource-type</b></p><a name=\"hx-fhir-1.0.51-cs-ex-payee-resource-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-payee-resource-type\"> </a><p>Provenance for <a href=\"CodeSystem-ex-payee-resource-type.html\">CodeSystem ClaimPayeeResourceType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-payee-resource-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-paymenttype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-paymenttype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-paymenttype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-paymenttype</b></p><a name=\"hx-fhir-1.0.51-cs-ex-paymenttype\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-paymenttype\"> </a><p>Provenance for <a href=\"CodeSystem-ex-paymenttype.html\">CodeSystem Example Payment Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-paymenttype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-procedure-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-procedure-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-procedure-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-procedure-type</b></p><a name=\"hx-fhir-1.0.51-cs-ex-procedure-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-procedure-type\"> </a><p>Provenance for <a href=\"CodeSystem-ex-procedure-type.html\">CodeSystem Example Procedure Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-procedure-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-programcode",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-programcode",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-programcode\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-programcode</b></p><a name=\"hx-fhir-1.0.51-cs-ex-programcode\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-programcode\"> </a><p>Provenance for <a href=\"CodeSystem-ex-programcode.html\">CodeSystem Example Program Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-programcode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-providerqualification",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-providerqualification",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-providerqualification\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-providerqualification</b></p><a name=\"hx-fhir-1.0.51-cs-ex-providerqualification\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-providerqualification\"> </a><p>Provenance for <a href=\"CodeSystem-ex-providerqualification.html\">CodeSystem Example Provider Qualification Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-providerqualification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-relatedclaimrelationship",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-relatedclaimrelationship",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-relatedclaimrelationship\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-relatedclaimrelationship</b></p><a name=\"hx-fhir-1.0.51-cs-ex-relatedclaimrelationship\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-relatedclaimrelationship\"> </a><p>Provenance for <a href=\"CodeSystem-ex-relatedclaimrelationship.html\">CodeSystem Example Related Claim Relationship Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-relatedclaimrelationship"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-revenue-center",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-revenue-center",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-revenue-center\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-revenue-center</b></p><a name=\"hx-fhir-1.0.51-cs-ex-revenue-center\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-revenue-center\"> </a><p>Provenance for <a href=\"CodeSystem-ex-revenue-center.html\">CodeSystem Example Revenue Center Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-revenue-center"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-serviceplace",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-serviceplace",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-serviceplace\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-serviceplace</b></p><a name=\"hx-fhir-1.0.51-cs-ex-serviceplace\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-serviceplace\"> </a><p>Provenance for <a href=\"CodeSystem-ex-serviceplace.html\">CodeSystem Example Service Place Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-serviceplace"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-tooth",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-tooth",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-tooth\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-tooth</b></p><a name=\"hx-fhir-1.0.51-cs-ex-tooth\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-tooth\"> </a><p>Provenance for <a href=\"CodeSystem-ex-tooth.html\">CodeSystem Oral Site Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-tooth"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-USCLS",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-USCLS",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-USCLS\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-USCLS</b></p><a name=\"hx-fhir-1.0.51-cs-ex-USCLS\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-USCLS\"> </a><p>Provenance for <a href=\"CodeSystem-ex-USCLS.html\">CodeSystem USCLS Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-USCLS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-ex-visionprescriptionproduct",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-ex-visionprescriptionproduct",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-ex-visionprescriptionproduct\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-ex-visionprescriptionproduct</b></p><a name=\"hx-fhir-1.0.51-cs-ex-visionprescriptionproduct\"> </a><a name=\"hchx-fhir-1.0.51-cs-ex-visionprescriptionproduct\"> </a><p>Provenance for <a href=\"CodeSystem-ex-visionprescriptionproduct.html\">CodeSystem Example Vision Prescription Product Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-visionprescriptionproduct"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-expansion-parameter-source",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-expansion-parameter-source",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-expansion-parameter-source\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-expansion-parameter-source</b></p><a name=\"hx-fhir-1.0.51-cs-expansion-parameter-source\"> </a><a name=\"hchx-fhir-1.0.51-cs-expansion-parameter-source\"> </a><p>Provenance for <a href=\"CodeSystem-expansion-parameter-source.html\">CodeSystem ExpansionParameterSource</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/expansion-parameter-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-expansion-processing-rule",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-expansion-processing-rule",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-expansion-processing-rule\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-expansion-processing-rule</b></p><a name=\"hx-fhir-1.0.51-cs-expansion-processing-rule\"> </a><a name=\"hchx-fhir-1.0.51-cs-expansion-processing-rule\"> </a><p>Provenance for <a href=\"CodeSystem-expansion-processing-rule.html\">CodeSystem ExpansionProcessingRule</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/expansion-processing-rule"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-extra-security-role-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-extra-security-role-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-extra-security-role-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-extra-security-role-type</b></p><a name=\"hx-fhir-1.0.51-cs-extra-security-role-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-extra-security-role-type\"> </a><p>Provenance for <a href=\"CodeSystem-extra-security-role-type.html\">CodeSystem Security Role Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/extra-security-role-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-failure-action",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-failure-action",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-failure-action\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-failure-action</b></p><a name=\"hx-fhir-1.0.51-cs-failure-action\"> </a><a name=\"hchx-fhir-1.0.51-cs-failure-action\"> </a><p>Provenance for <a href=\"CodeSystem-failure-action.html\">CodeSystem Failure-action</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/failure-action"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-FDI-surface",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-FDI-surface",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-FDI-surface\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-FDI-surface</b></p><a name=\"hx-fhir-1.0.51-cs-FDI-surface\"> </a><a name=\"hchx-fhir-1.0.51-cs-FDI-surface\"> </a><p>Provenance for <a href=\"CodeSystem-FDI-surface.html\">CodeSystem Surface Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/FDI-surface"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-financialtaskcode",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-financialtaskcode",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-financialtaskcode\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-financialtaskcode</b></p><a name=\"hx-fhir-1.0.51-cs-financialtaskcode\"> </a><a name=\"hchx-fhir-1.0.51-cs-financialtaskcode\"> </a><p>Provenance for <a href=\"CodeSystem-financialtaskcode.html\">CodeSystem Financial Task Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/financialtaskcode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-financialtaskinputtype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-financialtaskinputtype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-financialtaskinputtype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-financialtaskinputtype</b></p><a name=\"hx-fhir-1.0.51-cs-financialtaskinputtype\"> </a><a name=\"hchx-fhir-1.0.51-cs-financialtaskinputtype\"> </a><p>Provenance for <a href=\"CodeSystem-financialtaskinputtype.html\">CodeSystem Financial Task Input Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/financialtaskinputtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-flag-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-flag-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-flag-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-flag-category</b></p><a name=\"hx-fhir-1.0.51-cs-flag-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-flag-category\"> </a><p>Provenance for <a href=\"CodeSystem-flag-category.html\">CodeSystem Flag Category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/flag-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-forms-codes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-forms-codes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-forms-codes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-forms-codes</b></p><a name=\"hx-fhir-1.0.51-cs-forms-codes\"> </a><a name=\"hchx-fhir-1.0.51-cs-forms-codes\"> </a><p>Provenance for <a href=\"CodeSystem-forms-codes.html\">CodeSystem Form Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/forms-codes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-fundsreserve",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-fundsreserve",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-fundsreserve\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-fundsreserve</b></p><a name=\"hx-fhir-1.0.51-cs-fundsreserve\"> </a><a name=\"hchx-fhir-1.0.51-cs-fundsreserve\"> </a><p>Provenance for <a href=\"CodeSystem-fundsreserve.html\">CodeSystem Funds Reservation Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/fundsreserve"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-goal-acceptance-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-goal-acceptance-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-goal-acceptance-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-goal-acceptance-status</b></p><a name=\"hx-fhir-1.0.51-cs-goal-acceptance-status\"> </a><a name=\"hchx-fhir-1.0.51-cs-goal-acceptance-status\"> </a><p>Provenance for <a href=\"CodeSystem-goal-acceptance-status.html\">CodeSystem GoalAcceptanceStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-acceptance-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-goal-achievement",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-goal-achievement",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-goal-achievement\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-goal-achievement</b></p><a name=\"hx-fhir-1.0.51-cs-goal-achievement\"> </a><a name=\"hchx-fhir-1.0.51-cs-goal-achievement\"> </a><p>Provenance for <a href=\"CodeSystem-goal-achievement.html\">CodeSystem Goal achievement status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-achievement"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-goal-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-goal-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-goal-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-goal-category</b></p><a name=\"hx-fhir-1.0.51-cs-goal-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-goal-category\"> </a><p>Provenance for <a href=\"CodeSystem-goal-category.html\">CodeSystem Goal category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-goal-priority",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-goal-priority",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-goal-priority\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-goal-priority</b></p><a name=\"hx-fhir-1.0.51-cs-goal-priority\"> </a><a name=\"hchx-fhir-1.0.51-cs-goal-priority\"> </a><p>Provenance for <a href=\"CodeSystem-goal-priority.html\">CodeSystem Goal priority</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-priority"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-goal-relationship-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-goal-relationship-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-goal-relationship-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-goal-relationship-type</b></p><a name=\"hx-fhir-1.0.51-cs-goal-relationship-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-goal-relationship-type\"> </a><p>Provenance for <a href=\"CodeSystem-goal-relationship-type.html\">CodeSystem GoalRelationshipType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-relationship-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-guide-parameter-code",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-guide-parameter-code",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-guide-parameter-code\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-guide-parameter-code</b></p><a name=\"hx-fhir-1.0.51-cs-guide-parameter-code\"> </a><a name=\"hchx-fhir-1.0.51-cs-guide-parameter-code\"> </a><p>Provenance for <a href=\"CodeSystem-guide-parameter-code.html\">CodeSystem GuideParameterCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/guide-parameter-code"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-handling-condition",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-handling-condition",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-handling-condition\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-handling-condition</b></p><a name=\"hx-fhir-1.0.51-cs-handling-condition\"> </a><a name=\"hchx-fhir-1.0.51-cs-handling-condition\"> </a><p>Provenance for <a href=\"CodeSystem-handling-condition.html\">CodeSystem HandlingConditionSet</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/handling-condition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-history-absent-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-history-absent-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-history-absent-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-history-absent-reason</b></p><a name=\"hx-fhir-1.0.51-cs-history-absent-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-history-absent-reason\"> </a><p>Provenance for <a href=\"CodeSystem-history-absent-reason.html\">CodeSystem FamilyHistoryAbsentReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/history-absent-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-immunization-evaluation-dose-status-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-immunization-evaluation-dose-status-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-immunization-evaluation-dose-status-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-immunization-evaluation-dose-status-reason</b></p><a name=\"hx-fhir-1.0.51-cs-immunization-evaluation-dose-status-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-immunization-evaluation-dose-status-reason\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-evaluation-dose-status-reason.html\">CodeSystem Immunization Evaluation Dose Status Reason codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-evaluation-dose-status-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-immunization-evaluation-dose-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-immunization-evaluation-dose-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-immunization-evaluation-dose-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-immunization-evaluation-dose-status</b></p><a name=\"hx-fhir-1.0.51-cs-immunization-evaluation-dose-status\"> </a><a name=\"hchx-fhir-1.0.51-cs-immunization-evaluation-dose-status\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-evaluation-dose-status.html\">CodeSystem Immunization Evaluation Dose Status codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-evaluation-dose-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-immunization-funding-source",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-immunization-funding-source",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-immunization-funding-source\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-immunization-funding-source</b></p><a name=\"hx-fhir-1.0.51-cs-immunization-funding-source\"> </a><a name=\"hchx-fhir-1.0.51-cs-immunization-funding-source\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-funding-source.html\">CodeSystem Immunization Funding Source</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-funding-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-immunization-origin",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-immunization-origin",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-immunization-origin\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-immunization-origin</b></p><a name=\"hx-fhir-1.0.51-cs-immunization-origin\"> </a><a name=\"hchx-fhir-1.0.51-cs-immunization-origin\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-origin.html\">CodeSystem Immunization Origin Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-origin"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-immunization-program-eligibility",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-immunization-program-eligibility",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-immunization-program-eligibility\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-immunization-program-eligibility</b></p><a name=\"hx-fhir-1.0.51-cs-immunization-program-eligibility\"> </a><a name=\"hchx-fhir-1.0.51-cs-immunization-program-eligibility\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-program-eligibility.html\">CodeSystem Immunization Program Eligibility</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-program-eligibility"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-immunization-recommendation-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-immunization-recommendation-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-immunization-recommendation-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-immunization-recommendation-status</b></p><a name=\"hx-fhir-1.0.51-cs-immunization-recommendation-status\"> </a><a name=\"hchx-fhir-1.0.51-cs-immunization-recommendation-status\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-recommendation-status.html\">CodeSystem Immunization Recommendation Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-recommendation-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-immunization-subpotent-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-immunization-subpotent-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-immunization-subpotent-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-immunization-subpotent-reason</b></p><a name=\"hx-fhir-1.0.51-cs-immunization-subpotent-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-immunization-subpotent-reason\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-subpotent-reason.html\">CodeSystem Immunization Subpotent Reason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-subpotent-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-implantStatus",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-implantStatus",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-implantStatus\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-implantStatus</b></p><a name=\"hx-fhir-1.0.51-cs-implantStatus\"> </a><a name=\"hchx-fhir-1.0.51-cs-implantStatus\"> </a><p>Provenance for <a href=\"CodeSystem-implantStatus.html\">CodeSystem Implant Status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/implantStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-insurance-plan-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-insurance-plan-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-insurance-plan-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-insurance-plan-type</b></p><a name=\"hx-fhir-1.0.51-cs-insurance-plan-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-insurance-plan-type\"> </a><p>Provenance for <a href=\"CodeSystem-insurance-plan-type.html\">CodeSystem Insurance plan type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/insurance-plan-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-iso-21089-lifecycle",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-iso-21089-lifecycle",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-iso-21089-lifecycle\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-iso-21089-lifecycle</b></p><a name=\"hx-fhir-1.0.51-cs-iso-21089-lifecycle\"> </a><a name=\"hchx-fhir-1.0.51-cs-iso-21089-lifecycle\"> </a><p>Provenance for <a href=\"CodeSystem-iso-21089-lifecycle.html\">CodeSystem ISO 21089 2017 Health Record Lifecycle Events</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/iso-21089-lifecycle"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-library-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-library-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-library-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-library-type</b></p><a name=\"hx-fhir-1.0.51-cs-library-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-library-type\"> </a><p>Provenance for <a href=\"CodeSystem-library-type.html\">CodeSystem LibraryType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/library-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-list-empty-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-list-empty-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-list-empty-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-list-empty-reason</b></p><a name=\"hx-fhir-1.0.51-cs-list-empty-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-list-empty-reason\"> </a><p>Provenance for <a href=\"CodeSystem-list-empty-reason.html\">CodeSystem List Empty Reasons</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/list-empty-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-list-example-use-codes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-list-example-use-codes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-list-example-use-codes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-list-example-use-codes</b></p><a name=\"hx-fhir-1.0.51-cs-list-example-use-codes\"> </a><a name=\"hchx-fhir-1.0.51-cs-list-example-use-codes\"> </a><p>Provenance for <a href=\"CodeSystem-list-example-use-codes.html\">CodeSystem Example Use Codes for List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/list-example-use-codes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-list-order",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-list-order",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-list-order\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-list-order</b></p><a name=\"hx-fhir-1.0.51-cs-list-order\"> </a><a name=\"hchx-fhir-1.0.51-cs-list-order\"> </a><p>Provenance for <a href=\"CodeSystem-list-order.html\">CodeSystem List Order Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/list-order"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-location-physical-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-location-physical-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-location-physical-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-location-physical-type</b></p><a name=\"hx-fhir-1.0.51-cs-location-physical-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-location-physical-type\"> </a><p>Provenance for <a href=\"CodeSystem-location-physical-type.html\">CodeSystem Location type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/location-physical-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-match-grade",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-match-grade",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-match-grade\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-match-grade</b></p><a name=\"hx-fhir-1.0.51-cs-match-grade\"> </a><a name=\"hchx-fhir-1.0.51-cs-match-grade\"> </a><p>Provenance for <a href=\"CodeSystem-match-grade.html\">CodeSystem MatchGrade</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/match-grade"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-measure-data-usage",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-measure-data-usage",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-measure-data-usage\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-measure-data-usage</b></p><a name=\"hx-fhir-1.0.51-cs-measure-data-usage\"> </a><a name=\"hchx-fhir-1.0.51-cs-measure-data-usage\"> </a><p>Provenance for <a href=\"CodeSystem-measure-data-usage.html\">CodeSystem MeasureDataUsage</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-data-usage"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-measure-improvement-notation",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-measure-improvement-notation",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-measure-improvement-notation\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-measure-improvement-notation</b></p><a name=\"hx-fhir-1.0.51-cs-measure-improvement-notation\"> </a><a name=\"hchx-fhir-1.0.51-cs-measure-improvement-notation\"> </a><p>Provenance for <a href=\"CodeSystem-measure-improvement-notation.html\">CodeSystem MeasureImprovementNotation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-improvement-notation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-measure-population",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-measure-population",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-measure-population\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-measure-population</b></p><a name=\"hx-fhir-1.0.51-cs-measure-population\"> </a><a name=\"hchx-fhir-1.0.51-cs-measure-population\"> </a><p>Provenance for <a href=\"CodeSystem-measure-population.html\">CodeSystem Measure Population Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-population"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-measure-scoring",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-measure-scoring",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-measure-scoring\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-measure-scoring</b></p><a name=\"hx-fhir-1.0.51-cs-measure-scoring\"> </a><a name=\"hchx-fhir-1.0.51-cs-measure-scoring\"> </a><p>Provenance for <a href=\"CodeSystem-measure-scoring.html\">CodeSystem Measure Scoring</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-scoring"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-measure-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-measure-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-measure-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-measure-type</b></p><a name=\"hx-fhir-1.0.51-cs-measure-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-measure-type\"> </a><p>Provenance for <a href=\"CodeSystem-measure-type.html\">CodeSystem MeasureType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-med-admin-perform-function",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-med-admin-perform-function",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-med-admin-perform-function\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-med-admin-perform-function</b></p><a name=\"hx-fhir-1.0.51-cs-med-admin-perform-function\"> </a><a name=\"hchx-fhir-1.0.51-cs-med-admin-perform-function\"> </a><p>Provenance for <a href=\"CodeSystem-med-admin-perform-function.html\">CodeSystem MedicationAdministration Performer Function Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/med-admin-perform-function"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medication-admin-location",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medication-admin-location",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medication-admin-location\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medication-admin-location</b></p><a name=\"hx-fhir-1.0.51-cs-medication-admin-location\"> </a><a name=\"hchx-fhir-1.0.51-cs-medication-admin-location\"> </a><p>Provenance for <a href=\"CodeSystem-medication-admin-location.html\">CodeSystem MedicationAdministration Location Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medication-admin-location"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medication-usage-admin-location",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medication-usage-admin-location",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medication-usage-admin-location\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medication-usage-admin-location</b></p><a name=\"hx-fhir-1.0.51-cs-medication-usage-admin-location\"> </a><a name=\"hchx-fhir-1.0.51-cs-medication-usage-admin-location\"> </a><p>Provenance for <a href=\"CodeSystem-medication-usage-admin-location.html\">CodeSystem MedicationUsage Administration Location Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medication-usage-admin-location"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medicationdispense-performer-function",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medicationdispense-performer-function",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medicationdispense-performer-function\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medicationdispense-performer-function</b></p><a name=\"hx-fhir-1.0.51-cs-medicationdispense-performer-function\"> </a><a name=\"hchx-fhir-1.0.51-cs-medicationdispense-performer-function\"> </a><p>Provenance for <a href=\"CodeSystem-medicationdispense-performer-function.html\">CodeSystem MedicationDispense Performer Function Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationdispense-performer-function"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medicationknowledge-characteristic",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medicationknowledge-characteristic",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medicationknowledge-characteristic\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medicationknowledge-characteristic</b></p><a name=\"hx-fhir-1.0.51-cs-medicationknowledge-characteristic\"> </a><a name=\"hchx-fhir-1.0.51-cs-medicationknowledge-characteristic\"> </a><p>Provenance for <a href=\"CodeSystem-medicationknowledge-characteristic.html\">CodeSystem MedicationKnowledge Characteristic Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationknowledge-characteristic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medicationknowledge-package-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medicationknowledge-package-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medicationknowledge-package-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medicationknowledge-package-type</b></p><a name=\"hx-fhir-1.0.51-cs-medicationknowledge-package-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-medicationknowledge-package-type\"> </a><p>Provenance for <a href=\"CodeSystem-medicationknowledge-package-type.html\">CodeSystem MedicationKnowledge Package Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationknowledge-package-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medicationknowledge-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medicationknowledge-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medicationknowledge-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medicationknowledge-status</b></p><a name=\"hx-fhir-1.0.51-cs-medicationknowledge-status\"> </a><a name=\"hchx-fhir-1.0.51-cs-medicationknowledge-status\"> </a><p>Provenance for <a href=\"CodeSystem-medicationknowledge-status.html\">CodeSystem MedicationKnowledge Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationknowledge-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medicationrequest-admin-location",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medicationrequest-admin-location",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medicationrequest-admin-location\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medicationrequest-admin-location</b></p><a name=\"hx-fhir-1.0.51-cs-medicationrequest-admin-location\"> </a><a name=\"hchx-fhir-1.0.51-cs-medicationrequest-admin-location\"> </a><p>Provenance for <a href=\"CodeSystem-medicationrequest-admin-location.html\">CodeSystem Medication request  administration  location  codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationrequest-admin-location"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medicationrequest-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medicationrequest-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medicationrequest-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medicationrequest-category</b></p><a name=\"hx-fhir-1.0.51-cs-medicationrequest-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-medicationrequest-category\"> </a><p>Provenance for <a href=\"CodeSystem-medicationrequest-category.html\">CodeSystem MedicationRequest Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationrequest-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medicationrequest-course-of-therapy",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medicationrequest-course-of-therapy",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medicationrequest-course-of-therapy\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medicationrequest-course-of-therapy</b></p><a name=\"hx-fhir-1.0.51-cs-medicationrequest-course-of-therapy\"> </a><a name=\"hchx-fhir-1.0.51-cs-medicationrequest-course-of-therapy\"> </a><p>Provenance for <a href=\"CodeSystem-medicationrequest-course-of-therapy.html\">CodeSystem MedicationRequest Course of Therapy Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationrequest-course-of-therapy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-medicationrequest-status-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-medicationrequest-status-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-medicationrequest-status-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-medicationrequest-status-reason</b></p><a name=\"hx-fhir-1.0.51-cs-medicationrequest-status-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-medicationrequest-status-reason\"> </a><p>Provenance for <a href=\"CodeSystem-medicationrequest-status-reason.html\">CodeSystem MedicationRequest Status Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationrequest-status-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-message-reasons-encounter",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-message-reasons-encounter",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-message-reasons-encounter\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-message-reasons-encounter</b></p><a name=\"hx-fhir-1.0.51-cs-message-reasons-encounter\"> </a><a name=\"hchx-fhir-1.0.51-cs-message-reasons-encounter\"> </a><p>Provenance for <a href=\"CodeSystem-message-reasons-encounter.html\">CodeSystem Example Message Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/message-reasons-encounter"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-missingtoothreason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-missingtoothreason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-missingtoothreason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-missingtoothreason</b></p><a name=\"hx-fhir-1.0.51-cs-missingtoothreason\"> </a><a name=\"hchx-fhir-1.0.51-cs-missingtoothreason\"> </a><p>Provenance for <a href=\"CodeSystem-missingtoothreason.html\">CodeSystem Missing Tooth Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/missingtoothreason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-modifiers",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-modifiers",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-modifiers\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-modifiers</b></p><a name=\"hx-fhir-1.0.51-cs-modifiers\"> </a><a name=\"hchx-fhir-1.0.51-cs-modifiers\"> </a><p>Provenance for <a href=\"CodeSystem-modifiers.html\">CodeSystem Modifier type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/modifiers"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-name-assembly-order",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-name-assembly-order",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-name-assembly-order\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-name-assembly-order</b></p><a name=\"hx-fhir-1.0.51-cs-name-assembly-order\"> </a><a name=\"hchx-fhir-1.0.51-cs-name-assembly-order\"> </a><p>Provenance for <a href=\"CodeSystem-name-assembly-order.html\">CodeSystem HumanNameAssemblyOrder</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/name-assembly-order"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-need",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-need",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-need\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-need</b></p><a name=\"hx-fhir-1.0.51-cs-need\"> </a><a name=\"hchx-fhir-1.0.51-cs-need\"> </a><p>Provenance for <a href=\"CodeSystem-need.html\">CodeSystem Need</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/need"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-nutrition-intake-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-nutrition-intake-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-nutrition-intake-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-nutrition-intake-category</b></p><a name=\"hx-fhir-1.0.51-cs-nutrition-intake-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-nutrition-intake-category\"> </a><p>Provenance for <a href=\"CodeSystem-nutrition-intake-category.html\">CodeSystem Nutrition intake category codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/nutrition-intake-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-object-role",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-object-role",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-object-role\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-object-role</b></p><a name=\"hx-fhir-1.0.51-cs-object-role\"> </a><a name=\"hchx-fhir-1.0.51-cs-object-role\"> </a><p>Provenance for <a href=\"CodeSystem-object-role.html\">CodeSystem AuditEventEntityRole</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/object-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-observation-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-observation-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-observation-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-observation-category</b></p><a name=\"hx-fhir-1.0.51-cs-observation-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-observation-category\"> </a><p>Provenance for <a href=\"CodeSystem-observation-category.html\">CodeSystem Observation Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/observation-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-observation-statistics",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-observation-statistics",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-observation-statistics\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-observation-statistics</b></p><a name=\"hx-fhir-1.0.51-cs-observation-statistics\"> </a><a name=\"hchx-fhir-1.0.51-cs-observation-statistics\"> </a><p>Provenance for <a href=\"CodeSystem-observation-statistics.html\">CodeSystem StatisticsCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/observation-statistics"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-operation-outcome",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-operation-outcome",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-operation-outcome\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-operation-outcome</b></p><a name=\"hx-fhir-1.0.51-cs-operation-outcome\"> </a><a name=\"hchx-fhir-1.0.51-cs-operation-outcome\"> </a><p>Provenance for <a href=\"CodeSystem-operation-outcome.html\">CodeSystem Operation Outcome Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/operation-outcome"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-organization-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-organization-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-organization-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-organization-type</b></p><a name=\"hx-fhir-1.0.51-cs-organization-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-organization-type\"> </a><p>Provenance for <a href=\"CodeSystem-organization-type.html\">CodeSystem Organization type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/organization-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-parameter-group",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-parameter-group",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-parameter-group\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-parameter-group</b></p><a name=\"hx-fhir-1.0.51-cs-parameter-group\"> </a><a name=\"hchx-fhir-1.0.51-cs-parameter-group\"> </a><p>Provenance for <a href=\"CodeSystem-parameter-group.html\">CodeSystem DeviceDefinitionParameterGroup</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/parameter-group"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-participant-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-participant-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-participant-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-participant-type</b></p><a name=\"hx-fhir-1.0.51-cs-participant-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-participant-type\"> </a><p>Provenance for <a href=\"CodeSystem-participant-type.html\">CodeSystem Participant type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/participant-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-payeetype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-payeetype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-payeetype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-payeetype</b></p><a name=\"hx-fhir-1.0.51-cs-payeetype\"> </a><a name=\"hchx-fhir-1.0.51-cs-payeetype\"> </a><p>Provenance for <a href=\"CodeSystem-payeetype.html\">CodeSystem Payee Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/payeetype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-payment-adjustment-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-payment-adjustment-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-payment-adjustment-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-payment-adjustment-reason</b></p><a name=\"hx-fhir-1.0.51-cs-payment-adjustment-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-payment-adjustment-reason\"> </a><p>Provenance for <a href=\"CodeSystem-payment-adjustment-reason.html\">CodeSystem Payment Adjustment Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/payment-adjustment-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-payment-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-payment-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-payment-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-payment-type</b></p><a name=\"hx-fhir-1.0.51-cs-payment-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-payment-type\"> </a><p>Provenance for <a href=\"CodeSystem-payment-type.html\">CodeSystem Payment Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/payment-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-paymentstatus",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-paymentstatus",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-paymentstatus\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-paymentstatus</b></p><a name=\"hx-fhir-1.0.51-cs-paymentstatus\"> </a><a name=\"hchx-fhir-1.0.51-cs-paymentstatus\"> </a><p>Provenance for <a href=\"CodeSystem-paymentstatus.html\">CodeSystem Payment Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/paymentstatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-plan-definition-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-plan-definition-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-plan-definition-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-plan-definition-type</b></p><a name=\"hx-fhir-1.0.51-cs-plan-definition-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-plan-definition-type\"> </a><p>Provenance for <a href=\"CodeSystem-plan-definition-type.html\">CodeSystem PlanDefinitionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/plan-definition-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-practitioner-role",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-practitioner-role",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-practitioner-role\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-practitioner-role</b></p><a name=\"hx-fhir-1.0.51-cs-practitioner-role\"> </a><a name=\"hchx-fhir-1.0.51-cs-practitioner-role\"> </a><p>Provenance for <a href=\"CodeSystem-practitioner-role.html\">CodeSystem Practitioner role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/practitioner-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-primary-source-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-primary-source-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-primary-source-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-primary-source-type</b></p><a name=\"hx-fhir-1.0.51-cs-primary-source-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-primary-source-type\"> </a><p>Provenance for <a href=\"CodeSystem-primary-source-type.html\">CodeSystem Primary-source-type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/primary-source-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-processpriority",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-processpriority",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-processpriority\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-processpriority</b></p><a name=\"hx-fhir-1.0.51-cs-processpriority\"> </a><a name=\"hchx-fhir-1.0.51-cs-processpriority\"> </a><p>Provenance for <a href=\"CodeSystem-processpriority.html\">CodeSystem Process Priority Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/processpriority"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-program",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-program",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-program\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-program</b></p><a name=\"hx-fhir-1.0.51-cs-program\"> </a><a name=\"hchx-fhir-1.0.51-cs-program\"> </a><p>Provenance for <a href=\"CodeSystem-program.html\">CodeSystem Program</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/program"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-provenance-participant-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-provenance-participant-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-provenance-participant-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-provenance-participant-type</b></p><a name=\"hx-fhir-1.0.51-cs-provenance-participant-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-provenance-participant-type\"> </a><p>Provenance for <a href=\"CodeSystem-provenance-participant-type.html\">CodeSystem Provenance participant type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/provenance-participant-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-push-type-available",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-push-type-available",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-push-type-available\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-push-type-available</b></p><a name=\"hx-fhir-1.0.51-cs-push-type-available\"> </a><a name=\"hchx-fhir-1.0.51-cs-push-type-available\"> </a><p>Provenance for <a href=\"CodeSystem-push-type-available.html\">CodeSystem Push-type-available</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/push-type-available"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-question-max-occurs",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-question-max-occurs",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-question-max-occurs\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-question-max-occurs</b></p><a name=\"hx-fhir-1.0.51-cs-question-max-occurs\"> </a><a name=\"hchx-fhir-1.0.51-cs-question-max-occurs\"> </a><p>Provenance for <a href=\"CodeSystem-question-max-occurs.html\">CodeSystem MaxOccurs</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/question-max-occurs"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-questionnaire-usage-mode",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-questionnaire-usage-mode",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-questionnaire-usage-mode\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-questionnaire-usage-mode</b></p><a name=\"hx-fhir-1.0.51-cs-questionnaire-usage-mode\"> </a><a name=\"hchx-fhir-1.0.51-cs-questionnaire-usage-mode\"> </a><p>Provenance for <a href=\"CodeSystem-questionnaire-usage-mode.html\">CodeSystem QuestionnaireItemUsageMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/questionnaire-usage-mode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-reaction-event-certainty",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-reaction-event-certainty",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-reaction-event-certainty\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-reaction-event-certainty</b></p><a name=\"hx-fhir-1.0.51-cs-reaction-event-certainty\"> </a><a name=\"hchx-fhir-1.0.51-cs-reaction-event-certainty\"> </a><p>Provenance for <a href=\"CodeSystem-reaction-event-certainty.html\">CodeSystem AllergyIntoleranceCertainty</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/reaction-event-certainty"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-reason-medication-given",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-reason-medication-given",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-reason-medication-given\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-reason-medication-given</b></p><a name=\"hx-fhir-1.0.51-cs-reason-medication-given\"> </a><a name=\"hchx-fhir-1.0.51-cs-reason-medication-given\"> </a><p>Provenance for <a href=\"CodeSystem-reason-medication-given.html\">CodeSystem Reason Medication Given Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/reason-medication-given"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-recommendation-strength",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-recommendation-strength",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-recommendation-strength\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-recommendation-strength</b></p><a name=\"hx-fhir-1.0.51-cs-recommendation-strength\"> </a><a name=\"hchx-fhir-1.0.51-cs-recommendation-strength\"> </a><p>Provenance for <a href=\"CodeSystem-recommendation-strength.html\">CodeSystem StrengthOfRecommendationRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/recommendation-strength"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-referencerange-meaning",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-referencerange-meaning",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-referencerange-meaning\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-referencerange-meaning</b></p><a name=\"hx-fhir-1.0.51-cs-referencerange-meaning\"> </a><a name=\"hchx-fhir-1.0.51-cs-referencerange-meaning\"> </a><p>Provenance for <a href=\"CodeSystem-referencerange-meaning.html\">CodeSystem Observation Reference Range Meaning Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/referencerange-meaning"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-rejection-criteria",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-rejection-criteria",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-rejection-criteria\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-rejection-criteria</b></p><a name=\"hx-fhir-1.0.51-cs-rejection-criteria\"> </a><a name=\"hchx-fhir-1.0.51-cs-rejection-criteria\"> </a><p>Provenance for <a href=\"CodeSystem-rejection-criteria.html\">CodeSystem RejectionCriterion</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/rejection-criteria"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-research-study-objective-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-research-study-objective-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-research-study-objective-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-research-study-objective-type</b></p><a name=\"hx-fhir-1.0.51-cs-research-study-objective-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-research-study-objective-type\"> </a><p>Provenance for <a href=\"CodeSystem-research-study-objective-type.html\">CodeSystem ResearchStudyObjectiveType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-study-objective-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-research-study-phase",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-research-study-phase",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-research-study-phase\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-research-study-phase</b></p><a name=\"hx-fhir-1.0.51-cs-research-study-phase\"> </a><a name=\"hchx-fhir-1.0.51-cs-research-study-phase\"> </a><p>Provenance for <a href=\"CodeSystem-research-study-phase.html\">CodeSystem ResearchStudyPhase</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-study-phase"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-research-study-prim-purp-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-research-study-prim-purp-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-research-study-prim-purp-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-research-study-prim-purp-type</b></p><a name=\"hx-fhir-1.0.51-cs-research-study-prim-purp-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-research-study-prim-purp-type\"> </a><p>Provenance for <a href=\"CodeSystem-research-study-prim-purp-type.html\">CodeSystem ResearchStudyPrimaryPurposeType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-study-prim-purp-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-research-study-reason-stopped",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-research-study-reason-stopped",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-research-study-reason-stopped\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-research-study-reason-stopped</b></p><a name=\"hx-fhir-1.0.51-cs-research-study-reason-stopped\"> </a><a name=\"hchx-fhir-1.0.51-cs-research-study-reason-stopped\"> </a><p>Provenance for <a href=\"CodeSystem-research-study-reason-stopped.html\">CodeSystem ResearchStudyReasonStopped</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-study-reason-stopped"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-research-subject-milestone",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-research-subject-milestone",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-research-subject-milestone\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-research-subject-milestone</b></p><a name=\"hx-fhir-1.0.51-cs-research-subject-milestone\"> </a><a name=\"hchx-fhir-1.0.51-cs-research-subject-milestone\"> </a><p>Provenance for <a href=\"CodeSystem-research-subject-milestone.html\">CodeSystem ResearchSubjectMilestone</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-subject-milestone"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-research-subject-state-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-research-subject-state-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-research-subject-state-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-research-subject-state-type</b></p><a name=\"hx-fhir-1.0.51-cs-research-subject-state-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-research-subject-state-type\"> </a><p>Provenance for <a href=\"CodeSystem-research-subject-state-type.html\">CodeSystem ResearchSubjectStateType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-subject-state-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-research-subject-state",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-research-subject-state",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-research-subject-state\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-research-subject-state</b></p><a name=\"hx-fhir-1.0.51-cs-research-subject-state\"> </a><a name=\"hchx-fhir-1.0.51-cs-research-subject-state\"> </a><p>Provenance for <a href=\"CodeSystem-research-subject-state.html\">CodeSystem ResearchSubjectState</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-subject-state"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-resource-security-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-resource-security-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-resource-security-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-resource-security-category</b></p><a name=\"hx-fhir-1.0.51-cs-resource-security-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-resource-security-category\"> </a><p>Provenance for <a href=\"CodeSystem-resource-security-category.html\">CodeSystem ResourceSecurityCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/resource-security-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-resource-type-link",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-resource-type-link",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-resource-type-link\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-resource-type-link</b></p><a name=\"hx-fhir-1.0.51-cs-resource-type-link\"> </a><a name=\"hchx-fhir-1.0.51-cs-resource-type-link\"> </a><p>Provenance for <a href=\"CodeSystem-resource-type-link.html\">CodeSystem PayeeResourceType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/resource-type-link"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-risk-probability",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-risk-probability",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-risk-probability\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-risk-probability</b></p><a name=\"hx-fhir-1.0.51-cs-risk-probability\"> </a><a name=\"hchx-fhir-1.0.51-cs-risk-probability\"> </a><p>Provenance for <a href=\"CodeSystem-risk-probability.html\">CodeSystem Risk Probability</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/risk-probability"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-security-source-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-security-source-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-security-source-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-security-source-type</b></p><a name=\"hx-fhir-1.0.51-cs-security-source-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-security-source-type\"> </a><p>Provenance for <a href=\"CodeSystem-security-source-type.html\">CodeSystem Audit Event Source Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/security-source-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-service-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-service-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-service-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-service-category</b></p><a name=\"hx-fhir-1.0.51-cs-service-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-service-category\"> </a><p>Provenance for <a href=\"CodeSystem-service-category.html\">CodeSystem Service category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-service-provision-conditions",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-service-provision-conditions",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-service-provision-conditions\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-service-provision-conditions</b></p><a name=\"hx-fhir-1.0.51-cs-service-provision-conditions\"> </a><a name=\"hchx-fhir-1.0.51-cs-service-provision-conditions\"> </a><p>Provenance for <a href=\"CodeSystem-service-provision-conditions.html\">CodeSystem ServiceProvisionConditions</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-provision-conditions"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-service-referral-method",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-service-referral-method",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-service-referral-method\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-service-referral-method</b></p><a name=\"hx-fhir-1.0.51-cs-service-referral-method\"> </a><a name=\"hchx-fhir-1.0.51-cs-service-referral-method\"> </a><p>Provenance for <a href=\"CodeSystem-service-referral-method.html\">CodeSystem ReferralMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-referral-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-service-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-service-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-service-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-service-type</b></p><a name=\"hx-fhir-1.0.51-cs-service-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-service-type\"> </a><p>Provenance for <a href=\"CodeSystem-service-type.html\">CodeSystem Service type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-smart-capabilities",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-smart-capabilities",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-smart-capabilities\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-smart-capabilities</b></p><a name=\"hx-fhir-1.0.51-cs-smart-capabilities\"> </a><a name=\"hchx-fhir-1.0.51-cs-smart-capabilities\"> </a><p>Provenance for <a href=\"CodeSystem-smart-capabilities.html\">CodeSystem SmartCapabilities</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/smart-capabilities"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-special-values",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-special-values",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-special-values\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-special-values</b></p><a name=\"hx-fhir-1.0.51-cs-special-values\"> </a><a name=\"hchx-fhir-1.0.51-cs-special-values\"> </a><p>Provenance for <a href=\"CodeSystem-special-values.html\">CodeSystem SpecialValues</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/special-values"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-standards-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-standards-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-standards-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-standards-status</b></p><a name=\"hx-fhir-1.0.51-cs-standards-status\"> </a><a name=\"hchx-fhir-1.0.51-cs-standards-status\"> </a><p>Provenance for <a href=\"CodeSystem-standards-status.html\">CodeSystem StandardsStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/standards-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-state-change-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-state-change-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-state-change-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-state-change-reason</b></p><a name=\"hx-fhir-1.0.51-cs-state-change-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-state-change-reason\"> </a><p>Provenance for <a href=\"CodeSystem-state-change-reason.html\">CodeSystem StateChangeReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/state-change-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-statistic-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-statistic-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-statistic-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-statistic-type</b></p><a name=\"hx-fhir-1.0.51-cs-statistic-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-statistic-type\"> </a><p>Provenance for <a href=\"CodeSystem-statistic-type.html\">CodeSystem StatisticStatisticType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/statistic-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-study-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-study-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-study-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-study-type</b></p><a name=\"hx-fhir-1.0.51-cs-study-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-study-type\"> </a><p>Provenance for <a href=\"CodeSystem-study-type.html\">CodeSystem StatisticStudyType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/study-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-subscriber-relationship",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-subscriber-relationship",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-subscriber-relationship\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-subscriber-relationship</b></p><a name=\"hx-fhir-1.0.51-cs-subscriber-relationship\"> </a><a name=\"hchx-fhir-1.0.51-cs-subscriber-relationship\"> </a><p>Provenance for <a href=\"CodeSystem-subscriber-relationship.html\">CodeSystem SubscriberPolicyholder Relationship Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscriber-relationship"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-subscription-channel-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-subscription-channel-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-subscription-channel-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-subscription-channel-type</b></p><a name=\"hx-fhir-1.0.51-cs-subscription-channel-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-subscription-channel-type\"> </a><p>Provenance for <a href=\"CodeSystem-subscription-channel-type.html\">CodeSystem SubscriptionChannel Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscription-channel-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-subscription-error",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-subscription-error",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-subscription-error\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-subscription-error</b></p><a name=\"hx-fhir-1.0.51-cs-subscription-error\"> </a><a name=\"hchx-fhir-1.0.51-cs-subscription-error\"> </a><p>Provenance for <a href=\"CodeSystem-subscription-error.html\">CodeSystem Subscription Error Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscription-error"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-subscription-status-at-event",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-subscription-status-at-event",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-subscription-status-at-event\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-subscription-status-at-event</b></p><a name=\"hx-fhir-1.0.51-cs-subscription-status-at-event\"> </a><a name=\"hchx-fhir-1.0.51-cs-subscription-status-at-event\"> </a><p>Provenance for <a href=\"CodeSystem-subscription-status-at-event.html\">CodeSystem SubscriptionStatusAtEvent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscription-status-at-event"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-subscription-tag",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-subscription-tag",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-subscription-tag\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-subscription-tag</b></p><a name=\"hx-fhir-1.0.51-cs-subscription-tag\"> </a><a name=\"hchx-fhir-1.0.51-cs-subscription-tag\"> </a><p>Provenance for <a href=\"CodeSystem-subscription-tag.html\">CodeSystem SubscriptionTag</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscription-tag"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-substance-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-substance-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-substance-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-substance-category</b></p><a name=\"hx-fhir-1.0.51-cs-substance-category\"> </a><a name=\"hchx-fhir-1.0.51-cs-substance-category\"> </a><p>Provenance for <a href=\"CodeSystem-substance-category.html\">CodeSystem Substance Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/substance-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-supply-item-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-supply-item-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-supply-item-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-supply-item-type</b></p><a name=\"hx-fhir-1.0.51-cs-supply-item-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-supply-item-type\"> </a><p>Provenance for <a href=\"CodeSystem-supply-item-type.html\">CodeSystem Supply Item Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/supply-item-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-supply-kind",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-supply-kind",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-supply-kind\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-supply-kind</b></p><a name=\"hx-fhir-1.0.51-cs-supply-kind\"> </a><a name=\"hchx-fhir-1.0.51-cs-supply-kind\"> </a><p>Provenance for <a href=\"CodeSystem-supply-kind.html\">CodeSystem Supply Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/supply-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-supplyrequest-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-supplyrequest-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-supplyrequest-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-supplyrequest-reason</b></p><a name=\"hx-fhir-1.0.51-cs-supplyrequest-reason\"> </a><a name=\"hchx-fhir-1.0.51-cs-supplyrequest-reason\"> </a><p>Provenance for <a href=\"CodeSystem-supplyrequest-reason.html\">CodeSystem SupplyRequestReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/supplyrequest-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-synthesis-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-synthesis-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-synthesis-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-synthesis-type</b></p><a name=\"hx-fhir-1.0.51-cs-synthesis-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-synthesis-type\"> </a><p>Provenance for <a href=\"CodeSystem-synthesis-type.html\">CodeSystem StatisticSynthesisType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/synthesis-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-testscript-operation-codes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-testscript-operation-codes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-testscript-operation-codes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-testscript-operation-codes</b></p><a name=\"hx-fhir-1.0.51-cs-testscript-operation-codes\"> </a><a name=\"hchx-fhir-1.0.51-cs-testscript-operation-codes\"> </a><p>Provenance for <a href=\"CodeSystem-testscript-operation-codes.html\">CodeSystem Test script operation code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/testscript-operation-codes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-testscript-profile-destination-types",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-testscript-profile-destination-types",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-testscript-profile-destination-types\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-testscript-profile-destination-types</b></p><a name=\"hx-fhir-1.0.51-cs-testscript-profile-destination-types\"> </a><a name=\"hchx-fhir-1.0.51-cs-testscript-profile-destination-types\"> </a><p>Provenance for <a href=\"CodeSystem-testscript-profile-destination-types.html\">CodeSystem Test script profile destination type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/testscript-profile-destination-types"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-testscript-profile-origin-types",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-testscript-profile-origin-types",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-testscript-profile-origin-types\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-testscript-profile-origin-types</b></p><a name=\"hx-fhir-1.0.51-cs-testscript-profile-origin-types\"> </a><a name=\"hchx-fhir-1.0.51-cs-testscript-profile-origin-types\"> </a><p>Provenance for <a href=\"CodeSystem-testscript-profile-origin-types.html\">CodeSystem Test script profile origin type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/testscript-profile-origin-types"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-usage-context-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-usage-context-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-usage-context-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-usage-context-type</b></p><a name=\"hx-fhir-1.0.51-cs-usage-context-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-usage-context-type\"> </a><p>Provenance for <a href=\"CodeSystem-usage-context-type.html\">CodeSystem UsageContextType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/usage-context-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-validation-process",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-validation-process",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-validation-process\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-validation-process</b></p><a name=\"hx-fhir-1.0.51-cs-validation-process\"> </a><a name=\"hchx-fhir-1.0.51-cs-validation-process\"> </a><p>Provenance for <a href=\"CodeSystem-validation-process.html\">CodeSystem Validation-process</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/validation-process"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-validation-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-validation-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-validation-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-validation-status</b></p><a name=\"hx-fhir-1.0.51-cs-validation-status\"> </a><a name=\"hchx-fhir-1.0.51-cs-validation-status\"> </a><p>Provenance for <a href=\"CodeSystem-validation-status.html\">CodeSystem Validation-status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/validation-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-validation-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-validation-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-validation-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-validation-type</b></p><a name=\"hx-fhir-1.0.51-cs-validation-type\"> </a><a name=\"hchx-fhir-1.0.51-cs-validation-type\"> </a><p>Provenance for <a href=\"CodeSystem-validation-type.html\">CodeSystem Validation-type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/validation-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-variable-role",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-variable-role",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-variable-role\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-variable-role</b></p><a name=\"hx-fhir-1.0.51-cs-variable-role\"> </a><a name=\"hchx-fhir-1.0.51-cs-variable-role\"> </a><p>Provenance for <a href=\"CodeSystem-variable-role.html\">CodeSystem EvidenceVariableRole</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/variable-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-variant-state",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-variant-state",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-variant-state\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-variant-state</b></p><a name=\"hx-fhir-1.0.51-cs-variant-state\"> </a><a name=\"hchx-fhir-1.0.51-cs-variant-state\"> </a><p>Provenance for <a href=\"CodeSystem-variant-state.html\">CodeSystem sequenceStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/variant-state"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-cs-verificationresult-communication-method",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-cs-verificationresult-communication-method",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-cs-verificationresult-communication-method\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-cs-verificationresult-communication-method</b></p><a name=\"hx-fhir-1.0.51-cs-verificationresult-communication-method\"> </a><a name=\"hchx-fhir-1.0.51-cs-verificationresult-communication-method\"> </a><p>Provenance for <a href=\"CodeSystem-verificationresult-communication-method.html\">CodeSystem VerificationResult Communication Method</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/verificationresult-communication-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-action-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-action-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-action-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-action-type</b></p><a name=\"hx-fhir-1.0.51-vs-action-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-action-type\"> </a><p>Provenance for <a href=\"ValueSet-action-type.html\">ValueSet ActionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/action-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-activity-definition-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-activity-definition-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-activity-definition-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-activity-definition-category</b></p><a name=\"hx-fhir-1.0.51-vs-activity-definition-category\"> </a><a name=\"hchx-fhir-1.0.51-vs-activity-definition-category\"> </a><p>Provenance for <a href=\"ValueSet-activity-definition-category.html\">ValueSet ActivityDefinitionCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/activity-definition-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-adjudication-error",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-adjudication-error",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-adjudication-error\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-adjudication-error</b></p><a name=\"hx-fhir-1.0.51-vs-adjudication-error\"> </a><a name=\"hchx-fhir-1.0.51-vs-adjudication-error\"> </a><p>Provenance for <a href=\"ValueSet-adjudication-error.html\">ValueSet AdjudicationError</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adjudication-error"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-adjudication-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-adjudication-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-adjudication-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-adjudication-reason</b></p><a name=\"hx-fhir-1.0.51-vs-adjudication-reason\"> </a><a name=\"hchx-fhir-1.0.51-vs-adjudication-reason\"> </a><p>Provenance for <a href=\"ValueSet-adjudication-reason.html\">ValueSet Adjudication Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adjudication-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-adjudication",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-adjudication",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-adjudication\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-adjudication</b></p><a name=\"hx-fhir-1.0.51-vs-adjudication\"> </a><a name=\"hchx-fhir-1.0.51-vs-adjudication\"> </a><p>Provenance for <a href=\"ValueSet-adjudication.html\">ValueSet Adjudication Value Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adjudication"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-adverse-event-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-adverse-event-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-adverse-event-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-adverse-event-category</b></p><a name=\"hx-fhir-1.0.51-vs-adverse-event-category\"> </a><a name=\"hchx-fhir-1.0.51-vs-adverse-event-category\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-category.html\">ValueSet AdverseEventCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-adverse-event-causality-assess",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-adverse-event-causality-assess",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-adverse-event-causality-assess\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-adverse-event-causality-assess</b></p><a name=\"hx-fhir-1.0.51-vs-adverse-event-causality-assess\"> </a><a name=\"hchx-fhir-1.0.51-vs-adverse-event-causality-assess\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-causality-assess.html\">ValueSet AdverseEventCausalityAssessment</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-causality-assess"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-adverse-event-causality-method",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-adverse-event-causality-method",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-adverse-event-causality-method\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-adverse-event-causality-method</b></p><a name=\"hx-fhir-1.0.51-vs-adverse-event-causality-method\"> </a><a name=\"hchx-fhir-1.0.51-vs-adverse-event-causality-method\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-causality-method.html\">ValueSet AdverseEventCausalityMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-causality-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-adverse-event-seriousness",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-adverse-event-seriousness",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-adverse-event-seriousness\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-adverse-event-seriousness</b></p><a name=\"hx-fhir-1.0.51-vs-adverse-event-seriousness\"> </a><a name=\"hchx-fhir-1.0.51-vs-adverse-event-seriousness\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-seriousness.html\">ValueSet AdverseEventSeriousness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-seriousness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-adverse-event-severity",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-adverse-event-severity",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-adverse-event-severity\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-adverse-event-severity</b></p><a name=\"hx-fhir-1.0.51-vs-adverse-event-severity\"> </a><a name=\"hchx-fhir-1.0.51-vs-adverse-event-severity\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-severity.html\">ValueSet AdverseEventSeverity</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-severity"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-allerg-intol-substance-exp-risk",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-allerg-intol-substance-exp-risk",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-allerg-intol-substance-exp-risk\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-allerg-intol-substance-exp-risk</b></p><a name=\"hx-fhir-1.0.51-vs-allerg-intol-substance-exp-risk\"> </a><a name=\"hchx-fhir-1.0.51-vs-allerg-intol-substance-exp-risk\"> </a><p>Provenance for <a href=\"ValueSet-allerg-intol-substance-exp-risk.html\">ValueSet AllergyIntoleranceSubstanceExposureRisk</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/allerg-intol-substance-exp-risk"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-allergyintolerance-clinical",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-allergyintolerance-clinical",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-allergyintolerance-clinical\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-allergyintolerance-clinical</b></p><a name=\"hx-fhir-1.0.51-vs-allergyintolerance-clinical\"> </a><a name=\"hchx-fhir-1.0.51-vs-allergyintolerance-clinical\"> </a><p>Provenance for <a href=\"ValueSet-allergyintolerance-clinical.html\">ValueSet AllergyIntolerance Clinical Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/allergyintolerance-clinical"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-allergyintolerance-verification",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-allergyintolerance-verification",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-allergyintolerance-verification\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-allergyintolerance-verification</b></p><a name=\"hx-fhir-1.0.51-vs-allergyintolerance-verification\"> </a><a name=\"hchx-fhir-1.0.51-vs-allergyintolerance-verification\"> </a><p>Provenance for <a href=\"ValueSet-allergyintolerance-verification.html\">ValueSet AllergyIntolerance Verification Status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/allergyintolerance-verification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-appointment-cancellation-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-appointment-cancellation-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-appointment-cancellation-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-appointment-cancellation-reason</b></p><a name=\"hx-fhir-1.0.51-vs-appointment-cancellation-reason\"> </a><a name=\"hchx-fhir-1.0.51-vs-appointment-cancellation-reason\"> </a><p>Provenance for <a href=\"ValueSet-appointment-cancellation-reason.html\">ValueSet Appointment cancellation reason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/appointment-cancellation-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-attribute-estimate-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-attribute-estimate-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-attribute-estimate-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-attribute-estimate-type</b></p><a name=\"hx-fhir-1.0.51-vs-attribute-estimate-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-attribute-estimate-type\"> </a><p>Provenance for <a href=\"ValueSet-attribute-estimate-type.html\">ValueSet StatisticAttributeEstimateType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/attribute-estimate-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-audit-event-outcome",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-audit-event-outcome",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-audit-event-outcome\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-audit-event-outcome</b></p><a name=\"hx-fhir-1.0.51-vs-audit-event-outcome\"> </a><a name=\"hchx-fhir-1.0.51-vs-audit-event-outcome\"> </a><p>Provenance for <a href=\"ValueSet-audit-event-outcome.html\">ValueSet Audit Event Outcome</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/audit-event-outcome"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-audit-source-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-audit-source-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-audit-source-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-audit-source-type</b></p><a name=\"hx-fhir-1.0.51-vs-audit-source-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-audit-source-type\"> </a><p>Provenance for <a href=\"ValueSet-audit-source-type.html\">ValueSet Audit Event Source Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/audit-source-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-basic-resource-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-basic-resource-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-basic-resource-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-basic-resource-type</b></p><a name=\"hx-fhir-1.0.51-vs-basic-resource-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-basic-resource-type\"> </a><p>Provenance for <a href=\"ValueSet-basic-resource-type.html\">ValueSet Basic Resource Types</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/basic-resource-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-benefit-network",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-benefit-network",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-benefit-network\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-benefit-network</b></p><a name=\"hx-fhir-1.0.51-vs-benefit-network\"> </a><a name=\"hchx-fhir-1.0.51-vs-benefit-network\"> </a><p>Provenance for <a href=\"ValueSet-benefit-network.html\">ValueSet Network Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/benefit-network"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-benefit-term",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-benefit-term",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-benefit-term\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-benefit-term</b></p><a name=\"hx-fhir-1.0.51-vs-benefit-term\"> </a><a name=\"hchx-fhir-1.0.51-vs-benefit-term\"> </a><p>Provenance for <a href=\"ValueSet-benefit-term.html\">ValueSet Benefit Term Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/benefit-term"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-benefit-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-benefit-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-benefit-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-benefit-type</b></p><a name=\"hx-fhir-1.0.51-vs-benefit-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-benefit-type\"> </a><p>Provenance for <a href=\"ValueSet-benefit-type.html\">ValueSet Benefit Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/benefit-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-benefit-unit",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-benefit-unit",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-benefit-unit\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-benefit-unit</b></p><a name=\"hx-fhir-1.0.51-vs-benefit-unit\"> </a><a name=\"hchx-fhir-1.0.51-vs-benefit-unit\"> </a><p>Provenance for <a href=\"ValueSet-benefit-unit.html\">ValueSet Unit Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/benefit-unit"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-catalogType",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-catalogType",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-catalogType\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-catalogType</b></p><a name=\"hx-fhir-1.0.51-vs-catalogType\"> </a><a name=\"hchx-fhir-1.0.51-vs-catalogType\"> </a><p>Provenance for <a href=\"ValueSet-catalogType.html\">ValueSet CatalogType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/catalogType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-certainty-rating",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-certainty-rating",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-certainty-rating\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-certainty-rating</b></p><a name=\"hx-fhir-1.0.51-vs-certainty-rating\"> </a><a name=\"hchx-fhir-1.0.51-vs-certainty-rating\"> </a><p>Provenance for <a href=\"ValueSet-certainty-rating.html\">ValueSet StatisticCertaintyRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/certainty-rating"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-certainty-subcomponent-rating",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-certainty-subcomponent-rating",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-certainty-subcomponent-rating\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-certainty-subcomponent-rating</b></p><a name=\"hx-fhir-1.0.51-vs-certainty-subcomponent-rating\"> </a><a name=\"hchx-fhir-1.0.51-vs-certainty-subcomponent-rating\"> </a><p>Provenance for <a href=\"ValueSet-certainty-subcomponent-rating.html\">ValueSet StatisticCertaintySubcomponentRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/certainty-subcomponent-rating"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-certainty-subcomponent-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-certainty-subcomponent-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-certainty-subcomponent-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-certainty-subcomponent-type</b></p><a name=\"hx-fhir-1.0.51-vs-certainty-subcomponent-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-certainty-subcomponent-type\"> </a><p>Provenance for <a href=\"ValueSet-certainty-subcomponent-type.html\">ValueSet StatisticCertaintySubcomponentType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/certainty-subcomponent-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-characteristic-method",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-characteristic-method",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-characteristic-method\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-characteristic-method</b></p><a name=\"hx-fhir-1.0.51-vs-characteristic-method\"> </a><a name=\"hchx-fhir-1.0.51-vs-characteristic-method\"> </a><p>Provenance for <a href=\"ValueSet-characteristic-method.html\">ValueSet CharacteristicMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/characteristic-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-chargeitem-billingcodes",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-chargeitem-billingcodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-chargeitem-billingcodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-chargeitem-billingcodes</b></p><a name=\"hx-fhir-1.0.51-vs-chargeitem-billingcodes\"> </a><a name=\"hchx-fhir-1.0.51-vs-chargeitem-billingcodes\"> </a><p>Provenance for <a href=\"ValueSet-chargeitem-billingcodes.html\">ValueSet ChargeItemCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/chargeitem-billingcodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-choice-list-orientation",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-choice-list-orientation",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-choice-list-orientation\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-choice-list-orientation</b></p><a name=\"hx-fhir-1.0.51-vs-choice-list-orientation\"> </a><a name=\"hchx-fhir-1.0.51-vs-choice-list-orientation\"> </a><p>Provenance for <a href=\"ValueSet-choice-list-orientation.html\">ValueSet ChoiceListOrientation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/choice-list-orientation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-chromosome-human",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-chromosome-human",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-chromosome-human\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-chromosome-human</b></p><a name=\"hx-fhir-1.0.51-vs-chromosome-human\"> </a><a name=\"hchx-fhir-1.0.51-vs-chromosome-human\"> </a><p>Provenance for <a href=\"ValueSet-chromosome-human.html\">ValueSet chromosome-human</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/chromosome-human"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-claim-careteamrole",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-claim-careteamrole",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-claim-careteamrole\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-claim-careteamrole</b></p><a name=\"hx-fhir-1.0.51-vs-claim-careteamrole\"> </a><a name=\"hchx-fhir-1.0.51-vs-claim-careteamrole\"> </a><p>Provenance for <a href=\"ValueSet-claim-careteamrole.html\">ValueSet Claim Care Team Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-careteamrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-claim-exception",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-claim-exception",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-claim-exception\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-claim-exception</b></p><a name=\"hx-fhir-1.0.51-vs-claim-exception\"> </a><a name=\"hchx-fhir-1.0.51-vs-claim-exception\"> </a><p>Provenance for <a href=\"ValueSet-claim-exception.html\">ValueSet Exception Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-exception"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-claim-informationcategory",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-claim-informationcategory",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-claim-informationcategory\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-claim-informationcategory</b></p><a name=\"hx-fhir-1.0.51-vs-claim-informationcategory\"> </a><a name=\"hchx-fhir-1.0.51-vs-claim-informationcategory\"> </a><p>Provenance for <a href=\"ValueSet-claim-informationcategory.html\">ValueSet Claim Information Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-informationcategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-claim-modifiers",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-claim-modifiers",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-claim-modifiers\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-claim-modifiers</b></p><a name=\"hx-fhir-1.0.51-vs-claim-modifiers\"> </a><a name=\"hchx-fhir-1.0.51-vs-claim-modifiers\"> </a><p>Provenance for <a href=\"ValueSet-claim-modifiers.html\">ValueSet Modifier type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-modifiers"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-claim-subtype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-claim-subtype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-claim-subtype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-claim-subtype</b></p><a name=\"hx-fhir-1.0.51-vs-claim-subtype\"> </a><a name=\"hchx-fhir-1.0.51-vs-claim-subtype\"> </a><p>Provenance for <a href=\"ValueSet-claim-subtype.html\">ValueSet Example Claim SubType Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-subtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-claim-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-claim-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-claim-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-claim-type</b></p><a name=\"hx-fhir-1.0.51-vs-claim-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-claim-type\"> </a><p>Provenance for <a href=\"ValueSet-claim-type.html\">ValueSet Claim Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-codesystem-altcode-kind",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-codesystem-altcode-kind",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-codesystem-altcode-kind\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-codesystem-altcode-kind</b></p><a name=\"hx-fhir-1.0.51-vs-codesystem-altcode-kind\"> </a><a name=\"hchx-fhir-1.0.51-vs-codesystem-altcode-kind\"> </a><p>Provenance for <a href=\"ValueSet-codesystem-altcode-kind.html\">ValueSet AlternativeCodeKind</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/codesystem-altcode-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-common-tags",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-common-tags",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-common-tags\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-common-tags</b></p><a name=\"hx-fhir-1.0.51-vs-common-tags\"> </a><a name=\"hchx-fhir-1.0.51-vs-common-tags\"> </a><p>Provenance for <a href=\"ValueSet-common-tags.html\">ValueSet Common Tags</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/common-tags"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-communication-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-communication-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-communication-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-communication-category</b></p><a name=\"hx-fhir-1.0.51-vs-communication-category\"> </a><a name=\"hchx-fhir-1.0.51-vs-communication-category\"> </a><p>Provenance for <a href=\"ValueSet-communication-category.html\">ValueSet CommunicationCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/communication-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-communication-not-done-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-communication-not-done-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-communication-not-done-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-communication-not-done-reason</b></p><a name=\"hx-fhir-1.0.51-vs-communication-not-done-reason\"> </a><a name=\"hchx-fhir-1.0.51-vs-communication-not-done-reason\"> </a><p>Provenance for <a href=\"ValueSet-communication-not-done-reason.html\">ValueSet CommunicationNotDoneReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/communication-not-done-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-communication-topic",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-communication-topic",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-communication-topic\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-communication-topic</b></p><a name=\"hx-fhir-1.0.51-vs-communication-topic\"> </a><a name=\"hchx-fhir-1.0.51-vs-communication-topic\"> </a><p>Provenance for <a href=\"ValueSet-communication-topic.html\">ValueSet CommunicationTopic</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/communication-topic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-composite-measure-scoring",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-composite-measure-scoring",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-composite-measure-scoring\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-composite-measure-scoring</b></p><a name=\"hx-fhir-1.0.51-vs-composite-measure-scoring\"> </a><a name=\"hchx-fhir-1.0.51-vs-composite-measure-scoring\"> </a><p>Provenance for <a href=\"ValueSet-composite-measure-scoring.html\">ValueSet CompositeMeasureScoring</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/composite-measure-scoring"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-composition-altcode-kind",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-composition-altcode-kind",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-composition-altcode-kind\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-composition-altcode-kind</b></p><a name=\"hx-fhir-1.0.51-vs-composition-altcode-kind\"> </a><a name=\"hchx-fhir-1.0.51-vs-composition-altcode-kind\"> </a><p>Provenance for <a href=\"ValueSet-composition-altcode-kind.html\">ValueSet AlternativeCodeKind</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/composition-altcode-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-condition-category",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-condition-category",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-condition-category\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-condition-category</b></p><a name=\"hx-fhir-1.0.51-vs-condition-category\"> </a><a name=\"hchx-fhir-1.0.51-vs-condition-category\"> </a><p>Provenance for <a href=\"ValueSet-condition-category.html\">ValueSet Condition Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/condition-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-condition-clinical",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-condition-clinical",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-condition-clinical\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-condition-clinical</b></p><a name=\"hx-fhir-1.0.51-vs-condition-clinical\"> </a><a name=\"hchx-fhir-1.0.51-vs-condition-clinical\"> </a><p>Provenance for <a href=\"ValueSet-condition-clinical.html\">ValueSet Condition Clinical Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/condition-clinical"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-condition-state",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-condition-state",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-condition-state\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-condition-state</b></p><a name=\"hx-fhir-1.0.51-vs-condition-state\"> </a><a name=\"hchx-fhir-1.0.51-vs-condition-state\"> </a><p>Provenance for <a href=\"ValueSet-condition-state.html\">ValueSet ConditionState</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/condition-state"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-condition-ver-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-condition-ver-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-condition-ver-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-condition-ver-status</b></p><a name=\"hx-fhir-1.0.51-vs-condition-ver-status\"> </a><a name=\"hchx-fhir-1.0.51-vs-condition-ver-status\"> </a><p>Provenance for <a href=\"ValueSet-condition-ver-status.html\">ValueSet ConditionVerificationStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/condition-ver-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-conformance-expectation",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-conformance-expectation",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-conformance-expectation\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-conformance-expectation</b></p><a name=\"hx-fhir-1.0.51-vs-conformance-expectation\"> </a><a name=\"hchx-fhir-1.0.51-vs-conformance-expectation\"> </a><p>Provenance for <a href=\"ValueSet-conformance-expectation.html\">ValueSet ConformanceExpectation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/conformance-expectation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-consent-action",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-consent-action",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-consent-action\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-consent-action</b></p><a name=\"hx-fhir-1.0.51-vs-consent-action\"> </a><a name=\"hchx-fhir-1.0.51-vs-consent-action\"> </a><p>Provenance for <a href=\"ValueSet-consent-action.html\">ValueSet Consent Action Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/consent-action"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-consent-policy",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-consent-policy",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-consent-policy\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-consent-policy</b></p><a name=\"hx-fhir-1.0.51-vs-consent-policy\"> </a><a name=\"hchx-fhir-1.0.51-vs-consent-policy\"> </a><p>Provenance for <a href=\"ValueSet-consent-policy.html\">ValueSet Consent PolicyRule Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/consent-policy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-consent-scope",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-consent-scope",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-consent-scope\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-consent-scope</b></p><a name=\"hx-fhir-1.0.51-vs-consent-scope\"> </a><a name=\"hchx-fhir-1.0.51-vs-consent-scope\"> </a><p>Provenance for <a href=\"ValueSet-consent-scope.html\">ValueSet Consent Scope Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/consent-scope"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-consent-verification",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-consent-verification",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-consent-verification\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-consent-verification</b></p><a name=\"hx-fhir-1.0.51-vs-consent-verification\"> </a><a name=\"hchx-fhir-1.0.51-vs-consent-verification\"> </a><p>Provenance for <a href=\"ValueSet-consent-verification.html\">ValueSet Consent Verification Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/consent-verification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contactentity-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contactentity-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contactentity-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contactentity-type</b></p><a name=\"hx-fhir-1.0.51-vs-contactentity-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-contactentity-type\"> </a><p>Provenance for <a href=\"ValueSet-contactentity-type.html\">ValueSet Contact entity type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contactentity-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-container-cap",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-container-cap",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-container-cap\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-container-cap</b></p><a name=\"hx-fhir-1.0.51-vs-container-cap\"> </a><a name=\"hchx-fhir-1.0.51-vs-container-cap\"> </a><p>Provenance for <a href=\"ValueSet-container-cap.html\">ValueSet ContainerCap</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/container-cap"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contract-action",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contract-action",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contract-action\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contract-action</b></p><a name=\"hx-fhir-1.0.51-vs-contract-action\"> </a><a name=\"hchx-fhir-1.0.51-vs-contract-action\"> </a><p>Provenance for <a href=\"ValueSet-contract-action.html\">ValueSet Contract Action Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-action"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contract-actorrole",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contract-actorrole",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contract-actorrole\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contract-actorrole</b></p><a name=\"hx-fhir-1.0.51-vs-contract-actorrole\"> </a><a name=\"hchx-fhir-1.0.51-vs-contract-actorrole\"> </a><p>Provenance for <a href=\"ValueSet-contract-actorrole.html\">ValueSet Contract Actor Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-actorrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contract-content-derivative",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contract-content-derivative",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contract-content-derivative\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contract-content-derivative</b></p><a name=\"hx-fhir-1.0.51-vs-contract-content-derivative\"> </a><a name=\"hchx-fhir-1.0.51-vs-contract-content-derivative\"> </a><p>Provenance for <a href=\"ValueSet-contract-content-derivative.html\">ValueSet Contract Content Derivation Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-content-derivative"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contract-data-meaning",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contract-data-meaning",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contract-data-meaning\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contract-data-meaning</b></p><a name=\"hx-fhir-1.0.51-vs-contract-data-meaning\"> </a><a name=\"hchx-fhir-1.0.51-vs-contract-data-meaning\"> </a><p>Provenance for <a href=\"ValueSet-contract-data-meaning.html\">ValueSet ContractDataMeaning</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-data-meaning"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contract-signer-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contract-signer-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contract-signer-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contract-signer-type</b></p><a name=\"hx-fhir-1.0.51-vs-contract-signer-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-contract-signer-type\"> </a><p>Provenance for <a href=\"ValueSet-contract-signer-type.html\">ValueSet Contract Signer Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-signer-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contract-subtype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contract-subtype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contract-subtype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contract-subtype</b></p><a name=\"hx-fhir-1.0.51-vs-contract-subtype\"> </a><a name=\"hchx-fhir-1.0.51-vs-contract-subtype\"> </a><p>Provenance for <a href=\"ValueSet-contract-subtype.html\">ValueSet Contract Subtype Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-subtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contract-term-subtype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contract-term-subtype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contract-term-subtype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contract-term-subtype</b></p><a name=\"hx-fhir-1.0.51-vs-contract-term-subtype\"> </a><a name=\"hchx-fhir-1.0.51-vs-contract-term-subtype\"> </a><p>Provenance for <a href=\"ValueSet-contract-term-subtype.html\">ValueSet Contract Term Subtype Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-term-subtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contract-term-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contract-term-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contract-term-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contract-term-type</b></p><a name=\"hx-fhir-1.0.51-vs-contract-term-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-contract-term-type\"> </a><p>Provenance for <a href=\"ValueSet-contract-term-type.html\">ValueSet Contract Term Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-term-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-contract-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-contract-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-contract-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-contract-type</b></p><a name=\"hx-fhir-1.0.51-vs-contract-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-contract-type\"> </a><p>Provenance for <a href=\"ValueSet-contract-type.html\">ValueSet Contract Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-copy-number-event",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-copy-number-event",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-copy-number-event\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-copy-number-event</b></p><a name=\"hx-fhir-1.0.51-vs-copy-number-event\"> </a><a name=\"hchx-fhir-1.0.51-vs-copy-number-event\"> </a><p>Provenance for <a href=\"ValueSet-copy-number-event.html\">ValueSet CopyNumberEvent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/copy-number-event"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-coverage-class",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-coverage-class",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-coverage-class\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-coverage-class</b></p><a name=\"hx-fhir-1.0.51-vs-coverage-class\"> </a><a name=\"hchx-fhir-1.0.51-vs-coverage-class\"> </a><p>Provenance for <a href=\"ValueSet-coverage-class.html\">ValueSet Coverage Class Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/coverage-class"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-coverage-copay-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-coverage-copay-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-coverage-copay-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-coverage-copay-type</b></p><a name=\"hx-fhir-1.0.51-vs-coverage-copay-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-coverage-copay-type\"> </a><p>Provenance for <a href=\"ValueSet-coverage-copay-type.html\">ValueSet Coverage Copay Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/coverage-copay-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-coverage-financial-exception",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-coverage-financial-exception",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-coverage-financial-exception\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-coverage-financial-exception</b></p><a name=\"hx-fhir-1.0.51-vs-coverage-financial-exception\"> </a><a name=\"hchx-fhir-1.0.51-vs-coverage-financial-exception\"> </a><p>Provenance for <a href=\"ValueSet-coverage-financial-exception.html\">ValueSet Example Coverage Financial Exception Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/coverage-financial-exception"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-coverage-selfpay",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-coverage-selfpay",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-coverage-selfpay\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-coverage-selfpay</b></p><a name=\"hx-fhir-1.0.51-vs-coverage-selfpay\"> </a><a name=\"hchx-fhir-1.0.51-vs-coverage-selfpay\"> </a><p>Provenance for <a href=\"ValueSet-coverage-selfpay.html\">ValueSet Coverage SelfPay Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/coverage-selfpay"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-coverageeligibilityresponse-ex-auth-support",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-coverageeligibilityresponse-ex-auth-support",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-coverageeligibilityresponse-ex-auth-support\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-coverageeligibilityresponse-ex-auth-support</b></p><a name=\"hx-fhir-1.0.51-vs-coverageeligibilityresponse-ex-auth-support\"> </a><a name=\"hchx-fhir-1.0.51-vs-coverageeligibilityresponse-ex-auth-support\"> </a><p>Provenance for <a href=\"ValueSet-coverageeligibilityresponse-ex-auth-support.html\">ValueSet CoverageEligibilityResponse Auth Support Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/coverageeligibilityresponse-ex-auth-support"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-definition-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-definition-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-definition-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-definition-status</b></p><a name=\"hx-fhir-1.0.51-vs-definition-status\"> </a><a name=\"hchx-fhir-1.0.51-vs-definition-status\"> </a><p>Provenance for <a href=\"ValueSet-definition-status.html\">ValueSet DefinitionStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/definition-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-definition-topic",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-definition-topic",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-definition-topic\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-definition-topic</b></p><a name=\"hx-fhir-1.0.51-vs-definition-topic\"> </a><a name=\"hchx-fhir-1.0.51-vs-definition-topic\"> </a><p>Provenance for <a href=\"ValueSet-definition-topic.html\">ValueSet DefinitionTopic</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/definition-topic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-definition-use",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-definition-use",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-definition-use\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-definition-use</b></p><a name=\"hx-fhir-1.0.51-vs-definition-use\"> </a><a name=\"hchx-fhir-1.0.51-vs-definition-use\"> </a><p>Provenance for <a href=\"ValueSet-definition-use.html\">ValueSet Structure Definition Use Codes / Keywords</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/definition-use"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-device-kind",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-device-kind",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-device-kind\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-device-kind</b></p><a name=\"hx-fhir-1.0.51-vs-device-kind\"> </a><a name=\"hchx-fhir-1.0.51-vs-device-kind\"> </a><p>Provenance for <a href=\"ValueSet-device-kind.html\">ValueSet FHIR Device Types</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/device-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-device-status-reason",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-device-status-reason",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-device-status-reason\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-device-status-reason</b></p><a name=\"hx-fhir-1.0.51-vs-device-status-reason\"> </a><a name=\"hchx-fhir-1.0.51-vs-device-status-reason\"> </a><p>Provenance for <a href=\"ValueSet-device-status-reason.html\">ValueSet FHIRDeviceStatusReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/device-status-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-diagnosis-role",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-diagnosis-role",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-diagnosis-role\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-diagnosis-role</b></p><a name=\"hx-fhir-1.0.51-vs-diagnosis-role\"> </a><a name=\"hchx-fhir-1.0.51-vs-diagnosis-role\"> </a><p>Provenance for <a href=\"ValueSet-diagnosis-role.html\">ValueSet DiagnosisRole</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/diagnosis-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-directness",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-directness",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-directness\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-directness</b></p><a name=\"hx-fhir-1.0.51-vs-directness\"> </a><a name=\"hchx-fhir-1.0.51-vs-directness\"> </a><p>Provenance for <a href=\"ValueSet-directness.html\">ValueSet EvidenceDirectness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/directness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-dose-rate-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-dose-rate-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-dose-rate-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-dose-rate-type</b></p><a name=\"hx-fhir-1.0.51-vs-dose-rate-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-dose-rate-type\"> </a><p>Provenance for <a href=\"ValueSet-dose-rate-type.html\">ValueSet DoseAndRateType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/dose-rate-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-encounter-admit-source",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-encounter-admit-source",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-encounter-admit-source\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-encounter-admit-source</b></p><a name=\"hx-fhir-1.0.51-vs-encounter-admit-source\"> </a><a name=\"hchx-fhir-1.0.51-vs-encounter-admit-source\"> </a><p>Provenance for <a href=\"ValueSet-encounter-admit-source.html\">ValueSet Admit source</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/encounter-admit-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-encounter-diet",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-encounter-diet",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-encounter-diet\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-encounter-diet</b></p><a name=\"hx-fhir-1.0.51-vs-encounter-diet\"> </a><a name=\"hchx-fhir-1.0.51-vs-encounter-diet\"> </a><p>Provenance for <a href=\"ValueSet-encounter-diet.html\">ValueSet Diet</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/encounter-diet"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-encounter-discharge-disposition",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-encounter-discharge-disposition",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-encounter-discharge-disposition\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-encounter-discharge-disposition</b></p><a name=\"hx-fhir-1.0.51-vs-encounter-discharge-disposition\"> </a><a name=\"hchx-fhir-1.0.51-vs-encounter-discharge-disposition\"> </a><p>Provenance for <a href=\"ValueSet-encounter-discharge-disposition.html\">ValueSet Discharge disposition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/encounter-discharge-disposition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-encounter-special-arrangements",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-encounter-special-arrangements",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-encounter-special-arrangements\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-encounter-special-arrangements</b></p><a name=\"hx-fhir-1.0.51-vs-encounter-special-arrangements\"> </a><a name=\"hchx-fhir-1.0.51-vs-encounter-special-arrangements\"> </a><p>Provenance for <a href=\"ValueSet-encounter-special-arrangements.html\">ValueSet Special arrangements</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/encounter-special-arrangements"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-encounter-subject-status",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-encounter-subject-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-encounter-subject-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-encounter-subject-status</b></p><a name=\"hx-fhir-1.0.51-vs-encounter-subject-status\"> </a><a name=\"hchx-fhir-1.0.51-vs-encounter-subject-status\"> </a><p>Provenance for <a href=\"ValueSet-encounter-subject-status.html\">ValueSet Encounter subject status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/encounter-subject-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-encounter-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-encounter-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-encounter-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-encounter-type</b></p><a name=\"hx-fhir-1.0.51-vs-encounter-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-encounter-type\"> </a><p>Provenance for <a href=\"ValueSet-encounter-type.html\">ValueSet Encounter type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/encounter-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-endpoint-connection-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-endpoint-connection-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-endpoint-connection-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-endpoint-connection-type</b></p><a name=\"hx-fhir-1.0.51-vs-endpoint-connection-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-endpoint-connection-type\"> </a><p>Provenance for <a href=\"ValueSet-endpoint-connection-type.html\">ValueSet Endpoint Connection Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/endpoint-connection-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-entformula-additive",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-entformula-additive",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-entformula-additive\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-entformula-additive</b></p><a name=\"hx-fhir-1.0.51-vs-entformula-additive\"> </a><a name=\"hchx-fhir-1.0.51-vs-entformula-additive\"> </a><p>Provenance for <a href=\"ValueSet-entformula-additive.html\">ValueSet Enteral Formula Additive Type Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/entformula-additive"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-episodeofcare-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-episodeofcare-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-episodeofcare-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-episodeofcare-type</b></p><a name=\"hx-fhir-1.0.51-vs-episodeofcare-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-episodeofcare-type\"> </a><p>Provenance for <a href=\"ValueSet-episodeofcare-type.html\">ValueSet Episode of care type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/episodeofcare-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-evidence-quality",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-evidence-quality",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-evidence-quality\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-evidence-quality</b></p><a name=\"hx-fhir-1.0.51-vs-evidence-quality\"> </a><a name=\"hchx-fhir-1.0.51-vs-evidence-quality\"> </a><p>Provenance for <a href=\"ValueSet-evidence-quality.html\">ValueSet QualityOfEvidenceRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/evidence-quality"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-ex-benefitcategory",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-ex-benefitcategory",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-ex-benefitcategory\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-ex-benefitcategory</b></p><a name=\"hx-fhir-1.0.51-vs-ex-benefitcategory\"> </a><a name=\"hchx-fhir-1.0.51-vs-ex-benefitcategory\"> </a><p>Provenance for <a href=\"ValueSet-ex-benefitcategory.html\">ValueSet Benefit Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ex-benefitcategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-ex-diagnosis-on-admission",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-ex-diagnosis-on-admission",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-ex-diagnosis-on-admission\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-ex-diagnosis-on-admission</b></p><a name=\"hx-fhir-1.0.51-vs-ex-diagnosis-on-admission\"> </a><a name=\"hchx-fhir-1.0.51-vs-ex-diagnosis-on-admission\"> </a><p>Provenance for <a href=\"ValueSet-ex-diagnosis-on-admission.html\">ValueSet Example Diagnosis on Admission Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ex-diagnosis-on-admission"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-ex-diagnosisrelatedgroup",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-ex-diagnosisrelatedgroup",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-ex-diagnosisrelatedgroup\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-ex-diagnosisrelatedgroup</b></p><a name=\"hx-fhir-1.0.51-vs-ex-diagnosisrelatedgroup\"> </a><a name=\"hchx-fhir-1.0.51-vs-ex-diagnosisrelatedgroup\"> </a><p>Provenance for <a href=\"ValueSet-ex-diagnosisrelatedgroup.html\">ValueSet Example Diagnosis Related Group Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ex-diagnosisrelatedgroup"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-ex-diagnosistype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-ex-diagnosistype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-ex-diagnosistype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-ex-diagnosistype</b></p><a name=\"hx-fhir-1.0.51-vs-ex-diagnosistype\"> </a><a name=\"hchx-fhir-1.0.51-vs-ex-diagnosistype\"> </a><p>Provenance for <a href=\"ValueSet-ex-diagnosistype.html\">ValueSet Example Diagnosis Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ex-diagnosistype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-ex-payee-resource-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-ex-payee-resource-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-ex-payee-resource-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-ex-payee-resource-type</b></p><a name=\"hx-fhir-1.0.51-vs-ex-payee-resource-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-ex-payee-resource-type\"> </a><p>Provenance for <a href=\"ValueSet-ex-payee-resource-type.html\">ValueSet ClaimPayeeResourceType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ex-payee-resource-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-ex-paymenttype",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-ex-paymenttype",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-ex-paymenttype\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-ex-paymenttype</b></p><a name=\"hx-fhir-1.0.51-vs-ex-paymenttype\"> </a><a name=\"hchx-fhir-1.0.51-vs-ex-paymenttype\"> </a><p>Provenance for <a href=\"ValueSet-ex-paymenttype.html\">ValueSet Example Payment Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ex-paymenttype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-ex-procedure-type",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-ex-procedure-type",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-ex-procedure-type\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-ex-procedure-type</b></p><a name=\"hx-fhir-1.0.51-vs-ex-procedure-type\"> </a><a name=\"hchx-fhir-1.0.51-vs-ex-procedure-type\"> </a><p>Provenance for <a href=\"ValueSet-ex-procedure-type.html\">ValueSet Example Procedure Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ex-procedure-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-ex-program-code",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-ex-program-code",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-ex-program-code\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-ex-program-code</b></p><a name=\"hx-fhir-1.0.51-vs-ex-program-code\"> </a><a name=\"hchx-fhir-1.0.51-vs-ex-program-code\"> </a><p>Provenance for <a href=\"ValueSet-ex-program-code.html\">ValueSet Example Program Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ex-program-code"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-ex-revenue-center",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-ex-revenue-center",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-ex-revenue-center\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-ex-revenue-center</b></p><a name=\"hx-fhir-1.0.51-vs-ex-revenue-center\"> </a><a name=\"hchx-fhir-1.0.51-vs-ex-revenue-center\"> </a><p>Provenance for <a href=\"ValueSet-ex-revenue-center.html\">ValueSet Example Revenue Center Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ex-revenue-center"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-expansion-parameter-source",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-expansion-parameter-source",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-expansion-parameter-source\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-expansion-parameter-source</b></p><a name=\"hx-fhir-1.0.51-vs-expansion-parameter-source\"> </a><a name=\"hchx-fhir-1.0.51-vs-expansion-parameter-source\"> </a><p>Provenance for <a href=\"ValueSet-expansion-parameter-source.html\">ValueSet ExpansionParameterSource</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/expansion-parameter-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-expansion-processing-rule",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-expansion-processing-rule",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-expansion-processing-rule\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-expansion-processing-rule</b></p><a name=\"hx-fhir-1.0.51-vs-expansion-processing-rule\"> </a><a name=\"hchx-fhir-1.0.51-vs-expansion-processing-rule\"> </a><p>Provenance for <a href=\"ValueSet-expansion-processing-rule.html\">ValueSet ExpansionProcessingRule</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-14</td></tr><tr><td>Recorded</td><td>2020-10-14 16:46:34+1100</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Grahame Grieve</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/expansion-processing-rule"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-14"
        },
        "recorded" : "2020-10-14T16:46:34.413+11:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Reset Version after migration to UTG"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Grahame Grieve"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx-fhir-1.0.51-vs-financial-taskcode",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx-fhir-1.0.51-vs-financial-taskcode",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx-fhir-1.0.51-vs-financial-taskcode\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx-fhir-1.0.51-vs-financial-taskcode</b></p><a name=\"hx-fhir-1.0.51-vs-financial-taskcode\"> </a><a name=\"hchx-fhir-1.0.51-vs-financial-taskcode\"> </a><p>Provenance for <a href=\"ValueSet-financial-taskcode.html\">ValueSet Financial Task Codes</a></p><p>Summary</p><tabl