# Screening and Assessments - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **Screening and Assessments**

## Screening and Assessments

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

### Introduction

Clinicians use various terms such as **assessments**, **scales**, **surveys**, and **screenings** to describe the tools and processes to collect health-related information for assessing a patient's health-related matter. US Cores uses the term **Screening and Assessments** for recording responses and capturing assertions/determinations resulting from this process and these tools. This page documents how Screening and Assessments are used to identify various problems or health concerns and how US Core Profiles record Screenings and Assessments ranging from simple observations to complex structured evaluations.

With the addition of the USCDI Health Status Assessments data elements, US Core expanded the guidance from Social Determinant of Health (SDOH)-only focus to a general framework of Screenings and Assessments for all domains, including the USCDI Data Elements:

* Social Determinant of Health (SDOH)
* Functional Status
* Disability Status
* Mental/Cognitive Status
* Physical Activity
* Alcohol Use
* Substance Use

However, implementers **SHOULD** consider more constrained, domain-specific profiles derived from the US Core Profiles to meet the needs of their respective use cases.

The [Gravity Project](https://hl7.org/gravity) and its [SDOH Clinical Care](http://hl7.org/fhir/us/sdoh-clinicalcare/index.html) HL7 Implementation Guide address the screening process and related interventions to address Social Determinant of Health (SDOH). Those efforts helped guide US Core 5.0.1 updates to meet the [USCDI](uscdi.md) SDOH data elements for Assessments, Goals, Interventions, and Problems/Health Concerns.

### Related Activities in Clinical Care

The figure below shows how screening and assessments lead to providing services for a patient.

* **Screening and Assessments**: [Screening and Assessment](#screening-and-assessments) are used to identify problems before delivering appropriate clinical care. The following US Core Profiles support capturing their responses: 
* [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)
* The [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)
* The [SDC Base Questionnaire](http://hl7.org/fhir/uv/sdc/StructureDefinition-sdc-questionnaire.html)/[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md)
 
* **Problems/Health Concerns**: The identified health-related conditions (for example, homelessness or disability) are represented by: 
* [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)
* [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md).
 
* **Interventions**: The [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md) communicates services offered to patients to address problems/health concerns. The [US Core Procedure Profile](StructureDefinition-us-core-procedure.md) can also record a completed service or intervention.
* **Goals**: Identifying and defining a future desired condition or change in condition (for example, "Has adequate quality meals and snacks") is represented by [US Core Goal Profile](StructureDefinition-us-core-goal.md).

**Screening and Assessment Activities**
![](screening_and_assessments.svg)

### Screening and Assessments

Screening and Assessments are used to identify various problems or health concerns. Their complexity ranges from simple observations to complex structured evaluations:

* Clinician makes a simple observation - (for example, the patient states they are homeless)
* Clinician administers a survey to gather information (for example, the [Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences (PRAPARE) Survey](https://www.nachc.org/research-and-data/prapare/))
* Clinician makes a "clinical judgment" based on an assessment tool. (for example, based on the PRAPARE survey, the patient has a lack of access to transportation)

The following guidance was developed after reviewing several functional status, disability status, mental/cognitive status, and SDOH screening and assessment tools.

#### Clinical Judgments

Whether based on simple observations or detailed assessments, clinicians may record clinical judgments as either:

* a problem or health concern
* as observation

Local policies guide what is appropriate for the problem list and what is appropriate for an observation. For example, some clinics may consider social needs sensitive information inappropriate for the problem list. Observations can contribute to the identification of future problems or health concerns and support service requests and procedures.

Every Server that supports the USDCI Data Class "Health Status/Assessments":

* **SHALL** support representing clinical judgments using [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md) or [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md). 
* The US Core Simple Observation Profile's `Observation.derivedFrom` element **SHOULD** reference the Structured Screening and Assessment upon which clinical judgment observations are made (see below). Likewise, the US Core Condition Profile's `Condition.evidence.detail` element **SHOULD** reference the Structured Screening and Assessment which assist in diagnosing problems or health concerns.
 

#### Structured Screening and Assessments

Screening and Assessments can be structured survey instruments consisting of questions with various responses, including true/false, coded, textual, and multiple choice. Examples include PRAPARE, [Apgar score](https://en.wikipedia.org/wiki/Apgar_score), and [PHQ-9](https://en.wikipedia.org/wiki/PHQ-9). US Core defines two ways to represent the questions and responses to these screening and assessment instruments:

* Observation: [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)
* Questionnaire/QuestionnaireResponse: [SDC Base Questionnaire](http://hl7.org/fhir/uv/sdc/StructureDefinition-sdc-questionnaire.html)/[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md)

Servers that support the USCDI Health Status/Assessments Data Class **SHALL** support the US Core Observation Screening Assessment Profile and **SHOULD** support the SDC Base Questionnaire and the US Core QuestionnaireResponse Profile.

The sections below provide additional guidance on when Observations and Questionnaire/QuestionnaireResponse can be used to represent the structured screenings and assessments.

##### US Core Observation Screening Assessment Profile

[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md) is defined to record observations from responses to screening tools and assessments used for any context (e.g., SDOH, functional status, etc.). Although systems can represent most questions and answers in healthcare assessments as FHIR Observations, it is only sometimes necessary and appropriate to represent all of them as Observations. Only relevant responses should be extracted as Observations. For example, depending on the use case and focus of the Assessment or Survey, patient demographic information may be recorded in the Patient resource instead of Observations. The observations can be grouped and nested to preserve the structure of screening or assessment instruments. The figure below illustrates the relationship between the Observation screening and assessments "panel" and the individual screening and assessment "item" Observations. Each box represents an Observation:

**Relationship Between Screening Assessment Observations**
![](uscore-observation-assessment-structure.svg)

Note that the panels can be nested to create additional groupings of responses. See the [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md) page for detailed documentation on how the observations are linked, examples, and search requirements.

###### Searching for Screening and Assessment Data

Unlike QuestionnaireResponse, When Observations are used to record a set of Screening and Assessments responses, Clients can query individual responses using the standard FHIR RESTful API search parameters. The example below is a FHIR RESTful search transaction on Observation to access a patient's SDOH assessment:

 Click on Here To See Search Example 

* Patient's FHIR_id = "example"
* Observation category = "sdoh"

**Request**

Request url using GET

GET `http://wildfhir4.aegis.net/fhir4-0-1/Observation?patient=Patient/example&category=sdoh`

Request Headers

```
User-Agent: python-requests/2.25.1
Accept-Encoding: gzip, deflate
Accept: application/fhir+json
Connection: keep-alive
Content-Type: application/fhir+json

```

**Response**

200 OK

Response Headers

```
Connection: keep-alive
Content-Location: http://wildfhir4.aegis.net/fhir4-0-1/Observation?patient=Patient%2Fexample&category=sdoh
Content-Type: application/fhir+json;charset=utf-8
Content-Length: 4112
Date: Sun, 21 Nov 2021 03:15:18 GMT

```

Response Body

```
{
  "resourceType": "Bundle",
  "id": "158f4b97-5b3a-4363-81da-19d454a6df30",
  "meta": {
    "versionId": "1",
    "lastUpdated": "2021-11-20T22:15:18.726-05:00"
  },
  "type": "searchset",
  "total": 1,
  "link": [
    {
      "relation": "self",
      "url": "http://wildfhir4.aegis.net/fhir4-0-1/Observation?patient=Patient%2Fexample&category=sdoh"
    }
  ],
  "entry": [
    {
      "fullUrl": "http://wildfhir4.aegis.net/fhir4-0-1/Observation/hunger-question-example",
      "resource": {
        "resourceType": "Observation",
        "id": "hunger-question-example",
        "meta": {
          "extension": [
            {
              "url": "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString": "Hunger Question Example"
            },
            {
              "url": "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown": "This is a Hunger Question Example for the *US Core Screening Response Observation Profile*."
            }
          ],
          "versionId": "1",
          "lastUpdated": "2021-11-20T22:13:54.070-05:00",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-response"
          ]
        },
        "text": {
          "status": "generated",
          "div": "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p><b>Generated Narrative with Details</b></p><p><b>meta</b>:       \n      </p><p><b>status</b>: FINAL      \n      </p><p><b>category</b>: SDOH         \n        <span style=\"background: LightGoldenRodYellow\">(Details : {LOINC code 'sdoh' = 'sdoh', given as 'SDOH'})</span>, Survey         \n        <span style=\"background: LightGoldenRodYellow\">(Details : {http://terminology.hl7.org/CodeSystem/observation-category code 'survey' = 'Survey', given as 'Survey'})</span></p><p><b>code</b>:  Within the past 12 months we worried whether our food would run out before we got money to buy more         \n        <span style=\"background: LightGoldenRodYellow\">(Details : {LOINC code '88122-7' = ' Within the past 12 months we worried whether our food would run out before we got money to buy more', given as ' Within the past 12 months we worried whether our food would run out before we got money to buy more'})</span></p><p><b>subject</b>:         \n        <a href=\"Patient/example\">Patient/example</a></p><p><b>effective</b>: Nov 12, 2021 8:59:15 PM      \n      </p><p><b>performer</b>:         \n        <a href=\"Patient/example\">Patient/example</a></p><p><b>value</b>: Often true         \n        <span style=\"background: LightGoldenRodYellow\">(Details : {LOINC code 'LA28397-0' = 'Often true', given as 'Often true'})</span></p><p><b>derivedFrom</b>: Hunger Vital Signs Questionnaire      \n      </p></div>"
        },
        "status": "final",
        "category": [
          {
            "coding": [
              {
                "system": "http://loinc.org",
                "code": "sdoh",
                "display": "SDOH"
              }
            ]
          },
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/observation-category",
                "code": "survey",
                "display": "Survey"
              }
            ]
          }
        ],
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "88122-7",
              "display": " Within the past 12 months we worried whether our food would run out before we got money to buy more"
            }
          ]
        },
        "subject": {
          "reference": "Patient/example"
        },
        "effectiveDateTime": "2021-11-12T17:59:15-08:00",
        "performer": [
          {
            "reference": "Patient/example"
          }
        ],
        "valueCodeableConcept": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "LA28397-0",
              "display": "Often true"
            }
          ]
        },
        "derivedFrom": [
          {
            "display": "Hunger Vital Signs Questionnaire"
          }
        ]
      },
      "search": {
        "mode": "match",
        "score": 1
      }
    }
  ]
}

```

##### SDC Base Questionnaire/US Core QuestionnaireResponse Profile

Screening and assessment instruments may be represented as questionnaires, including FHIR Questionnaires. The [Structured Data Capture (SDC)](http://hl7.org/fhir/uv/sdc) specification documents the workflow for the creation, discovery, retrieval, and data extraction of FHIR Questionnaire and QuestionnaireResponse. The [US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) is based on the [Structured Data Capture (SDC) Questionnaire Response Profile](http://hl7.org/fhir/uv/sdc/StructureDefinition-sdc-questionnaireresponse.html)) and is used to capture, exchange, and persist the response data. QuestionnaireResponse can be considered a snapshot of the filled-out answer forms to the screening and assessment questions in the [SDC Base Questionnaire](http://hl7.org/fhir/uv/sdc/StructureDefinition-sdc-questionnaire.html). It is ordered and grouped according to the FHIR Questionnaire and can be consulted when a complete and accurate record of the responses is required. Refer to the [US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) page for detailed documentation, examples, and search requirements.

###### Extracting US Core Observation Screening Assessment from US Core QuestionnaireResponse

US Core Observation Screening Assessment can be extracted from US Core QuestionnaireResponse. Although QuestionnaireResponse can be searched using the standard FHIR RESTful API search parameters, individual responses are not directly searchable in QuestionnaireResponse. To search directly for individual responses, the QuestionnaireResponse must be "parsed" into a searchable form - i.e., to a local FHIR or non-FHIR data store such as a database or FHIR Observations. Both SDC and the [SDOH Clinical Care](http://hl7.org/fhir/us/sdoh-clinicalcare/index.html) implementation guide define how data captured in a QuestionnaireResponse can be extracted and used to create or update Observations or other FHIR resources.

#### Choosing Between QuestionnaireResponse and Observation

For API developers using US Core, it's important to understand when to use the QuestionnaireResponse versus Observation to represent structured assessments and surveys. Here are some guidelines to help choose the appropriate profile:

* Observations represent specific point-in-time facts that need to be searched, trended, the subject of statistical analysis, and directly referenced in support of other actions. Not all answers in a form will necessarily be appropriate to surface as an Observation. However, anything that meets one of the preceding criteria must be surfaced as an Observation.
* QuestionnaireResponses represent the source-of-truth of a completed form. QuestionnaireResponse shows how the question was phrased, what answer text was seen or typed, the order in which the survey or assessment was completed, etc. For FHIR implementers, it is important to note that QuestionnaireResponse references a specific version of a form, whether it was represented as a FHIR Questionnaire or not. (however, it may be challenging to determine canonical URLs and linkIds consistently across systems without using a FHIR Questionnaire.) This reference provides the context of exactly what options were available, what logic was used to calculate answers, and what questions were asked. It is important to note that QuestionnaireResponse cannot be used for searching based on individual responses but to capture higher-level information such as what form was filled out, by whom, and when.

In many cases, data might be represented using both mechanisms - the initial raw assessment retained for audit or detailed review stored as a QuestionnaireResponse, and the detailed key answers surfaced as Observations for easy search and analysis.

### Terminology

#### Category Codes

API consumers can query by category when accessing patient information. Each profile's **Quick Start** section shows searches by category if the category element is defined in the profile. US Core defined these USCDI Health Assessments Data Elements category codes:

| | |
| :--- | :--- |
| SDOH | "sdoh" |
| Functional Status | "functional-status" |
| Mental/Cognitive Status | "cognitive-status" |
| Disability Status | "disability-status" |
| Physical Activity | "activity" |
| Alcohol Use | "social-history" |
| Substance Use | "social-history" |

For the US Core Simple Observation Profile and US Core Observation Screening Assessment Profiles, Servers **SHALL** support all the category codes listed above.

For the US Core Condition Problems and Health Concerns Profile, Servers **SHALL** support the code ,"sdoh", and **SHOULD** support the other category codes listed above.

For the US Core ServiceRequest Profile, Servers **SHOULD** support all the above category codes.

The category element is optional in US Core Procedure and US Core Goal, but implementers can categorize them using one of the above category codes or infer the context by inspecting the referenced ServiceRequest if available. Similarly, they can review the Questionnaire resource's metadata to determine the context of the US Core QuestionnaireResponse.

Clients need to understand that data categorization is somewhat subjective. The categorization applied by the source may not align with the Client's expectations. Clients may find it more beneficial to use queries based on a specific code or set of codes or to perform additional Client-side filtering of query results.

#### Screening and Assessment Codes

The US Core Observation Screening Assessment Profile, SDC Base Questionnaire, and US Core Simple Observation Profiles have [preferred](http://hl7.org/fhir/R4/terminologies.html#preferred) or [example](http://hl7.org/fhir/R4/terminologies.html#example) bindings to broadly defined LOINC value sets. These value sets contain concepts that span many use cases and are not bound to any USCDI Health Assessments Data Element.

##### USCDI Health Assessments Data Element Value Sets

The following sections and table below identify the associated value sets for each USCDI Health Status Assessments Data Element. This guidance intends to promote interoperability by introducing "starter" value sets **where available** for the USCDI Data Elements covered by Screenings and Assessments. These value sets are divided into clinical judgment codes, structured screening and assessment panel codes, and structured screening and assessment panel item codes. Note that a suitable value set has yet to be identified in several instances. Implementers **SHOULD** treat these value sets as having an [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible) binding. In other words, the **Clinical Judgement Codes** code sets are extensibly bound to the US Core Condition Problems and Health Concerns Profile and the US Core Simple Observation Profile when representing clinical judgments. Similarly, **Panel Codes** and **Panel Item Codes** are extensibly bound to the US Core Observation Screening Assessment Profile and SDC Base Questionnaire/US Core QuestionnaireResponse Profile when representing structured screening and assessments. Because the value sets in this table are not formally bound to a US Core Profile in the StructureDefinitions, "automatic" validation (confirmation) that a code is a member of a value set will not occur using the standard validation tools.

###### SDOH value sets

* The Gravity project created and maintains the [Social Determinants of Health Screening Assessments And Questions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.206/expansion) value set for the SDOH USCDI Health Assessments Data Element. This value set contains both panel and panel item codes.


  In addition to these concepts, implementers should consider using several SDOH value sets maintained and updated in VSAC by [Multiple Chronic Condition (MCC) Care Plan Implementation Guide](https://hl7.org/fhir/us/mcc/2023Sep/) and the HL7 Patent Care work group with support from the National Institute of Health. These are panel item codes that may be part of a LOINC panel.

*  [Caregiver Availability](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1058/expansion) 
*  [Caregiver Characteristics](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1057/expansion) 
*  [Criminal Justice Involvement or Incarceration History](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1082/expansion) 
*  [Current or Former Occupation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1048/expansion) 
*  [Dependents in Home](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1065/expansion) 
*  [English Proficiency](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1030/expansion) 
*  [Experiences of Discrimination](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1080/expansion) 
*  [Exposure to Environmental Hazards](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1075/expansion) 
*  [Immigration Status](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1083/expansion) 
*  [Income Level](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1053/expansion) 
*  [Leisure Activity Engagement](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1069/expansion) 
*  [Living Situation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1060/expansion) 
*  [Marital or Spousal Status](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1064/expansion) 
*  [Neglect](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1042/expansion) 
*  [Physical Activity Level](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1068/expansion) 
*  [Unsafe Neighborhood](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1076/expansion) 
*  [Work Productivity](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1050/expansion) 

###### Functional Status

* The [Functional Status Related Questionnaire Panel Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1586/expansion) contains LOINC panel codes that represent functional status questionnaire LOINC panel code, such as CMS Assessment.

###### Mental and Cognitive Health

* The [Cognitive Health Related Questionnaire Panel Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.979/expansion) contains LOINC panel codes that represent Mental or Cognitive health screening assessments, such as FACIT, PROMIS, and MoCA.
* The [Cognitive Function Clinician Interpretation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.979/expansion) represents clinical judgment codes such as "Cognitive Function Interpretation".
* The [Mental Status Observation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.1/expansion) value set contains SNOMED CT clinical judgment codes related to mental status observations that can come from a broad range of subjective and objective information such as Assessment and Screening tools. In many cases, the value (answer) at `Observation.value` may be boolean true | false.

###### Disability Status

* The [Disability Status Assessment](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.49/expansion) contains LOINC panel item codes that represent detailed patient questions about functional status, such as difficulty dressing or bathing.

###### Physical Activity

* The [Physical Activity Observation Questions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.9/expansion) are panel item codes taken from the [Physical Activity Implementation Guide](https://hl7.org/fhir/us/physical-activity/), sponsored by the [American Heart Association](http://heart.org/) and the [Physical Activity Alliance](http://paamovewithus.org/). In addition to contributing to the terminology for the USCDI Health Assessments Physical Activity Data Element, the guide documents a standardized way of measuring and sharing a patient's physical activity.


  In addition to these concepts, implementers should consider using [Physical Activity Level](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1068/expansion) referenced in the SDOH section above. It represents simple question-and-answer assessment questions such as, "Kinds of physical activity you usually performed while on the job this last year" or "Days per week of moderate to vigorous physical activity".

###### Substance Use (Including Alcohol Use)

* The [Substance Use](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1015/expansion) contain LOINC panel item codes such as, "How often do you have a drink containing alcohol" or "How often have you used any prescription medications just for the feeling, more than prescribed or that were not prescribed for you in past 12 months (TAPS)"
* The [Alcohol Use Related Questionnaire Panel Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1585/expansion) contains the LOINC Panel Codes for Alcohol Use Disorder Identification Test - Consumption AUDIT-C and PROMIS short form - alcohol use 7a - version 1.0.
* The [Drug Misuse](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.707/expansion) values set contains SNOMED CT clinical judgment codes to represent conclusions or diagnoses about drug misuse or abuse. In many cases, the value (answer) at `Observation.value` may be boolean true | false.

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| SDOH | [Social Determinants of Health Screening Assessments and Questions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.206/expansion) |  | ✔ | ✔ |
| Functional Status | [Functional Status Clinician Interpretation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1007/expansion) | ✔ |  |  |
| Functional Status | [Functional Status Related Questionnaire Panel Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1586/expansion) |  | ✔ |  |
| Mental/Cognitive Status | [Cognitive Function Clinician Interpretation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.979/expansion) | ✔ |  |  |
| Mental/Cognitive Status | [Mental Status Observation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.1/expansion) | ✔ |  |  |
| Mental/Cognitive Status | [Cognitive Health Related Questionnaire Panel Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1584/expansion) |  | ✔ |  |
| Disability Status | [Disability Status Assessment](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.49/expansion) |  |  | ✔ |
| Physical Activity | [Physical Activity Observation Questions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.9/expansion) |  |  | ✔ |
| Alcohol Use | [Alcohol Use Related Questionnaire Panel Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1585/expansion) |  | ✔ |  |
| Alcohol Use | [Substance Use](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1015/expansion) |  |  | ✔ |
| Substance Use | [Drug Misuse](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.707/expansion) | ✔ |  |  |
| Substance Use | [Substance Use](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1015/expansion) |  |  | ✔ |

This information is also available as a [csv](tables/assessments-valuesets.csv) or [excel](tables/assessments-valuesets.xlsx) file:

#### Codes for Problems/HealthConcerns, Goals, Service Requests, and Procedures

US Core uses broadly defined value sets that contain concepts used across use cases, including SDOH. For the SDOH Clinical Care HL7 Implementation Guide, the Gravity Project has defined "Grouped Value Sets" across specific social risk factor domains for problems/health concerns, goals, procedures, and service requests. Value sets for each SDOH domain are bundled together to create the groupings. The links below are to these Gravity Project-managed value sets in the [Value Set Authority Center (VSAC)](https://vsac.nlm.nih.gov/). In VSAC, clicking "Grouping Members" within the Value Set Details tab will present the many individual value sets in the group representing the various SDOH domains. These grouped value sets are narrower subsets of the value sets allowed in the respective US Core Profiles. However, when recording SDOH data US Core Profiles, Servers **SHOULD** use them.

* [Social Determinants of Health Conditions Value Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.788/expansion)
* [Social Determinants of Health Procedures Value Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.789/expansion)
* [Social Determinants of Health Goals Value Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.71/expansion)
* [Social Determinants of Health Service Requests Value Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.790/expansion)

The figure below illustrates how the Gravity value sets are grouped for use in the US Core Condition Problems and Health Concerns Profile and how the grouped value set is compatible with the broader US Core Problem code value set.

**SDOH Grouped Value Set Reuse in US Core**
![](sdoh_condition.svg)

### Examples

These examples show what Screening and Assessments data produced and consumed by systems conforming with this implementation guide might look like.

#### Social Determinant of Health (SDOH) Examples

* [Questionnaire PRAPARE Example](Questionnaire-prapare-example.md)
* [Questionnaire Hunger Vital Sign (HVS) Example](Questionnaire-hunger-vital-sign-example.md)
* [QuestionnaireResponse PRAPARE Example](QuestionnaireResponse-prapare-example.md)
* [QuestionnaireResponse Hunger Vital Sign (HVS) Example](QuestionnaireResponse-hunger-vital-sign-example.md)
* [Ahc-Hrsn Item Observation Example 68517-2](Observation-AHC-HRSN-item-example-68517-2.md)
* [Prapare Item Example 54899-0](Observation-PRAPARE-item-example-54899-0.md)
* [Prapare Item Example 56051-6](Observation-PRAPARE-item-example-56051-6.md)
* [Prapare Item Example 56799-0](Observation-PRAPARE-item-example-56799-0.md)
* [Prapare Item Example 63512-8](Observation-PRAPARE-item-example-63512-8.md)
* [Prapare Item Example 63586-2](Observation-PRAPARE-item-example-63586-2.md)
* [Prapare Item Example 67875-5](Observation-PRAPARE-item-example-67875-5.md)
* [Prapare Item Example 71802-3](Observation-PRAPARE-item-example-71802-3.md)
* [Prapare Item Example 76437-3](Observation-PRAPARE-item-example-76437-3.md)
* [Prapare Item Example 76501-6](Observation-PRAPARE-item-example-76501-6.md)
* [Prapare Item Example 82589-3](Observation-PRAPARE-item-example-82589-3.md)
* [Prapare Item Example 93026-3](Observation-PRAPARE-item-example-93026-3.md)
* [Prapare Item Example 93027-1](Observation-PRAPARE-item-example-93027-1.md)
* [Prapare Item Example 93028-9](Observation-PRAPARE-item-example-93028-9.md)
* [Prapare Item Example 93029-7](Observation-PRAPARE-item-example-93029-7.md)
* [Prapare Item Example 93030-5](Observation-PRAPARE-item-example-93030-5.md)
* [Prapare Item Example 93033-9](Observation-PRAPARE-item-example-93033-9.md)
* [Prapare Item Example 93034-7](Observation-PRAPARE-item-example-93034-7.md)
* [Prapare Item Example 93035-4](Observation-PRAPARE-item-example-93035-4.md)
* [Prapare Item Example 93038-8](Observation-PRAPARE-item-example-93038-8.md)
* [Prapare Multiselect-Item Example 32624-9-Answer0](Observation-PRAPARE-multiselect-item-example-32624-9-answer0.md)
* [Prapare Multiselect-Item Example 32624-9-Answer1](Observation-PRAPARE-multiselect-item-example-32624-9-answer1.md)
* [Prapare Multiselect-Item Example 93031-3-Answer0](Observation-PRAPARE-multiselect-item-example-93031-3-answer0.md)
* [Prapare Multiselect-Item Example 93031-3-Answer1](Observation-PRAPARE-multiselect-item-example-93031-3-answer1.md)
* [Prapare Panel Example 93025-5](Observation-PRAPARE-panel-example-93025-5.md)
* [Prapare Panel Example 93039-6](Observation-PRAPARE-panel-example-93039-6.md)
* [Prapare Panel Example 93040-4](Observation-PRAPARE-panel-example-93040-4.md)
* [Prapare Panel Example 93041-2](Observation-PRAPARE-panel-example-93041-2.md)
* [Prapare Panel Example 93042-0](Observation-PRAPARE-panel-example-93042-0.md)
* [PRAPARE Panel Example 93043-8](Observation-PRAPARE-panel-example-93043-8.md)
* [HVS Item Example 88122-7](Observation-HVS-item-example-88122-7.md)
* [HVS Item Example 88123-5](Observation-HVS-item-example-88123-5.md)
* [HVS Item Example 88124-3](Observation-HVS-item-example-88124-3.md)
* [HVSPanel Example 88121-9](Observation-HVS-panel-example-88121-9.md)
* [Simple Observation SDOH Example](Observation-simple-observation-sdoh.md)
* [SDOH Problem/Health Concern Example](Condition-condition-SDOH-example.md)
* [ServiceRequest Food Pantry Referral Example](ServiceRequest-foodpantry-referral.md)
* [Goal 2 Example](Goal-goal-sdoh-2.md) 

#### Functional Status Examples

 
* [Simple Observation Functional Status Example](Observation-simple-observation-functional-status.md) 

#### Disability Status Examples

 
* [Simple Observation Disability Status Example](Observation-simple-observation-disability-status.md) 

#### Mental/Cognitive Status Examples

 
* [Questionnaire PHQ-9 Example](Questionnaire-phq-9-example.md)
* [QuestionnaireResponse PHQ-9 Example](QuestionnaireResponse-phq-9-example.md)
* [PHQ9 Item Example 44250-9](Observation-PHQ9-item-example-44250-9.md)
* [PHQ9 Item Example 44251-7](Observation-PHQ9-item-example-44251-7.md)
* [PHQ9 Item Example 44252-5](Observation-PHQ9-item-example-44252-5.md)
* [PHQ9 Item Example 44253-3](Observation-PHQ9-item-example-44253-3.md)
* [PHQ9 Item Example 44254-1](Observation-PHQ9-item-example-44254-1.md)
* [PHQ9 Item Example 44255-8](Observation-PHQ9-item-example-44255-8.md)
* [PHQ9 Item Example 44258-2](Observation-PHQ9-item-example-44258-2.md)
* [PHQ9 Item Example 44259-0](Observation-PHQ9-item-example-44259-0.md)
* [PHQ9 Item Example 44260-8](Observation-PHQ9-item-example-44260-8.md)
* [PHQ9 Item Example 44261-6](Observation-PHQ9-item-example-44261-6.md)
* [PHQ9 Item Example 69722-7](Observation-PHQ9-item-example-69722-7.md)
* [PHQ9 Panel Example 44249-1](Observation-PHQ9-panel-example-44249-1.md)
* [Simple Observation Cognitive Status Example](Observation-simple-observation-cognitive-status.md) 

#### Physical Activity Health Status Assessment Examples

 
* [Evs Item Example 68516-4](Observation-EVS-item-example-68516-4.md)
* [Evs Item Example 89555-7](Observation-EVS-item-example-89555-7.md)
* [Evs Panel Example 89574-8](Observation-EVS-panel-example-89574-8.md)
* [Exercise Per Day Example](Observation-exercise-per-day.md)
* [Exercise Per Week Example](Observation-exercise-per-week.md)
* [Exercise Vital Sign Questionnaire Example](Questionnaire-exercise-vital-sign.md)
* [Exercise Vital Sign QuestionnaireResponse Example](QuestionnaireResponse-exercise-vital-sign.md) 

#### Alcohol Use Health Status Assessment Examples

 
* [Alcohol Use Status Example](Observation-alcohol-use-status.md)
* [Alcoholic Drinks Per Day Example](Observation-alcoholic-drinks-per-day.md)
* [Audit-C Item Example 68517-2](Observation-AUDIT-C-item-example-68517-2.md)
* [Audit-C Item Example 68519-8](Observation-AUDIT-C-item-example-68519-8.md)
* [Audit-C Item Example 68520-6](Observation-AUDIT-C-item-example-68520-6.md)
* [Audit-C Item Example 75626-2](Observation-AUDIT-C-item-example-75626-2.md)
* [Audit-C Panel Example 72109-2](Observation-AUDIT-C-panel-example-72109-2.md)
* [Alcohol Use Disorder Identification Test - Consumption (AUDIT-C) Questionnaire Example](Questionnaire-AUDIT-C.md)
* [Alcohol Use Disorder Identification Test - Consumption (AUDIT-C) QuestionnaireResponse Example](QuestionnaireResponse-AUDIT-C.md) 

#### Substance Use Health Status Assessment Examples

 
* [Substance Use Status Example](Observation-substance-use-status.md)
* [Taps Item Example 75889-6](Observation-TAPS-item-example-75889-6.md)
* [Taps Item Example 88037-7](Observation-TAPS-item-example-88037-7.md)
* [Taps Item Example 96842-0](Observation-TAPS-item-example-96842-0.md)
* [Taps Item Example 96843-8](Observation-TAPS-item-example-96843-8.md)
* [Taps Item Example 96844-6](Observation-TAPS-item-example-96844-6.md)
* [Taps Panel Example 96841-2](Observation-TAPS-panel-example-96841-2.md)
* [Tobacco, Alcohol, Prescription medications, and other Substance use screen (TAPS) Questionnaire Example](Questionnaire-TAPS.md)
* [Tobacco, Alcohol, Prescription medications, and other Substance use screen (TAPS) QuestionnaireResponse Example](QuestionnaireResponse-TAPS.md)

