# SMART on FHIR Obligations and Capabilities - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Conformance**](conformance.md)
* **SMART on FHIR Obligations and Capabilities**

## SMART on FHIR Obligations and Capabilities

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

The [SMART App Launch](http://hl7.org/fhir/smart-app-launch/STU2.2) implementation guide describes a set of foundational patterns based on OAuth 2.0 for Client applications to authorize, authenticate, and integrate with FHIR-based data systems. This page documents the SMART on FHIR obligations and capabilities for US Core Servers supporting User-Facing Applications and Backend Services.

### Capability Sets for US Core Servers Supporting User-Facing Applications and Backend Services

To promote interoperability, SMART on FHIR defines a set of core capabilities. An individual SMART Server will publish a granular list of its capabilities, and a set of these capabilities is combined to support a specific use, a **Capability Set**. See SMART App Launch's [FHIR OAuth authorization Endpoints and Capabilities](http://hl7.org/fhir/smart-app-launch/STU2.2/conformance.html#smart-on-fhir-oauth-authorization-endpoints-and-capabilities) for more details. Servers **MAY** support the other SMART on FHIR **Capability Sets** and capabilities than those listed below.

#### Capabilities for Implementations Supporting User-Facing Applications

At least one of the following SMART on FHIR **Capability Sets** **SHOULD** be supported for US Core Servers that support User-Facing Applications. For certified systems, both **SHALL** be supported:

* [Patient Access for Standalone Apps](http://hl7.org/fhir/smart-app-launch/STU2.2/conformance.html#patient-access-for-standalone-apps)
* [Clinician Access for EHR Launch](http://hl7.org/fhir/smart-app-launch/STU2.2/conformance.html#clinician-access-for-standalone)

#### Capabilities for Implementations Supporting Backend Services

Implementations supporting Backend Services – for example, to meet US EHR certification requirements - **SHALL** include support for the `client-confidential-asymmetric` capability and `system/scopes`.

### US Core Servers SHALL Support Token Introspection

US Core Server **SHALL** support token introspection defined by the SMART App Launch Guide. For more details and additional consideration, see SMART App Launch's [Token Introspection](http://hl7.org/fhir/smart-app-launch/STU2.2/token-introspection.html#token-introspection)).

### SMART Scopes

SMART's scopes, defined in Version 2.0.0 and later of the SMART App Launch implementation guide, allow access permissions to be delegated to a Client application. To allow access to specific data about a single patient, the US Core API requires Servers to support [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data) and "[granular scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#finer-grained-resource-constraints-using-search-parameters)", the finer-grained scopes using search parameters. US Core's required scopes (**SHALL**) are based on community-based consensus that the scope meets a system requirement, clinical need, or federal regulation. Similarly, US Core's recommended scopes (**SHOULD**) rely on community-based consensus that the scope meets a system requirement or clinical need as a best practice.

The US Core required scopes listed below are named in the [HTI-1 final rule](https://www.federalregister.gov/documents/2023/04/18/2023-07229/health-data-technology-and-interoperability-certification-program-updates-algorithm-transparency-and), which requires support for the Condition and Observation category scopes. (Note that although mentioned in HTI-1 final rule, there is no "Clinical Test" category for Observation in US Core.) The recommended granular scopes listed below are of particular interest to patients and health systems. Implementations meeting US EHR certification requirements must support all US Core's required scopes. Other systems only need to support scopes for the US Core APIs they support.

Each US Core Profile page includes a "Quick Start" section summarizing each profile's supported search transactions and scopes. Servers **MAY** support other scopes in addition to those listed below and in the Quick Start sections. US Core Clients should follow the [principle of least privilege](https://en.wikipedia.org/wiki/Principle_of_least_privilege) and access only the necessary resources. In other words, if a Client needs only vital sign observations, it should request access only to Observations with a category of "vital-signs". Note that a granular scope grants access to all resources matching that granular scope **regardless of whether other categories** are present.

#### Scopes Format

SMART App Launch Version 2.0.0 introduced a scope syntax of: `<patient|user|system> / <fhir-resource>. <c | r | u | d |s> [?param=value]`

For example, to limit read and search access to a specific patient's laboratory observations but not other observations, the Server grants the following patient-specific scope:

`patient/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory`.

This example uses a `patient/` prefix, but implementers may support `system/` and `user/`.

#### US Core Scopes

The table below summarizes the US Core scope requirements (**SHALL**) and best practice recommendations (**SHOULD**) for resource-level adn granular scopes. This information can be found for each US Core Profile in the profile page's "Quick Start" section.

For "User-Facing Applications", a system's support for patient-level (`patient`) or user-level (`user`) scopes depends on its published list of SMART on FHIR capabilities (see the [capability sets](#capability-sets) above). For example, if a Server lists `permission-patient` and `permission-user` in its capabilities, it **SHALL** support both patient-level and user-level required scopes and **SHOULD** support both patient-level and user-level recommended best-practice scopes.

For "Backend-Services", System-level scopes (`system`) describe data that a Client system is directly authorized to access. Systems that support system-level (`system`) scopes **SHALL** support the required US Core scopes and **SHOULD** support the recommended US Core scopes.

##### Scopes For Requesting FHIR Resources By Type

The following scopes that correspond directly to FHIR resource types **SHALL** be supported

| | |
| :--- | :--- |
| AllergyIntolerance | `<patient|user|system>/AllergyIntolerance.rs` |
| CarePlan | `<patient|user|system>/CarePlan.rs` |
| CareTeam | `<patient|user|system>/CareTeam.rs` |
| Condition | `<patient|user|system>/Condition.rs` |
| Coverage | `<patient|user|system>/Coverage.rs` |
| Device | `<patient|user|system>/Device.rs` |
| DiagnosticReport | `<patient|user|system>/DiagnosticReport.rs` |
| DocumentReference | `<patient|user|system>/DocumentReference.rs` |
| Encounter | `<patient|user|system>/Encounter.rs` |
| Goal | `<patient|user|system>/Goal.rs` |
| Immunization | `<patient|user|system>/Immunization.rs` |
| MedicationDispense | `<patient|user|system>/MedicationDispense.rs` |
| MedicationRequest | `<patient|user|system>/MedicationRequest.rs` |
| Observation | `<patient|user|system>/Observation.rs` |
| Organization | `<patient|user|system>/Organization.rs` |
| Patient | `<patient|user|system>/Patient.rs` |
| Practitioner | `<patient|user|system>/Practitioner.rs` |
| PractitionerRole | `<patient|user|system>/PractitionerRole.rs` |
| Procedure | `<patient|user|system>/Procedure.rs` |
| Provenance | `<patient|user|system>/Provenance.rs` |
| QuestionnaireResponse | `<patient|user|system>/QuestionnaireResponse.rs` |
| RelatedPerson | `<patient|user|system>/RelatedPerson.rs` |
| ServiceRequest | `<patient|user|system>/ServiceRequest.rs` |
| Specimen | `<patient|user|system>/Specimen.rs` |

The following scopes that correspond directly to FHIR resource types **MAY** be supported

| | |
| :--- | :--- |
| Location | `<patient|user|system>/Location.rs` |
| Medication | `<patient|user|system>/Medication.rs` |

##### Granular Scopes For Requesting FHIR Resources

The following **granular** scopes **SHALL** be supported

| | |
| :--- | :--- |
| Condition | `<patient|user|system>/Condition.rs?category=http://hl7.org/fhir/us/core/CodeSystem/condition-category|health-concern` |
| Condition | `<patient|user|system>/Condition.rs?category=http://terminology.hl7.org/CodeSystem/condition-category|encounter-diagnosis` |
| Condition | `<patient|user|system>/Condition.rs?category=http://terminology.hl7.org/CodeSystem/condition-category|problem-list-item` |
| Observation | `<patient|user|system>/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|sdoh` |
| Observation | `<patient|user|system>/Observation.rs?category=http://terminology.hl7.org//CodeSystem-observation-category|social-history` |
| Observation | `<patient|user|system>/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory` |
| Observation | `<patient|user|system>/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|survey` |
| Observation | `<patient|user|system>/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs` |

The following **granular** scopes **SHOULD** be supported

| | |
| :--- | :--- |
| DocumentReference | `<patient|user|system>/DocumentReference.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category|clinical-note` |

###### Best Practices

End users often select all the scopes presented if given a "select all" option. Therefore, client provisioning is key to empowering patients with scopes and avoiding unnecessary access. This page reflects best practices when implementing Granular Scopes. See also [Considerations for Scope Consent](https://www.hl7.org/fhir/smart-app-launch/best-practices.html#considerations-for-scope-consent) in the SMART App Launch implementation guide.

**Best practices for server developers include**

* Use published US Core granular scopes whenever possible.
* Systems that add custom (i.e., non-US Core) granular scopes must not duplicate existing US Core scopes.
* When using granular scopes, ensure that all data supplied in the Resource has a granular scope that can be used to access it.
* Document all the scopes they provide on their published list of SMART on FHIR capabilities and offline documentation.
* Display Considerations 
* Display a summary of the requested scopes in clear, concise language that the user can understand.
* Groupings and text displayed to patients do not need to match the Granular Scopes listed in US Core.
* Systems may provide the user an option to see more detail on the access provided by a US Core Granular Scope (for example, a detailed view button)
 
* Client access requirements may evolve. Servers should allow clients to update their original provisioning request to add or subtract scopes

**Best practices for app developers include**

* Read and understand what granular scopes are available for a system as documented in its SMART on FHIR capabilities and offline documentation.
* Limit the requested scopes to the available granular scopes.
* Request the appropriate level of access for your use case and only request the necessary scopes. (For example, a pharmacy app may not need access to all observations.)

### Servers SHALL support the following metadata in their /.well-known/smart-configuration

In addition to the capabilities defined in the Server's CapabilityStatement, Servers **SHALL** document their SMART capabilities in their [Well-Known Uniform Resource Identifiers (URIs)](https://hl7.org/fhir/smart-app-launch/STU2/conformance.html#using-well-known) JSON file.

#### Required SMART App Launch Metadata

The SMART App Launch guide requires the following JSON file metadata:

* `issuer` (conditional)
* `jwks_uri` (conditional)
* `authorization_endpoint`
* `grant_types_supported`
* `token_endpoint`
* `capabilities`
* `code_challenge_methods_supported`

#### Additional US Core Requirements

US Core requires following additional metadata:

* `scopes_supported`: Array of scopes a Client may request. 
* The Server **SHALL** list all the required US Core Scopes for the US Core Profiles they support in the `scopes_supported` array; additional scopes **MAY** be supported (so Clients should not consider this array an exhaustive list).
* Servers **MAY** limit Clients' scopes to those configured at registration time. Servers **SHALL** allow users to select a subset of the requested scopes at the approval time. The app **SHOULD** inspect the returned scopes and accommodate the differences from the scopes it asked for and registered.
 
* `introspection_endpoint`: The URL to a Server's introspection endpoint, which can be used to validate a token. 
* Servers **SHALL** document this endpoint in the file
 

#### Example .well-known/smart-configuration File

This example `.well-known/smart-configuration` file shows all the required and recommended metadata listed in SMART App Launch for a certified system supporting User-Facing Applications and Backend Services. The Server lists all the required and recommended US Core scopes for both `patient/`, `user/`, and `system/` in the `scopes_supported` metadata array. See the SMART App Launch implementation guide for more examples and details.

```
HTTP/1.1 200 OK
Content-Type: application/json

```

```
{
  "issuer": "https://ehr.example.com",
  "jwks_uri": "https://ehr.example.com/.well-known/jwks.json",
  "authorization_endpoint": "https://ehr.example.com/auth/authorize",
  "token_endpoint": "https://ehr.example.com/auth/token",
  "token_endpoint_auth_methods_supported": [
    "client_secret_basic",
    "private_key_jwt"
  ],
  "grant_types_supported": [
    "authorization_code",
    "client_credentials"
  ],
  "registration_endpoint": "https://ehr.example.com/auth/register",
  "scopes_supported": [
    "openid",
    "profile",
    "launch",
    "launch/patient",
    "offline_access",
    "patient/AllergyIntolerance.rs",
    "user/AllergyIntolerance.rs",
    "system/AllergyIntolerance.rs",
    "patient/CarePlan.rs",
    "user/CarePlan.rs",
    "system/CarePlan.rs",
    "patient/CareTeam.rs",
    "user/CareTeam.rs",
    "system/CareTeam.rs",
    "patient/Condition.rs",
    "user/Condition.rs",
    "system/Condition.rs",
    "patient/Coverage.rs",
    "user/Coverage.rs",
    "system/Coverage.rs",
    "patient/Device.rs",
    "user/Device.rs",
    "system/Device.rs",
    "patient/DiagnosticReport.rs",
    "user/DiagnosticReport.rs",
    "system/DiagnosticReport.rs",
    "patient/DocumentReference.rs",
    "user/DocumentReference.rs",
    "system/DocumentReference.rs",
    "patient/Encounter.rs",
    "user/Encounter.rs",
    "system/Encounter.rs",
    "patient/Goal.rs",
    "user/Goal.rs",
    "system/Goal.rs",
    "patient/Immunization.rs",
    "user/Immunization.rs",
    "system/Immunization.rs",
    "patient/MedicationDispense.rs",
    "user/MedicationDispense.rs",
    "system/MedicationDispense.rs",
    "patient/MedicationRequest.rs",
    "user/MedicationRequest.rs",
    "system/MedicationRequest.rs",
    "patient/Observation.rs",
    "user/Observation.rs",
    "system/Observation.rs",
    "patient/Organization.rs",
    "user/Organization.rs",
    "system/Organization.rs",
    "patient/Patient.rs",
    "user/Patient.rs",
    "system/Patient.rs",
    "patient/Practitioner.rs",
    "user/Practitioner.rs",
    "system/Practitioner.rs",
    "patient/PractitionerRole.rs",
    "user/PractitionerRole.rs",
    "system/PractitionerRole.rs",
    "patient/Procedure.rs",
    "user/Procedure.rs",
    "system/Procedure.rs",
    "patient/Provenance.rs",
    "user/Provenance.rs",
    "system/Provenance.rs",
    "patient/QuestionnaireResponse.rs",
    "user/QuestionnaireResponse.rs",
    "system/QuestionnaireResponse.rs",
    "patient/RelatedPerson.rs",
    "user/RelatedPerson.rs",
    "system/RelatedPerson.rs",
    "patient/ServiceRequest.rs",
    "user/ServiceRequest.rs",
    "system/ServiceRequest.rs",
    "patient/Specimen.rs",
    "user/Specimen.rs",
    "system/Specimen.rs",
    "patient/Condition.rs?category=bar",
    "user/Condition.rs?category=bar",
    "system/Condition.rs?category=bar",
    "patient/Condition.rs?category=foo",
    "user/Condition.rs?category=foo",
    "system/Condition.rs?category=foo",
    "patient/Condition.rs?category=http://hl7.org/fhir/us/core/CodeSystem/condition-category|health-concern",
    "user/Condition.rs?category=http://hl7.org/fhir/us/core/CodeSystem/condition-category|health-concern",
    "system/Condition.rs?category=http://hl7.org/fhir/us/core/CodeSystem/condition-category|health-concern",
    "patient/Condition.rs?category=http://terminology.hl7.org/CodeSystem/condition-category|encounter-diagnosis",
    "user/Condition.rs?category=http://terminology.hl7.org/CodeSystem/condition-category|encounter-diagnosis",
    "system/Condition.rs?category=http://terminology.hl7.org/CodeSystem/condition-category|encounter-diagnosis",
    "patient/Condition.rs?category=http://terminology.hl7.org/CodeSystem/condition-category|problem-list-item",
    "user/Condition.rs?category=http://terminology.hl7.org/CodeSystem/condition-category|problem-list-item",
    "system/Condition.rs?category=http://terminology.hl7.org/CodeSystem/condition-category|problem-list-item",
    "patient/DiagnosticReport.rs?category=http://loinc.org|LP29684-5",
    "user/DiagnosticReport.rs?category=http://loinc.org|LP29684-5",
    "system/DiagnosticReport.rs?category=http://loinc.org|LP29684-5",
    "patient/DiagnosticReport.rs?category=http://loinc.org|LP29708-2",
    "user/DiagnosticReport.rs?category=http://loinc.org|LP29708-2",
    "system/DiagnosticReport.rs?category=http://loinc.org|LP29708-2",
    "patient/DiagnosticReport.rs?category=http://loinc.org|LP7839-6",
    "user/DiagnosticReport.rs?category=http://loinc.org|LP7839-6",
    "system/DiagnosticReport.rs?category=http://loinc.org|LP7839-6",
    "patient/DiagnosticReport.rs?category=http://terminology.hl7.org/CodeSystem/v2-0074|LAB",
    "user/DiagnosticReport.rs?category=http://terminology.hl7.org/CodeSystem/v2-0074|LAB",
    "system/DiagnosticReport.rs?category=http://terminology.hl7.org/CodeSystem/v2-0074|LAB",
    "patient/DocumentReference.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category|clinical-note",
    "user/DocumentReference.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category|clinical-note",
    "system/DocumentReference.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category|clinical-note",
    "patient/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|cognitive-status",
    "user/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|cognitive-status",
    "system/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|cognitive-status",
    "patient/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|disability-status",
    "user/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|disability-status",
    "system/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|disability-status",
    "patient/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|functional-status",
    "user/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|functional-status",
    "system/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|functional-status",
    "patient/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|sdoh",
    "user/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|sdoh",
    "system/Observation.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|sdoh",
    "patient/Observation.rs?category=http://terminology.hl7.org//CodeSystem-observation-category|social-history",
    "user/Observation.rs?category=http://terminology.hl7.org//CodeSystem-observation-category|social-history",
    "system/Observation.rs?category=http://terminology.hl7.org//CodeSystem-observation-category|social-history",
    "patient/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|activity",
    "user/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|activity",
    "system/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|activity",
    "patient/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|imaging",
    "user/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|imaging",
    "system/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|imaging",
    "patient/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory",
    "user/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory",
    "system/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory",
    "patient/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|procedure",
    "user/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|procedure",
    "system/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|procedure",
    "patient/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|survey",
    "user/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|survey",
    "system/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|survey",
    "patient/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs",
    "user/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs",
    "system/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs",
    "patient/ServiceRequest.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|functional-status",
    "user/ServiceRequest.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|functional-status",
    "system/ServiceRequest.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-category|functional-status",
    "patient/ServiceRequest.rs?category=http://snomed.info/sct|surgical-procedure",
    "user/ServiceRequest.rs?category=http://snomed.info/sct|surgical-procedure",
    "system/ServiceRequest.rs?category=http://snomed.info/sct|surgical-procedure"
],
  "response_types_supported": ["code"],
  "management_endpoint": "https://ehr.example.com/user/manage",
  "introspection_endpoint": "https://ehr.example.com/user/introspect",
  "revocation_endpoint": "https://ehr.example.com/user/revoke",
  "code_challenge_methods_supported": ["S256"],
  "capabilities": [
    "launch-ehr",
    "permission-patient",
    "permission-user",
    "permission-v2",
    "client-public",
    "client-confidential-symmetric",
    "client-confidential-asymmetric",
    "context-ehr-patient",
    "sso-openid-connect"
  ]
}

```

