# Relationship With Other IGs - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **Relationship With Other IGs**

## Relationship With Other IGs

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

US Core is intended to provide an implementable standard for FHIR based interfaces for provider and patient facing systems​ providing:

* An exchange Standard for [U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isa/united-states-core-data-interoperability-uscdi) and comments and requests from the US Realm FHIR community.
* A set of conformance requirements that enforce a set of 'minimum requirements' on FHIR resources to create the US Core Profiles specifying rules for the elements, extensions, vocabularies, and value sets, and the RESTful API interactions.
* For use by US stakeholders when implementing FHIR to provide a common implementation and to be built upon when creating further US Realm specific profiles and implementation guides for specific use cases.

The context of US Core within the set of US Realm HL7 FHIR standards is shown in the figure below.

**Figure 1: Figure 1: Context of US Core within the set of HL7 US FHIR standards**
![](relationships.svg)

### Relationship to US Core and Other IGs

Other international and national standards were reviewed and considered during the development process to assess the degree of alignment and to facilitate adoption of this standard. These implementation guides include:

| | |
| :--- | :--- |
| [International Patient Access (IPA)](https://hl7.org/fhir/uv/ipa/) | This IG describes how an application acting on behalf of a patient can access information about the patient from a clinical records system using a FHIR based API. The REST API and profiles in this IG were reviewed and considered during development of US Core. US Core was is compatible with IPA, e.g. US Core conformant data can be accessed by an IPA conformant client. |
| [International Patient Summary (IPS)](https://hl7.org/fhir/uv/ips/STU1.1/) | This IG describes specify how to represent in HL7 FHIR the IPS. An IPS document is an electronic health record extract containing essential healthcare information about a subject of care. The formal review between this IG and US Core is not current. |

#### Comparison With International IGs

The table below summarizes profile only comparison between US Core and the International Patient Access Implementation Guides. This comparison evaluates US Core conformance requirements with the key implementation guides identifying where compliance with US Core satisfies the expectations established by the referenced implementation guide. Compliance in the reverse direction is not guaranteed, i.e. a resource that is compliant with an International Patient Access profile **may not** be compliant with US Core.

As part of profile comparison, the requirements, constraints, and standards specified in a particular FHIR profile are evaluated. These requirements can include mandatory elements, **Must Support** elements, cardinality constraints, data types, terminology bindings, usage rules, extensions, rules on missing or suppressed data. A detailed comparisons with the current version of IPA can be found [here](ipa-comparison-v1.1.0/index.md)

**Legend:**

✔ **Compliant**: A US Core compliant resource meets all requirements of the compared profile.

➕ **Additional requirements**: A US Core compliant resource is compatible, but additional changes may be needed to meet all requirements of the compared profile. Where additional requirements are identified, more information is provided in the sections below.

✘ **Incompatible**: A US Core compliant resource is incompatible with the compared profile. A resource cannot be compliant to both. Where incompatible requirements are identified, more information is provided in the sections below.

⛔ **No equivalent profile**: No equivalent profile for comparison.

| | |
| :--- | :--- |
| [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md) | ➕ |
| [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md) | ✔ |
| [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md) | ➕ |
| [US Core BMI Profile](StructureDefinition-us-core-bmi.md) | ✔ |
| [US Core Blood Pressure Profile](StructureDefinition-us-core-blood-pressure.md) | ✔ |
| [US Core Body Height Profile](StructureDefinition-us-core-body-height.md) | ✔ |
| [US Core Body Temperature Profile](StructureDefinition-us-core-body-temperature.md) | ✔ |
| [US Core Body Weight Profile](StructureDefinition-us-core-body-weight.md) | ✔ |
| [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md) | ➕ |
| [US Core CarePlan Profile](StructureDefinition-us-core-careplan.md) | ⛔ |
| [US Core CareTeam Profile](StructureDefinition-us-core-careteam.md) | ⛔ |
| [US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md) | ✔ |
| [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md) | ✔ |
| [US Core Coverage Profile](StructureDefinition-us-core-coverage.md) | ⛔ |
| [US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md) | ⛔ |
| [US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) | ⛔ |
| [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md) | ➕ |
| [US Core Encounter Profile](StructureDefinition-us-core-encounter.md) | ⛔ |
| [US Core Goal Profile](StructureDefinition-us-core-goal.md) | ⛔ |
| [US Core Head Circumference Profile](StructureDefinition-us-core-head-circumference.md) | ✔ |
| [US Core Heart Rate Profile](StructureDefinition-us-core-heart-rate.md) | ✔ |
| [US Core Immunization Profile](StructureDefinition-us-core-immunization.md) | ✔ |
| [US Core Implantable Device Profile](StructureDefinition-us-core-implantable-device.md) | ⛔ |
| [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md) | ✔ |
| [US Core Location Profile](StructureDefinition-us-core-location.md) | ⛔ |
| [US Core Medication Profile](StructureDefinition-us-core-medication.md) | ✔ |
| [US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md) | ⛔ |
| [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) | ✔ |
| [US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md) | ➕ |
| [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md) | ✔ |
| [US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md) | ➕ |
| [US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md) | ✔ |
| [US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md) | ✔ |
| [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md) | ✔ |
| [US Core Observation Sexual Orientation Profile](StructureDefinition-us-core-observation-sexual-orientation.md) | ✔ |
| [US Core Organization Profile](StructureDefinition-us-core-organization.md) | ⛔ |
| [US Core Patient Profile](StructureDefinition-us-core-patient.md) | ➕ |
| [US Core Pediatric BMI for Age Observation Profile](StructureDefinition-pediatric-bmi-for-age.md) | ✔ |
| [US Core Pediatric Head Occipital Frontal Circumference Percentile Profile](StructureDefinition-head-occipital-frontal-circumference-percentile.md) | ✔ |
| [US Core Pediatric Weight for Height Observation Profile](StructureDefinition-pediatric-weight-for-height.md) | ✔ |
| [US Core Practitioner Profile](StructureDefinition-us-core-practitioner.md) | ✔ |
| [US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md) | ✔ |
| [US Core Procedure Profile](StructureDefinition-us-core-procedure.md) | ⛔ |
| [US Core Provenance Profile](StructureDefinition-us-core-provenance.md) | ⛔ |
| [US Core Pulse Oximetry Profile](StructureDefinition-us-core-pulse-oximetry.md) | ✔ |
| [US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | ⛔ |
| [US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md) | ⛔ |
| [US Core Respiratory Rate Profile](StructureDefinition-us-core-respiratory-rate.md) | ✔ |
| [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md) | ⛔ |
| [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md) | ➕ |
| [US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md) | ➕ |
| [US Core Specimen Profile](StructureDefinition-us-core-specimen.md) | ⛔ |
| [US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md) | ➕ |
| [US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md) | ✔ |

##### Additional requirements

The following US Core resource are compatible to the IPA profiles, but the IPA profile(s) contain additional requirements which are listed below. Changes may be needed to meet all the IPA profile requirements. Implementers are advised to note that some code changes may be required to support these profiles.

1. [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md)Additional requirements for[IPA DocumentReference](http://hl7.org/fhir/uv/IPA/StructureDefinition/IPA-documentreference):
* `DocumentReference.content.attachment.contentType` Element minimum cardinalities differ: '1' vs '0'
* `DocumentReference.context` Elements differ in definition for mustSupport: 'true' vs 'false'
* `DocumentReference.context.encounter` Elements differ in definition for mustSupport: 'true' vs 'false'
* `DocumentReference.context.encounter` Element maximum cardinalities differ: '1' vs '*'
* `DocumentReference.context.period` Elements differ in definition for mustSupport: 'true' vs 'false'

1. [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md)Additional requirements for[IPA DocumentReference](http://hl7.org/fhir/uv/IPA/StructureDefinition/IPA-documentreference):
* `DocumentReference.content.attachment.contentType` Element minimum cardinalities differ: '1' vs '0'

1. [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md)Additional requirements for[IPA Observation](http://hl7.org/fhir/uv/IPA/StructureDefinition/IPA-observation)
* `Observation.value[x]` Elements differ in definition for mustSupport: 'true' vs 'false'
* `Observation.value[x]` Element maximum cardinalities differ: '1' vs '0'
* `Observation.dataAbsentReason` Elements differ in definition for mustSupport: 'true' vs 'false'

1. [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md),[US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md),[US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md),[US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md)Additional requirements for[IPA Observation](http://hl7.org/fhir/uv/IPA/StructureDefinition/IPA-observation):
* `Observation.dataAbsentReason` Elements differ in definition for mustSupport: 'true' vs 'false'

1. [US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md),[US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md)Additional requirements for[IPA Observation](http://hl7.org/fhir/uv/IPA/StructureDefinition/IPA-observation):
* `Observation.value[x]` Elements differ in definition for mustSupport: 'true' vs 'false'
* `Observation.dataAbsentReason` Elements differ in definition for mustSupport: 'true' vs 'false'

1. [US Core Patient Profile](StructureDefinition-us-core-patient.md)Additional requirements for[IPA Patient](http://hl7.org/fhir/uv/IPA/StructureDefinition/IPA-patient):
* `Patient.active` Element minimum cardinalities differ: '1' vs '0'
* `Patient.active` Elements differ in definition for mustSupport: 'true' vs 'false'
* `Patient.gender` Elements differ in definition for mustSupport: 'true' vs 'false'
* `Patient.link` Element maximum cardinalities differ: '1' vs '*' (:thinking_face: a technical error in IPA profile)
* `Patient.link` Elements differ in definition for mustSupport: 'true' vs 'false'

##### Missing Data

US Core compliant resources are compliant with IPA requirements for Missing Data.

##### Suppressed Data

IPA does not include requirements for Suppressed Data.

##### Additional profiles

This version of US Core has no equivalent profile for the following IPA profiles:

* [IPA-MedicationStatement](https://hl7.org/fhir/uv/ipa/STU1.1//StructureDefinition-ipa-medicationstatement.html)

