# Profiles and Extensions - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* **Profiles and Extensions**

## Profiles and Extensions

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Profiles

The following profiles have been defined for this implementation guide.

#### AllergyIntolerance

* [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md)

#### CarePlan

* [US Core CarePlan Profile](StructureDefinition-us-core-careplan.md)

#### CareTeam

* [US Core CareTeam Profile](StructureDefinition-us-core-careteam.md)

#### Condition

* [US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md)
* [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)

#### Coverage

* [US Core Coverage Profile](StructureDefinition-us-core-coverage.md)

#### Device

* [US Core Implantable Device Profile](StructureDefinition-us-core-implantable-device.md)

#### DiagnosticReport

* [US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md)
* [US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md)

#### DocumentReference

* [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md)
* [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md)

#### Encounter

* [US Core Encounter Profile](StructureDefinition-us-core-encounter.md)

#### Goal

* [US Core Goal Profile](StructureDefinition-us-core-goal.md)

#### Immunization

* [US Core Immunization Profile](StructureDefinition-us-core-immunization.md)

#### Location

* [US Core Location Profile](StructureDefinition-us-core-location.md)

#### Medication

* [US Core Medication Profile](StructureDefinition-us-core-medication.md)

#### MedicationDispense

* [US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md)

#### MedicationRequest

* [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md)

#### Observation

* [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md)
* [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md)
* [US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md)
* [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md) 
* [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md)
 
* [US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md)
* [US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md)
* [US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md)
* [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)
* [US Core Observation Sexual Orientation Profile](StructureDefinition-us-core-observation-sexual-orientation.md)
* [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)
* [US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md)
* [US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md)
* [US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md) 
* [US Core Pediatric BMI for Age Observation Profile](StructureDefinition-pediatric-bmi-for-age.md)
* [US Core Pediatric Weight for Height Observation Profile](StructureDefinition-pediatric-weight-for-height.md)
* [US Core Blood Pressure Profile](StructureDefinition-us-core-blood-pressure.md)
* [US Core BMI Profile](StructureDefinition-us-core-bmi.md)
* [US Core Body Height Profile](StructureDefinition-us-core-body-height.md)
* [US Core Body Temperature Profile](StructureDefinition-us-core-body-temperature.md)
* [US Core Body Weight Profile](StructureDefinition-us-core-body-weight.md)
* [US Core Head Circumference Profile](StructureDefinition-us-core-head-circumference.md)
* [US Core Heart Rate Profile](StructureDefinition-us-core-heart-rate.md)
* [US Core Pulse Oximetry Profile](StructureDefinition-us-core-pulse-oximetry.md)
* [US Core Respiratory Rate Profile](StructureDefinition-us-core-respiratory-rate.md)
* [US Core Pediatric Head Occipital Frontal Circumference Percentile Profile](StructureDefinition-head-occipital-frontal-circumference-percentile.md)
 

#### Organization

* [US Core Organization Profile](StructureDefinition-us-core-organization.md)

#### Patient

* [US Core Patient Profile](StructureDefinition-us-core-patient.md)

#### Practitioner

* [US Core Practitioner Profile](StructureDefinition-us-core-practitioner.md)

#### PractitionerRole

* [US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md)

#### Procedure

* [US Core Procedure Profile](StructureDefinition-us-core-procedure.md)

#### Provenance

* [US Core Provenance Profile](StructureDefinition-us-core-provenance.md)

#### QuestionnaireResponse

* [US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md)

#### RelatedPerson

* [US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md)

#### ServiceRequest

* [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md)

#### Specimen

* [US Core Specimen Profile](StructureDefinition-us-core-specimen.md)

### Extensions

The following [Extensions](http://hl7.org/fhir/R4/extensibility.html) have been defined as part of the US Core Implementation Guide. A [registry of standard extensions](http://hl7.org/fhir/R4/extensibility-registry.html) can be found in the FHIR specification, and additional extensions may be registered on the HL7 FHIR registry at [http://hl7.org/fhir/registry](http://hl7.org/fhir/registry).

#### US Core Profile Extensions

The following extensions are used in US Core Profiles.

*  [US Core Authentication Time Extension](StructureDefinition-us-core-authentication-time.md) 
*  [US Core Ethnicity Extension](StructureDefinition-us-core-ethnicity.md) 
*  [US Core Extension Questionnaire URI](StructureDefinition-us-core-extension-questionnaire-uri.md) 
*  [US Core Individual Sex Extension](StructureDefinition-us-core-individual-sex.md) 
*  [US Core Interpreter Needed Extension](StructureDefinition-us-core-interpreter-needed.md) 
*  [US Core Medication Adherence Extension](StructureDefinition-us-core-medication-adherence.md) 
*  [US Core Race Extension](StructureDefinition-us-core-race.md) 
*  [US Core Tribal Affiliation Extension](StructureDefinition-us-core-tribal-affiliation.md) 

#### Other US Realm Specific Extension

The following extensions are not used in any US Core Profile. They are provided to assist implementers who may find them relevant to their specific use cases.

*  [US Core Birth Sex Extension](StructureDefinition-us-core-birthsex.md) 
*  [US Core Direct email Extension](StructureDefinition-us-core-direct.md) 
*  [US Core Jurisdiction Extension](StructureDefinition-us-core-jurisdiction.md) 

#### US Core Profile StructureDefinition Extensions

The following extensions are only used in the US Core Implementation Guide to create US Core Profiles. They are used in the context of StructureDefinition elements.

*  [US Core USCDI Requirement Extension](StructureDefinition-uscdi-requirement.md) 

#### Deprecated US Realm Specific Extension

The following extensions are not used in any US Core Profile and are **deprecated**. They **SHOULD NOT** be used for new or revised content. They are retained for historical/backward compatibility purposes.

*  [US Core Gender Identity Extension](StructureDefinition-us-core-genderIdentity.md) 
*  [US Core Sex Extension](StructureDefinition-us-core-sex.md) 

