# Medication List - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **Medication List**

## Medication List

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

The guidance below addresses how a patient or a provider can access a patient's active, historical, and future (planned) medications list. This use case adopts the use cases defined as part of the Argonaut Project and US Core, specifically within the scope of accessing medication information prescribed in the ASTP U.S. Core Data for Interoperability (USCDI). This section provides specific guidance on accessing "all medications" and "all active medications" for a patient using a query on **MedicationRequest**. Note that a query on **MedicationStatement** was required in prior versions of this guide. Because of underlying changes in the FHIR Release 4 pharmacy resources, this guide doesn't require the use of **MedicationStatement** since an "active" medication list can be obtained using only MedicationRequest.[1](#fn:1)

### Background on the FHIR Medications resources

#### Pharmacy FHIR Resources

The FHIR specification defines five FHIR pharmacy resources concerned with the ordering, dispensing, administering, and recording of medications. This guide documents accessing a patient's medications using the following three resources:

* [Medication](http://hl7.org/fhir/R4/medication.html): Represents the medication itself
* [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html): An order or request for the supply of the medication and the instructions for administration of the medication to a patient, and patient reported medications.
* [MedicationDispense](http://hl7.org/fhir/R4/medicationdispense.html): Provision a medication with regards to dispensing in response to a prescription

The following two medication resources are not profiled by US Core, and systems that support US Core are permitted to use them. They are introduced here to provide background and define the relationships between the pharmacy resources. **However, as documented in the section below, the US Core Guidance for accessing a patient's medications does not use them:**

* [MedicationAdministration](http://hl7.org/fhir/R4/medicationadministration.html)
* [MedicationStatement](http://hl7.org/fhir/R4/medicationstatement.html)

The FHIR specification details each resource. The FHIR [Medications Module](http://hl7.org/fhir/R4/medications-module.html) and the [Guide to Resources](http://hl7.org/fhir/R4/resourceguide.html) Sections describe the interaction between these resources in general.

#### Relationships Between the Pharmacy FHIR Resources

This IG focuses on access to a patient's medications. Therefore, it is essential to understand the relationships between these resources. Figure 1 illustrates the workflow relationship between the medication order and the fulfillment represented by the FHIR medication resources. Note that in the outpatient setting, the patient does the administration.

**Figure 1: FHIR Medication Order and Fulfillment**
![](ArgoR4Meds_1.svg)

#### Sources of a MedicationRequest

Several sources may be used to create a MedicationRequest, as is shown in Figure 2 below. The information may be captured directly by a system's medication order or reported by a provider. A patient or related person may also report the information (or provide some record), including "self-prescribed" orders. For example, the patient is often the **only** source of information when the patient reports Cannabis or OTC medication use.

**Figure 2: MedicationRequest Information Sources**
![](ArgoR4Meds_3.svg)

#### Options for Representing Medication

This guide supports representing a medication using a code or a reference to a Medication resource. Typically, a code will be for a branded (for example, Crestor 10mg tablet) or a generic (for example, Rosuvastatin 10mg tablet) medication. When using a code, the code **SHALL** follow the [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible) binding rules to [Medication Clinical Drug (RxNorm)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.4/expansion) - i.e., unless RxNorm does not cover the concept, the RxNorm code **SHALL** be used. USCDI recommends the [National Drug Codes (NDC)](https://www.fda.gov/drugs/drug-approvals-and-databases/national-drug-code-directory) as an optional medication terminology. They can be supplied as an additional coding element. More information about using codes can be found in the [General Guidance](general-guidance.md) and the [FHIR Terminology](http://hl7.org/fhir/R4/terminologies.html) sections. A medication resource is typically used when information not included in the RxNorm code is required. For example, the Medication resource is the only way to represent compounded correctly or extemporaneously prepared medication. When referencing the Medication resource, the resource may be included in the returned bundle, as an external resource, or as a [contained](http://hl7.org/fhir/R4/references.html#contained) resource if it can't stand alone. These options are shown in Figure 3 below. The Server application **MAY** choose any combination of these methods, but if an external reference to Medication is used, the Server **SHALL** support the [`_include`](http://hl7.org/fhir/R4/search.html#include) parameter for searching this element. The Client application **MUST** support all methods. The [MedicationRequest examples](StructureDefinition-us-core-medicationrequest-examples.md) show these different methods. Additional guidance is provided below and in the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) section.

**Figure 3: Ways to Represent the Medication**
![](ArgoR4Meds_4.svg)

### Fetching All Medications, Active Medications, and All Medications for an Encounter

**Definitions**

* "Medication" is defined in this IG to include all prescribed and "self-prescribed" medications directly ordered by a provider or reported by the provider, patient, or related person. It includes ethical drugs, over-the-counter (OTC) medication, and other substances taken for medical and recreational use.
* "All medications" is defined in this IG to include all historical, active, and future prescribed medications and medications entered in error and whose status is unknown.
* "Active medications" is defined in this IG as including all medications with an active status. Active medications do not include past, future, unknown status, and entered-in-error medications.

**Note that these definitions do not convey compliance - i.e., the list is a statement of what is prescribed (or self-prescribed) and not what is consumed by the patient.**

**Requirements to access "all medications" and "all**active**medications" for a patient:**

1. A MedicationRequest resource query**SHALL**be all that is required to access "all medications" or "all active medications" for a patient. (In other words, no other medication resource type needs to be fetched)
1. The query result**SHALL**include all MedicationRequest resources with a`MedicationRequest.intent`= "order" representing authorized medication orders directly derived from the system's orders.
1. The query result**SHALL**include all prescribed and "self-prescribed" MedicationRequest resources with a`MedicationRequest.intent`= "plan" representing reported medications.
1. Servers**SHALL**use the`MedicationRequest.reported[x]`element to indicate that the MedicationRequest record was captured as a secondary "reported" record rather than an original primary source-of-truth record. It may also indicate the source of the report.
1. When recording "self-prescribed" medication, Servers**SHOULD**use the`MedicationRequest.requester`element to indicate the Patient or RelatedPerson is the prescriber.
1. Servers**SHOULD**support the encounter search parameter. Searching by encounter will return all medications ordered during that encounter, including medications administered in the hospital and prescribed or discharge medications intended to be taken at home.
1. Servers**MAY**support the search parameters`category`and`encounter`. This search will return all medications ordered during an encounter for a given`MedicationRequest.category`such as "inpatient".

#### Get All Medications

1. Get all medications for a patient by querying MedicationRequest using the`patient`search parameter and`intent`search parameter = "order,plan". See[MedicationRequest Quick Start](StructureDefinition-us-core-medicationrequest.md#search)for further details.`GET /MedicationRequest?patient=[id]&intent=order,plan{&_include=MedicationRequest:medication}`

 Click Here to See 'Get All Medications' Example 

**Storyboard for this example**

This example is based upon the following scenario:

Patient Brian Z uses an App to request all his medications from a single provider, Dr Cayr. This test scenario exercises a mix of routine meds, unusual schedule meds and as-needed meds. All meds are in the outpatient setting only.

Provider A's (Dr Cayr) medication records for Patient Brian Z

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| 1 | 9/12/2016 | testosterone cypionate 100mg/ml inj 1ml intramuscularly every 3 weeks | Reported by Patient | Get at doctor's office every third Friday. Taking for energy level and drive. |
| 2 | 9/1/2016 | testosterone cypionate 100mg/ml inj 1ml intramuscularly | Reported by Dr Cryn | completed |
| 3 | 1/15/2016 | Zocor (simvastatin) 40mg by mouth once daily | Dr. Cayr Order: BMC | patient med status: taking |
| 4 | 7/1/2015 | Humulin R (insulin regular, human) U100 10U every AM, 5U every PM, 5U at bedtime. | Dr.Cayr Order:BMC | patient med status: taking |
| 5 | 6/12/2015 | simvastatin 30mg by mouth once daily | Dr. Cayr Order: BMC | patient med status: completed |

**Request:**

Get “all medications” for a patient by querying MedicationRequest using the patient search parameter.

```
GET [base]/MedicationRequest?patient=test2&intent=order,plan

```

**Response:**

A Server returns a search Bundle resource containing all the MedicationRequests for the patient Brian Z

```
HTTP/1.1 200 OK
[other headers]

```

```
{
  "resourceType": "Bundle",
  "id": "f48e4a18-173b-4c82-8eeb-3e39daa59f",
  "meta": {
    "lastUpdated": "2022-04-12T00:01:27.106Z"
  },
  "type": "searchset",
  "total": 5,
  "link": [
    {
      "relation": "self",
      "url": "http://test.fhir.org/r4/MedicationRequest?_format=application/fhir+json&search-id=a27179f4-7471-44dd-b6f1-73ae7ef001&&patient=test2&intent=order,plan&_sort=_id"
    }
  ],
  "entry": [
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/269",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "269",
        "meta": {
          "versionId": "2",
          "lastUpdated": "2022-04-11T23:29:16.906Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            },
            {
              "code": "US_Core_5_Example"
            }
          ]
        },
        "status": "active",
        "intent": "order",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "outpatient",
                "display": "Outpatient"
              }
            ],
            "text": "Outpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "104491",
              "display": "Simvastatin 20 MG Oral Tablet [Zocor]"
            }
          ],
          "text": "Zocor (simvastatin) 20mg Tablet"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "encounter": {
          "reference": "Encounter/outpatien-Example-1"
        },
        "authoredOn": "2016-01-15",
        "requester": {
          "reference": "Practitioner/practitioner-drcayr",
          "display": "Dr Cayr"
        },
        "reasonCode": [
          {
            "coding": [
              {
                "system": "http://snomed.info/sct",
                "code": "13644009",
                "display": "Hypercholesterolemia (disorder)"
              }
            ]
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "40mg by mouth once daily",
            "asNeededBoolean": false,
            "route": {
              "coding": [
                {
                  "system": "http://ncimeta.nci.nih.gov",
                  "code": "C38288",
                  "display": "ORAL"
                }
              ]
            }
          }
        ],
        "dispenseRequest": {
          "numberOfRepeatsAllowed": 11,
          "quantity": {
            "value": 60,
            "unit": "tablets",
            "system": "http://hl7.org/fhir/v3/orderableDrugForm",
            "code": "TAB"
          }
        }
      },
      "search": {
        "mode": "match"
      }
    },
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/270",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "270",
        "meta": {
          "versionId": "1",
          "lastUpdated": "2022-04-11T23:33:38.281Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            }
          ]
        },
        "text": {
          "status": "generated",
          "div": "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p><b>Generated Narrative with Details</b></p><p><b>meta</b>: </p><p><b>status</b>: active</p><p><b>intent</b>: order</p><p><b>category</b>: Outpatient <span style=\"background: LightGoldenRodYellow \">(Details : {http://terminology.hl7.org/CodeSystem/medicationrequest-category code \"outpatient\" := \"outpatient\", given as \"Outpatient\"})</span></p><p><b>reported</b>: false</p><p><b>medication</b>: Humulin R (insulin regular, human) U100  100units/ml inj solution <span style=\"background: LightGoldenRodYellow \">(Details : {RxNorm code \"311036\" := \"311036\", given as \"Humulin R (insulin regular, human) U100  100units/ml inj solution\"})</span></p><p><b>subject</b>: <a href=\"Patient/test2\">Brian Z</a></p><p><b>encounter</b>: <a href=\"Encounter/outpatient-example-2\">Encounter/outpatient-example-2</a></p><p><b>authoredOn</b>: 7/1/2015</p><p><b>requester</b>: </p><p><b>dosageInstruction</b>: </p></div>"
        },
        "status": "active",
        "intent": "order",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "outpatient",
                "display": "Outpatient"
              }
            ],
            "text": "Outpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "311036",
              "display": "Humulin R (insulin regular, human) U100  100units/ml inj solution"
            }
          ],
          "text": "Humulin R (insulin regular, human) U100  100units/ml inj solution"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "encounter": {
          "reference": "Encounter/outpatient-example-2"
        },
        "authoredOn": "2015-07-01",
        "requester": {
          "reference": "Practitioner/practitioner-drcayr",
          "display": "Dr Cayr"
        },
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "10U every AM, 5U every PM, 5U at bedtime",
            "asNeededBoolean": false,
            "route": {
              "coding": [
                {
                  "system": "http://snomed.info/sct",
                  "code": "34206005",
                  "display": "Subcutaneous route (qualifier value)"
                }
              ]
            }
          }
        ],
        "dispenseRequest": {
          "numberOfRepeatsAllowed": 11,
          "quantity": {
            "value": 40,
            "unit": "ml",
            "system": "http://unitsofmeasure.org",
            "code": "mL"
          }
        }
      },
      "search": {
        "mode": "match"
      }
    },
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/271",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "271",
        "meta": {
          "versionId": "1",
          "lastUpdated": "2022-04-11T23:46:16.248Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            }
          ]
        },
        "status": "active",
        "intent": "plan",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "outpatient",
                "display": "Outpatient"
              }
            ],
            "text": "Outpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "835829",
              "display": "testosterone cypionate 100 MG/ML Injectable Solution"
            }
          ],
          "text": "testosterone cypionate 100mg/ml inj"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "encounter": {
          "reference": "Encounter/outpatient-example-3"
        },
        "authoredOn": "2016-09-12",
        "requester": {
          "reference": "Practitioner/practitioner-drcryn",
          "display": "Dr Cryn"
        },
        "reasonCode": [
          {
            "text": "Taking for energy level and drive."
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "1ml intramuscularly every 3 weeks"
          }
        ]
      },
      "search": {
        "mode": "match"
      }
    },
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/272",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "272",
        "meta": {
          "versionId": "1",
          "lastUpdated": "2022-04-11T23:49:12.951Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            }
          ]
        },
        "status": "completed",
        "intent": "order",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "outpatient",
                "display": "Outpatient"
              }
            ],
            "text": "Outpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "314231",
              "display": "Simvastatin 10 MG Oral Tablet"
            }
          ],
          "text": "simvastatin 10mg Tablet"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "authoredOn": "2015-06-12",
        "requester": {
          "reference": "Practitioner/practitioner-drcayr",
          "display": "Dr Cayr"
        },
        "reasonCode": [
          {
            "coding": [
              {
                "system": "http://snomed.info/sct",
                "code": "13644009",
                "display": "Hypercholesterolemia (disorder)"
              }
            ]
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "30mg (3 tablets) by mouth once daily",
            "asNeededBoolean": false,
            "route": {
              "coding": [
                {
                  "system": "http://ncimeta.nci.nih.gov",
                  "code": "C38288",
                  "display": "ORAL"
                }
              ]
            }
          }
        ],
        "dispenseRequest": {
          "numberOfRepeatsAllowed": 6,
          "quantity": {
            "value": 90,
            "unit": "tablets",
            "system": "http://hl7.org/fhir/v3/orderableDrugForm",
            "code": "TAB"
          }
        }
      },
      "search": {
        "mode": "match"
      }
    },
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/273",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "273",
        "meta": {
          "versionId": "1",
          "lastUpdated": "2022-04-11T23:57:17.715Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            }
          ]
        },
        "status": "completed",
        "intent": "plan",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "outpatient",
                "display": "Outpatient"
              }
            ],
            "text": "Outpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "835829",
              "display": "testosterone cypionate 100 MG/ML Injectable Solution"
            }
          ],
          "text": "testosterone cypionate 100mg/ml inj"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "authoredOn": "2016-09-01",
        "requester": {
          "reference": "Practitioner/practitioner-drcryn",
          "display": "Dr Cryn"
        },
        "reasonCode": [
          {
            "text": "Taking for energy level and drive."
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "1ml intramuscularly"
          }
        ]
      },
      "search": {
        "mode": "match"
      }
    }
  ]
}


```

#### Get All Active Medications

1. Get all**active**medications for a patient by querying MedicationRequest using the`patient`, and`intent`= "order,plan"`status`= "active" search parameters. See[MedicationRequest Quick Start](StructureDefinition-us-core-medicationrequest.md#search)for further details. Note that the Client should also consider MedicationRequests with a status of "unknown" and whether to query those as well.`GET /MedicationRequest?patient=[id]&intent=order,plan&status=active{&_include=MedicationRequest:medication}`

 Click Here to See 'Get All *Active* Medications' Example 

**Storyboard for this example**

This example is based upon the following scenario:

Patient Brian Z uses an App to request all his medications from a single provider, Dr Cayr. This test scenario exercises a mix of routine meds, unusual schedule meds and as-needed meds. All meds are in the outpatient setting only.

Provider A's (Dr Cayr) medication records for Patient Brian Z. Note that three of these are active, the other two are completed.

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| 1 | 9/12/2016 | testosterone cypionate 100mg/ml inj 1ml intramuscularly every 3 weeks | Reported by Patient | Get at doctor's office every third Friday. Taking for energy level and drive. |
| 2 | 9/1/2016 | testosterone cypionate 100mg/ml inj 1ml intramuscularly | Reported by Dr Cryn | completed |
| 3 | 1/15/2016 | Zocor (simvastatin) 40mg by mouth once daily | Dr. Cayr Order: BMC | patient med status: taking |
| 4 | 7/1/2015 | Humulin R (insulin regular, human) U100 10U every AM, 5U every PM, 5U at bedtime. | Dr.Cayr Order:BMC | patient med status: taking |
| 5 | 6/12/2015 | simvastatin 30mg by mouth once daily | Dr. Cayr Order: BMC | patient med status: completed |

**Request:**

Get “all active medications” for a patient by querying MedicationRequest using the patient and status= "active" search parameters.

```
GET [base]/MedicationRequest?patient=test2&intent=order,plan&status=active

```

**Response:**

A Server returns a search Bundle resource containing all the MedicationRequests with a status of "active" for the patient Brian Z

```
HTTP/1.1 200 OK
[other headers]

```

```
{
    "resourceType": "Bundle",
    "id": "1f8a772f-1a54-4ef7-8bf6-7e27325ca4",
    "meta": {
        "lastUpdated": "2022-04-12T01:01:49.419Z"
    },
    "type": "searchset",
    "total": 3,
    "link": [
        {
            "relation": "self",
            "url": "http://test.fhir.org/r4/MedicationRequest?_format=application/fhir+json&search-id=667926e8-efa6-427e-b801-73c66b1789&&patient=test2&intent=order,plan&status=active&_sort=_id"
        }
    ],
    "entry": [
        {
            "fullUrl": "http://test.fhir.org/r4/MedicationRequest/269",
            "resource": {
                "resourceType": "MedicationRequest",
                "id": "269",
                "meta": {
                    "versionId": "3",
                    "lastUpdated": "2022-04-12T01:01:29.279Z",
                    "profile": [
                        "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
                    ],
                    "tag": [
                        {
                            "code": "US_Core_5"
                        },
                        {
                            "code": "US_Core_5_Example"
                        }
                    ]
                },
                "status": "active",
                "intent": "order",
                "category": [
                    {
                        "coding": [
                            {
                                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                                "code": "outpatient",
                                "display": "Outpatient"
                            }
                        ],
                        "text": "Outpatient"
                    }
                ],
                "reportedBoolean": false,
                "medicationCodeableConcept": {
                    "coding": [
                        {
                            "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
                            "code": "104491",
                            "display": "Simvastatin 20 MG Oral Tablet [Zocor]"
                        }
                    ],
                    "text": "Zocor (simvastatin) 20mg Tablet"
                },
                "subject": {
                    "reference": "Patient/test2",
                    "display": "Brian Z"
                },
                "encounter": {
                    "reference": "Encounter/outpatien-Example-1"
                },
                "authoredOn": "2016-01-15",
                "requester": {
                    "reference": "Practitioner/practitioner-drcayr",
                    "display": "Dr Cayr"
                },
                "reasonCode": [
                    {
                        "coding": [
                            {
                                "system": "http://snomed.info/sct",
                                "code": "13644009",
                                "display": "Hypercholesterolemia (disorder)"
                            }
                        ]
                    }
                ],
                "dosageInstruction": [
                    {
                        "sequence": 1,
                        "text": "40mg by mouth once daily",
                        "asNeededBoolean": false,
                        "route": {
                            "coding": [
                                {
                                    "system": "http://ncimeta.nci.nih.gov",
                                    "code": "C38288",
                                    "display": "ORAL"
                                }
                            ]
                        }
                    }
                ],
                "dispenseRequest": {
                    "numberOfRepeatsAllowed": 11,
                    "quantity": {
                        "value": 60,
                        "unit": "tablets",
                        "system": "http://hl7.org/fhir/v3/orderableDrugForm",
                        "code": "TAB"
                    }
                }
            },
            "search": {
                "mode": "match"
            }
        },
        {
            "fullUrl": "http://test.fhir.org/r4/MedicationRequest/270",
            "resource": {
                "resourceType": "MedicationRequest",
                "id": "270",
                "meta": {
                    "versionId": "2",
                    "lastUpdated": "2022-04-12T01:01:29.498Z",
                    "profile": [
                        "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
                    ],
                    "tag": [
                        {
                            "code": "US_Core_5"
                        }
                    ]
                },
                "status": "active",
                "intent": "order",
                "category": [
                    {
                        "coding": [
                            {
                                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                                "code": "outpatient",
                                "display": "Outpatient"
                            }
                        ],
                        "text": "Outpatient"
                    }
                ],
                "reportedBoolean": false,
                "medicationCodeableConcept": {
                    "coding": [
                        {
                            "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
                            "code": "311036",
                            "display": "Humulin R (insulin regular, human) U100  100units/ml inj solution"
                        }
                    ],
                    "text": "Humulin R (insulin regular, human) U100  100units/ml inj solution"
                },
                "subject": {
                    "reference": "Patient/test2",
                    "display": "Brian Z"
                },
                "encounter": {
                    "reference": "Encounter/outpatient-example-2"
                },
                "authoredOn": "2015-07-01",
                "requester": {
                    "reference": "Practitioner/practitioner-drcayr",
                    "display": "Dr Cayr"
                },
                "dosageInstruction": [
                    {
                        "sequence": 1,
                        "text": "10U every AM, 5U every PM, 5U at bedtime",
                        "asNeededBoolean": false,
                        "route": {
                            "coding": [
                                {
                                    "system": "http://snomed.info/sct",
                                    "code": "34206005",
                                    "display": "Subcutaneous route (qualifier value)"
                                }
                            ]
                        }
                    }
                ],
                "dispenseRequest": {
                    "numberOfRepeatsAllowed": 11,
                    "quantity": {
                        "value": 40,
                        "unit": "ml",
                        "system": "http://unitsofmeasure.org",
                        "code": "mL"
                    }
                }
            },
            "search": {
                "mode": "match"
            }
        },
        {
            "fullUrl": "http://test.fhir.org/r4/MedicationRequest/271",
            "resource": {
                "resourceType": "MedicationRequest",
                "id": "271",
                "meta": {
                    "versionId": "2",
                    "lastUpdated": "2022-04-12T01:01:29.795Z",
                    "profile": [
                        "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
                    ],
                    "tag": [
                        {
                            "code": "US_Core_5"
                        }
                    ]
                },

                "status": "active",
                "intent": "plan",
                "category": [
                    {
                        "coding": [
                            {
                                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                                "code": "outpatient",
                                "display": "Outpatient"
                            }
                        ],
                        "text": "Outpatient"
                    }
                ],
                "reportedBoolean": false,
                "medicationCodeableConcept": {
                    "coding": [
                        {
                            "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
                            "code": "835829",
                            "display": "testosterone cypionate 100 MG/ML Injectable Solution"
                        }
                    ],
                    "text": "testosterone cypionate 100mg/ml inj"
                },
                "subject": {
                    "reference": "Patient/test2",
                    "display": "Brian Z"
                },
                "encounter": {
                    "reference": "Encounter/outpatient-example-3"
                },
                "authoredOn": "2016-09-12",
                "requester": {
                    "reference": "Practitioner/practitioner-drcryn",
                    "display": "Dr Cryn"
                },
                "reasonCode": [
                    {
                        "text": "Taking for energy level and drive."
                    }
                ],
                "dosageInstruction": [
                    {
                        "sequence": 1,
                        "text": "1ml intramuscularly every 3 weeks"
                    }
                ]
            },
            "search": {
                "mode": "match"
            }
        }
    ]
}


```

#### Get All Medications for an Encounter

1. Get "all medications" for an encounter by querying MedicationRequest using the`patient`,`encounter`,`intent`= "order,plan" search parameters. See[MedicationRequest Quick Start](StructureDefinition-us-core-medicationrequest.md#search)for further details.`GET /MedicationRequest?patient=[id]&intent=order,plan&encounter=[id]{&_include=MedicationRequest:medication}`

 Click Here to See 'Get All Medications for an Encounter' Example 

**Storyboard for this example**

This example is based upon the following scenario.

Patient Brain Z has presented with the same condition (pneumonia) as in a previous inpatient encounter. Provider A (Dr Cayr) uses a desktop or mobile application to request all the medications from this previous inpatient encounter (Encounter A).

Medication records for Patient Brian Z during Encounter A

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| 1 | 9/10/2016 - 9/12-2016 | Cefatoxime 1gm intravenously every 6 hours | Provider B's Order | Administered in hospital |
| 2 | 9/10/2016 - 9/12-2016 | Zithromax (azithromycin) 500 MG in 250 ml Normal Saline intravenous infusion over 1hr daily | Provider B's Order | Administered in hospital |
| 3 | 9/10/2016 - 9/12-2016 | Ketorolac 15 mg intravenously every 6 hours | Provider B's Order | Administered in hospital |
| 2 | 9/10/2016 - 9/12-2016 | LRS Solution 200 ml/hr intravenously CRI | Provider B's Order | Administered in hospital |
| 5 | 9/12/2016 | Amoxicillin 500mg by mouth every 6 hours for 10 days | Provider B's Order | discharge prescription, patient reported did not comply (fill prescription) |
| 6 | 9/12/2016 | Zithromax (azithromycin) 250mg by mouth every 12 hours for 10 days | Provider B's Order | discharge prescription, patient reported did not comply (fill prescription) |

**Request:**

Get “all medications” for a patient inpatient encounter by querying MedicationRequest using the patient and encounter search parameters.

```
GET [base]/MedicationRequest?patient=test2&intent=order,plan&encounter=A

```

**Response:**

A Server returns a search Bundle resource containing all the MedicationRequests for the patient Brian Z during inpatient Encounter A:

```
HTTP/1.1 200 OK
[other headers]

```

```
{
  "resourceType": "Bundle",
  "id": "bb33a47a-cab8-4b4b-ba2e-3b663ffb98",
  "meta": {
    "lastUpdated": "2022-04-12T01:55:49.093Z"
  },
  "type": "searchset",
  "total": 6,
  "link": [
    {
      "relation": "self",
      "url": "http://test.fhir.org/r4/MedicationRequest?_format=application/fhir+json&search-id=3f726452-7d24-4740-86f8-9c4a8f993a&&patient=test2&intent=order,plan&encounter=inpatient-example&_sort=_id"
    }
  ],
  "entry": [
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/0e2dda71-7122-4840-9252-17c84a0d50",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "0e2dda71-7122-4840-9252-17c84a0d50",
        "meta": {
          "versionId": "4",
          "lastUpdated": "2022-04-12T01:54:45.483Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            },
            {
              "code": "Inpatient"
            }
          ]
        },
        "contained": [
          {
            "resourceType": "Medication",
            "id": "med-1",
            "meta": {
              "profile": [
                "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication"
              ]
            },
            "code": {
              "text": "Azithromycin 500mg in 250 ml Normal Saline"
            },
            "ingredient": [
              {
                "itemCodeableConcept": {
                  "coding": [
                    {
                      "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
                      "code": "1668240",
                      "display": "Zithromax 500 MG Injection"
                    }
                  ],
                  "text": "Zithromax (azithromycin) 500 MG Injection"
                },
                "isActive": true
              },
              {
                "itemCodeableConcept": {
                  "coding": [
                    {
                      "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
                      "code": "313002",
                      "display": "Sodium Chloride 0.9% injectable solution"
                    }
                  ],
                  "text": "Normal Saline"
                },
                "isActive": true
              }
            ]
          }
        ],
        "status": "active",
        "intent": "order",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "inpatient",
                "display": "Inpatient"
              }
            ],
            "text": "Inpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationReference": {
          "reference": "#med-1"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "encounter": {
          "reference": "Encounter/inpatient-example",
          "display": "Inpatient encounter"
        },
        "authoredOn": "2016-09-12",
        "requester": {
          "reference": "Practitioner/example-drb",
          "display": "Dr B"
        },
        "reasonCode": [
          {
            "coding": [
              {
                "system": "http://snomed.info/sct",
                "code": "233604007",
                "display": "Pneumonia (disorder)"
              }
            ]
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "Azithromycin 500mg in 250 ml Normal Saline intravenously over 1hour every 24 hours",
            "timing": {
              "repeat": {
                "duration": 1,
                "durationUnit": "h",
                "frequency": 1,
                "period": 24,
                "periodUnit": "h"
              }
            },
            "asNeededBoolean": false,
            "route": {
              "coding": [
                {
                  "system": "http://ncimeta.nci.nih.gov",
                  "code": "C38276",
                  "display": "INTRAVENOUS"
                }
              ]
            },
            "method": {
              "text": "1 hr infusion"
            }
          }
        ]
      },
      "search": {
        "mode": "match"
      }
    },
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/1e51d801-1cdf-4d61-9dc0-8937945a35",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "1e51d801-1cdf-4d61-9dc0-8937945a35",
        "meta": {
          "versionId": "4",
          "lastUpdated": "2022-04-12T01:54:45.608Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            },
            {
              "code": "Inpatient"
            }
          ]
        },
        "status": "active",
        "intent": "order",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "inpatient",
                "display": "Inpatient"
              }
            ],
            "text": "Inpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "212446",
              "display": "Zithromax 250 MG Oral Tablet"
            }
          ],
          "text": "Zithromax 500 MG Oral Tablet"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "encounter": {
          "reference": "Encounter/inpatient-example",
          "display": "Inpatient encounter"
        },
        "authoredOn": "2016-09-12",
        "requester": {
          "reference": "Practitioner/example-drb",
          "display": "Dr B"
        },
        "reasonCode": [
          {
            "coding": [
              {
                "system": "http://snomed.info/sct",
                "code": "233604007",
                "display": "Pneumonia (disorder)"
              }
            ]
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "Zithromax (azithromycin) 250mg by mouth every 12 hours for 10 days",
            "additionalInstruction": [
              {
                "coding": [
                  {
                    "system": "http://snomed.info/sct",
                    "code": "311504000",
                    "display": "With or after food"
                  }
                ]
              }
            ],
            "timing": {
              "repeat": {
                "frequency": 1,
                "period": 12,
                "periodUnit": "h"
              }
            },
            "route": {
              "coding": [
                {
                  "system": "http://ncimeta.nci.nih.gov",
                  "code": "C38288",
                  "display": "ORALLY",
                  "userSelected": false
                }
              ]
            }
          }
        ],
        "dispenseRequest": {
          "validityPeriod": {
            "start": "2016-09-12",
            "end": "2016-10-12"
          },
          "quantity": {
            "value": 20,
            "unit": "TAB",
            "system": "http://hl7.org/fhir/v3/orderableDrugForm",
            "code": "TAB"
          },
          "expectedSupplyDuration": {
            "value": 10,
            "unit": "days",
            "system": "http://unitsofmeasure.org",
            "code": "d"
          }
        }
      },
      "search": {
        "mode": "match"
      }
    },
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/4362b3f0-37bc-4463-93b3-c6b8228d91",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "4362b3f0-37bc-4463-93b3-c6b8228d91",
        "meta": {
          "versionId": "4",
          "lastUpdated": "2022-04-12T01:54:45.671Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            },
            {
              "code": "Inpatient"
            }
          ]
        },
        "status": "active",
        "intent": "order",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "inpatient",
                "display": "Inpatient"
              }
            ],
            "text": "Inpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "308191",
              "display": "Amoxicillin 500 MG Oral Capsule"
            }
          ],
          "text": "Amoxicillin 500 MG"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "encounter": {
          "reference": "Encounter/inpatient-example",
          "display": "Inpatient encounter"
        },
        "authoredOn": "2016-09-12",
        "requester": {
          "reference": "Practitioner/example-drb",
          "display": "Dr B"
        },
        "reasonCode": [
          {
            "coding": [
              {
                "system": "http://snomed.info/sct",
                "code": "233604007",
                "display": "Pneumonia (disorder)"
              }
            ]
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "Amoxicillin 500mg by mouth every 6 hours for 10 days",
            "additionalInstruction": [
              {
                "coding": [
                  {
                    "system": "http://snomed.info/sct",
                    "code": "311504000",
                    "display": "With or after food"
                  }
                ]
              }
            ],
            "timing": {
              "repeat": {
                "frequency": 1,
                "period": 6,
                "periodUnit": "h"
              }
            },
            "route": {
              "coding": [
                {
                  "system": "http://ncimeta.nci.nih.gov",
                  "code": "C38288",
                  "display": "ORALLY",
                  "userSelected": false
                }
              ]
            }
          }
        ],
        "dispenseRequest": {
          "validityPeriod": {
            "start": "2016-09-12",
            "end": "2016-10-12"
          },
          "numberOfRepeatsAllowed": 0,
          "quantity": {
            "value": 40,
            "unit": "Oral Capsule",
            "system": "http://hl7.org/fhir/v3/orderableDrugForm",
            "code": "ORCAP"
          },
          "expectedSupplyDuration": {
            "value": 10,
            "unit": "days",
            "system": "http://unitsofmeasure.org",
            "code": "d"
          }
        }
      },
      "search": {
        "mode": "match"
      }
    },
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/5996de24-bb15-44d5-ad5e-e942090123",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "5996de24-bb15-44d5-ad5e-e942090123",
        "meta": {
          "versionId": "4",
          "lastUpdated": "2022-04-12T01:54:45.765Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            },
            {
              "code": "Inpatient"
            }
          ]
        },
        "status": "active",
        "intent": "order",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "inpatient",
                "display": "Inpatient"
              }
            ],
            "text": "Inpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "860601",
              "display": "Calcium Chloride 0.0014 MEQ/ML / Potassium Chloride 0.024 MEQ/ML / Sodium Chloride 0.103 MEQ/ML / Sodium Lactate 0.028 MEQ/ML Injectable Solution"
            }
          ],
          "text": "LRS"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "encounter": {
          "reference": "Encounter/inpatient-example",
          "display": "Inpatient encounter"
        },
        "authoredOn": "2016-09-12",
        "requester": {
          "reference": "Practitioner/example-drb",
          "display": "Dr B"
        },
        "reasonCode": [
          {
            "coding": [
              {
                "system": "http://snomed.info/sct",
                "code": "233604007",
                "display": "Pneumonia (disorder)"
              }
            ]
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "LRS IV at 250 ml/hr",
            "asNeededBoolean": false,
            "route": {
              "coding": [
                {
                  "system": "http://ncimeta.nci.nih.gov",
                  "code": "C38276",
                  "display": "INTRAVENOUS",
                  "userSelected": false
                }
              ]
            },
            "method": {
              "text": "Constant Rate Infusion"
            }
          }
        ]
      },
      "search": {
        "mode": "match"
      }
    },
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/bb95536c-eca6-4f31-af6e-821c3bc9d3",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "bb95536c-eca6-4f31-af6e-821c3bc9d3",
        "meta": {
          "versionId": "4",
          "lastUpdated": "2022-04-12T01:54:45.811Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            },
            {
              "code": "Inpatient"
            }
          ]
        },
        "status": "active",
        "intent": "order",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "inpatient",
                "display": "Inpatient"
              }
            ],
            "text": "Inpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "1656313",
              "display": "Cefotaxime 1000 MG Injection"
            }
          ],
          "text": "Cefotaxime 1000Mg Powder For Solution For Injection"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "encounter": {
          "reference": "Encounter/inpatient-example",
          "display": "Inpatient encounter"
        },
        "authoredOn": "2016-09-12",
        "requester": {
          "reference": "Practitioner/example-drcayr",
          "display": "Dr Cayr"
        },
        "reasonCode": [
          {
            "coding": [
              {
                "system": "http://snomed.info/sct",
                "code": "233604007",
                "display": "Pneumonia (disorder)"
              }
            ]
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "Cefatoxime 1gm intravenously every 6 hours",
            "timing": {
              "repeat": {
                "frequency": 1,
                "period": 6,
                "periodUnit": "h"
              }
            },
            "asNeededBoolean": false,
            "route": {
              "coding": [
                {
                  "system": "http://ncimeta.nci.nih.gov",
                  "code": "C38276",
                  "display": "INTRAVENOUS",
                  "userSelected": false
                }
              ]
            },
            "method": {
              "text": "Slow Push"
            }
          }
        ]
      },
      "search": {
        "mode": "match"
      }
    },
    {
      "fullUrl": "http://test.fhir.org/r4/MedicationRequest/e5fb50da-bff9-414a-a229-68b431c489",
      "resource": {
        "resourceType": "MedicationRequest",
        "id": "e5fb50da-bff9-414a-a229-68b431c489",
        "meta": {
          "versionId": "4",
          "lastUpdated": "2022-04-12T01:54:45.858Z",
          "profile": [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
          ],
          "tag": [
            {
              "code": "US_Core_5"
            },
            {
              "code": "Inpatient"
            }
          ]
        },
        "status": "active",
        "intent": "order",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code": "inpatient",
                "display": "Inpatient"
              }
            ],
            "text": "Inpatient"
          }
        ],
        "reportedBoolean": false,
        "medicationCodeableConcept": {
          "coding": [
            {
              "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code": "860092",
              "display": "1 ML Ketorolac Tromethamine 15 MG/ML Injection"
            }
          ],
          "text": "Ketorolac Tromethamine 15 MG/ML For Injection"
        },
        "subject": {
          "reference": "Patient/test2",
          "display": "Brian Z"
        },
        "encounter": {
          "reference": "Encounter/inpatient-example",
          "display": "Inpatient encounter"
        },
        "authoredOn": "2016-09-12",
        "requester": {
          "reference": "Practitioner/example-drb",
          "display": "Dr B"
        },
        "reasonCode": [
          {
            "coding": [
              {
                "system": "http://snomed.info/sct",
                "code": "233604007",
                "display": "Pneumonia (disorder)"
              }
            ]
          }
        ],
        "dosageInstruction": [
          {
            "sequence": 1,
            "text": "Ketoralac 15mg every six hours",
            "timing": {
              "repeat": {
                "frequency": 1,
                "period": 6,
                "periodUnit": "h"
              }
            },
            "asNeededBoolean": false,
            "route": {
              "coding": [
                {
                  "system": "http://ncimeta.nci.nih.gov",
                  "code": "C38276",
                  "display": "INTRAVENOUS",
                  "userSelected": false
                }
              ]
            },
            "method": {
              "text": "Slow Push"
            }
          }
        ]
      },
      "search": {
        "mode": "match"
      }
    }
  ]
}


```

See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful operations and search parameters for this IG.

#### De-duplication of Data

Medications may be duplicated in a medication list when multiple sources of data are used to generate the list. To provide a list of a patient's medications, it may be necessary to "de-duplicate" them. The de-duplication activity **MAY** be supplied by the Server, but **SHOULD** be provided by the Client.

This specification does not specify de-duplication best practices; however, systems can consider the following approaches:

* Compare the`MedicationRequest.identifier`. The `identifier` element is an external business identifier systems include to help indicate that the resources are related.
* Compare the generic or brand name included in the medication resource. The system will require access to terminology capabilities to identify equivalence.
* Finally, in the de-duplication process, systems must exercise caution in marking things as equivalent only if they are certain.

-------

Footnotes

1. Future versions of FHIR are anticipated to include further changes to the medication resources, which may lead to changes in our guidance for fetching patient medications in future versions of this guide. [↩](#fnref:1)

