# hl7.fhir.us.core#8.0.1: US Core Implementation Guide

## Pages

* [Home](index.md)
* [Examples](examples.md)
* [Profiles and Extensions](profiles-and-extensions.md)
* [Relationship With Other IGs](relationship-with-other-igs.md)
* [Patient Data Feed](patient-data-feed.md)
* [US Core Roadmap](us-core-roadmap.md)
* [Terminology](terminology.md)
* [Writing Vital Signs](writing-vital-signs.md)
* [Security](security.md)
* [Clinical Notes](clinical-notes.md)
* [US Core ImplementationGuide Resource](ImplementationGuide-hl7.fhir.us.core.md)
* [Observation Summary Table](observation-summary.md)
* [Change Log](changes.md)
* [Capability Statements](capability-statements.md)
* [General Requirements](general-requirements.md)
* [USCDI](uscdi.md)
* [Conformance](conformance.md)
* [Must Support](must-support.md)
* [General Guidance](general-guidance.md)
* [VSAC to FHIR Code System Mapping Table](vsacname-fhiruri-map.md)
* [Medication List](medication-list.md)
* [Using Provenance To Target Resource Elements](element-level-provenance.md)
* [Looking Ahead](looking-ahead.md)
* [Search Parameters and Operations](search-parameters-and-operations.md)
* [Screening and Assessments](screening-and-assessments.md)
* [Patient Data Feed Additional Resources](patient-data-feed-additional-resources.md)
* [Basic Provenance](basic-provenance.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](downloads.md)
* [SMART on FHIR Obligations and Capabilities](scopes.md)
* [Guidance](guidance.md)
* [Changes Between Versions](changes-between-versions.md)

## Resources

### CodeSystems

* [US Core CarePlan Category Extension Codes](CodeSystem-careplan-category.md)
* [US Core Condition Category Extension Codes](CodeSystem-condition-category.md)
* [US Core Category](CodeSystem-us-core-category.md)
* [US Core DocumentReferences Category Codes](CodeSystem-us-core-documentreference-category.md)
* [US Core Provenance Participant Type Extension Codes](CodeSystem-us-core-provenance-participant-type.md)

### ValueSets

* [US Core Clinical Note Type](ValueSet-us-core-clinical-note-type.md)
* [US Core Clinical Result Observation Category](ValueSet-us-core-clinical-result-observation-category.md)
* [US Core Condition Codes Current](ValueSet-us-core-condition-code-current.md)
* [US Core Condition Codes](ValueSet-us-core-condition-code.md)
* [US Core Diagnostic Report Category Codes](ValueSet-us-core-diagnosticreport-category.md)
* [US Core Non Laboratory Codes](ValueSet-us-core-diagnosticreport-report-and-note-codes.md)
* [US Core DocumentReference Category](ValueSet-us-core-documentreference-category.md)
* [US Core DocumentReference Type](ValueSet-us-core-documentreference-type.md)
* [US Core Goal Codes](ValueSet-us-core-goal-description.md)
* [US Core Laboratory Test Codes](ValueSet-us-core-laboratory-test-codes.md)
* [US Core Narrative Status](ValueSet-us-core-narrative-status.md)
* [US Core Status for Smoking Status Observation](ValueSet-us-core-observation-smoking-status-status.md)
* [US Core Problem or Health Concern](ValueSet-us-core-problem-or-health-concern.md)
* [US Core Procedure Codes](ValueSet-us-core-procedure-code.md)
* [US Core Provenance Participant Type Codes](ValueSet-us-core-provenance-participant-type.md)
* [US Core Screening Assessment Condition Category](ValueSet-us-core-screening-assessment-condition-category.md)
* [US Core Screening Assessment Observation Category](ValueSet-us-core-screening-assessment-observation-category.md)
* [US Core Screening Assessment Observation Maximum Category](ValueSet-us-core-screening-assessment-observation-maximum-category.md)
* [US Core ServiceRequest Category Codes](ValueSet-us-core-servicerequest-category.md)
* [US Core Simple Observation Category](ValueSet-us-core-simple-observation-category.md)
* [US Core Specimen Condition](ValueSet-us-core-specimen-condition.md)

### Resource Profiles

* [US Core Pediatric Head Occipital Frontal Circumference Percentile Profile](StructureDefinition-head-occipital-frontal-circumference-percentile.md)
* [US Core Pediatric BMI for Age Observation Profile](StructureDefinition-pediatric-bmi-for-age.md)
* [US Core Pediatric Weight for Height Observation Profile](StructureDefinition-pediatric-weight-for-height.md)
* [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md)
* [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md)
* [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md)
* [US Core Blood Pressure Profile](StructureDefinition-us-core-blood-pressure.md)
* [US Core BMI Profile](StructureDefinition-us-core-bmi.md)
* [US Core Body Height Profile](StructureDefinition-us-core-body-height.md)
* [US Core Body Temperature Profile](StructureDefinition-us-core-body-temperature.md)
* [US Core Body Weight Profile](StructureDefinition-us-core-body-weight.md)
* [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md)
* [US Core CarePlan Profile](StructureDefinition-us-core-careplan.md)
* [US Core CareTeam Profile](StructureDefinition-us-core-careteam.md)
* [US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md)
* [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)
* [US Core Coverage Profile](StructureDefinition-us-core-coverage.md)
* [US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md)
* [US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md)
* [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md)
* [US Core Encounter Profile](StructureDefinition-us-core-encounter.md)
* [US Core Goal Profile](StructureDefinition-us-core-goal.md)
* [US Core Head Circumference Profile](StructureDefinition-us-core-head-circumference.md)
* [US Core Heart Rate Profile](StructureDefinition-us-core-heart-rate.md)
* [US Core Immunization Profile](StructureDefinition-us-core-immunization.md)
* [US Core Implantable Device Profile](StructureDefinition-us-core-implantable-device.md)
* [US Core Location Profile](StructureDefinition-us-core-location.md)
* [US Core Medication Profile](StructureDefinition-us-core-medication.md)
* [US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md)
* [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md)
* [US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md)
* [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md)
* [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md)
* [US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md)
* [US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md)
* [US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md)
* [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)
* [US Core Observation Sexual Orientation Profile](StructureDefinition-us-core-observation-sexual-orientation.md)
* [US Core Organization Profile](StructureDefinition-us-core-organization.md)
* [US Core Patient Profile](StructureDefinition-us-core-patient.md)
* [US Core Practitioner Profile](StructureDefinition-us-core-practitioner.md)
* [US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md)
* [US Core Procedure Profile](StructureDefinition-us-core-procedure.md)
* [US Core Provenance Profile](StructureDefinition-us-core-provenance.md)
* [US Core Pulse Oximetry Profile](StructureDefinition-us-core-pulse-oximetry.md)
* [US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md)
* [US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md)
* [US Core Respiratory Rate Profile](StructureDefinition-us-core-respiratory-rate.md)
* [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md)
* [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)
* [US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md)
* [US Core Specimen Profile](StructureDefinition-us-core-specimen.md)
* [US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md)
* [US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md)

### Extensions

* [US Core Authentication Time Extension](StructureDefinition-us-core-authentication-time.md)
* [US Core Birth Sex Extension](StructureDefinition-us-core-birthsex.md)
* [US Core Direct email Extension](StructureDefinition-us-core-direct.md)
* [US Core Ethnicity Extension](StructureDefinition-us-core-ethnicity.md)
* [US Core Extension Questionnaire URI](StructureDefinition-us-core-extension-questionnaire-uri.md)
* [US Core Gender Identity Extension](StructureDefinition-us-core-genderIdentity.md)
* [US Core Individual Sex Extension](StructureDefinition-us-core-individual-sex.md)
* [US Core Interpreter Needed Extension](StructureDefinition-us-core-interpreter-needed.md)
* [US Core Jurisdiction Extension](StructureDefinition-us-core-jurisdiction.md)
* [US Core Medication Adherence Extension](StructureDefinition-us-core-medication-adherence.md)
* [US Core Race Extension](StructureDefinition-us-core-race.md)
* [US Core Sex Extension](StructureDefinition-us-core-sex.md)
* [US Core Tribal Affiliation Extension](StructureDefinition-us-core-tribal-affiliation.md)
* [US Core USCDI Requirement Extension](StructureDefinition-uscdi-requirement.md)

### CapabilityStatements

* [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md)
* [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

### ImplementationGuides

* [US Core Implementation Guide](index.md)

### OperationDefinitions

* [US Core Fetch DocumentReference](OperationDefinition-docref.md)

### SearchParameters

* [USCoreAllergyintoleranceClinicalStatus](SearchParameter-us-core-allergyintolerance-clinical-status.md)
* [USCoreAllergyintolerancePatient](SearchParameter-us-core-allergyintolerance-patient.md)
* [USCoreCareplanCategory](SearchParameter-us-core-careplan-category.md)
* [USCoreCareplanDate](SearchParameter-us-core-careplan-date.md)
* [USCoreCareplanPatient](SearchParameter-us-core-careplan-patient.md)
* [USCoreCareplanStatus](SearchParameter-us-core-careplan-status.md)
* [USCoreCareteamPatient](SearchParameter-us-core-careteam-patient.md)
* [USCoreCareTeamRole](SearchParameter-us-core-careteam-role.md)
* [USCoreCareteamStatus](SearchParameter-us-core-careteam-status.md)
* [USCoreConditionAbatementDate](SearchParameter-us-core-condition-abatement-date.md)
* [USCoreConditionAssertedDate](SearchParameter-us-core-condition-asserted-date.md)
* [USCoreConditionCategory](SearchParameter-us-core-condition-category.md)
* [USCoreConditionClinicalStatus](SearchParameter-us-core-condition-clinical-status.md)
* [USCoreConditionCode](SearchParameter-us-core-condition-code.md)
* [USCoreConditionEncounter](SearchParameter-us-core-condition-encounter.md)
* [USCoreConditionLastUpdated](SearchParameter-us-core-condition-lastupdated.md)
* [USCoreConditionOnsetDate](SearchParameter-us-core-condition-onset-date.md)
* [USCoreConditionPatient](SearchParameter-us-core-condition-patient.md)
* [USCoreConditionRecordedDate](SearchParameter-us-core-condition-recorded-date.md)
* [USCoreCoveragePatient](SearchParameter-us-core-coverage-patient.md)
* [USCoreDevicePatient](SearchParameter-us-core-device-patient.md)
* [USCoreDeviceStatus](SearchParameter-us-core-device-status.md)
* [USCoreDeviceType](SearchParameter-us-core-device-type.md)
* [USCoreDiagnosticreportCategory](SearchParameter-us-core-diagnosticreport-category.md)
* [USCoreDiagnosticreportCode](SearchParameter-us-core-diagnosticreport-code.md)
* [USCoreDiagnosticreportDate](SearchParameter-us-core-diagnosticreport-date.md)
* [USCoreDiagnosticreportLastUpdated](SearchParameter-us-core-diagnosticreport-lastupdated.md)
* [USCoreDiagnosticreportPatient](SearchParameter-us-core-diagnosticreport-patient.md)
* [USCoreDiagnosticreportStatus](SearchParameter-us-core-diagnosticreport-status.md)
* [USCoreDocumentreferenceCategory](SearchParameter-us-core-documentreference-category.md)
* [USCoreDocumentreferenceDate](SearchParameter-us-core-documentreference-date.md)
* [USCoreDocumentreferenceId](SearchParameter-us-core-documentreference-id.md)
* [USCoreDocumentreferencePatient](SearchParameter-us-core-documentreference-patient.md)
* [USCoreDocumentreferencePeriod](SearchParameter-us-core-documentreference-period.md)
* [USCoreDocumentreferenceStatus](SearchParameter-us-core-documentreference-status.md)
* [USCoreDocumentreferenceType](SearchParameter-us-core-documentreference-type.md)
* [USCoreEncounterClass](SearchParameter-us-core-encounter-class.md)
* [USCoreEncounterDate](SearchParameter-us-core-encounter-date.md)
* [USCoreEncounterDischargeDisposition](SearchParameter-us-core-encounter-discharge-disposition.md)
* [USCoreEncounterId](SearchParameter-us-core-encounter-id.md)
* [USCoreEncounterIdentifier](SearchParameter-us-core-encounter-identifier.md)
* [USCoreEncounterLastUpdated](SearchParameter-us-core-encounter-lastupdated.md)
* [USCoreEncounterLocation](SearchParameter-us-core-encounter-location.md)
* [USCoreEncounterPatient](SearchParameter-us-core-encounter-patient.md)
* [USCoreEncounterStatus](SearchParameter-us-core-encounter-status.md)
* [USCoreEncounterType](SearchParameter-us-core-encounter-type.md)
* [USCoreEthnicity](SearchParameter-us-core-ethnicity.md)
* [USCoreGoalDescription](SearchParameter-us-core-goal-description.md)
* [USCoreGoalLifecycleStatus](SearchParameter-us-core-goal-lifecycle-status.md)
* [USCoreGoalPatient](SearchParameter-us-core-goal-patient.md)
* [USCoreGoalTargetDate](SearchParameter-us-core-goal-target-date.md)
* [USCoreImmunizationDate](SearchParameter-us-core-immunization-date.md)
* [USCoreImmunizationPatient](SearchParameter-us-core-immunization-patient.md)
* [USCoreImmunizationStatus](SearchParameter-us-core-immunization-status.md)
* [USCoreLocationAddressCity](SearchParameter-us-core-location-address-city.md)
* [USCoreLocationAddressPostalcode](SearchParameter-us-core-location-address-postalcode.md)
* [USCoreLocationAddressState](SearchParameter-us-core-location-address-state.md)
* [USCoreLocationAddress](SearchParameter-us-core-location-address.md)
* [USCoreLocationName](SearchParameter-us-core-location-name.md)
* [USCoreMedicationdispensePatient](SearchParameter-us-core-medicationdispense-patient.md)
* [USCoreMedicationdispenseStatus](SearchParameter-us-core-medicationdispense-status.md)
* [USCoreMedicationdispenseType](SearchParameter-us-core-medicationdispense-type.md)
* [USCoreMedicationrequestAuthoredon](SearchParameter-us-core-medicationrequest-authoredon.md)
* [USCoreMedicationrequestEncounter](SearchParameter-us-core-medicationrequest-encounter.md)
* [USCoreMedicationrequestIntent](SearchParameter-us-core-medicationrequest-intent.md)
* [USCoreMedicationrequestPatient](SearchParameter-us-core-medicationrequest-patient.md)
* [USCoreMedicationrequestStatus](SearchParameter-us-core-medicationrequest-status.md)
* [USCoreObservationCategory](SearchParameter-us-core-observation-category.md)
* [USCoreObservationCode](SearchParameter-us-core-observation-code.md)
* [USCoreObservationDate](SearchParameter-us-core-observation-date.md)
* [USCoreObservationLastUpdated](SearchParameter-us-core-observation-lastupdated.md)
* [USCoreObservationPatient](SearchParameter-us-core-observation-patient.md)
* [USCoreObservationStatus](SearchParameter-us-core-observation-status.md)
* [USCoreOrganizationAddress](SearchParameter-us-core-organization-address.md)
* [USCoreOrganizationName](SearchParameter-us-core-organization-name.md)
* [USCorePatientBirthdate](SearchParameter-us-core-patient-birthdate.md)
* [USCorePatientDeathDate](SearchParameter-us-core-patient-death-date.md)
* [USCorePatientFamily](SearchParameter-us-core-patient-family.md)
* [USCorePatientGiven](SearchParameter-us-core-patient-given.md)
* [USCorePatientId](SearchParameter-us-core-patient-id.md)
* [USCorePatientIdentifier](SearchParameter-us-core-patient-identifier.md)
* [USCorePatientName](SearchParameter-us-core-patient-name.md)
* [USCorePractitionerId](SearchParameter-us-core-practitioner-id.md)
* [USCorePractitionerIdentifier](SearchParameter-us-core-practitioner-identifier.md)
* [USCorePractitionerName](SearchParameter-us-core-practitioner-name.md)
* [USCorePractitionerrolePractitioner](SearchParameter-us-core-practitionerrole-practitioner.md)
* [USCorePractitionerroleSpecialty](SearchParameter-us-core-practitionerrole-specialty.md)
* [USCoreProcedureCode](SearchParameter-us-core-procedure-code.md)
* [USCoreProcedureDate](SearchParameter-us-core-procedure-date.md)
* [USCoreProcedurePatient](SearchParameter-us-core-procedure-patient.md)
* [USCoreProcedureStatus](SearchParameter-us-core-procedure-status.md)
* [USCoreQuestionnaireresponseAuthored](SearchParameter-us-core-questionnaireresponse-authored.md)
* [USCoreQuestionnaireresponseId](SearchParameter-us-core-questionnaireresponse-id.md)
* [USCoreQuestionnaireresponsePatient](SearchParameter-us-core-questionnaireresponse-patient.md)
* [USCoreQuestionnaireresponseQuestionnaire](SearchParameter-us-core-questionnaireresponse-questionnaire.md)
* [USCoreQuestionnaireresponseStatus](SearchParameter-us-core-questionnaireresponse-status.md)
* [USCoreRace](SearchParameter-us-core-race.md)
* [USCoreRelatedpersonId](SearchParameter-us-core-relatedperson-id.md)
* [USCoreRelatedpersonName](SearchParameter-us-core-relatedperson-name.md)
* [USCoreRelatedpersonPatient](SearchParameter-us-core-relatedperson-patient.md)
* [USCoreServicerequestAuthored](SearchParameter-us-core-servicerequest-authored.md)
* [USCoreServicerequestCategory](SearchParameter-us-core-servicerequest-category.md)
* [USCoreServicerequestCode](SearchParameter-us-core-servicerequest-code.md)
* [USCoreServicerequestId](SearchParameter-us-core-servicerequest-id.md)
* [USCoreServicerequestPatient](SearchParameter-us-core-servicerequest-patient.md)
* [USCoreServicerequestStatus](SearchParameter-us-core-servicerequest-status.md)
* [USCoreSpecimenId](SearchParameter-us-core-specimen-id.md)
* [USCoreSpecimenPatient](SearchParameter-us-core-specimen-patient.md)

### Examples

* [example (AllergyIntolerance)](AllergyIntolerance-example.md)
* [non-pharmacologic-agent-example (AllergyIntolerance)](AllergyIntolerance-non-pharmacologic-agent-example.md)
* [66c8856b-ba11-4876-8aa8-467aad8c11a2 (Bundle)](Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.md)
* [allergyintolerance-provenance-example1 (Bundle)](Bundle-allergyintolerance-provenance-example1.md)
* [allergyintolerance-provenance-example2 (Bundle)](Bundle-allergyintolerance-provenance-example2.md)
* [docref-example-1 (Bundle)](Bundle-docref-example-1.md)
* [docref-example-2 (Bundle)](Bundle-docref-example-2.md)
* [colonoscopy (CarePlan)](CarePlan-colonoscopy.md)
* [US-Core example CareTeam (CareTeam)](CareTeam-example.md)
* [US-Core example CareTeam (CareTeam)](CareTeam-missing-coded-data-example.md)
* [condition-SDOH-example (Condition)](Condition-condition-SDOH-example.md)
* [condition-duodenal-ulcer (Condition)](Condition-condition-duodenal-ulcer.md)
* [encounter-diagnosis-example1 (Condition)](Condition-encounter-diagnosis-example1.md)
* [encounter-diagnosis-example2 (Condition)](Condition-encounter-diagnosis-example2.md)
* [health-concern-example (Condition)](Condition-health-concern-example.md)
* [coverage-example (Coverage)](Coverage-coverage-example.md)
* [udi-1 (Device)](Device-udi-1.md)
* [udi-2 (Device)](Device-udi-2.md)
* [udi-3 (Device)](Device-udi-3.md)
* [bone-density-report (DiagnosticReport)](DiagnosticReport-bone-density-report.md)
* [cardiology-report (DiagnosticReport)](DiagnosticReport-cardiology-report.md)
* [cbc (DiagnosticReport)](DiagnosticReport-cbc.md)
* [chest-xray-report (DiagnosticReport)](DiagnosticReport-chest-xray-report.md)
* [metabolic-panel (DiagnosticReport)](DiagnosticReport-metabolic-panel.md)
* [adi-dnr (DocumentReference)](DocumentReference-adi-dnr.md)
* [discharge-summary (DocumentReference)](DocumentReference-discharge-summary.md)
* [episode-summary (DocumentReference)](DocumentReference-episode-summary.md)
* [living-will (DocumentReference)](DocumentReference-living-will.md)
* [polst (DocumentReference)](DocumentReference-polst.md)
* [1036 (Encounter)](Encounter-1036.md)
* [delivery (Encounter)](Encounter-delivery.md)
* [example-1 (Encounter)](Encounter-example-1.md)
* [goal-1 (Goal)](Goal-goal-1.md)
* [goal-sdoh-2 (Goal)](Goal-goal-sdoh-2.md)
* [imm-1 (Immunization)](Immunization-imm-1.md)
* [US Core Version 3.1.1 Model Definition (Library)](Library-uscore-3.1.1-model-definition.md)
* [US Core Version 4.0.0 Model Definition (Library)](Library-uscore-4.0.0-model-definition.md)
* [US Core Version 5.0.1 Model Definition (Library)](Library-uscore-5.0.1-model-definition.md)
* [US Core Version 6.1.0 Model Definition (Library)](Library-uscore-6.1.0-model-definition.md)
* [US Core Version 7.0.0 Model Definition (Library)](Library-uscore-7.0.0-model-definition.md)
* [US Core Version 8.0.1 Model Definition (Library)](Library-uscore-8.0.1-model-definition.md)
* [Health Level Seven International - Amherst (Location)](Location-hl7east.md)
* [Holy Family Hospital (Location)](Location-hospital.md)
* [chest-xray (Media)](Media-chest-xray.md)
* [ekg-strip (Media)](Media-ekg-strip.md)
* [uscore-med1 (Medication)](Medication-uscore-med1.md)
* [uscore-med2 (Medication)](Medication-uscore-med2.md)
* [medicationdispense-example (MedicationDispense)](MedicationDispense-medicationdispense-example.md)
* [medicationrequest-coded-oral-axid (MedicationRequest)](MedicationRequest-medicationrequest-coded-oral-axid.md)
* [medicationrequest-contained-oral-axid (MedicationRequest)](MedicationRequest-medicationrequest-contained-oral-axid.md)
* [medicationrequest-referenced-oral-axid (MedicationRequest)](MedicationRequest-medicationrequest-referenced-oral-axid.md)
* [self-tylenol (MedicationRequest)](MedicationRequest-self-tylenol.md)
* [10-minute-apgar-color (Observation)](Observation-10-minute-apgar-color.md)
* [10-minute-apgar-heart-rate (Observation)](Observation-10-minute-apgar-heart-rate.md)
* [10-minute-apgar-muscle-tone (Observation)](Observation-10-minute-apgar-muscle-tone.md)
* [10-minute-apgar-reflex-irritability (Observation)](Observation-10-minute-apgar-reflex-irritability.md)
* [10-minute-apgar-respiratory-effort (Observation)](Observation-10-minute-apgar-respiratory-effort.md)
* [10-minute-apgar-score-panel (Observation)](Observation-10-minute-apgar-score-panel.md)
* [10-minute-apgar-score (Observation)](Observation-10-minute-apgar-score.md)
* [ADI-example (Observation)](Observation-ADI-example.md)
* [AHC-HRSN-item-example-68517-2 (Observation)](Observation-AHC-HRSN-item-example-68517-2.md)
* [AUDIT-C-item-example-68517-2 (Observation)](Observation-AUDIT-C-item-example-68517-2.md)
* [AUDIT-C-item-example-68519-8 (Observation)](Observation-AUDIT-C-item-example-68519-8.md)
* [AUDIT-C-item-example-68520-6 (Observation)](Observation-AUDIT-C-item-example-68520-6.md)
* [AUDIT-C-item-example-75626-2 (Observation)](Observation-AUDIT-C-item-example-75626-2.md)
* [AUDIT-C-panel-example-72109-2 (Observation)](Observation-AUDIT-C-panel-example-72109-2.md)
* [EVS-item-example-68516-4 (Observation)](Observation-EVS-item-example-68516-4.md)
* [EVS-item-example-89555-7 (Observation)](Observation-EVS-item-example-89555-7.md)
* [EVS-panel-example-89574-8 (Observation)](Observation-EVS-panel-example-89574-8.md)
* [HVS-item-example-88122-7 (Observation)](Observation-HVS-item-example-88122-7.md)
* [HVS-item-example-88123-5 (Observation)](Observation-HVS-item-example-88123-5.md)
* [HVS-item-example-88124-3 (Observation)](Observation-HVS-item-example-88124-3.md)
* [HVS-panel-example-88121-9 (Observation)](Observation-HVS-panel-example-88121-9.md)
* [PHQ9-item-example-44250-9 (Observation)](Observation-PHQ9-item-example-44250-9.md)
* [PHQ9-item-example-44251-7 (Observation)](Observation-PHQ9-item-example-44251-7.md)
* [PHQ9-item-example-44252-5 (Observation)](Observation-PHQ9-item-example-44252-5.md)
* [PHQ9-item-example-44253-3 (Observation)](Observation-PHQ9-item-example-44253-3.md)
* [PHQ9-item-example-44254-1 (Observation)](Observation-PHQ9-item-example-44254-1.md)
* [PHQ9-item-example-44255-8 (Observation)](Observation-PHQ9-item-example-44255-8.md)
* [PHQ9-item-example-44258-2 (Observation)](Observation-PHQ9-item-example-44258-2.md)
* [PHQ9-item-example-44259-0 (Observation)](Observation-PHQ9-item-example-44259-0.md)
* [PHQ9-item-example-44260-8 (Observation)](Observation-PHQ9-item-example-44260-8.md)
* [PHQ9-item-example-44261-6 (Observation)](Observation-PHQ9-item-example-44261-6.md)
* [PHQ9-item-example-69722-7 (Observation)](Observation-PHQ9-item-example-69722-7.md)
* [PHQ9-panel-example-44249-1 (Observation)](Observation-PHQ9-panel-example-44249-1.md)
* [PRAPARE-item-example-54899-0 (Observation)](Observation-PRAPARE-item-example-54899-0.md)
* [PRAPARE-item-example-56051-6 (Observation)](Observation-PRAPARE-item-example-56051-6.md)
* [PRAPARE-item-example-56799-0 (Observation)](Observation-PRAPARE-item-example-56799-0.md)
* [PRAPARE-item-example-63512-8 (Observation)](Observation-PRAPARE-item-example-63512-8.md)
* [PRAPARE-item-example-63586-2 (Observation)](Observation-PRAPARE-item-example-63586-2.md)
* [PRAPARE-item-example-67875-5 (Observation)](Observation-PRAPARE-item-example-67875-5.md)
* [PRAPARE-item-example-71802-3 (Observation)](Observation-PRAPARE-item-example-71802-3.md)
* [PRAPARE-item-example-76437-3 (Observation)](Observation-PRAPARE-item-example-76437-3.md)
* [PRAPARE-item-example-76501-6 (Observation)](Observation-PRAPARE-item-example-76501-6.md)
* [PRAPARE-item-example-82589-3 (Observation)](Observation-PRAPARE-item-example-82589-3.md)
* [PRAPARE-item-example-93026-3 (Observation)](Observation-PRAPARE-item-example-93026-3.md)
* [PRAPARE-item-example-93027-1 (Observation)](Observation-PRAPARE-item-example-93027-1.md)
* [PRAPARE-item-example-93028-9 (Observation)](Observation-PRAPARE-item-example-93028-9.md)
* [PRAPARE-item-example-93029-7 (Observation)](Observation-PRAPARE-item-example-93029-7.md)
* [PRAPARE-item-example-93030-5 (Observation)](Observation-PRAPARE-item-example-93030-5.md)
* [PRAPARE-item-example-93033-9 (Observation)](Observation-PRAPARE-item-example-93033-9.md)
* [PRAPARE-item-example-93034-7 (Observation)](Observation-PRAPARE-item-example-93034-7.md)
* [PRAPARE-item-example-93035-4 (Observation)](Observation-PRAPARE-item-example-93035-4.md)
* [PRAPARE-item-example-93038-8 (Observation)](Observation-PRAPARE-item-example-93038-8.md)
* [PRAPARE-multiselect-item-example-32624-9-answer0 (Observation)](Observation-PRAPARE-multiselect-item-example-32624-9-answer0.md)
* [PRAPARE-multiselect-item-example-32624-9-answer1 (Observation)](Observation-PRAPARE-multiselect-item-example-32624-9-answer1.md)
* [PRAPARE-multiselect-item-example-93031-3-answer0 (Observation)](Observation-PRAPARE-multiselect-item-example-93031-3-answer0.md)
* [PRAPARE-multiselect-item-example-93031-3-answer1 (Observation)](Observation-PRAPARE-multiselect-item-example-93031-3-answer1.md)
* [PRAPARE-panel-example-93025-5 (Observation)](Observation-PRAPARE-panel-example-93025-5.md)
* [PRAPARE-panel-example-93039-6 (Observation)](Observation-PRAPARE-panel-example-93039-6.md)
* [PRAPARE-panel-example-93040-4 (Observation)](Observation-PRAPARE-panel-example-93040-4.md)
* [PRAPARE-panel-example-93041-2 (Observation)](Observation-PRAPARE-panel-example-93041-2.md)
* [PRAPARE-panel-example-93042-0 (Observation)](Observation-PRAPARE-panel-example-93042-0.md)
* [PRAPARE-panel-example-93043-8 (Observation)](Observation-PRAPARE-panel-example-93043-8.md)
* [TAPS-item-example-75889-6 (Observation)](Observation-TAPS-item-example-75889-6.md)
* [TAPS-item-example-88037-7 (Observation)](Observation-TAPS-item-example-88037-7.md)
* [TAPS-item-example-96842-0 (Observation)](Observation-TAPS-item-example-96842-0.md)
* [TAPS-item-example-96843-8 (Observation)](Observation-TAPS-item-example-96843-8.md)
* [TAPS-item-example-96844-6 (Observation)](Observation-TAPS-item-example-96844-6.md)
* [TAPS-panel-example-96841-2 (Observation)](Observation-TAPS-panel-example-96841-2.md)
* [alcohol-use-status (Observation)](Observation-alcohol-use-status.md)
* [alcoholic-drinks-per-day (Observation)](Observation-alcoholic-drinks-per-day.md)
* [at-home-in-vitro-test (Observation)](Observation-at-home-in-vitro-test.md)
* [average-blood-pressure (Observation)](Observation-average-blood-pressure.md)
* [blood-pressure (Observation)](Observation-blood-pressure.md)
* [bmi (Observation)](Observation-bmi.md)
* [bp-data-absent (Observation)](Observation-bp-data-absent.md)
* [capillary-refill-time-nail-bed (Observation)](Observation-capillary-refill-time-nail-bed.md)
* [care-experience-preference (Observation)](Observation-care-experience-preference.md)
* [cbc-erythrocytes (Observation)](Observation-cbc-erythrocytes.md)
* [cbc-hematocrit (Observation)](Observation-cbc-hematocrit.md)
* [cbc-hemoglobin (Observation)](Observation-cbc-hemoglobin.md)
* [cbc-leukocytes (Observation)](Observation-cbc-leukocytes.md)
* [cbc-mch (Observation)](Observation-cbc-mch.md)
* [cbc-mchc (Observation)](Observation-cbc-mchc.md)
* [cbc-mcv (Observation)](Observation-cbc-mcv.md)
* [cbc-platelets (Observation)](Observation-cbc-platelets.md)
* [dxa-femur-l-armass-bmd (Observation)](Observation-dxa-femur-l-armass-bmd.md)
* [dxa-femur-l-t-score-bmd (Observation)](Observation-dxa-femur-l-t-score-bmd.md)
* [dxa-femur-l-z-score-bmd (Observation)](Observation-dxa-femur-l-z-score-bmd.md)
* [dxa-hip-l-armass-bmd (Observation)](Observation-dxa-hip-l-armass-bmd.md)
* [dxa-hip-l-t-score-bmd (Observation)](Observation-dxa-hip-l-t-score-bmd.md)
* [dxa-hip-l-z-score-bmd (Observation)](Observation-dxa-hip-l-z-score-bmd.md)
* [ekg-impression (Observation)](Observation-ekg-impression.md)
* [ekg-lead (Observation)](Observation-ekg-lead.md)
* [exercise-per-day (Observation)](Observation-exercise-per-day.md)
* [exercise-per-week (Observation)](Observation-exercise-per-week.md)
* [head-circumference (Observation)](Observation-head-circumference.md)
* [heart-rate-rhythm (Observation)](Observation-heart-rate-rhythm.md)
* [heart-rate (Observation)](Observation-heart-rate.md)
* [height (Observation)](Observation-height.md)
* [jugular-vein-distension (Observation)](Observation-jugular-vein-distension.md)
* [length (Observation)](Observation-length.md)
* [no-ADI-example (Observation)](Observation-no-ADI-example.md)
* [observation-occupation-industry-unknown (Observation)](Observation-observation-occupation-industry-unknown.md)
* [observation-occupation-unknown (Observation)](Observation-observation-occupation-unknown.md)
* [observation-occupation (Observation)](Observation-observation-occupation.md)
* [ofc-percentile (Observation)](Observation-ofc-percentile.md)
* [oxygen-saturation (Observation)](Observation-oxygen-saturation.md)
* [p-r-interval-ekg-lead (Observation)](Observation-p-r-interval-ekg-lead.md)
* [pack-years-example (Observation)](Observation-pack-years-example.md)
* [pediatric-bmi-example (Observation)](Observation-pediatric-bmi-example.md)
* [pediatric-wt-example (Observation)](Observation-pediatric-wt-example.md)
* [pregnancy-intent (Observation)](Observation-pregnancy-intent.md)
* [pregnancy-status (Observation)](Observation-pregnancy-status.md)
* [pulse-intensity-palpation (Observation)](Observation-pulse-intensity-palpation.md)
* [q-t-interval-ekg-lead (Observation)](Observation-q-t-interval-ekg-lead.md)
* [qrs-dur-ekg-lead (Observation)](Observation-qrs-dur-ekg-lead.md)
* [respiratory-rate (Observation)](Observation-respiratory-rate.md)
* [satO2-fiO2 (Observation)](Observation-satO2-fiO2.md)
* [serum-bun (Observation)](Observation-serum-bun.md)
* [serum-calcium (Observation)](Observation-serum-calcium.md)
* [serum-chloride (Observation)](Observation-serum-chloride.md)
* [serum-co2 (Observation)](Observation-serum-co2.md)
* [serum-creatinine (Observation)](Observation-serum-creatinine.md)
* [serum-glucose (Observation)](Observation-serum-glucose.md)
* [serum-potassium (Observation)](Observation-serum-potassium.md)
* [serum-sodium (Observation)](Observation-serum-sodium.md)
* [simple-observation-cognitive-status (Observation)](Observation-simple-observation-cognitive-status.md)
* [simple-observation-disability-status (Observation)](Observation-simple-observation-disability-status.md)
* [simple-observation-functional-status (Observation)](Observation-simple-observation-functional-status.md)
* [simple-observation-sdoh (Observation)](Observation-simple-observation-sdoh.md)
* [some-day-smoker (Observation)](Observation-some-day-smoker.md)
* [substance-use-status (Observation)](Observation-substance-use-status.md)
* [temperature (Observation)](Observation-temperature.md)
* [treatment-intervention-preference (Observation)](Observation-treatment-intervention-preference.md)
* [urobilinogen (Observation)](Observation-urobilinogen.md)
* [weight (Observation)](Observation-weight.md)
* [xray-chest-findings (Observation)](Observation-xray-chest-findings.md)
* [xray-chest-impression (Observation)](Observation-xray-chest-impression.md)
* [Acme Labs (Organization)](Organization-acme-lab.md)
* [Acme Health Plan (Organization)](Organization-acme-payer.md)
* [Acme Clinic (Organization)](Organization-example-organization-2.md)
* [Holy Healthcare (Organization)](Organization-holy-healthcare.md)
* [Saint Luke's Hospital of Kansas City (Organization)](Organization-saint-luke-w-endpoint.md)
* [child-example (Patient)](Patient-child-example.md)
* [deceased-example (Patient)](Patient-deceased-example.md)
* [example (Patient)](Patient-example.md)
* [infant-example (Patient)](Patient-infant-example.md)
* [practitioner-1 (Practitioner)](Practitioner-practitioner-1.md)
* [practitioner-2 (Practitioner)](Practitioner-practitioner-2.md)
* [practitioner-pharmacist (Practitioner)](Practitioner-practitioner-pharmacist.md)
* [defib-implant (Procedure)](Procedure-defib-implant.md)
* [rehab (Procedure)](Procedure-rehab.md)
* [Alcohol Use Disorder Identification Test - Consumption [AUDIT-C] (Questionnaire)](Questionnaire-AUDIT-C.md)
* [Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS] (Questionnaire)](Questionnaire-TAPS.md)
* [Exercise Vital Sign (EVS) (Questionnaire)](Questionnaire-exercise-vital-sign.md)
* [Hunger Vital Sign Example (Questionnaire)](Questionnaire-hunger-vital-sign-example.md)
* [PHQ-9 Example (Questionnaire)](Questionnaire-phq-9-example.md)
* [Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE] (Questionnaire)](Questionnaire-prapare-example.md)
* [AUDIT-C (QuestionnaireResponse)](QuestionnaireResponse-AUDIT-C.md)
* [TAPS (QuestionnaireResponse)](QuestionnaireResponse-TAPS.md)
* [exercise-vital-sign (QuestionnaireResponse)](QuestionnaireResponse-exercise-vital-sign.md)
* [glascow-coma-score (QuestionnaireResponse)](QuestionnaireResponse-glascow-coma-score.md)
* [hunger-vital-sign-example (QuestionnaireResponse)](QuestionnaireResponse-hunger-vital-sign-example.md)
* [phq-9-example (QuestionnaireResponse)](QuestionnaireResponse-phq-9-example.md)
* [prapare-example (QuestionnaireResponse)](QuestionnaireResponse-prapare-example.md)
* [shaw-niece (RelatedPerson)](RelatedPerson-shaw-niece.md)
* [bmp (ServiceRequest)](ServiceRequest-bmp.md)
* [cbc (ServiceRequest)](ServiceRequest-cbc.md)
* [chest-xray (ServiceRequest)](ServiceRequest-chest-xray.md)
* [ekg (ServiceRequest)](ServiceRequest-ekg.md)
* [foodpantry-referral (ServiceRequest)](ServiceRequest-foodpantry-referral.md)
* [rehab (ServiceRequest)](ServiceRequest-rehab.md)
* [example-serum-lipemic (Specimen)](Specimen-example-serum-lipemic.md)
* [specimen-example-serum (Specimen)](Specimen-specimen-example-serum.md)
* [specimen-example-urine (Specimen)](Specimen-specimen-example-urine.md)
* [specimen-example-whole-blood (Specimen)](Specimen-specimen-example-whole-blood.md)
