# Home - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core | *Version*:8.0.1 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCore |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

Key updates and detailed changes between this and prior versions are available on the US Core [Change Log](changes.md) and [Changes Between Versions](changes-between-versions.md) pages.

### Introduction

This guide and the US Core profiles have become the foundation for US Realm FHIR implementation guides. This annual release reflects changes to [U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isa/united-states-core-data-interoperability-uscdi) and comments and requests from the US Realm FHIR community. (The [US Core Roadmap](us-core-roadmap.md#us-core-roadmap) page outlines this approach to yearly updates.) US Core has benefitted from testing and guidance by the Argonaut Project Team. Their feedback continues to lay the groundwork for documenting the US Core Profile design, interactions, requirements, and guidelines for patient data access and [Assistant Secretary for Technology Policy (ASTP)](https://www.healthit.gov/topic/about-astp) Certification testing. Under the guidance of HL7 and the HL7 US Realm Steering Committee, the content will expand in future versions to meet the needs specific to the US Realm.

The US Core Implementation Guide is based on [FHIR Version R4](http://hl7.org/fhir/R4/index.html). It defines the minimum constraints on the FHIR resources to create the US Core Profiles. The elements, extensions, vocabularies, and value sets that SHALL be present are identified, and how they are used is defined. It also documents the minimum FHIR RESTful interactions for each US Core Profiles to access patient data. Establishing the "floor" of standards to promote interoperability and adoption through common implementation allows for further standards development evolution for specific use cases. There are two different ways to implement US Core:

1. Profile Only Support: Systems may support**only**the US Core Profiles to represent clinical information.
1. Profile Support + Interaction Support: Systems may support**both**the US Core Profile content structure**and**the RESTful interactions defined for a resource.

For a detailed description of these different usages of US Core, see the [Conformance Requirements](capability-statements.md) page.

### Background

The US Core requirements were initially developed, balloted, and published in FHIR DSTU2 as part of the [Office of the National Coordinator for Health Information Technology (ONC)](http://www.healthit.gov/newsroom/about-onc) sponsored Data Access Framework (DAF) project. The Argonaut Data Query Implementation Guide superseded DAF and documented security and authorization and the querying of the [2015 Edition Common Clinical Data Set (CCDS)](https://www.healthit.gov/sites/default/files/ccds_reference_document_v1_1.pdf) and static documents. US Core descended directly from the Argonaut guide to support FHIR Version STU3 and eventually FHIR R4 and the ASTP/ONC [U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isa/united-states-core-data-interoperability-uscdi). Refer to the [USCDI](uscdi.md) page which maps the US Core versions and profiles to the USCDI versions and Data Elements.

### How To Read This Guide

This Guide is divided into several pages, which are listed at the top of each page in the menu bar.

* [Home](index.md): The home page provides the introduction and background for US Core.
* [Conformance](conformance.md): These pages describe the set of rules to claim conformance to this guide 
* [General Requirements](general-requirements.md): This page defines requirements common to all actors and profiles used in this guide, including how CapabilityStatements are used to claim conformance.
* [Must Support](must-support.md): This page defines the expectations for mandatory and Must Support elements in the US Core Profiles.
 
* [Guidance](guidance.md): The Guidance pages document best practices and how to use the profiles and transactions defined in this guide. 
* [USCDI](uscdi.md): This page maps the US Core Profiles to the (USCDI) data classes and data elements.
* [General Guidance](general-guidance.md): This page provides guidance, definitions, and requirements common to all actors and profiles used in this guide.
* [Clinical Notes](clinical-notes.md): This page provides guidance on the interactions between Consumers and Producers of clinical notes.
* [Medication List](medication-list.md): This page provides guidance on how a patient or provider can access a patient's medications.
* [Basic Provenance](basic-provenance.md): This page provides implementers with important definitions to create and share the Provenance Resource.
* [Screening and Assessments](screening-and-assessments.md): This page documents how US Core Profiles are used to represent screenings and assessments for patient health status
* [Changes Between Versions](changes-between-versions.md): This page considers the user and developer experience when transitioning between versions of US Core and documents the changes between versions.
 
* [FHIR Artifacts](artifacts.md): These pages provide detailed descriptions and formal definitions for all the FHIR objects defined in this guide. 
* [Profiles and Extensions](profiles-and-extensions.md): This page lists the US Core Profiles and Extensions defined in this guide to exchange quality data. 
* Each US Core Profile page includes a narrative description that lists all the [Mandatory](must-support.md) and [Must Support](must-support.md) data elements, profile-specific implementation guidance, and formal definitions. A "Quick Start" guide summarizes the supported search transactions for each profile. Although the guidance typically focuses on the profiled elements, it also may cover un-profiled elements to aid with implementation and certification.
 
* [Search Parameters and Operations](search-parameters-and-operations.md): This page lists the defined US Core Operations and Search Parameters used in US Core transactions.
* [Terminology](terminology.md): This page lists the US Core ValueSets, and CodeSystems defined for the profiles.
* [Capability Statements](capability-statements.md): These pages define the expected FHIR capabilities of the US Core Servers and Clients.
 
* [Security](security.md): This page documents the general security requirements and recommendations for actors.
* [Examples](examples.md): This page lists all the examples used in this guide. These examples show what data produced and consumed by systems conforming with this implementation guide might look like. Every effort has been made to ensure that the examples are correct and useful, but they are not a normative part of the specification, nor fully representative of real-world examples.
* [Downloads](downloads.md): This page provides links to downloadable artifacts.
* [Change Log](changes.md): This page documents the changes across the versions of US Core. It is a vital resource for implementers, developers, and stakeholders to understand the guide’s progression.
* [Looking Ahead](looking-ahead.md): These pages provide a preview of the future direction of US Core 
* [US Core Roadmap](us-core-roadmap.md#us-core-roadmap): This page outlines the approach to adding new content to US Core.
* [Writing Vital Signs](writing-vital-signs.md): This page documents how to write vital sign Observation using patient- and provider-facing apps.
* [Patient Data Feed](patient-data-feed.md): This page documents how to use FHIR Subscriptions to be notified when events related to US Core content occur.
 

### US Core Actors

The following actors are part of the US Core IG:

#### US Core Requestor

A US Core Requester is an application that initiates a data access request to retrieve patient data. The US Core Requestor is the Client in a Client-Server interaction. The terms "US Core Requestor" and "Client" are used interchangeably throughout this guide and are not meant to limit this actor to only patient and provider apps. For example, payers and other users can use the same technology. These terms are a short-hand notation for "user application".

#### US Core Responder

A US Core Responder is a system that responds to the data access request providing patient data. The US Core responder is the Server in a Client-Server interaction. The terms "US Core Responder", "Server", and "EHR" are used interchangeably throughout this guide and are not meant to limit this actor to electronic health record systems. For example, HIEs, care coordination platforms, population health systems, etc., can use the same technology. These terms are a short-hand notation for "interoperable healthcare platform".

### US Core Profiles

Below is the list of US Core Profiles. Each profile identifies which core elements, extensions, vocabularies, and ValueSets **SHALL** be present in the resource when using this profile. Together, they promote interoperability and adoption through common implementation and provide the floor for standards development for specific use cases. See the [USCDI](uscdi.md) page, for a mapping to the U.S. Core Data for Interoperability (USCDI).

A simple narrative summary gives each profile's requirements and guidance. A formal hierarchical table presents a [logical view](http://hl7.org/fhir/R4/formats.html#table) of the content in both a differential and snapshot view, and provides references to appropriate terminologies and examples.

#### US Core Profile Maturity

All US Core FHIR conformance and terminology artifacts are assigned a [FHIR Maturity Level](http://hl7.org/fhir/R4/versions.html#maturity). The content in this release has been thoroughly reviewed through the HL7 ballot and other processes, implemented, and subject to ASTP certification testing. A FHIR Maturity Level of **FMM 3** is assigned to US Core artifacts associated with a USCDI Data Class or Element and subject to regulation and ASTP certification. A FHIR Maturity Level of **FMM 2** is assigned to US Core artifacts related to a USCDI Data Class or Element but have not yet been identified in regulation or subject to ASTP certification. All other US Core artifacts have been assigned a FHIR Maturity Level of **FMM 3** based upon community review. Refer to the FHIR specification for more information about maturity levels.

#### AllergyIntolerance

* [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md)

#### CarePlan

* [US Core CarePlan Profile](StructureDefinition-us-core-careplan.md)

#### CareTeam

* [US Core CareTeam Profile](StructureDefinition-us-core-careteam.md)

#### Condition

* [US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md)
* [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)

#### Coverage

* [US Core Coverage Profile](StructureDefinition-us-core-coverage.md)

#### Device

* [US Core Implantable Device Profile](StructureDefinition-us-core-implantable-device.md)

#### DiagnosticReport

* [US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md)
* [US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md)

#### DocumentReference

* [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md)
* [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md)

#### Encounter

* [US Core Encounter Profile](StructureDefinition-us-core-encounter.md)

#### Goal

* [US Core Goal Profile](StructureDefinition-us-core-goal.md)

#### Immunization

* [US Core Immunization Profile](StructureDefinition-us-core-immunization.md)

#### Location

* [US Core Location Profile](StructureDefinition-us-core-location.md)

#### Medication

* [US Core Medication Profile](StructureDefinition-us-core-medication.md)

#### MedicationDispense

* [US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md)

#### MedicationRequest

* [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md)

#### Observation

* [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md)
* [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md)
* [US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md)
* [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md) 
* [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md)
 
* [US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md)
* [US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md)
* [US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md)
* [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)
* [US Core Observation Sexual Orientation Profile](StructureDefinition-us-core-observation-sexual-orientation.md)
* [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)
* [US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md)
* [US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md)
* [US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md) 
* [US Core Pediatric BMI for Age Observation Profile](StructureDefinition-pediatric-bmi-for-age.md)
* [US Core Pediatric Weight for Height Observation Profile](StructureDefinition-pediatric-weight-for-height.md)
* [US Core Blood Pressure Profile](StructureDefinition-us-core-blood-pressure.md)
* [US Core BMI Profile](StructureDefinition-us-core-bmi.md)
* [US Core Body Height Profile](StructureDefinition-us-core-body-height.md)
* [US Core Body Temperature Profile](StructureDefinition-us-core-body-temperature.md)
* [US Core Body Weight Profile](StructureDefinition-us-core-body-weight.md)
* [US Core Head Circumference Profile](StructureDefinition-us-core-head-circumference.md)
* [US Core Heart Rate Profile](StructureDefinition-us-core-heart-rate.md)
* [US Core Pulse Oximetry Profile](StructureDefinition-us-core-pulse-oximetry.md)
* [US Core Respiratory Rate Profile](StructureDefinition-us-core-respiratory-rate.md)
* [US Core Pediatric Head Occipital Frontal Circumference Percentile Profile](StructureDefinition-head-occipital-frontal-circumference-percentile.md)
 

#### Organization

* [US Core Organization Profile](StructureDefinition-us-core-organization.md)

#### Patient

* [US Core Patient Profile](StructureDefinition-us-core-patient.md)

#### Practitioner

* [US Core Practitioner Profile](StructureDefinition-us-core-practitioner.md)

#### PractitionerRole

* [US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md)

#### Procedure

* [US Core Procedure Profile](StructureDefinition-us-core-procedure.md)

#### Provenance

* [US Core Provenance Profile](StructureDefinition-us-core-provenance.md)

#### QuestionnaireResponse

* [US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md)

#### RelatedPerson

* [US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md)

#### ServiceRequest

* [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md)

#### Specimen

* [US Core Specimen Profile](StructureDefinition-us-core-specimen.md)

### US Core FHIR RESTful interactions

For systems that support the US Core Profile content structure and the RESTful interactions defined for a resource, the requirements are formally defined in the US Core CapabilityStatements. In addition, each profile page has a **Quick Start** Section that documents the required FHIR RESTful search and read operations. These sections demonstrate how to access a patient's clinical and administrative data:

**Example of a simple FHIR RESTful Search Transaction**
![](basic_fhir_restful_interaction.svg)

See the FHIR specification for details on [FHIR RESTful Search API](http://hl7.org/fhir/R4/http.html#search) and the [SMART App Launch](http://hl7.org/fhir/smart-app-launch/STU2.2) for how an application gets access to a patient record.

-------

Primary Authors: Brett Marquard, Eric Haas, Gay Dolin

