# Downloads - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* **Downloads**

## Downloads

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Package File

The following package file includes an NPM package file used by many of the FHIR tools. It contains all the value sets, profiles, extensions, list of pages and URLs in the IG, etc., defined as part of this version of the Implementation Guides. This file **SHOULD** be the first choice whenever generating any implementation artifacts since it contains all the rules about what makes the profiles valid. Implementers must still be familiar with the specification content and profiles that apply to create a conformant implementation. See the [validating profiles and resources](http://hl7.org/fhir/R4/validation.html) documentation in FHIR for more information.

* [Package(compressed folder)](package.tgz)

### Downloadable Copy of Specification

A downloadable version of this IG is available so it can be hosted locally:

* [Downloadable Copy(compressed folder)](full-ig.zip)

### Examples

All the examples in this Implementation Guide are available for download:

* [XML(compressed folder)](examples.xml.zip)
* [JSON(compressed folder)](examples.json.zip)

### Consolidated CSV and Excel File Representations of Profiles

All the profile information for the US Core Implementation Guide in a single CSV or Excel file, which may be helpful to testers and analysts to review element properties across profiles in a single table:

* [CSV(compressed folder)](csvs.zip)
* [Excel(compressed folder)](excels.zip)

A table comparing all the Observation Profiles in US Core is also available for download:

* [Excel](observations-summary.xlsx)

### Schematrons

Schematrons are also available for download:

* [Schematrons(compressed folder)](schematrons.zip)

### Implementation Guide Details

The following link to the [ImplementationGuide](http://hl7.org/fhir/R4/implementationguide.html) resource defines the technical details of this publication, including dependencies and publishing parameters:

* [US Core ImplementationGuide Resource](ImplementationGuide-hl7.fhir.us.core.md)

