# Changes Between Versions - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **Changes Between Versions**

## Changes Between Versions

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

### Introduction

With each major version of FHIR, the core data models have changed. The FHIR core specification provides a [base resource differential](http://hl7.org/fhir/R4/diff.html) to help implementers navigate version changes. However, there are additional considerations for the user and developer experience when transitioning from [FHIR Version DSTU2](http://hl7.org/fhir/DSTU2/index.html) to FHIR R4. Similarly, US Core undergoes annual updates, which are documented on the [US Core Roadmap](us-core-roadmap.md#us-core-roadmap) page. Each update to a new version of US Core changes the US Core Profiles and conformance expectations. The following guidance on this page is provided to ensure a smoother upgrade path. It reflects non-normative best practices established at the time of publication.

### Versioning of US Core

US Core undergoes annual updates with new guidance, requirements, profiles, and changes to existing content. The [Directory of published versions](http://hl7.org/fhir/us/core/history.html) lists the publication history with links to each version of US Core. The [Change Log](changes.md) documents the changes across the versions of US Core. The [Argonaut Data Query](http://www.fhir.org/guides/argonaut/r2/) guide was published separately and is not included in the directory or change log.

Work is underway to identify corrections in subsequent versions as "patches" to prior versions for ASTP Certification.

### Cross Version Comparisons

The table below summarizes the different profiles and resource types between Argonaut Data Query and major releases of US Core :

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Argonaut CarePlan Profile | US Core CarePlan Profile | 3.1.1* |   |   | Type changed from CarePlan in DSTU2 to CareTeam in R4 |
| Argonaut CareTeam Profile | US Core CareTeam Profile | 3.1.1* |   |   |   |
| Argonaut Condition Profile | US Core Condition Profile | 3.1.1* |   | 5.0.0 | In version 5.0.0 split US Core Condition Profilee into US Core Condition Encounter Diagnosis Profile and US Core Condition Problems and Health Concerns Profile |
| - | US Core Condition Encounter Diagnosis Profile | 5.0.0 |   |   | see above |
| - | US Core Condition Problems and Health Concerns Profile | 5.0.0 |   |   | see above |
| Argonaut Device Profile | US Core Implantable Device Profile | 3.1.1* |   |   |   |
| Argonaut DiagnosticReport Profile | US Core DiagnosticReport Profile for Laboratory Results Reporting | 3.1.1* |   |   |   |
| Argonaut DocumentReference Profile | US Core DocumentReference Profile | 3.1.1* |   |   |   |
| Argonaut Goal Profile | US Core Goal Profile | 3.1.1* |   |   |   |
| Argonaut Immunization Profile | US Core Immunization Profile | 3.1.1* |   |   |   |
| Argonaut Medication Profile | US Core Medication Profile | 3.1.1* |   |   |   |
| Argonaut MedicationOrder Profile | US Core MedicationRequest Profile | 3.1.1* |   |   |   |
| Argonaut MedicationStatement Profile | - |   |   |   | US Core MedicationStatement Profile not defined in 3.1.1* |
| Argonaut Observation Results Profile | US Core Laboratory Result Observation Profile | 3.1.1* |   |   | In Version 6.0.0 derived from US Core Observation Clinical Test Result Profile |
| Argonaut Patient Profile | US Core Patient Profile | 3.1.1* |   |   |   |
| Argonaut Procedure Profile | US Core Procedure Profile | 3.1.1* |   |   |   |
| Argonaut Smoking Status Observation Profile | US Core Smoking Status Observation Profile | 3.1.1* |   |   |   |
| Argonaut Vital Signs Observation Profile | US Core Vital Signs Profile | 4.0.0 |   |   | Previous to version 4.0.0, referenced the FHIR Vital Signs Profile |
| - | US Core Blood Pressure Profile | 4.0.0 |   |   | Previous to version 4.0.0, referenced the FHIR Vital Signs Profile |
| - | US Core BMI Profile | 4.0.0 |   |   | Previous to version 4.0.0, referenced the FHIR Vital Signs Profile |
| - | US Core Head Circumference Profile | 4.0.0 |   |   | Previous to version 4.0.0, referenced the FHIR Vital Signs Profile |
| - | US Core Body Height Profile | 4.0.0 |   |   | Previous to version 4.0.0, referenced the FHIR Vital Signs Profile |
| - | US Core Body Weight Profile | 4.0.0 |   |   | Previous to version 4.0.0, referenced the FHIR Vital Signs Profile |
| - | US Core Body Temperature Profile | 4.0.0 |   |   | Previous to version 4.0.0, referenced the FHIR Vital Signs Profile |
| - | US Core Heart Rate Profile | 4.0.0 |   |   | Previous to version 4.0.0, referenced the FHIR Vital Signs Profile |
| - | US Core Respiratory Rate Profile | 4.0.0 |   |   | Previous to version 4.0.0, referenced the FHIR Vital Signs Profile |
| - | US Core Pediatric BMI for Age Observation Profile | 3.1.1* |   |   | 3.1.1* based on the FHIR Vital Signs Profile, 4.0.0+ based on the US Core Vital Signs Profile |
| - | US Core Pediatric Head Occipital Frontal Circumference Percentile Profile | 3.1.1* |   |   | 3.1.1* based on the FHIR Vital Signs Profile, 4.0.0+ based on the US Core Vital Signs Profile |
| - | US Core Pediatric Weight for Height Observation Profile | 3.1.1* |   |   | 3.1.1* based on the FHIR Vital Signs Profile, 4.0.0+ based on the US Core Vital Signs Profile |
| - | US Core Pulse Oximetry Profile | 3.1.1* |   |   | 3.1.1* based on the FHIR Vital Signs Profile, 4.0.0+ based on the US Core Vital Signs Profile |
| - | US Core DiagnosticReport Profile for Report and Note Exchange | 3.1.1* |   |   |   |
| - | US Core Encounter Profile | 3.1.1* |   |   |   |
| - | US Core Location Profile | 3.1.1* |   |   |   |
| - | US Core Organization Profile | 3.1.1* |   |   |   |
| - | US Core Practitioner Profile | 3.1.1* |   |   |   |
| - | US Core PractitionerRole Profile | 3.1.1* |   |   |   |
| - | US Core Provenance Profile | 3.1.1* |   |   |   |
| - | US Core Observation Sexual Orientation Profile | 5.0.0 |   |   | After version 7.0.0 this extension is no longer a USCDI requirement. |
| - | US Core Observation Social History Profile | 5.0.0 |   | 6.0.0 | Superseded by US Core Simple Observation Profile in version 6.0.0 |
| - | US Core Observation Survey Profile | 5.0.0 |   | 6.0.0 | Superseded by US Core Observation Screening Assessment Profile in version 6.0.0 |
| - | US Core Observation SDOH Assessment Profile | 5.0.0 |   | 6.0.0 | Superseded by US Core Observation Screening Assessment Profile in version 6.0.0 |
| - | US Core Observation Clinical Test Result Profile | 5.0.0 |   | 6.0.0 | Superseded by US Core Observation Clinical Result Profile in version 6.0.0 |
| - | US Core Observation Imaging Result Profile | 5.0.0 |   | 6.0.0 | Superseded by US Core Observation Clinical Result Profile in version 6.0.0 |
| - | US Core QuestionnaireResponse Profile | 5.0.0 |   |   |   |
| - | US Core RelatedPerson Profile | 5.0.0 |   |   |   |
| - | US Core ServiceRequest Profile | 5.0.0 |   |   |   |
| - | US Core Coverage Profile | 6.0.0 |   |   |   |
| - | US Core Observation Occupation Profile | 6.0.0 |   |   |   |
| - | US Core Observation Pregnancy Status Profile | 6.0.0 |   |   |   |
| - | US Core Observation Pregnancy Intent Profile | 6.0.0 |   |   |   |
| - | US Core Observation Clinical Result Profile | 6.0.0 |   |   | Replaces US Core Observation Clinical Test Result Profile and US Core Observation Imaging Result Profile |
| - | US Core Observation Screening Assessment Profile | 6.0.0 |   |   | Replaces US Core Observation Survey Profile and US Core Observation SDOH Assessment Profile |
| - | US Core MedicationDispense Profile | 6.0.0 |   |   |   |
| - | US Core Simple Observation Profile | 6.0.0 |   |   | Replaces US Core Observation Social History Profile |
| - | US Core Specimen Profile | 6.0.0 |   |   |   |
| - | US Core Average Blood Pressure Profile | 7.0.0 |   |   |   |
| - | US Core Care Experience Preference Profile | 7.0.0 |   |   |   |
| - | US Core Treatment Intervention Preference Profile | 7.0.0 |   |   |   |
| - | US Core Observation ADI Documentation Profile | 8.0.0 |   |   |   |
| - | US Core ADI DocumentReference Profile | 8.0.0 |   |   |   |
| **Extensions** |   |   |   |   |   |
| Sex of patient assigned at birth | US Core Birth Sex Extension | 3.1.1* |   |   | After version 6.0.0 this extension is no longer a USCDI requirement. |
| Argonaut ethnicity Extension | US Core Ethnicity Extension | 3.1.1* |   |   |   |
| Argonaut Race Extension | US Core Race Extension | 3.1.1* |   |   |   |
| - | US Core Direct email Extension | 3.1.1* |   |   |   |
| - | US Core Extension Questionnaire URI | 5.0.0 |   |   |   |
| - | US Core Gender Identity Extension | 5.0.0 |   |   | After version 7.0.0 this extension is no longer a USCDI requirement and has been deprecated. |
| - | US Core Tribal Affiliation Extension | 6.0.0 |   |   |   |
| - | US Core Jurisdiction Extension | 6.0.0 |   |   |   |
| - | US Core USCDI Requirements Extension | 6.0.0 |   |   | This extension is only used on US Core Profile StructureDefinition elements |
| - | US Core Individual Sex Extension | 8.0.1 |   |   |   |
| - | US Core Medication Adherence Extension | 7.0.0 |   |   |   |
|   | US Core Authentication Time Extension | 8.0.0 |   |   |   |
| - | US Core Interpreter Needed Extension | 8.0.0 |   |   |   |
| - | US Core Sex Extension | 6.1.0 | 8.0.1 |   | Superseded by US Core Individual Sex Extension in version 8.0.1 |
|   |   |   |   |   | * 3.1.1**or prior**version of US Core |

Detailed comparisons between the FHIR artifacts in this current 8.0.1 version of US Core and each previous major release are provided in the links below:

* [Comparison with version 7.0.0](comparison-v7.0.0/index.md)
* [Comparison with version 6.1.0](comparison-v6.1.0/index.md)
* [Comparison with version 5.0.1](comparison-v5.0.1/index.md)
* [Comparison with version 4.0.0](comparison-v4.0.0/index.md)
* [Comparison with version 3.1.1](comparison-v3.1.1/index.md)
* [(Partial) Comparison with Argonaut Data Query IG](comparison-argo/index.md)

### Endpoint Discoverability

A Server may support Version DSTU2 and Argonaut Data Query or FHIR R4 and US Core ver 3.1.1+ or both. A Server may make explicit which version of Argo/US Core is on their FHIR endpoint (e.g., "DSTU2" or "R4" path component or separate files based on version). However, the best practice is to inspect the [endpoint metadata](http://hl7.org/fhir/R4/http.html) on each endpoint to discover the information about a Server's capabilities, including the FHIR version and the US Core Profile version that is supported:

`GET [base]/metadata{?mode=[mode]} {&_format=[mime-type]}`

### No Guarantee that Resource IDs are Preserved

In some FHIR Servers, the identifier of the underlying clinical data is not maintained across FHIR versions. Therefore, Client applications must plan on deduplication methods that rely on something other than a common identifier across FHIR versions.

* Servers **SHOULD** maintain a stable common identifier for a resource across versions.

### Expectation that FHIR DSTU2 Data is Preserved in FHIR R4

In an upgraded R4 endpoint, any data in FHIR DSTU2 **SHOULD** be in FHIR R4. However, not all data in R4 may be available in DSTU2 because some profiles and data classes, like Clinical Notes and pediatric observations, are not part of DSTU2.

* The FHIR RESTful resource types supported in a DSTU2 implementation **SHOULD** be supported in a R4 implementation 
* Exceptions 
* MedicationStatement may be deprecated, and the data **SHOULD** be mapped to MedicationRequest. 
* See the guidance on the [Medication List](medication-list.md) page for how to access a patient's medications
 
* Care teams as represented by CarePlan in DSTU2 **SHOULD** be replaced by and the data mapped to CareTeam in R4
 
 
* Servers **SHOULD** make available the same information in DSTU2 and R4 where the more recent standard allows. (e.g., patient Rhonda Jones is available on both) 
* Exceptions 
* MedicationStatement data mapped to MedicationRequest
* care teams, as represented by CarePlan, **SHOULD** be mapped to CareTeam in R4
 
 
* Data **SHOULD** be maintained between versions (i.e., not be degraded).
* When updating between versions, Clients **SHOULD** consider the impact of any changes to data visualization on the usability for the end user and the maintenance of data integrity.

### Authorization Across Versions

* Separate authorization is required 
* There is no expectation that DSTU2 authorizations will work on R4 endpoints, and reauthorization is required when migrating between versions. 
* Maintaining the same auth Server for both endpoints so that the refresh token is valid for both DSTU2 and the R4 endpoint may be possible but not in scope.
 
 
* The new endpoint will bring additional/changed resource types and added scopes

