# US Core USCDI Requirement Extension - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core USCDI Requirement Extension**

## Extension: US Core USCDI Requirement Extension 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCDIRequirement |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.67 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

**This extension is only used in the US Core Implementation Guide''s Profile StructureDefinition elements.** It flags elements that are **Additional** USCDI Requirements for certified systems. In other words, elements that are not marked as Must Support but are required for ASTP Health IT certification testing. See the [Conformance page](general-requirements.md) for more information.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [USCoreAllergyIntolerance](StructureDefinition-us-core-allergyintolerance.md), [USCoreCareExperiencePreferenceProfile](StructureDefinition-us-core-care-experience-preference.md), [USCoreCarePlanProfile](StructureDefinition-us-core-careplan.md), [USCoreConditionEncounterDiagnosisProfile](StructureDefinition-us-core-condition-encounter-diagnosis.md)...Show 15 more,[USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md),[USCoreDocumentReferenceProfile](StructureDefinition-us-core-documentreference.md),[USCoreEncounterProfile](StructureDefinition-us-core-encounter.md),[USCoreMedicationRequestProfile](StructureDefinition-us-core-medicationrequest.md),[USCoreLaboratoryResultObservationProfile](StructureDefinition-us-core-observation-lab.md),[USCoreObservationOccupationProfile](StructureDefinition-us-core-observation-occupation.md),[USCoreObservationPregnancyIntentProfile](StructureDefinition-us-core-observation-pregnancyintent.md),[USCoreObservationPregnancyStatusProfile](StructureDefinition-us-core-observation-pregnancystatus.md),[USCoreObservationScreeningAssessmentProfile](StructureDefinition-us-core-observation-screening-assessment.md),[USCorePatientProfile](StructureDefinition-us-core-patient.md),[USCoreProcedureProfile](StructureDefinition-us-core-procedure.md),[USCoreServiceRequestProfile](StructureDefinition-us-core-servicerequest.md),[USCoreSimpleObservationProfile](StructureDefinition-us-core-simple-observation.md),[USCoreSpecimenProfile](StructureDefinition-us-core-specimen.md)and[USCoreTreatmentInterventionPreferenceProfile](StructureDefinition-us-core-treatment-intervention-preference.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/uscdi-requirement)

**Changes since version 7.0.0:**

* The resource metadata has changed (description)

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-uscdi-requirement.csv), [Excel](StructureDefinition-uscdi-requirement.xlsx), [Schematron](StructureDefinition-uscdi-requirement.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "uscdi-requirement",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.67"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCDIRequirement",
  "title" : "US Core USCDI Requirement Extension",
  "status" : "active",
  "date" : "2023-04-03",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "**This extension is only used in the US Core Implementation Guide''s Profile StructureDefinition elements.**  It flags elements that are *Additional* USCDI Requirements for certified systems. In other words, elements that are not marked as Must Support but are required for ASTP Health IT certification testing. See the [Conformance page](general-requirements.html) for more information.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ElementDefinition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "USCDI Requirement Flag: ONLY USED FOR US Core Profile StructureDefinitions",
        "definition" : "This extension flags elements that are *Additional* USCDI  Requirements for certified systems. In other words, elements that are not marked as Must Support but are required for for ASTP Health IT certification testing. See the [Conformance page](general-requirements.html) for more information.",
        "min" : 0,
        "max" : "1",
        "isModifier" : false,
        "mapping" : [
          {
            "identity" : "v2",
            "map" : "No v2 equivalent"
          },
          {
            "identity" : "rim",
            "map" : "No RIM equivalent"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
