# US Core RelatedPerson Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core RelatedPerson Profile**

## Resource Profile: US Core RelatedPerson Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreRelatedPersonProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.58 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core RelatedPerson Profile inherits from the FHIR[RelatedPerson](https://hl7.org/fhir/R4/relatedperson.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the RelatedPerson resource to record, search, and fetch basic administrative information about persons with a legal or familial relationship to a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for a related person that supports the patient.
* Query for a person related to the patient by name.

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each RelatedPerson Must Have:**

1. an active flag
1. a patient

**Each RelatedPerson Must Support:**

1. the relationship to the patient
1. the name of the related person
1. the telecom of the related person
1. the address of the related person*

*see guidance below

**Profile Specific Implementation Guidance:**

* * Systems **SHOULD** follow the [Project US@ Technical Specification for Patient Addresses Final Version 1.0](https://asapnet.org/wp-content/uploads/2022/03/Project_US_FINAL_Technical_Specification_Version_1.0.pdf) as the standard style guide for `RelatedPerson.address.line` and  `RelatedPerson.address.city`.

**Usages:**

* Refer to this Profile: [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md), [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md), [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md), [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md)...Show 24 more,[US Core CarePlan Profile](StructureDefinition-us-core-careplan.md),[US Core CareTeam Profile](StructureDefinition-us-core-careteam.md),[US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md),[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md),[US Core Coverage Profile](StructureDefinition-us-core-coverage.md),[US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md),[US Core Encounter Profile](StructureDefinition-us-core-encounter.md),[US Core Goal Profile](StructureDefinition-us-core-goal.md),[US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md),[US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md),[US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md),[US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md),[US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md),[US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md),[US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md),[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md),[US Core Procedure Profile](StructureDefinition-us-core-procedure.md),[US Core Provenance Profile](StructureDefinition-us-core-provenance.md),[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md),[US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md),[US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md),[US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md),[US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md)and[US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md)
* Examples for this Profile: [RelatedPerson/shaw-niece](RelatedPerson-shaw-niece.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-relatedperson)

**Changes since version 7.0.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-relatedperson.csv), [Excel](StructureDefinition-us-core-relatedperson.xlsx), [Schematron](StructureDefinition-us-core-relatedperson.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to related person data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/RelatedPerson.rs`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support both read RelatedPerson by`id`**AND**RelatedPerson search using the**[`_id`](SearchParameter-us-core-relatedperson-id.md)**search parameter:`GET [base]/RelatedPerson/[id]`or`GET [base]/RelatedPerson?_id=[id]`Example:
1. GET [base]/RelatedPerson/shaw-niece
1. GET [base]/RelatedPerson?_id=shaw-niece
**Implementation Notes:**([how to search by the logical id](http://hl7.org/fhir/R4/references.html#logical)of the resource)

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching for all relatedpersons for a patient using the**[`patient`](SearchParameter-us-core-relatedperson-patient.md)**search parameter:`GET [base]/RelatedPerson?patient={Type/}[id]`Example:
1. GET [base]/RelatedPerson?patient=1032702
**Implementation Notes:**Fetches a bundle of all RelatedPerson resources for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-relatedperson-patient.md)**and**[`name`](SearchParameter-us-core-relatedperson-name.md)**search parameters:`GET [base]/RelatedPerson?patient={Type/}[id]&name=[string]`Example:
1. GET [base]/RelatedPerson?patient=1137192&name=van%20Putten
**Implementation Notes:**Fetches a bundle of all RelatedPerson resources for the specified patient that may match any of the string fields in the`name`element (including family, give, prefix, suffix, suffix, and/or text) ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by string](http://hl7.org/fhir/R4/search.html#string))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-relatedperson",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.58"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreRelatedPersonProfile",
  "title" : "US Core RelatedPerson Profile",
  "status" : "active",
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core RelatedPerson Profile inherits from the FHIR [RelatedPerson](https://hl7.org/fhir/R4/relatedperson.html) resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the RelatedPerson resource to record, search, and fetch basic administrative information about persons with a legal or familial relationship to a patient. It specifies which core elements, extensions, vocabularies, and value sets **SHALL** be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RelatedPerson",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RelatedPerson",
        "path" : "RelatedPerson",
        "constraint" : [
          {
            "key" : "us-core-14",
            "severity" : "error",
            "human" : "Either a name or a relationship SHALL be provided (or both)",
            "expression" : "name.exists() or relationship.exists()"
          }
        ]
      },
      {
        "id" : "RelatedPerson.active",
        "path" : "RelatedPerson.active",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.patient",
        "path" : "RelatedPerson.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.relationship",
        "path" : "RelatedPerson.relationship",
        "condition" : ["us-core-14"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "The nature of the relationship between a patient and the related person.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype"
        }
      },
      {
        "id" : "RelatedPerson.name",
        "path" : "RelatedPerson.name",
        "condition" : ["us-core-14"],
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.telecom",
        "path" : "RelatedPerson.telecom",
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.address",
        "path" : "RelatedPerson.address",
        "mustSupport" : true
      }
    ]
  }
}

```
