# US Core Pulse Oximetry Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Pulse Oximetry Profile**

## Resource Profile: US Core Pulse Oximetry Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-pulse-oximetry | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCorePulseOximetryProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.55 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Pulse Oximetry Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and pulse oximetry and inspired oxygen observations with standard LOINC codes and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for pulse oximetry observations for a patient
* [Record or update](us-core-roadmap.md#future-candidate-requirements-under-consideration) pulse oximetry observations belonging to a patient

### Mandatory and Must Support Data Elements

In addition to the Mandatory and Must Support data elements in the [US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md), the following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Observation Must Have:**

1. a fixed code for oxygen saturation in arterial blood as defined in the FHIR oxygen saturation profile
1. an additional coding for oxygen saturation in arterial blood by pulse oximetry

**Each Observation Must Support:**

1. a value for oxygen saturation
1. a code for inspired oxygen concentration*
1. a value for inspired oxygen concentration

*see guidance below

**Profile Specific Implementation Guidance:**

*  
* Note that this profile also conforms to the base FHIR [Vital Signs Profile](http://hl7.org/fhir/R4/observation-vitalsigns.html).
 

* A code system value **SHOULD** be supplied for each additional code.
* The observations **MAY** have [component](http://hl7.org/fhir/R4/observation.html#gr-comp) observations. For example, to qualify the vital sign observation, 8310-5 - **Body temperature**, 8327-9 - **Body temperature measurement site** (oral, forehead, rectal, etc.) may be used as a component observation. The FHIR core specification [vital signs table](http://hl7.org/fhir/R4/observation-vitalsigns.html#vitals-table) provides several of these.
* *An Observation without a value, **SHALL** include a reason why the data is absent **unless** there are 1) component observations, or 2) reporting panel observations using `Observation.hasMember`. 
* For further guidance, see the [Observation Grouping](http://hl7.org/fhir/R4/observation.html#obsgrouping) section in FHIR Specification.
* Systems that never provide an observation without a value are not required to support `Observation.dataAbsentReason`.
 
* *An `Observation.component` without a value, **SHALL** include a reason why the data is absent. 
* Systems that never provide a component observation without a component value are not required to support `Observation.component.dataAbsentReason`.
 
* Implementers may use this profile as a base for other vital signs in addition to those in this guide.
* Inspired oxygen therapy may be represented with [component](http://hl7.org/fhir/R4/observation.html#gr-comp) observations when measured at the same time as the pulse oximetry measurements. They are expressed as inhaled oxygen flow rate (e.g., 6 liters/min) and inhaled oxygen concentration (e.g., 40% oxygen). 
* This profile is technically non-conformant with the base FHIR version 4.0.1 vitals profile which defines a **required** binding that excludes the concept for `L/min` for `Observation.component.value(x)`. This is a known issue and it means validation errors may occur when validating against this version of the US Core Pulse Oximetry Profile. A change request to correct this has been applied to the base FHIR ver 4.3.0 ("Release 4B").
 
* Many pulse oximetry readings are taken while the patient is breathing room air. The concept of "room air" (unmodified, ambient air) **SHOULD** be represented as an inhaled oxygen flow rate of 0 liters/min.
* A pulse oximetry reading without inspired oxygen component observations may imply that the measurement was performed while the patient was breathing room air or that the inspired oxygen reading was omitted. To remove this uncertainty, the inspired oxygen [component](http://hl7.org/fhir/R4/observation.html#gr-comp) observations **SHOULD** be used.

**Usages:**

* Examples for this Profile: [Observation/oxygen-saturation](Observation-oxygen-saturation.md) and [Observation/satO2-fiO2](Observation-satO2-fiO2.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-pulse-oximetry)

**Changes since version 7.0.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-pulse-oximetry.csv), [Excel](StructureDefinition-us-core-pulse-oximetry.xlsx), [Schematron](StructureDefinition-us-core-pulse-oximetry.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to vital signs data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/Observation.rs`
* [granular scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#finer-grained-resource-constraints-using-search-parameters): `<patient|user|system>/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**search parameters:`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs`Example:
1. GET [base]/Observation?patient=1134281&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and a category code =`vital-signs`([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`code`](SearchParameter-us-core-observation-code.md)**search parameters:
* including optional support for **OR** search on `code` (e.g.`code={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=1186747&code=http://loinc.org|8867-4,http://loinc.org|9279-1,http://loinc.org|59408-5
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and observation code(s).**SHOULD**support search by multiple codes. The Observation`code`parameter searches `Observation.code only. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**and**[`date`](SearchParameter-us-core-observation-date.md)**search parameters:
* including support for these `date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `date` (e.g.`date=[date]&date=[date]]&...`)
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Observation?patient=1134281&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&date=ge2020-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and date and a category code =`vital-signs`([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**and**[`status`](SearchParameter-us-core-observation-status.md)**search parameters:
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=1134281&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&status=final
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and category and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**and**[`_lastUpdated`](SearchParameter-us-core-observation-lastupdated.md)**search parameters:
* including support for these `_lastUpdated` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `_lastUpdated` (e.g.`_lastUpdated=[date]&_lastUpdated=[date]]&...`)
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Observation?patient=1134281&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&_lastUpdated=ge2024-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and category and _lastUpdated. See the US Core General Guidance page for[Searching Using lastUpdated](general-guidance.md#searching-using-lastupdated). ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`code`](SearchParameter-us-core-observation-code.md)**and**[`date`](SearchParameter-us-core-observation-date.md)**search parameters:
* including optional support for **OR** search on `code` (e.g.`code={system|}[code],{system|}[code],...`)
* including support for these `date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `date` (e.g.`date=[date]&date=[date]]&...`)
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Observation?patient=1186747&code=http://loinc.org|8867-4,http://loinc.org|9279-1,http://loinc.org|59408-5&date=ge2020-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and date and report code(s).**SHOULD**support search by multiple codes. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-pulse-oximetry",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-pulse-oximetry",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.55"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCorePulseOximetryProfile",
  "title" : "US Core Pulse Oximetry Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Pulse Oximetry Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search,  and pulse oximetry and inspired oxygen observations with standard LOINC codes and UCUM units of measure. It specifies which *additional*  core elements, extensions,  vocabularies, and value sets **SHALL** be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-vital-signs",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "US Core Pulse Oximetry Profile",
        "mustSupport" : false
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Oxygen Saturation by Pulse Oximetry",
        "comment" : "The code (59408-5 Oxygen saturation in Arterial blood by Pulse oximetry) is included as an additional observation code to FHIR Core vital Oxygen Saturation code (2708-6 Oxygen saturation in Arterial blood).",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 2,
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:PulseOx",
        "path" : "Observation.code.coding",
        "sliceName" : "PulseOx",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "59408-5"
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:O2Sat",
        "path" : "Observation.code.coding",
        "sliceName" : "O2Sat",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "2708-6"
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.valueQuantity",
        "path" : "Observation.valueQuantity",
        "short" : "Oxygen Saturation by Pulse Oximetry Value",
        "definition" : "The oxygen saturation by pulse oximetry value is expressed as a percentage (0-100) of the total hemoglobin content of the blood.",
        "mustSupport" : true
      },
      {
        "id" : "Observation.valueQuantity.value",
        "path" : "Observation.valueQuantity.value",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.valueQuantity.unit",
        "path" : "Observation.valueQuantity.unit",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.valueQuantity.system",
        "path" : "Observation.valueQuantity.system",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.valueQuantity.code",
        "path" : "Observation.valueQuantity.code",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "%",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used when reporting flow rates or oxygen concentration.",
        "definition" : "Used when reporting flow rates or oxygen concentration.",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate",
        "path" : "Observation.component",
        "sliceName" : "FlowRate",
        "short" : "Inhaled oxygen flow rate",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.code",
        "path" : "Observation.component.code",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "3151-8"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.valueQuantity",
        "path" : "Observation.component.valueQuantity",
        "short" : "Vital Sign Component Value",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.valueQuantity.value",
        "path" : "Observation.component.valueQuantity.value",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.valueQuantity.unit",
        "path" : "Observation.component.valueQuantity.unit",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.valueQuantity.system",
        "path" : "Observation.component.valueQuantity.system",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:FlowRate.valueQuantity.code",
        "path" : "Observation.component.valueQuantity.code",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "L/min",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration",
        "path" : "Observation.component",
        "sliceName" : "Concentration",
        "short" : "Inhaled oxygen concentration",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.code",
        "path" : "Observation.component.code",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "3150-0"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.valueQuantity",
        "path" : "Observation.component.valueQuantity",
        "short" : "Vital Sign Component Value",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.valueQuantity.value",
        "path" : "Observation.component.valueQuantity.value",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.valueQuantity.unit",
        "path" : "Observation.component.valueQuantity.unit",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.valueQuantity.system",
        "path" : "Observation.component.valueQuantity.system",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Concentration.valueQuantity.code",
        "path" : "Observation.component.valueQuantity.code",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "%",
        "mustSupport" : true
      }
    ]
  }
}

```
