# US Core Practitioner Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Practitioner Profile**

## Resource Profile: US Core Practitioner Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCorePractitionerProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.51 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Practitioner Profile inherits from the FHIR[Practitioner](https://hl7.org/fhir/R4/practitioner.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Practitioner resource to record, search, and fetch basic demographics and administrative information about an individual practitioner. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for a practitioner by name or NPI
* Reference from other Resources

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Practitioner Must Have:**

1. An identifier that Must Support a National Provider Identifier (NPI) if available*
1. A name

**Each PractitionerRole Must Support:**

1. Contact information*
1. An address*

* see guidance below

**Profile Specific Implementation Guidance:**

* *Other identifiers beyond NPI, such as the National Council of State Boards of Nursing Identifier (NCSBN ID), may be used to uniquely refer to a practitioner when appropriate.
* *The Practitioner and PractitionerRole directly and indirectly communicate the address(es) and contact information of the practitioner. Servers that support **only** the US Core Practitioner Profile and do not support the [US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md) **SHALL** provide implementation-specific guidance on how to access a provider's location and contact information using only the Practitioner resource. 
* Although `Practitioner.address` is marked as Must Support, the Server system is not required to support it if they support the US Core PractitionerRole Profile, but **SHALL** support it if they do not support the US Core PractitionerRole Profile. The Client application **SHALL** support both.
 
* It is important to balance the privacy of healthcare workers with the patient's right to access information. Only professional/work contact information about the practitioner **SHOULD** be available to the patient (such as a work address or office telephone number).
* This profile may be referenced by different capability statements, such as the [Conformance requirements for the US Core Server](CapabilityStatement-us-core-server.md) or a provider directory capability statement.
* * Systems **SHOULD** follow the [Project US@ Technical Specification for Patient Addresses Final Version 1.0](https://asapnet.org/wp-content/uploads/2022/03/Project_US_FINAL_Technical_Specification_Version_1.0.pdf) as the standard style guide for `Practitioner.address.line` and  `Practitioner.address.city`.

**Usages:**

* Refer to this Profile: [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md), [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md), [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md), [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md)...Show 27 more,[US Core CarePlan Profile](StructureDefinition-us-core-careplan.md),[US Core CareTeam Profile](StructureDefinition-us-core-careteam.md),[US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md),[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md),[US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md),[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md),[US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md),[US Core Encounter Profile](StructureDefinition-us-core-encounter.md),[US Core Goal Profile](StructureDefinition-us-core-goal.md),[US Core Immunization Profile](StructureDefinition-us-core-immunization.md),[US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md),[US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md),[US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md),[US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md),[US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md),[US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md),[US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md),[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md),[US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md),[US Core Procedure Profile](StructureDefinition-us-core-procedure.md),[US Core Provenance Profile](StructureDefinition-us-core-provenance.md),[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md),[US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md),[US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md),[US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md),[US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md)and[US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md)
* Examples for this Profile: [Practitioner/practitioner-1](Practitioner-practitioner-1.md), [Practitioner/practitioner-2](Practitioner-practitioner-2.md) and [Practitioner/practitioner-pharmacist](Practitioner-practitioner-pharmacist.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-practitioner)

**Changes since version 7.0.0:**

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-practitioner.csv), [Excel](StructureDefinition-us-core-practitioner.xlsx), [Schematron](StructureDefinition-us-core-practitioner.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to practitioner data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/Practitioner.rs`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support searching for a practitioner by a string match of any part of name using the**[`name`](SearchParameter-us-core-practitioner-name.md)**search parameter:`GET [base]/Practitioner?name=[string]`Example:
1. GET [base]/Practitioner?name=Smith
**Implementation Notes:**Fetches a bundle of all Practitioner resources matching the name ([how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHALL**support searching a practitioner by an identifier such as an NPI using the**[`identifier`](SearchParameter-us-core-practitioner-identifier.md)**search parameter:`GET [base]/Practitioner?identifier={system|}[code]`Example:
1. GET [base]/Practitioner?dentifier=http://hl7.org/fhir/sid/us-npi|97860456
**Implementation Notes:**Fetches a bundle containing any Practitioner resources matching the identifier ([how to search by token](http://hl7.org/fhir/R4/search.html#token))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support both read Practitioner by`id`**AND**Practitioner search using the**[`_id`](SearchParameter-us-core-practitioner-id.md)**search parameter:`GET [base]/Practitioner/[id]`or`GET [base]/Practitioner?_id=[id]`Example:
1. GET [base]/Practitioner/practitioner-1
1. GET [base]/Practitioner?_id=practitioner-1
**Implementation Notes:**([how to search by the logical id](http://hl7.org/fhir/R4/references.html#logical)of the resource)



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.51"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCorePractitionerProfile",
  "title" : "US Core Practitioner Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-04-20",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Practitioner Profile inherits from the FHIR [Practitioner](https://hl7.org/fhir/R4/practitioner.html) resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Practitioner resource to record, search, and fetch basic demographics and administrative information about an individual practitioner. It specifies which core elements, extensions, vocabularies, and value sets **SHALL** be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "alias" : ["Provider"],
        "mustSupport" : false
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "comment" : "NPI must be supported as the identifier system in the US, Tax id is allowed, Local id is allowed in addition to another identifier supplied by a jurisdictional authority such as a practitioner's *Drug Enforcement Administration (DEA)* number.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier.system",
        "path" : "Practitioner.identifier.system",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier.value",
        "path" : "Practitioner.identifier.value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:NPI",
        "path" : "Practitioner.identifier",
        "sliceName" : "NPI",
        "patternIdentifier" : {
          "system" : "http://hl7.org/fhir/sid/us-npi"
        },
        "condition" : ["us-core-16", "us-core-17"],
        "constraint" : [
          {
            "key" : "us-core-16",
            "severity" : "error",
            "human" : "NPI must be 10 digits",
            "expression" : "value.matches('^[0-9]{10}$')",
            "xpath" : "f:value/f:matches(value,/^[0-9]{10}$/)"
          },
          {
            "key" : "us-core-17",
            "severity" : "error",
            "human" : "NPI check digit must be valid (Luhn algorithm check)",
            "expression" : "(((select(value.substring(0,1).toInteger()).select(iif($this<5, $this*2, (($this*2)-9))))+(value.substring(1,1).toInteger())+(select(value.substring(2,1).toInteger()).select(iif($this<5, $this*2, (($this*2)-9))))+(value.substring(3,1).toInteger())+(select(value.substring(4,1).toInteger()).select(iif($this<5, $this*2, (($this*2)-9))))+(value.substring(5,1).toInteger())+(select(value.substring(6,1).toInteger()).select(iif($this<5, $this*2, (($this*2)-9))))+(value.substring(7,1).toInteger())+(select(value.substring(8,1).toInteger()).select(iif($this<5, $this*2, (($this*2)-9))))+(value.substring(9,1).toInteger()) + 24)mod 10=0)"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name.family",
        "path" : "Practitioner.name.family",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.telecom",
        "path" : "Practitioner.telecom",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.telecom.system",
        "path" : "Practitioner.telecom.system",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.telecom.value",
        "path" : "Practitioner.telecom.value",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.address",
        "path" : "Practitioner.address",
        "short" : "Address(es) of the practitioner",
        "definition" : "Address(es) of the practitioner",
        "requirements" : "\\-",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.address.line",
        "path" : "Practitioner.address.line",
        "max" : "4",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "49 MEADOW ST"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.address.city",
        "path" : "Practitioner.address.city",
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "EVERYTOWN"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.address.state",
        "path" : "Practitioner.address.state",
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "OK"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Two letter USPS alphabetic codes.",
          "valueSet" : "http://terminology.hl7.org/ValueSet/USPS-State"
        },
        "mapping" : [
          {
            "identity" : "servd",
            "map" : "./Sites"
          }
        ]
      },
      {
        "id" : "Practitioner.address.postalCode",
        "path" : "Practitioner.address.postalCode",
        "short" : "US Zip Codes",
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "74047"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.address.country",
        "path" : "Practitioner.address.country",
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
