# US Core Patient Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Patient Profile**

## Resource Profile: US Core Patient Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCorePatientProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.50 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Patient Profile inherits from the FHIR[Patient](https://hl7.org/fhir/R4/patient.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the[U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi)**Patient Demographics/Information**Data Class. It sets minimum expectations for the Patient resource to record, search, and fetch basic demographics and other administrative information about an individual patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for Patient demographic information using Medical Record Number (MRN), which is a type of identifier. The MRN is identifiable by `identifier.system` and may be location specific.
* Query for Patient demographic information using first name, last name, and birthdate.

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Patient Must Have:**

1. a patient identifier (e.g., MRN)
1. a patient name

**Each Patient Must Support:**

1. a birth date
1. an address*

**Additional USCDI Requirements:**

These [Additional USCDI Requirements](must-support.md#additional-uscdi-requirements) elements are not Mandatory or Must Support but are required for ASTP Health IT certification testing and are included in the formal definition of the profile and the Patient examples.

1. contact detail (e.g., a telephone number or an email address)
1. a communication language*
1. Interpreter Needed flag*
1. a race*
1. an ethnicity*
1. a tribal affiliation
1. sex*
1. date of death*
1. address use*
1. address period*
1. name use*
1. name period*
1. suffix*

*see guidance below

**Profile Specific Implementation Guidance:**

* Notes for **Race**, **Ethnicity**, **Date of Death**, **Name to Use**, **Previous Name**, **Suffix**, **Previous Address**, **Interpreter Needed**, and **Preferred Language** USCDI Data Elements: 
* The Complex Extensions for Race and Ethnicity allow for one or more codes of which: [Must Support](must-support.md) at least one category code from the OMB Race and Ethnicity Category Value Sets that draw from the [Race & Ethnicity - CDC (CDCREC)](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238) code system. 
* **MAY** include additional codes from the detailed ethnicity and detailed race value sets drawn from the [Race & Ethnicity - CDC (CDCREC)](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238) code system
* **SHALL** include a text description
 
* **Date of Death** is communicated using the `Patient.deceasedDateTime` element. 
* Although `Patient.deceased[x]` is marked as 𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜, Certifying Systems are not required to support both, but **SHALL** support at least `Patient.deceasedDateTime`
 
* **Previous name** is represented by setting `Patient.name.use` to "old" or providing an end date in `Patient.name.period` or doing both.
* **Suffix** is represented using the `Patient.name.suffix` element.
* **Previous Address** is represented by setting `Patient.address.use` to "old" or providing an end date in `Patient.address.period` or doing both.
* Servers can use the [US Core Interpreter Needed Extension](StructureDefinition-us-core-interpreter-needed.md) on this profile or the [US Core Encounter Profile](StructureDefinition-us-core-encounter.md) to communicate whether a patient needs an interpreter. Although the extension is marked as an **Additional USCDI Requirement** on both US Core Patient and US Core Encounter Profiles, the certifying Server system is not required to support the extension on both profiles but **SHALL** support the extension on at least one. The certifying Client application **SHALL** support the extension on both profiles. 
* Systems **SHOULD** designate the patient's preferred language in the `Patient.communication.preferred` element.
 
* The [Patient example](Patient-example.md) demonstrates how these elements are represented
 
* The USCDI Patient Demographics Data Class requires following the [Project US@ Technical Specification for Patient Addresses Final Version 1.0](https://asapnet.org/wp-content/uploads/2022/03/Project_US_FINAL_Technical_Specification_Version_1.0.pdf) for patient addresses. For new and updated records, [Certifying Systems](https://www.healthit.gov/topic/certification-ehrs/about-onc-health-it-certification-program) **SHALL** and non-Certifying Systems **SHOULD** follow it as the standard style guide for Patient addresses. 
* Consult the style guide for details about the format for the Address datatypes elements, especially `Patient.address.line` and `Patient.address.city`.
* Note: historical records or documents that are not exposed through FHIR-based APIs may not meet this requirement.
 
* *The [US Core Individual Sex Extension](StructureDefinition-us-core-individual-sex.md) represents the [U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isa/united-states-core-data-interoperability-uscdi) data element "Sex". Refer to the FHIR R5 [Patient](http://hl7.org/fhir/R4/patient.html) Resource for other interoperability considerations with regards to patient sex
* [Provenance](http://hl7.org/fhir/R4/provenance.html) and the FHIR Extension [Target Element](http://hl7.org/fhir/StructureDefinition/targetElement) can document how individual patient demographic data was captured. See [Element Level Provenance](element-level-provenance.md) on the [Basic Provenance](basic-provenance.md) page for more information.
* The Patient's Social Security Numbers **SHOULD NOT** be used as a patient identifier in `Patient.identifier.value`. There is increasing concern over using Social Security Numbers in healthcare due to the risk of identity theft and related issues. Many payers and providers have purged them from their systems and filtered them out of incoming data.

**Usages:**

* Refer to this Profile: [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md), [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md), [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md), [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md)...Show 31 more,[US Core CarePlan Profile](StructureDefinition-us-core-careplan.md),[US Core CareTeam Profile](StructureDefinition-us-core-careteam.md),[US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md),[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md),[US Core Coverage Profile](StructureDefinition-us-core-coverage.md),[US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md),[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md),[US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md),[US Core Encounter Profile](StructureDefinition-us-core-encounter.md),[US Core Goal Profile](StructureDefinition-us-core-goal.md),[US Core Immunization Profile](StructureDefinition-us-core-immunization.md),[US Core Implantable Device Profile](StructureDefinition-us-core-implantable-device.md),[US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md),[US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md),[US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md),[US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md),[US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md),[US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md),[US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md),[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md),[US Core Observation Sexual Orientation Profile](StructureDefinition-us-core-observation-sexual-orientation.md),[US Core Procedure Profile](StructureDefinition-us-core-procedure.md),[US Core Provenance Profile](StructureDefinition-us-core-provenance.md),[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md),[US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md),[US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md),[US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md),[US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md),[US Core Specimen Profile](StructureDefinition-us-core-specimen.md),[US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md)and[US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md)
* Examples for this Profile: [Patient/child-example](Patient-child-example.md), [Patient/deceased-example](Patient-deceased-example.md), [Patient/example](Patient-example.md) and [Patient/infant-example](Patient-infant-example.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-patient)

**Changes since version 7.0.0:**

* The resource metadata has changed (description)

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-patient.csv), [Excel](StructureDefinition-us-core-patient.xlsx), [Schematron](StructureDefinition-us-core-patient.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to patient data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/Patient.rs`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support both read Patient by`id`**AND**Patient search using the**[`_id`](SearchParameter-us-core-patient-id.md)**search parameter:`GET [base]/Patient/[id]`or`GET [base]/Patient?_id=[id]`Example:
1. GET [base]/Patient/1032702
1. GET [base]/Patient?_id=1032702
**Implementation Notes:**([how to search by the logical id](http://hl7.org/fhir/R4/references.html#logical)of the resource)
1. **SHALL**support searching a patient by an identifier such as a MPI using the**[`identifier`](SearchParameter-us-core-patient-identifier.md)**search parameter:`GET [base]/Patient?identifier={system|}[code]`Example:
1. GET [base]/Patient?identifier=http://hospital.smarthealthit.org|1032702
**Implementation Notes:**Fetches a bundle containing any Patient resources matching the identifier ([how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching for a patient by a Server defined search that matches any of the string fields in the HumanName, including family, given, prefix, suffix, and/or text using the**[`name`](SearchParameter-us-core-patient-name.md)**search parameter:`GET [base]/Patient?name=[string]`Example:
1. GET [base]/Patient?name=Shaw
**Implementation Notes:**Fetches a bundle of all Patient resources matching the name ([how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHALL**support searching using the combination of the**[`birthdate`](SearchParameter-us-core-patient-birthdate.md)**and**[`name`](SearchParameter-us-core-patient-name.md)**search parameters:`GET [base]/Patient?birthdate=[date]&name=[string]`Example:
1. GET [base]/Patient?name=Shaw&birthdate=2007-03-20
**Implementation Notes:**Fetches a bundle of all Patient resources matching the specified birthdate and name ([how to search by date](http://hl7.org/fhir/R4/search.html#date)and[how to search by string](http://hl7.org/fhir/R4/search.html#string))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`birthdate`](SearchParameter-us-core-patient-birthdate.md)**and**[`family`](SearchParameter-us-core-patient-family.md)**search parameters:`GET [base]/Patient?birthdate=[date]&family=[string]`Example:
1. GET [base]/Patient?family=Shaw&birthdate=2007-03-20
**Implementation Notes:**Fetches a bundle of all Patient resources matching the specified birthdate and family ([how to search by date](http://hl7.org/fhir/R4/search.html#date)and[how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHOULD**support searching using the combination of the**[`death-date`](SearchParameter-us-core-patient-death-date.md)**and**[`family`](SearchParameter-us-core-patient-family.md)**search parameters:`GET [base]/Patient?death-date=[date]&family=[string]`Example:
1. GET [base]/Patient?family=Shaw&death-date=2022-07-22
**Implementation Notes:**Fetches a bundle of all Patient resources matching the specified death-date and family ([how to search by date](http://hl7.org/fhir/R4/search.html#date)and[how to search by string](http://hl7.org/fhir/R4/search.html#string))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.50"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCorePatientProfile",
  "title" : "US Core Patient Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-04-22",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Patient Profile inherits from the FHIR [Patient](https://hl7.org/fhir/R4/patient.html) resource; refer to it for scope and usage definitions. This profile meets the requirements of the [U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi) *Patient Demographics/Information* Data Class. It sets minimum expectations for the Patient resource to record, search, and fetch basic demographics and other administrative information about an individual patient. It specifies which core elements, extensions, vocabularies, and value sets **SHALL** be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient"
          }
        ]
      },
      {
        "id" : "Patient.extension:race",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "race",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: US Core Race Extension. (multiple races are supported in the extension)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
            ]
          }
        ],
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.extension"
          }
        ]
      },
      {
        "id" : "Patient.extension:ethnicity",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "ethnicity",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: US Core ethnicity Extension (multiple ethnicities are supported in the extension)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
            ]
          }
        ],
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.extension"
          }
        ]
      },
      {
        "id" : "Patient.extension:tribalAffiliation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "tribalAffiliation",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Tribal Affiliation Extension",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Patient.extension:sex",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "sex",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Sex Extension",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-individual-sex"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Patient.extension:interpreterRequired",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "interpreterRequired",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Whether the patient needs an interpreter",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-interpreter-needed"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "min" : 1,
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.identifier"
          }
        ]
      },
      {
        "id" : "Patient.identifier.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.identifier.system"
          }
        ]
      },
      {
        "id" : "Patient.identifier.value",
        "path" : "Patient.identifier.value",
        "short" : "The value that is unique within the system.",
        "min" : 1,
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.identifier.value"
          }
        ]
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "us-core-6",
            "severity" : "error",
            "human" : "At least name.given and/or name.family are present or, if neither is available, the Data Absent Reason Extension is present.",
            "expression" : "(family.exists() or given.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "xpath" : "(/f:extension/@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason' and not(/f:family or /f:given)) or (not(/f:extension/@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason') and (/f:family or /f:given))"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.name"
          }
        ]
      },
      {
        "id" : "Patient.name.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.name.use",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: usual | official | temp | nickname | anonymous | old | maiden",
        "comment" : "The [United States Core Data for Interoperability (USCDI)](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi) Patient Demographics/Information Data Element, *Name to Use*, is represented by the code \"usual\", and, *Previous Name*, by the code \"old\"."
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family",
        "condition" : ["us-core-6"],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.name.family"
          }
        ]
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "condition" : ["us-core-6"],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.name.given"
          }
        ]
      },
      {
        "id" : "Patient.name.suffix",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.name.suffix",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Parts that come after the name",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.name.period",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.name.period",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Time period when name was/is in use",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.telecom",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.telecom",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: A contact detail for the individual",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.telecom.system",
        "path" : "Patient.telecom.system",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Telecommunications form for contact point.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-system"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.telecom.value",
        "path" : "Patient.telecom.value",
        "min" : 1,
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.telecom.use",
        "path" : "Patient.telecom.use",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/contact-point-use"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.birthDate"
          }
        ]
      },
      {
        "id" : "Patient.deceased[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.deceased[x]",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Indicates if the individual is deceased or not"
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.birthDate"
          }
        ]
      },
      {
        "id" : "Patient.address.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.address.use",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: home | work | temp | old | billing - purpose of this address"
      },
      {
        "id" : "Patient.address.line",
        "path" : "Patient.address.line",
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "49 MEADOW ST"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.address.city",
        "path" : "Patient.address.city",
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "EVERYTOWN"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.address.state",
        "path" : "Patient.address.state",
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "OK"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Two Letter USPS alphabetic codes.",
          "valueSet" : "http://terminology.hl7.org/ValueSet/USPS-State"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.address.postalCode",
        "path" : "Patient.address.postalCode",
        "short" : "US Zip Codes",
        "alias" : ["Zip Code"],
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "74047"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.address.period",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.address.period",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Time period when address was/is in use",
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "Patient.communication",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.communication",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: A language which may be used to communicate with the patient about his or her health",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.communication"
          }
        ]
      },
      {
        "id" : "Patient.communication.language",
        "path" : "Patient.communication.language",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.org/ValueSet/Languages"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Patient.communication.language"
          }
        ]
      }
    ]
  }
}

```
