# US Core Laboratory Result Observation Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Laboratory Result Observation Profile**

## Resource Profile: US Core Laboratory Result Observation Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreLaboratoryResultObservationProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.43 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Laboratory Result Observation Profile is based upon the US Core Observation Clinical Result Profile and, along with the US Core DiagnosticReport Profile for Laboratory Results Reporting, meets the U.S. Core Data for Interoperability (USCDI) Laboratory requirements. Laboratory results are grouped and summarized using the DiagnosticReport resource, which references Observation resources. Each Observation resource represents an individual laboratory test and result value, a “nested” panel (such as a microbial susceptibility panel) that references other observations, or rarely a laboratory test with component result values. The US Core Laboratory Result Observation Profile sets minimum expectations for the Observation resource to record, search, and fetch laboratory test results associated with a patient to promote interoperability and adoption through common implementation. It identifies which core elements, extensions, vocabularies, and value sets SHALL be present in the resource and constrains the way the elements are used when using this profile. It provides the floor for standards development for specific use cases. 

**Usages:**

* Refer to this Profile: [US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md) and [US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md)
* Examples for this Profile: [Observation/at-home-in-vitro-test](Observation-at-home-in-vitro-test.md), [Observation/cbc-erythrocytes](Observation-cbc-erythrocytes.md), [Observation/cbc-hematocrit](Observation-cbc-hematocrit.md), [Observation/cbc-hemoglobin](Observation-cbc-hemoglobin.md)...Show 14 more,[Observation/cbc-leukocytes](Observation-cbc-leukocytes.md),[Observation/cbc-mch](Observation-cbc-mch.md),[Observation/cbc-mchc](Observation-cbc-mchc.md),[Observation/cbc-mcv](Observation-cbc-mcv.md),[Observation/cbc-platelets](Observation-cbc-platelets.md),[Observation/serum-bun](Observation-serum-bun.md),[Observation/serum-calcium](Observation-serum-calcium.md),[Observation/serum-chloride](Observation-serum-chloride.md),[Observation/serum-co2](Observation-serum-co2.md),[Observation/serum-creatinine](Observation-serum-creatinine.md),[Observation/serum-glucose](Observation-serum-glucose.md),[Observation/serum-potassium](Observation-serum-potassium.md),[Observation/serum-sodium](Observation-serum-sodium.md)and[Observation/urobilinogen](Observation-urobilinogen.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-observation-lab)

**Changes since version 7.0.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-observation-lab.csv), [Excel](StructureDefinition-us-core-observation-lab.xlsx), [Schematron](StructureDefinition-us-core-observation-lab.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to laboratory data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/Observation.rs`
* [granular scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#finer-grained-resource-constraints-using-search-parameters): `<patient|user|system>/Observation.rs?category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**search parameters:`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory`Example:
1. GET [base]/Observation?patient=1134281&amp;category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and a category code =`laboratory`([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`code`](SearchParameter-us-core-observation-code.md)**search parameters:
* including optional support for **OR** search on `code` (e.g.`code={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=1134281&amp;code=http://loinc.org|2339-0
1. GET [base]/Observation?patient=1134281&amp;code=http://loinc.org|2339-0,http://loinc.org|25428-4,http://loinc.org|2514-8
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and observation code(s). SHOULD support search by multiple report codes. The Observation`code`parameter searches `Observation.code only. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**and**[`date`](SearchParameter-us-core-observation-date.md)**search parameters:
* including support for these `date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `date` (e.g.`date=[date]&date=[date]]&...`)
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Observation?patient=555580&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory&date=ge2018-03-14T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and date and a category code =`laboratory`([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**and**[`status`](SearchParameter-us-core-observation-status.md)**search parameters:
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=1134281&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory&status=final
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and category =`laboratory`and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**and**[`_lastUpdated`](SearchParameter-us-core-observation-lastupdated.md)**search parameters:
* including support for these `_lastUpdated` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `_lastUpdated` (e.g.`_lastUpdated=[date]&_lastUpdated=[date]]&...`)
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Observation?patient=555580&http://terminology.hl7.org/CodeSystem/observation-category|laboratory&_lastUpdated=ge2024-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and category and _lastUpdated. See the US Core General Guidance page for[Searching Using lastUpdated](general-guidance.md#searching-using-lastupdated). ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`code`](SearchParameter-us-core-observation-code.md)**and**[`date`](SearchParameter-us-core-observation-date.md)**search parameters:
* including optional support for **OR** search on `code` (e.g.`code={system|}[code],{system|}[code],...`)
* including support for these `date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `date` (e.g.`date=[date]&date=[date]]&...`)
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Observation?patient=555580&code=http://loinc.org|2339-0&date=ge2019-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and date and report code(s). SHOULD support search by multiple report codes. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-observation-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.43"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreLaboratoryResultObservationProfile",
  "title" : "US Core Laboratory Result Observation Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Laboratory Result Observation Profile is based upon the US Core Observation Clinical Result Profile and, along with the US Core DiagnosticReport Profile for Laboratory Results Reporting, meets the U.S. Core Data for Interoperability (USCDI) Laboratory requirements. Laboratory results are grouped and summarized using the DiagnosticReport resource, which references Observation resources. Each Observation resource represents an individual laboratory test and result value, a “nested” panel (such as a microbial susceptibility panel) that references other observations, or rarely a laboratory test with component result values. The US Core Laboratory Result Observation Profile sets minimum expectations for the Observation resource to record, search, and fetch laboratory test results associated with a patient to promote interoperability and adoption through common implementation. It identifies which core elements, extensions, vocabularies, and value sets SHALL be present in the resource and constrains the way the elements are used when using this profile. It provides the floor for standards development for specific use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.meta",
        "path" : "Observation.meta",
        "mustSupport" : true
      },
      {
        "id" : "Observation.meta.lastUpdated",
        "path" : "Observation.meta.lastUpdated",
        "short" : "When the resource last changed",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:us-core",
        "path" : "Observation.category",
        "sliceName" : "us-core",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "laboratory"
            }
          ]
        },
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Observation.category"
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Laboratory Test Name",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Laboratory LOINC Codes",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-laboratory-test-codes"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Observation.code"
          }
        ]
      },
      {
        "id" : "Observation.code.text",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.code.text",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: The name of the test that was performed."
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "Result Value",
        "definition" : "The Laboratory result value.  If a coded value,  the valueCodeableConcept.code **SHOULD** be selected from [SNOMED CT](http://hl7.org/fhir/ValueSet/uslab-obs-codedresults) if the concept exists. If a numeric value, valueQuantity.code **SHALL** be selected from [UCUM](http://unitsofmeasure.org).  A FHIR [UCUM Codes value set](http://hl7.org/fhir/STU3/valueset-ucum-units.html) that defines all UCUM codes is in the FHIR specification.",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "CodeableConcept"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "string"
          },
          {
            "code" : "boolean"
          },
          {
            "code" : "integer"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "Ratio"
          },
          {
            "code" : "SampledData"
          },
          {
            "code" : "time"
          },
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "condition" : ["us-core-4"],
        "constraint" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice",
                "valueBoolean" : true
              }
            ],
            "key" : "us-core-4",
            "severity" : "warning",
            "human" : "SHOULD use Snomed CT for coded Results",
            "expression" : "ofType(CodeableConcept).coding.system.empty() or (ofType(CodeableConcept).coding.system contains 'http://snomed.info/sct')",
            "xpath" : "not(exists(f:valueCodeableConcept/f:coding/f:system) ) or f:valueCodeableConcept/f:coding/f:system[@value='http://snomed.info/sct']"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Observation.value[x]"
          }
        ]
      },
      {
        "id" : "Observation.interpretation",
        "path" : "Observation.interpretation",
        "short" : "Result interpretation",
        "comment" : "Categorical assessment of a laboratory value, often in relation to a test's reference range. Examples include but are not limited to high, low, critical, and normal.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Observation Interpretation Codes",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-interpretation"
        }
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-specimen"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "short" : "Result reference range",
        "comment" : "Upper and lower limit of test values expected for a designated population of individuals. Reference range values may differ by patient characteristics, laboratory test manufacturer and laboratory test performer.",
        "condition" : ["us-core-22"],
        "constraint" : [
          {
            "key" : "us-core-22",
            "severity" : "error",
            "human" : "SHALL use UCUM for coded quantity units.",
            "expression" : "(low.system.empty() or low.system = 'http://unitsofmeasure.org') and (high.system.empty() or high.system = 'http://unitsofmeasure.org')"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
