# US Core MedicationRequest Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core MedicationRequest Profile**

## Resource Profile: US Core MedicationRequest Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreMedicationRequestProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.40 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core MedicationRequest Profile inherits from the FHIR[MedicationRequest](https://hl7.org/fhir/R4/medicationrequest.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the[U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi)**Medications**Data Class. This profile sets minimum expectations for the MedicationRequest resource to record, search, and fetch a patient's medication prescriptions or orders. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for the US Core-MedicationRequest profile. See the [Medication List](medication-list.md) section for guidance on accessing a patient's medications:

* Fetching all medications that have been prescribed to a patient
* Fetching all **active** medications that have been prescribed to a patient
* Fetching all medications that have been prescribed to a patient during a particular encounter
* [Record or update](us-core-roadmap.md#future-candidate-requirements-under-consideration) medications that have been prescribed for a patient

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each MedicationRequest Must Have:**

1. a status
1. an intent code
1. a medication*
1. a patient

**Each MedicationRequest Must Support:**

1. the category (e.g., Discharge Medication)
1. the`reported`flag or reference signaling that information is from a secondary source such as a patient
1. the encounters
1. a prescriber
1. a date for when written
1. free text dosage instructions (the**SIG**)
1. when medication should be administered
1. the route of administration
1. the dose and rate
1. the amount dispensed and number of refills

**Additional USCDI Requirements:**

These [Additional USCDI Requirements](must-support.md#additional-uscdi-requirements) elements are not Mandatory or Must Support but are required for ASTP Health IT certification testing and are included in the formal definition of the profile and the MedicationRequest examples.

1. the reason or indication for the prescription*
1. reported adherence to prescribed medication instructions*

* see guidance below

**Profile Specific Implementation Guidance:**

* See the [Medication List](medication-list.md) section for guidance on accessing a patient's medications, including over-the-counter (OTC) medications and other substances taken for medical and recreational use. 
* Servers **SHALL** return all active medications following the [Get All Active Medications](medication-list.md#get-all-active-medications) guidance. It is always best practice to confirm this list with the patient or caregiver.
* When recording "self-prescribed" medication, `requester` **SHOULD** be used to indicate the Patient or RelatedPerson as the prescriber.
 
* *This Profile can represent a medication using a code or reference a [Medication](http://hl7.org/fhir/R4/medication.html) resource. 
* The Server systems are not required to support both a code and a reference, but **SHALL** support **at least one** of these methods.
* The Client application **SHALL** support all methods.
* When using a code, RXNorm concepts are used. They are defined as an [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible) binding to `.medicationCodeableConcept`. USCDI recommends the [National Drug Codes (NDC)](https://www.fda.gov/drugs/drug-approvals-and-databases/national-drug-code-directory) as an **optional** terminology. They can be supplied as an additional coding element. 
* Systems that primarily rely on NDC codes instead of RxNorm to represent medications can use the National Library of Medicine's (NLM) [NDC to RxNorm mappings](https://www.nlm.nih.gov/research/umls/user_education/quick_tours/RxNorm/ndc_rxcui/NDC_RXCUI_DrugName.html) to aid in additional codings.
 
* When referencing a Medication resource in `.medicationReference`, the resource may be [contained](http://hl7.org/fhir/R4/references.html#contained) or an external resource. If an external reference to a Medication resource is used, the Server **SHALL** support the [`_include`](http://hl7.org/fhir/R4/search.html#include) parameter for searching this element.
 

* *The profile elements `MedicationRequest.requester and MedicationRequest.reportedReference` communicate the [individual level provenance](basic-provenance.md#individual-level-provenance) author data corresponding to the U.S. Core Data for Interoperability (USCDI) Provenance Author Data Elements.
* The MedicationRequest resource can represent that information is from a secondary source using either the flag `MedicationRequest.reportedBoolean` or a reference using `MedicationRequest.reportedReference`. 
* Although both are marked as Must Support, the Server system is not required to support both, but **SHALL** support at least one of these elements.
* The Client application **SHALL** support both elements.
 
* *The MedicationRequest resource can communicate the reason or indication for treatment using either a code in `MedicationRequest.reasonCode` or a reference using `MedicationRequest.reasonReference`. 
* Although both `MedicationRequest.reasonCode` and `MedicationRequest.reasonReference` are marked as Additional USCDI Requirements. The certifying Server system is not required to support both, but **SHALL** support at least one of these elements. The certifying Client application **SHALL** support both elements. 
* when using `MedicationRequest.reasonReference`: 
* Servers **SHALL** support **at least one** target resource in `MedicationRequest.reasonReference`. Clients SHALL support all target resources in `MedicationRequest.reasonReference`.
* The referenced resources **SHOULD** be a US Core Profile as documented in [Referencing US Core Profiles](general-guidance.md#referencing-us-core-profiles).
 
 
 
* Source EHR identifiers **SHOULD** be included to support deduplication across MedicationRequest resources. Exposing the EHR identifiers helps Client applications identify duplicates.
* * This profile uses the [US Core Medication Adherence Extension](StructureDefinition-us-core-medication-adherence.md) to report medication adherence. This extension communicates whether a medication has been consumed according to instructions.

**Usages:**

* Refer to this Profile: [US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md)
* Examples for this Profile: [MedicationRequest/medicationrequest-coded-oral-axid](MedicationRequest-medicationrequest-coded-oral-axid.md), [MedicationRequest/medicationrequest-contained-oral-axid](MedicationRequest-medicationrequest-contained-oral-axid.md), [MedicationRequest/medicationrequest-referenced-oral-axid](MedicationRequest-medicationrequest-referenced-oral-axid.md) and [MedicationRequest/self-tylenol](MedicationRequest-self-tylenol.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-medicationrequest)

**Changes since version 7.0.0:**

* The resource metadata has changed (description)

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-medicationrequest.csv), [Excel](StructureDefinition-us-core-medicationrequest.xlsx), [Schematron](StructureDefinition-us-core-medicationrequest.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to prescription data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/MedicationRequest.rs`

#### Mandatory Search Parameters:

1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-medicationrequest-patient.md)**and**[`intent`](SearchParameter-us-core-medicationrequest-intent.md)**search parameters:
* including optional support for these `_include` parameters: `MedicationRequest:medication`
* including support for **OR** search on `intent` (e.g.`intent={system|}[code],{system|}[code],...`)
`GET [base]/MedicationRequest?patient={Type/}[id]&intent=order,plan`Example:
1. GET [base]/MedicationRequest?patient=14676&intent=order,plan
1. GET [base]/MedicationRequest?patient=14676&intent=order,plan&_include=MedicationRequest:medication
**Implementation Notes:**Fetches a bundle of all MedicationRequest resources for the specified patient and intent code =`order,plan`([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-medicationrequest-patient.md)**and**[`intent`](SearchParameter-us-core-medicationrequest-intent.md)**and**[`status`](SearchParameter-us-core-medicationrequest-status.md)**search parameters:
* including optional support for these `_include` parameters: `MedicationRequest:medication`
* including support for **OR** search on `intent` (e.g.`intent={system|}[code],{system|}[code],...`)
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/MedicationRequest?patient={Type/}[id]&intent=order,plan&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/MedicationRequest?patient=1137192&intent=order,plan&status=active
1. GET [base]/MedicationRequest?patient=1137192&intent=order,plan&status=active&_include=MedicationRequest:medication
**Implementation Notes:**Fetches a bundle of all MedicationRequest resources for the specified patient and intent code =`order,plan`and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-medicationrequest-patient.md)**and**[`intent`](SearchParameter-us-core-medicationrequest-intent.md)**and**[`encounter`](SearchParameter-us-core-medicationrequest-encounter.md)**search parameters:
* including optional support for these `_include` parameters: `MedicationRequest:medication`
* including support for **OR** search on `intent` (e.g.`intent={system|}[code],{system|}[code],...`)
`GET [base]/MedicationRequest?patient={Type/}[id]&intent=order,plan&encounter={Type/}[id]`Example:
1. GET [base]/MedicationRequest?patient=1137192&intent=order,plan&status=active&encounter=Encounter/123
1. GET [base]/MedicationRequest?patient=1137192&intent=order,plan&status=active&&encounter=Encounter/123&_include=MedicationRequest:medication
**Implementation Notes:**Fetches a bundle of all MedicationRequest resources for the specified patient and intent code =`order,plan`and encounter ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-medicationrequest-patient.md)**and**[`intent`](SearchParameter-us-core-medicationrequest-intent.md)**and**[`authoredon`](SearchParameter-us-core-medicationrequest-authoredon.md)**search parameters:
* including optional support for these `_include` parameters: `MedicationRequest:medication`
* including support for **OR** search on `intent` (e.g.`intent={system|}[code],{system|}[code],...`)
* including support for these `authoredon` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `authoredon` (e.g.`authoredon=[date]&authoredon=[date]]&...`)
`GET [base]/MedicationRequest?patient={Type/}[id]&intent=order,plan&authoredon={gt|lt|ge|le}[date]{&authoredon={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/MedicationRequest?patient=1137192&intent=order,plan&authoredon=ge2019-01-01T00:00:00Z
1. GET [base]/MedicationRequest?patient=1137192&intent=order,plan&authoredon=ge2019-01-01T00:00:00Z&_include=MedicationRequest:medication
**Implementation Notes:**Fetches a bundle of all MedicationRequest resources for the specified patient and intent code =`order,plan`and authoredon date ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-medicationrequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.40"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreMedicationRequestProfile",
  "title" : "US Core MedicationRequest Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core MedicationRequest Profile inherits from the FHIR [MedicationRequest](https://hl7.org/fhir/R4/medicationrequest.html) resource; refer to it for scope and usage definitions. This profile meets the requirements of the [U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi)  *Medications* Data Class. This profile sets minimum expectations for the MedicationRequest resource to record, search, and fetch a patient's medication prescriptions or orders. It specifies which core elements, extensions, vocabularies, and value sets **SHALL** be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest",
        "constraint" : [
          {
            "key" : "us-core-21",
            "severity" : "error",
            "human" : "requester SHALL be present if intent is \"order\"",
            "expression" : "(intent='order' or intent='original-order' or intent='reflex-order'or intent='filler-order' or intent='instance-order') implies requester.exists()"
          }
        ],
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "MedicationOrder"
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension:medicationAdherence",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.extension",
        "sliceName" : "medicationAdherence",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: US Core Medication Adherence Extension",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication-adherence"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "A code specifying the state of the prescribing event. Describes the lifecycle of the prescription.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-status"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "MedicationOrder.status"
          }
        ]
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "condition" : ["us-core-21"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "The kind of medication order.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-intent"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "MedicationOrder.status"
          }
        ]
      },
      {
        "id" : "MedicationRequest.category",
        "path" : "MedicationRequest.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.category:us-core",
        "path" : "MedicationRequest.category",
        "sliceName" : "us-core",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "The type of medication order. Note that other codes are permitted, see [Required Bindings When Slicing by Value Sets](general-requirements.html#required-bindings-when-slicing-by-valuesets)",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-category"
        }
      },
      {
        "id" : "MedicationRequest.reported[x]",
        "path" : "MedicationRequest.reported[x]",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "boolean"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "MedicationOrder.status"
          }
        ]
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "MedicationOrder.medication[x]"
          }
        ]
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "MedicationOrder.patient"
          }
        ]
      },
      {
        "id" : "MedicationRequest.encounter",
        "path" : "MedicationRequest.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter"
            ]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA"
          }
        ]
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "MedicationOrder.dateWritten"
          }
        ]
      },
      {
        "id" : "MedicationRequest.requester",
        "path" : "MedicationRequest.requester",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "condition" : ["us-core-21"],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "MedicationOrder.prescriber"
          }
        ]
      },
      {
        "id" : "MedicationRequest.reasonCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.reasonCode",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Reason or indication for ordering or not ordering the medication",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code"
        }
      },
      {
        "id" : "MedicationRequest.reasonReference",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.reasonReference",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: US Core Condition or Observation that supports the prescription"
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.text",
        "path" : "MedicationRequest.dosageInstruction.text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing",
        "path" : "MedicationRequest.dosageInstruction.timing",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route",
        "path" : "MedicationRequest.dosageInstruction.route",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "SNOMED CT and NCI Thesaurus SPL route of administration codes",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.22"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "short" : "Amount of medication per dose",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          },
          {
            "code" : "Range"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/ucum-units"
            }
          ],
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-common"
        }
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "path" : "MedicationRequest.dispenseRequest",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "path" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "mustSupport" : true
      }
    ]
  }
}

```
