# US Core MedicationDispense Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core MedicationDispense Profile**

## Resource Profile: US Core MedicationDispense Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreMedicationDispenseProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.39 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core MedicationDispense Profile inherits from the FHIR[MedicationDispense](https://hl7.org/fhir/R4/medicationdispense.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the MedicationDispense resource to record, search, and fetch the state of a patients medication with regards to dispensing or other activity. (e.g., dispensed, partially dispensed, not dispensed) It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for the US Core-MedicationDispense profile:

* Fetching dispense statuses for medications that have been prescribed to a particular patient
* [Record or update](us-core-roadmap.md#future-candidate-requirements-under-consideration) dispense statuses for medications that have been prescribed for a particular patient

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each MedicationDispense Must Have:**

1. a status (e.g., dispensed, not dispensed)
1. a medication*
1. a patient

* see guidance below

**Each MedicationDispense Must Support:**

1. the encounter associated with the dispense
1. who dispensed the medication*
1. the authorizing prescription
1. type of dispense (e.g., partially dispensed)
1. the quantity dispensed
1. a date for when medication was dispensed to the patient
1. free text dosage instructions (the**SIG**)
1. when medication should be administered
1. the route of administration
1. the dose and rate

*see guidance below

**Profile Specific Implementation Guidance:**

* The MedicationDispense resource is used to represent the USCDI medication fill status.
* *This Profile can represent a medication using a code or reference a [Medication](http://hl7.org/fhir/R4/medication.html) resource. 
* The Server systems are not required to support both a code and a reference, but **SHALL** support **at least one** of these methods.
* The Client application **SHALL** support all methods.
* When using a code, RXNorm concepts are used. They are defined as an [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible) binding to `.medicationCodeableConcept`. USCDI recommends the [National Drug Codes (NDC)](https://www.fda.gov/drugs/drug-approvals-and-databases/national-drug-code-directory) as an **optional** terminology. They can be supplied as an additional coding element. 
* Systems that primarily rely on NDC codes instead of RxNorm to represent medications can use the National Library of Medicine's (NLM) [NDC to RxNorm mappings](https://www.nlm.nih.gov/research/umls/user_education/quick_tours/RxNorm/ndc_rxcui/NDC_RXCUI_DrugName.html) to aid in additional codings.
 
* When referencing a Medication resource in `.medicationReference`, the resource may be [contained](http://hl7.org/fhir/R4/references.html#contained) or an external resource. If an external reference to a Medication resource is used, the Server **SHALL** support the [`_include`](http://hl7.org/fhir/R4/search.html#include) parameter for searching this element.
 

* *The profile element `MedicationDispense.performer.actor` communicates the [individual level provenance](basic-provenance.md#individual-level-provenance) author data corresponding to the U.S. Core Data for Interoperability (USCDI) Provenance Author Data Elements.

**Usages:**

* Examples for this Profile: [MedicationDispense/medicationdispense-example](MedicationDispense-medicationdispense-example.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-medicationdispense)

**Changes since version 7.0.0:**

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-medicationdispense.csv), [Excel](StructureDefinition-us-core-medicationdispense.xlsx), [Schematron](StructureDefinition-us-core-medicationdispense.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to dispensed medication data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/MedicationDispense.rs`

#### Mandatory Search Parameters:

1. **SHALL**support searching using the**[`patient`](SearchParameter-us-core-medicationdispense-patient.md)**search parameter:
* including optional support for these `_include` parameters: `MedicationDispense:medication`
`GET [base]/MedicationDispense?patient={Type/}[id]`Example:
1. GET [base]/MedicationDispense?patient=14676
1. GET [base]/MedicationStatement?patient=14676&_include=MedicationDispense:medication
**Implementation Notes:**Fetches a bundle of all MedicationDispense resources for the specified patient. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-medicationdispense-patient.md)**and**[`status`](SearchParameter-us-core-medicationdispense-status.md)**search parameters:
* including optional support for these `_include` parameters: `MedicationDispense:medication`
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/MedicationDispense?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/MedicationDispense?patient=1137192&status=completed
1. GET [base]/MedicationDispense?patient=1137192&status=completed&_include=MedicationDispense:medication
**Implementation Notes:**Fetches a bundle of all MedicationDispense resources for the specified patient that have a given dispense status (e.g., dispensed, not dispensed)). ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-medicationdispense-patient.md)**and**[`status`](SearchParameter-us-core-medicationdispense-status.md)**and**[`type`](SearchParameter-us-core-medicationdispense-type.md)**search parameters:
* including optional support for these `_include` parameters: `MedicationDispense:medication`
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
* including support for **OR** search on `type` (e.g.`type={system|}[code],{system|}[code],...`)
`GET [base]/MedicationDispense?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}&type={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/MedicationDispense?patient=1137192&status=&type=
1. GET [base]/MedicationDispense?patient=1137192&status=&type=FFP&_include=MedicationDispense:medication
**Implementation Notes:**Fetches a bundle of all MedicationDispense resources for the specified patient that have a given dispense status (e.g., dispensed, not dispensed) and type of dispense (e.g., partially dispensed). ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-medicationdispense",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.39"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreMedicationDispenseProfile",
  "title" : "US Core MedicationDispense Profile",
  "status" : "active",
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core MedicationDispense Profile inherits from the FHIR [MedicationDispense](https://hl7.org/fhir/R4/medicationdispense.html) resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the MedicationDispense resource to record, search, and fetch the state of a patients medication with regards to dispensing or other activity. (e.g., dispensed, partially dispensed, not dispensed)  It specifies which core elements, extensions, vocabularies, and value sets **SHALL** be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense",
        "constraint" : [
          {
            "key" : "us-core-20",
            "severity" : "error",
            "human" : "whenHandedOver SHALL be present if the status is \"completed\"",
            "expression" : "status='completed' implies whenHandedOver.exists()"
          }
        ]
      },
      {
        "id" : "MedicationDispense.status",
        "path" : "MedicationDispense.status",
        "condition" : ["us-core-20"],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.medication[x]",
        "path" : "MedicationDispense.medication[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4"
        }
      },
      {
        "id" : "MedicationDispense.subject",
        "path" : "MedicationDispense.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.context",
        "path" : "MedicationDispense.context",
        "short" : "Encounter associated with MedicationDispense",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter",
              "http://hl7.org/fhir/StructureDefinition/EpisodeOfCare"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.performer",
        "path" : "MedicationDispense.performer",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.performer.actor",
        "path" : "MedicationDispense.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              null
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.authorizingPrescription",
        "path" : "MedicationDispense.authorizingPrescription",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.type",
        "path" : "MedicationDispense.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActPharmacySupplyType"
        }
      },
      {
        "id" : "MedicationDispense.quantity",
        "path" : "MedicationDispense.quantity",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/ucum-units"
            }
          ],
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-common"
        }
      },
      {
        "id" : "MedicationDispense.whenHandedOver",
        "path" : "MedicationDispense.whenHandedOver",
        "short" : "When product was given out or mailed",
        "definition" : "When the product was given out. For mailed prescriptions, when the label was printed",
        "condition" : ["us-core-20"],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction",
        "path" : "MedicationDispense.dosageInstruction",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.text",
        "path" : "MedicationDispense.dosageInstruction.text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing",
        "path" : "MedicationDispense.dosageInstruction.timing",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route",
        "path" : "MedicationDispense.dosageInstruction.route",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "SNOMED CT and NCI Thesaurus SPL route of administration codes",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.22"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]",
        "short" : "Amount of medication per dose",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          },
          {
            "code" : "Range"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/ucum-units"
            }
          ],
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-common"
        }
      }
    ]
  }
}

```
