# US Core Medication Adherence Extension - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Medication Adherence Extension**

## Extension: US Core Medication Adherence Extension 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication-adherence | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USCoreMedicationAdherenceExtension |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.37 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

The Medication Adherence Extension is used to report whether a medication has been consumed according to instructions as reported by a patient or on behalf of the patient.

**Context of Use**

**Profile Specific Implementation Guidance:**

This Complex Extension is made up of three sub-extensions:

1. A required Medication Adherence Code, which is bound to the[Medication Adherence ValueSet](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.8/expansionStructureDefinition-us-core-medication-adherence.html)- a "starter" set of medication compliance SNOMED CT and NullValue codes. Its binding is[extensible](http://hl7.org/fhir/R4/terminologies.html#extensible), and other concepts from SNOMED CT or another code system, including local codes, can be used. The table below illustrates basic scenarios of how an implementer can use them:

| | |
| :--- | :--- |
| The medication is being taken as directed. | 1156699004|Complies with drug therapy (finding) |
| The medication is being taken, but not as directed. For example, the patient occasionally forgets or takes two pills instead of three. | 702565001|Non-compliance of drug therapy (finding) |
| The medication is not being taken. For example, the patient did not pick up a prescription. | 715036001|Does not take medication (finding) |


1. A required date asserting when the information was provided
1. A Must Support information source code with an[example binding](http://hl7.org/fhir/R4/terminologies.html#example)to the**Medication Adherence ValueSet**- a "starter" set of informant role codes.

**Usage info**

**Usages:**

* Use this Extension: [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md)
* Examples for this Extension: [MedicationRequest/medicationrequest-coded-oral-axid](MedicationRequest-medicationrequest-coded-oral-axid.md) and [MedicationRequest/self-tylenol](MedicationRequest-self-tylenol.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-medication-adherence)

**Changes since version 7.0.0:**

* No changes

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-medication-adherence.csv), [Excel](StructureDefinition-us-core-medication-adherence.xlsx), [Schematron](StructureDefinition-us-core-medication-adherence.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-medication-adherence",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication-adherence",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.37"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreMedicationAdherenceExtension",
  "title" : "US Core Medication Adherence Extension",
  "status" : "active",
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The Medication Adherence Extension is used to report whether a medication has been consumed according to instructions as reported by a patient or on behalf of the patient.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Reported adherence to prescribed medication instructions.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Extension.extension:medicationAdherence",
        "path" : "Extension.extension",
        "sliceName" : "medicationAdherence",
        "code" : [
          {
            "system" : "http://loinc.org",
            "code" : "71799-1",
            "display" : "Adherence to prescribed medication instructions [Reported]"
          }
        ],
        "short" : "Medication adherence code",
        "definition" : "Code stating whether the patient is consuming medications according to instructions.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:medicationAdherence.url",
        "path" : "Extension.extension.url",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "medicationAdherence"
      },
      {
        "id" : "Extension.extension:medicationAdherence.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "This set of values contains terms representing whether a medication has been consumed according to instructions.",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.8"
        }
      },
      {
        "id" : "Extension.extension:dateAsserted",
        "path" : "Extension.extension",
        "sliceName" : "dateAsserted",
        "short" : "When the medication adherence was asserted",
        "definition" : "When the medication adherence was asserted by the information source",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:dateAsserted.url",
        "path" : "Extension.extension.url",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "dateAsserted"
      },
      {
        "id" : "Extension.extension:dateAsserted.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Extension.extension:informationSource",
        "path" : "Extension.extension",
        "sliceName" : "informationSource",
        "short" : "Who provided the information about the medication adherence",
        "definition" : "The person or organization that provided the information about the medication adherence",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:informationSource.url",
        "path" : "Extension.extension.url",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "informationSource"
      },
      {
        "id" : "Extension.extension:informationSource.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "The person or organization that provided the information about the medication adherence",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.11"
        }
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication-adherence"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 0,
        "max" : "0"
      }
    ]
  }
}

```
