# US Core Location Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Location Profile**

## Resource Profile: US Core Location Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-location | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreLocationProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.36 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Location Profile inherits from the FHIR[Location](https://hl7.org/fhir/R4/location.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Location resource for recording, searching, and fetching a "physical place of available services or resources." It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Location Must Have:**

1. A name

**Each Location Must Support:**

1. Location or facility identifier
1. A status (whether in use)
1. The type of location or facility*
1. Contact details of the location
1. A Location address*
1. The managing organization

*see guidance below

**Additional Profile specific implementation guidance:**

* [US Core Encounter Profile](StructureDefinition-us-core-encounter.md) and the [US Core Immunization Profile](StructureDefinition-us-core-immunization.md) link directly to US Core Location via `Encounter.location` and `Immunization.location`.
* If the event facility/location differs from the `Encounter.location`, systems **SHOULD** reference it directly:
* *There are three bindings for `Location.type` to meet multiple industry needs for identifying service locations: 
* The extensibly bound Service Delivery Location Role Type value set is inherited from the base resource. Its binding strength has been revised to [preferred](http://hl7.org/fhir/R4/terminologies.html#preferred) in FHIR R5/R6, and for US Core, implementers may treat it as preferred.
* This guide uses a grouped value set that includes concepts from Healthcare Service Location Codes (HSLOC) and SNOMED-CT Healthcare Facility Type codes to meet the USCDI applicable vocabulary standard. Implementers can use a code from either vocabulary.
* The NUBC Place of Service (POS) codes meet the Health Insurance Portability and Accountability Act of 1996 (HIPAA) requirements for billing and Payers.
 
* * Systems **SHOULD** follow the [Project US@ Technical Specification for Patient Addresses Final Version 1.0](https://asapnet.org/wp-content/uploads/2022/03/Project_US_FINAL_Technical_Specification_Version_1.0.pdf) as the standard style guide for `Location.address.line` and  `Location.address.city`.

**Usages:**

* Refer to this Profile: [US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md), [US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md), [US Core Encounter Profile](StructureDefinition-us-core-encounter.md), [US Core Immunization Profile](StructureDefinition-us-core-immunization.md)...Show 6 more,[US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md),[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md),[US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md),[US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md),[US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)and[US Core Specimen Profile](StructureDefinition-us-core-specimen.md)
* Examples for this Profile: [Health Level Seven International - Amherst](Location-hl7east.md) and [Holy Family Hospital](Location-hospital.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-location)

**Changes since version 7.0.0:**

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-location.csv), [Excel](StructureDefinition-us-core-location.xlsx), [Schematron](StructureDefinition-us-core-location.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to data **MAY** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/Location.rs`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support searching by location name using the**[`name`](SearchParameter-us-core-location-name.md)**search parameter:`GET [base]/Location?name=[string]`Example:
1. GET [base]/Location?name=Health
**Implementation Notes:**Fetches a bundle of all Location resources that match the name ([how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHALL**support searching location based on text address using the**[`address`](SearchParameter-us-core-location-address.md)**search parameter:`GET [base]/Location?address=[string]`Example:
1. GET [base]/Location?address=Arbor
**Implementation Notes:**Fetches a bundle of all Location resources that match the address string ([how to search by string](http://hl7.org/fhir/R4/search.html#string))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the**[`address-city`](SearchParameter-us-core-location-address-city.md)**search parameter:`GET [base]/Location?address-city=[string]`Example:
1. GET [base]/Location?address-city=Ann Arbor
**Implementation Notes:**Fetches a bundle of all Location resources for the city ([how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHOULD**support searching using the**[`address-state`](SearchParameter-us-core-location-address-state.md)**search parameter:`GET [base]/Location?address-state=[string]`Example:
1. GET [base]/Location?address-state=MI
**Implementation Notes:**Fetches a bundle of all Location resources for the state ([how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHOULD**support searching using the**[`address-postalcode`](SearchParameter-us-core-location-address-postalcode.md)**search parameter:`GET [base]/Location?address-postalcode=[string]`Example:
1. GET [base]/Location?address-postalcode=48104
**Implementation Notes:**Fetches a bundle of all Location resources for the ZIP code ([how to search by string](http://hl7.org/fhir/R4/search.html#string))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-location",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.36"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreLocationProfile",
  "title" : "US Core Location Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Location Profile inherits from the FHIR [Location](https://hl7.org/fhir/R4/location.html) resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Location resource for  recording, searching, and fetching a \"physical place of available services or resources.\"  It specifies which core elements, extensions, vocabularies, and value sets **SHALL** be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "servd",
            "map" : "Organization"
          }
        ]
      },
      {
        "id" : "Location.identifier",
        "path" : "Location.identifier",
        "short" : "Unique business identifier for facility or location.",
        "mustSupport" : true
      },
      {
        "id" : "Location.status",
        "path" : "Location.status",
        "mustSupport" : true
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "short" : "Name by which a facility or location is known.",
        "min" : 1,
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "servd",
            "map" : "./PrimaryAddress and ./OtherAddresses"
          }
        ]
      },
      {
        "id" : "Location.type",
        "path" : "Location.type",
        "short" : "Category of service or resource available in a location.",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "uscore-uscdi"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.31"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Meets the USCDI applicable vocabulary standard Healthcare Service Location Codes(HSLOC) and SNOMED-CT."
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "USCDI applicable vocabulary standard Healthcare Service Location Codes (HSLOC) or SNOMED-CT Healthcare Facility Type codes"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "uscore-pos"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://terminology.hl7.org/ValueSet/CMSPlaceOfServiceCodes"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "NUBC Place of Service (POS) codes meet the Health Insurance Portability and Accountability Act of 1996 (HIPAA) (POS Memorandum 2003)."
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "NUBC Place of Service (POS) codes"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType"
        }
      },
      {
        "id" : "Location.type.coding",
        "path" : "Location.type.coding",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.type.coding.system",
        "path" : "Location.type.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.type.coding.code",
        "path" : "Location.type.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.telecom",
        "path" : "Location.telecom",
        "mustSupport" : true
      },
      {
        "id" : "Location.address",
        "path" : "Location.address",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "servd",
            "map" : "n/a"
          }
        ]
      },
      {
        "id" : "Location.address.line",
        "path" : "Location.address.line",
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "49 MEADOW ST"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Location.address.city",
        "path" : "Location.address.city",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "EVERYTOWN"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Location.address.state",
        "path" : "Location.address.state",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "OK"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Two letter USPS alphabetic codes.",
          "valueSet" : "http://terminology.hl7.org/ValueSet/USPS-State"
        },
        "mapping" : [
          {
            "identity" : "servd",
            "map" : "./Sites"
          }
        ]
      },
      {
        "id" : "Location.address.postalCode",
        "path" : "Location.address.postalCode",
        "short" : "US Zip Codes",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "example" : [
          {
            "label" : "US Core",
            "valueString" : "74047"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
