# US Core Jurisdiction Extension - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Jurisdiction Extension**

## Extension: US Core Jurisdiction Extension 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-jurisdiction | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreJurisdictionExtension |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.35 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

An extension to communicate the US state or local jurisdiction for individual and entity identifiers. For example, a practitioner's state or local jurisdiction for a license.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [Practitioner/practitioner-1](Practitioner-practitioner-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-jurisdiction)

**Changes since version 7.0.0:**

* The data elements list has changed

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-jurisdiction.csv), [Excel](StructureDefinition-us-core-jurisdiction.xlsx), [Schematron](StructureDefinition-us-core-jurisdiction.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-jurisdiction",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-jurisdiction",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.35"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreJurisdictionExtension",
  "title" : "US Core Jurisdiction Extension",
  "status" : "active",
  "date" : "2022-11-16",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "An extension to communicate the US state or local jurisdiction for individual and entity identifiers. For example, a practitioner's state or local jurisdiction for a license.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient.identifier"
    },
    {
      "type" : "element",
      "expression" : "Patient.contact.organization.identifier"
    },
    {
      "type" : "element",
      "expression" : "Patient.generalPractitioner.identifier"
    },
    {
      "type" : "element",
      "expression" : "Patient.managingOrganization.identifier"
    },
    {
      "type" : "element",
      "expression" : "Patient.link.other.identifier"
    },
    {
      "type" : "element",
      "expression" : "Practitioner.identifier"
    },
    {
      "type" : "element",
      "expression" : "Practitioner.qualification.identifier"
    },
    {
      "type" : "element",
      "expression" : "Practitioner.qualification.issuer.identifier"
    },
    {
      "type" : "element",
      "expression" : "PractitionerRole.identifier"
    },
    {
      "type" : "element",
      "expression" : "PractitionerRole.practitioner.identifier"
    },
    {
      "type" : "element",
      "expression" : "PractitionerRole.organization.identifier"
    },
    {
      "type" : "element",
      "expression" : "PractitionerRole.location.identifier"
    },
    {
      "type" : "element",
      "expression" : "PractitionerRole.healthcareService.identifier"
    },
    {
      "type" : "element",
      "expression" : "PractitionerRole.endpoint.identifier"
    },
    {
      "type" : "element",
      "expression" : "RelatedPerson.identifier"
    },
    {
      "type" : "element",
      "expression" : "RelatedPerson.patient.identifier"
    },
    {
      "type" : "element",
      "expression" : "Person.identifier"
    },
    {
      "type" : "element",
      "expression" : "Person.managingOrganization.identifier"
    },
    {
      "type" : "element",
      "expression" : "Person.link.target.identifier"
    },
    {
      "type" : "element",
      "expression" : "Group.identifier"
    },
    {
      "type" : "element",
      "expression" : "Group.managingEntity.identifier"
    },
    {
      "type" : "element",
      "expression" : "Group.characteristic.value[x]"
    },
    {
      "type" : "element",
      "expression" : "Group.member.entity.identifier"
    },
    {
      "type" : "element",
      "expression" : "Organization.identifier"
    },
    {
      "type" : "element",
      "expression" : "Organization.partOf.identifier"
    },
    {
      "type" : "element",
      "expression" : "Organization.endpoint.identifier"
    },
    {
      "type" : "element",
      "expression" : "OrganizationAffiliation.identifier"
    },
    {
      "type" : "element",
      "expression" : "OrganizationAffiliation.organization.identifier"
    },
    {
      "type" : "element",
      "expression" : "OrganizationAffiliation.participatingOrganization.identifier"
    },
    {
      "type" : "element",
      "expression" : "OrganizationAffiliation.network.identifier"
    },
    {
      "type" : "element",
      "expression" : "OrganizationAffiliation.location.identifier"
    },
    {
      "type" : "element",
      "expression" : "OrganizationAffiliation.healthcareService.identifier"
    },
    {
      "type" : "element",
      "expression" : "OrganizationAffiliation.endpoint.identifier"
    },
    {
      "type" : "element",
      "expression" : "HealthcareService.identifier"
    },
    {
      "type" : "element",
      "expression" : "HealthcareService.providedBy.identifier"
    },
    {
      "type" : "element",
      "expression" : "HealthcareService.location.identifier"
    },
    {
      "type" : "element",
      "expression" : "HealthcareService.coverageArea.identifier"
    },
    {
      "type" : "element",
      "expression" : "HealthcareService.endpoint.identifier"
    },
    {
      "type" : "element",
      "expression" : "Endpoint.identifier"
    },
    {
      "type" : "element",
      "expression" : "Endpoint.managingOrganization.identifier"
    },
    {
      "type" : "element",
      "expression" : "Location.identifier"
    },
    {
      "type" : "element",
      "expression" : "Location.managingOrganization.identifier"
    },
    {
      "type" : "element",
      "expression" : "Location.partOf.identifier"
    },
    {
      "type" : "element",
      "expression" : "Location.endpoint.identifier"
    },
    {
      "type" : "element",
      "expression" : "Substance.identifier"
    },
    {
      "type" : "element",
      "expression" : "Substance.instance.identifier"
    },
    {
      "type" : "element",
      "expression" : "Substance.ingredient.substance[x]"
    },
    {
      "type" : "element",
      "expression" : "BiologicallyDerivedProduct.identifier"
    },
    {
      "type" : "element",
      "expression" : "BiologicallyDerivedProduct.request.identifier"
    },
    {
      "type" : "element",
      "expression" : "BiologicallyDerivedProduct.parent.identifier"
    },
    {
      "type" : "element",
      "expression" : "BiologicallyDerivedProduct.collection.collector.identifier"
    },
    {
      "type" : "element",
      "expression" : "BiologicallyDerivedProduct.collection.source.identifier"
    },
    {
      "type" : "element",
      "expression" : "BiologicallyDerivedProduct.processing.additive.identifier"
    },
    {
      "type" : "element",
      "expression" : "Device.identifier"
    },
    {
      "type" : "element",
      "expression" : "Device.definition.identifier"
    },
    {
      "type" : "element",
      "expression" : "Device.version.component"
    },
    {
      "type" : "element",
      "expression" : "Device.patient.identifier"
    },
    {
      "type" : "element",
      "expression" : "Device.owner.identifier"
    },
    {
      "type" : "element",
      "expression" : "Device.location.identifier"
    },
    {
      "type" : "element",
      "expression" : "Device.parent.identifier"
    },
    {
      "type" : "element",
      "expression" : "Specimen.identifier"
    },
    {
      "type" : "element",
      "expression" : "Specimen.accessionIdentifier"
    },
    {
      "type" : "element",
      "expression" : "Specimen.subject.identifier"
    },
    {
      "type" : "element",
      "expression" : "Specimen.parent.identifier"
    },
    {
      "type" : "element",
      "expression" : "Specimen.request.identifier"
    },
    {
      "type" : "element",
      "expression" : "Specimen.collection.collector.identifier"
    },
    {
      "type" : "element",
      "expression" : "Specimen.processing.additive.identifier"
    },
    {
      "type" : "element",
      "expression" : "Specimen.container.identifier"
    },
    {
      "type" : "element",
      "expression" : "Specimen.container.additive[x]"
    },
    {
      "type" : "element",
      "expression" : "BodyStructure.identifier"
    },
    {
      "type" : "element",
      "expression" : "BodyStructure.patient.identifier"
    },
    {
      "type" : "element",
      "expression" : "Coverage.identifier"
    },
    {
      "type" : "element",
      "expression" : "Coverage.policyHolder.identifier"
    },
    {
      "type" : "element",
      "expression" : "Coverage.subscriber.identifier"
    },
    {
      "type" : "element",
      "expression" : "Coverage.beneficiary.identifier"
    },
    {
      "type" : "element",
      "expression" : "Coverage.payor.identifier"
    },
    {
      "type" : "element",
      "expression" : "Coverage.contract.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.patient.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.enterer.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.insurer.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.provider.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.related.claim.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.related.reference"
    },
    {
      "type" : "element",
      "expression" : "Claim.prescription.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.originalPrescription.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.payee.party.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.referral.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.facility.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.careTeam.provider.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.supportingInfo.value[x]"
    },
    {
      "type" : "element",
      "expression" : "Claim.diagnosis.diagnosis[x]"
    },
    {
      "type" : "element",
      "expression" : "Claim.procedure.procedure[x]"
    },
    {
      "type" : "element",
      "expression" : "Claim.procedure.udi.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.insurance.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.insurance.coverage.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.insurance.claimResponse.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.accident.location[x]"
    },
    {
      "type" : "element",
      "expression" : "Claim.item.location[x]"
    },
    {
      "type" : "element",
      "expression" : "Claim.item.udi.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.item.encounter.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.item.detail.udi.identifier"
    },
    {
      "type" : "element",
      "expression" : "Claim.item.detail.subDetail.udi.identifier"
    },
    {
      "type" : "element",
      "expression" : "Invoice.identifier"
    },
    {
      "type" : "element",
      "expression" : "Invoice.subject.identifier"
    },
    {
      "type" : "element",
      "expression" : "Invoice.recipient.identifier"
    },
    {
      "type" : "element",
      "expression" : "Invoice.participant.actor.identifier"
    },
    {
      "type" : "element",
      "expression" : "Invoice.issuer.identifier"
    },
    {
      "type" : "element",
      "expression" : "Invoice.account.identifier"
    },
    {
      "type" : "element",
      "expression" : "Invoice.lineItem.chargeItem[x]"
    },
    {
      "type" : "element",
      "expression" : "Contract.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.instantiatesCanonical.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.subject.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.authority.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.domain.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.site.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.author.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.topic[x]"
    },
    {
      "type" : "element",
      "expression" : "Contract.contentDefinition.publisher.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.topic[x]"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.offer.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.offer.party.reference.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.offer.topic.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.offer.answer.value[x]"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.asset.typeReference.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.asset.context.reference.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.asset.valuedItem.entity[x]"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.asset.valuedItem.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.asset.valuedItem.responsible.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.asset.valuedItem.recipient.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.action.subject.reference.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.action.context.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.action.requester.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.action.performer.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.term.action.reasonReference.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.supportingInfo.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.relevantHistory.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.signer.party.identifier"
    },
    {
      "type" : "element",
      "expression" : "Contract.friendly.content[x]"
    },
    {
      "type" : "element",
      "expression" : "Contract.legal.content[x]"
    },
    {
      "type" : "element",
      "expression" : "Contract.rule.content[x]"
    },
    {
      "type" : "element",
      "expression" : "Contract.legallyBinding[x]"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.patient.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.enterer.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.insurer.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.provider.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.related.claim.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.related.reference"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.prescription.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.originalPrescription.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.payee.party.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.referral.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.facility.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.claim.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.claimResponse.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.careTeam.provider.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.supportingInfo.value[x]"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.diagnosis.diagnosis[x]"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.procedure.procedure[x]"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.procedure.udi.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.insurance.coverage.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.accident.location[x]"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.item.location[x]"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.item.udi.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.item.encounter.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.item.detail.udi.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.item.detail.subDetail.udi.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.addItem.provider.identifier"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.addItem.location[x]"
    },
    {
      "type" : "element",
      "expression" : "ExplanationOfBenefit.payment.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.ownedBy.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.administeredBy.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.coverageArea.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.endpoint.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.network.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.coverage.network.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.plan.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.plan.coverageArea.identifier"
    },
    {
      "type" : "element",
      "expression" : "InsurancePlan.plan.network.identifier"
    },
    {
      "type" : "element",
      "expression" : "DeviceMetric.identifier"
    },
    {
      "type" : "element",
      "expression" : "DeviceMetric.source.identifier"
    },
    {
      "type" : "element",
      "expression" : "DeviceMetric.parent.identifier"
    },
    {
      "type" : "element",
      "expression" : "Consent.identifier"
    },
    {
      "type" : "element",
      "expression" : "Consent.patient.identifier"
    },
    {
      "type" : "element",
      "expression" : "Consent.performer.identifier"
    },
    {
      "type" : "element",
      "expression" : "Consent.organization.identifier"
    },
    {
      "type" : "element",
      "expression" : "Consent.source[x]"
    },
    {
      "type" : "element",
      "expression" : "Consent.verification.verifiedWith.identifier"
    },
    {
      "type" : "element",
      "expression" : "Consent.provision.actor.reference.identifier"
    },
    {
      "type" : "element",
      "expression" : "Consent.provision.data.reference.identifier"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "US State or local jurisdiction",
        "definition" : "An extension to communicate the US state or local jurisdiction for an element.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-jurisdiction"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "Target US State or local jurisdiction.",
          "valueSet" : "http://terminology.hl7.org/ValueSet/USPS-State"
        }
      }
    ]
  }
}

```
