# US Core DocumentReference Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core DocumentReference Profile**

## Resource Profile: US Core DocumentReference Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreDocumentReferenceProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.23 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core DocumentReference Profile inherits from the FHIR[DocumentReference](https://hl7.org/fhir/R4/documentreference.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for searching and fetching patient documents including Clinical Notes using the DocumentReference resource. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. Before reviewing this profile, implementers are encouraged to read the Clinical Notes Guidance to understand the overlap of the US Core DiagnosticReport Profile for Report and Note exchange and the US Core DocumentReference Profile. 

**Example Usage Scenarios:**

The following are example usage scenarios for the US Core DocumentReference profile. See the [Clinical Notes](clinical-notes.md) section for additional details on using this profile for Clinical Notes:

* Query for all documents belonging to a Patient
* Query for a specific Clinical Note type (e.g., Discharge Summary or Continuity of Care Document (CCD))
* Query for all Clinical Notes belonging to a Patient
* Write a new Note to a Patient's Chart

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each DocumentReference Must Have:**

1. a status
1. a code describing the type of document
1. a document category
1. a patient
1. document referenced (content)
1. the MIME type (i.e., contentType) of the document

**Each DocumentReference Must Support:**

1. a business identifier for the DocumentReference (possibly generated by the transcription system or EHR)
1. date and time the reference was created
1. an author
1. a code identifying the specific details about the format of the document — over and above the content's MIME type
1. the patient encounter that is being referenced
1. clinically relevant date

**Additional USCDI Requirements:**

This [Additional USCDI Requirements](must-support.md#additional-uscdi-requirements) element is not Mandatory or Must Support but is required for ASTP Health IT certification testing and is included in the formal definition of the profile and the DocumentReference examples.

1. a document category limited to[The US Core DocumentReferences Type Value Set](ValueSet-us-core-documentreference-category.md), which currently consists of a single value, "clinical note."

**Profile Specific Implementation Guidance:**

* See [Clinical Notes](clinical-notes.md)
* The `DocumentReference.type` binding Must Support, at a minimum, the [10 Common Clinical Notes](ValueSet-us-core-clinical-note-type.md) and may extend to the whole [US Core DocumentReference Type Value Set](ValueSet-us-core-documentreference-type.md)
* In addition to the [US Core DocumentReference Category](ValueSet-us-core-documentreference-category.md) value set, other category schemes such as the LOINC-based [Document Class Value Set](http://hl7.org/fhir/R4/valueset-document-classcodes.html) and [IHE XDSclassCode](https://wiki.ihe.net/index.php/XDS_classCode_Metadata_Coding_System) may be used to facilitate the sharing of health documents.
* For a C-CDA Clinical Summary of Care (CCD): 
* The document type code is the LOINC code [34133-9](http://s.details.loinc.org/LOINC/34133-9.html?sections=Comprehensive) **Summary of episode note**.
 
* For C-CDA Clinical Documents 
* The format code in `DocumentReference.content.format` is "urn:hl7-org:sdwg:ccda-structuredBody:2.1".
* For other CDA documents, Servers SHOULD select the appropriate format code from the [HL7 ValueSet of Format Codes for use with Document Sharing](https://terminology.hl7.org/6.2.0/ValueSet-v3-HL7FormatCodes.html).
 
* The DocumentReference resources can represent the referenced content using either an address where the document can be retrieved using `DocumentReference.content.attachment.url` or the content as inline base64 encoded data using `DocumentReference.content.attachment.data`. 
* Although both are marked as Must Support, the Server system is not required to support an address and inline base64 encoded data, but **SHALL** support at least one of these elements.
* The Client application **SHALL** support both elements.
* The `DocumentReference.content.attachment.url` may refer to a FHIR Binary Resource (i.e., [base]/Binary/[id]), FHIR Document Bundle (i.e., [base]/Bundle/[id], or another endpoint). 
* If the referenced a document or file is hosted on a server outside the FHIR server, it should be securely accessible using the same authorization credentials that were used to access the FHIR server. This reduces complexity for the client and improves the user experience.
 
* If there are multiple `DocumentReference.content` element repetitions, these **SHALL** all represent the same document in different formats or attachment metadata. The content element **SHALL NOT** contain different versions of the same content. For version handling, use multiple DocumentReferences with `DocumentReference.relatesTo`.
 
* Every DocumentReference must have a responsible Organization. The organization responsible for the DocumentReference **SHALL** be present either in `DocumentReference.custodian` or accessible in the Provenance resource targeting the DocumentReference using `Provenance.agent.who` or `Provenance.agent.onBehalfOf`. 
* Some systems may also expose the same organization in referenced Encounter in `Encounter.serviceProvider`.
 

**Usages:**

* Refer to this Profile: [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md) and [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)
* Examples for this Profile: [DocumentReference/discharge-summary](DocumentReference-discharge-summary.md) and [DocumentReference/episode-summary](DocumentReference-episode-summary.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-documentreference)

**Changes since version 7.0.0:**

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-documentreference.csv), [Excel](StructureDefinition-us-core-documentreference.xlsx), [Schematron](StructureDefinition-us-core-documentreference.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to clniical note data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/DocumentReference.rs`

Servers providing access to clniical note data **SHOULD** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [granular scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#finer-grained-resource-constraints-using-search-parameters): `<patient|user|system>/DocumentReference.rs?category=http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category|clinical-note`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support both read DocumentReference by`id`**AND**DocumentReference search using the**[`_id`](SearchParameter-us-core-documentreference-id.md)**search parameter:`GET [base]/DocumentReference/[id]`or`GET [base]/DocumentReference?_id=[id]`Example:
1. GET [base]/DocumentReference/2169591
1. GET [base]/DocumentReference?_id=2169591
**Implementation Notes:**Fetches a single DocumentReference. The document itself is represented as a base64 encoded binary data element or retrieved using the link provided by the resource. If the document is a relative link to a[Binary](http://hl7.org/fhir/R4/binary.html)resource like a resource reference, it can be subsequently retrieved using:`GET [base]/Binary/[id]`. ([how to search by the logical id](http://hl7.org/fhir/R4/references.html#logical)of the resource)
1. **SHALL**support searching for all documentreferences for a patient using the**[`patient`](SearchParameter-us-core-documentreference-patient.md)**search parameter:`GET [base]/DocumentReference?patient={Type/}[id]`Example:
1. GET [base]/DocumentReference?patient=1137192
**Implementation Notes:**Fetches a bundle of all DocumentReference resources for the specified patient. See the implementation notes above for how to access the actual document. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-documentreference-patient.md)**and**[`category`](SearchParameter-us-core-documentreference-category.md)**search parameters:`GET [base]/DocumentReference?patient={Type/}[id]&category={system|}[code]`Example:
1. GET [base]/DocumentReference?patient=1235541&category=http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category|clinical-note
**Implementation Notes:**Fetches a bundle of all DocumentReference resources for the specified patient and category = "clinical-note". See the implementation notes above for how to access the actual document. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-documentreference-patient.md)**and**[`category`](SearchParameter-us-core-documentreference-category.md)**and**[`date`](SearchParameter-us-core-documentreference-date.md)**search parameters:
* including support for these `date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `date` (e.g.`date=[date]&date=[date]]&...`)
`GET [base]/DocumentReference?patient={Type/}[id]&category={system|}[code]&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/DocumentReference?patient=1235541&category=http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category|clinical-note&date=ge2020-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all DocumentReference resources for the specified patient and category = "clinical-note" and date. See the implementation notes above for how to access the actual document. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-documentreference-patient.md)**and**[`type`](SearchParameter-us-core-documentreference-type.md)**search parameters:`GET [base]/DocumentReference?patient={Type/}[id]&type={system|}[code]`Example:
1. GET [base]/DocumentReference?patient=1316024&type=http://loinc.org|18842-5
**Implementation Notes:**Fetches a bundle of all DocumentReference resources for the specified patient and type. See the implementation notes above for how to access the actual document. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-documentreference-patient.md)**and**[`status`](SearchParameter-us-core-documentreference-status.md)**search parameters:
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/DocumentReference?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/DiagnosticReport?patient=1137192&status=completed
**Implementation Notes:**Fetches a bundle of all DocumentReference resources for the specified patient and status. See the implementation notes above for how to access the actual document. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-documentreference-patient.md)**and**[`type`](SearchParameter-us-core-documentreference-type.md)**and**[`period`](SearchParameter-us-core-documentreference-period.md)**search parameters:
* including support for these `period` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `period` (e.g.`period=[date]&period=[date]]&...`)
`GET [base]/DocumentReference?patient={Type/}[id]&type={system|}[code]&period={gt|lt|ge|le}[date]{&period={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/DocumentReference?patient=2169591&type=http://loinc.org|18842-5&period=ge2020-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all DocumentReference resources for the specified patient and type and period. See the implementation notes above for how to access the actual document. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))

#### Mandatory Write Capability:

1. **SHALL**support writing a new note to a Patient's Chart:`POST [base]/DocumentReference`

 Click Here To See Example 

An example to demonstrate writing a note to the Server.

**Clinical Note**

```

{
  "resourceType" : "DocumentReference",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|8.0.1"]
  },
  "status" : "current",
  "type" : {
    "coding" : [{
      "system" : "http://loinc.org",
      "code" : "18842-5",
      "display" : "Discharge Summary"
    }],
    "text" : "Discharge Summary"
  },
  "category" : [{
    "coding" : [{
      "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
      "code" : "clinical-note",
      "display" : "Clinical Note"
    }],
    "text" : "Clinical No"
  }],
  "subject" : {
    "reference" : "Patient/example"
  },
  "content" : [{
    "attachment" : {
      "contentType" : "text/plain",
      "data" : "Tm8gYWN0aXZpdHkgcmVzdHJpY3Rpb24sIHJlZ3VsYXIgZGlldCwgZm9sbG93IHVwIGluIHR3byB0byB0aHJlZSB3ZWVrcyB3aXRoIHByaW1hcnkgY2FyZSBwcm92aWRlci4="
    }
  }],
  "context" : {
    "encounter" : [{
      "reference" : "Encounter/example-1"
    }]
  }
}


```

**Note Content**

The content is Base64 encoded and states: "No activity restriction, regular diet, follow up in two to three weeks with primary care provider."

#### Mandatory Operation:

1. **SHALL**support fetching documents using the $docref operation.This[$docref operation](OperationDefinition-docref.md)is used to request a Server**generate**a document based on the specified parameters. This operation is invoked on a FHIR Server's DocumentReference endpoint (e.g.,`[base]/DocumentReference/$docref`) and operates across all DocumentReference instances returning a Bundle of DocumentReference resources. See the[$docref operation](OperationDefinition-docref.md)definition for detailed documentation.
* The operation can be invoked using the GET Syntax if the complex type parameter is omitted:


  `GET [base]/DocumentReference/$docref?{parameters}`
* Otherwise the POST transaction with used as follows:


  `POST [base]/DocumentReference/$docref`


  The body of the POST contains the [Parameters](http://hl7.org/fhir/R4/parameters.html) resource with the [$docref operation](OperationDefinition-docref.md) input parameters.

**Example 1: Request the latest CCD**

 Click Here To See Example 

**Request the latest CCD for a patient using`GET`syntax**

`GET [base]/DocumentReference/$docref?patient=123`

**Request the latest CCD for a patient using`POST`syntax**

`POST [base]/DocumentReference/$docref}`

**POST request body:**

```
    {
      "resourceType": "Parameters",
      "id": "get-ccd123",
      "parameter": [
        {
          "name": "patient",
          "valueId" : "123"
        }
      ]
    }

```

**Response**

```
HTTP/1.1 200 OK
[other headers]

```

**Response body**

```

{
  "resourceType" : "Bundle",
  "id" : "docref-example-1",
  "type" : "searchset",
  "total" : 1,
  "link" : [{
    "relation" : "self",
    "url" : "http://example.org/fhir/DocumentReference/$docref?patient=123"
  }],
  "entry" : [{
    "fullUrl" : "http://example.org/fhir/DocumentReference/ccd123",
    "resource" : {
      "resourceType" : "DocumentReference",
      "id" : "ccd123",
      "meta" : {
        "profile" : ["http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"]
      },
      "identifier" : [{
        "system" : "urn:ietf:rfc:3986",
        "value" : "urn:oid:2.16.840.1.113883.19.5.99999.1"
      }],
      "status" : "current",
      "type" : {
        "coding" : [{
          "system" : "http://loinc.org",
          "code" : "34133-9",
          "display" : "Summary of episode note"
        }],
        "text" : "CCD Document"
      },
      "category" : [{
        "coding" : [{
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
          "code" : "clinical-note",
          "display" : "Clinical Note"
        }],
        "text" : "Clinical Note"
      }],
      "subject" : {
        "reference" : "Patient/example",
        "display" : "Amy Shaw"
      },
      "date" : "2016-03-09T15:29:46Z",
      "author" : [{
        "reference" : "Practitioner/practitioner-1",
        "display" : "Ronald Bone, MD"
      }],
      "description" : "Pulmonology clinic acute visit",
      "content" : [{
        "attachment" : {
          "contentType" : "text/plain",
          "url" : "http://example.org/fhir/Binary/1-note",
          "title" : "URI where the data can be found: http://example.org/fhir/Binary/1-note"
        },
        "format" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes",
          "code" : "urn:hl7-org:sdwg:ccda-structuredBody:2.1",
          "display" : "ccda-structuredBody:2.1"
        }
      }],
      "context" : {
        "period" : {
          "start" : "2004-12-23T08:00:00+11:00",
          "end" : "2004-12-23T08:01:00+11:00"
        }
      }
    },
    "search" : {
      "mode" : "match"
    }
  }]
}


```

**Example 2: Request Procedure Notes and Discharge Summaries for 2019**

 Click Here To See Example 

**Request Procedure Notes and Discharge Summaries for 2019 using`POST`syntax**

`POST [base]/DocumentReference/$docref}`

**POST request body:**

```
{
    "resourceType": "Parameters",
    "id": "get-docs",
    "parameter": [
        {
            "name": "patient",
            "valueId": "123"
        },
        {
            "name": "start",
            "valueDateTime": "2019-01-01"
        },
        {
            "name": "end",
            "valueDateTime": "2019-12-31"
        },
        {
            "name": "type",
            "valueCoding": {
                "system": "http://terminology.hl7.org/CodeSystem/c80-doc-typecodes",
                "code": "18842-5",
                "display": "Discharge summary"
            }
        },
        {
            "name": "type",
            "valueCoding": {
                "system": "http://terminology.hl7.org/CodeSystem/c80-doc-typecodes",
                "code": "28570-0",
                "display": "Procedures Note"
            }
        },
        {
            "name": "on-demand",
            "valueBoolean": true
        }
    ]
}

```

**Response**

```
HTTP/1.1 200 OK
[other headers]

```

**Response body**

```

{
  "resourceType" : "Bundle",
  "id" : "docref-example-2",
  "type" : "searchset",
  "total" : 3,
  "link" : [{
    "relation" : "self",
    "url" : "http://example.org/fhir/DocumentReference/$docref?patient=123&start=2019-01-01&end=2019-01-01&type=http://terminology.hl7.org/CodeSystem/c80-doc-typecodes|18842-5,http://terminology.hl7.org/CodeSystem/c80-doc-typecodes|28570-0&ondemand=true"
  }],
  "entry" : [{
    "fullUrl" : "http://example.org/fhir/DocumentReference/procedure-note123",
    "resource" : {
      "resourceType" : "DocumentReference",
      "id" : "procedure-note123",
      "meta" : {
        "profile" : ["http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"]
      },
      "identifier" : [{
        "system" : "urn:ietf:rfc:3986",
        "value" : "urn:oid:2.16.840.1.113883.19.5.99999.1"
      }],
      "status" : "current",
      "type" : {
        "coding" : [{
          "system" : "http://loinc.org",
          "code" : "28570-0",
          "display" : "Procedure Note"
        }],
        "text" : "Procedure Note"
      },
      "category" : [{
        "coding" : [{
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
          "code" : "clinical-note",
          "display" : "Clinical Note"
        }],
        "text" : "Clinical Note"
      }],
      "subject" : {
        "reference" : "Patient/example",
        "display" : "Amy Shaw"
      },
      "date" : "2022-11-18T20:45:05Z",
      "author" : [{
        "reference" : "Practitioner/practitioner-1",
        "display" : "Ronald Bone, MD"
      }],
      "description" : "Ureteroscopy",
      "content" : [{
        "attachment" : {
          "contentType" : "application/pdf",
          "url" : "http://example.org/fhir/Binary/procedure-note123.pdf"
        }
      }],
      "context" : {
        "period" : {
          "start" : "2019-03-01",
          "end" : "2019-03-02"
        }
      }
    },
    "search" : {
      "mode" : "match"
    }
  },
  {
    "fullUrl" : "http://example.org/fhir/DocumentReference/procedure-note456",
    "resource" : {
      "resourceType" : "DocumentReference",
      "id" : "procedure-note456",
      "meta" : {
        "profile" : ["http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"]
      },
      "status" : "current",
      "type" : {
        "coding" : [{
          "system" : "http://loinc.org",
          "code" : "28570-0",
          "display" : "Procedure Note"
        }],
        "text" : "Procedure Note"
      },
      "category" : [{
        "coding" : [{
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
          "code" : "clinical-note",
          "display" : "Clinical Note"
        }],
        "text" : "Clinical Note"
      }],
      "subject" : {
        "reference" : "Patient/example",
        "display" : "Amy Shaw"
      },
      "date" : "2022-11-18T20:45:05Z",
      "author" : [{
        "reference" : "Practitioner/practitioner-1",
        "display" : "Ronald Bone, MD"
      }],
      "description" : "Ureteroscopy",
      "content" : [{
        "attachment" : {
          "contentType" : "application/pdf",
          "url" : "http://example.org/fhir/Binary/procedure-note456.pdf"
        }
      }],
      "context" : {
        "period" : {
          "start" : "2019-06-01",
          "end" : "2019-06-01"
        }
      }
    },
    "search" : {
      "mode" : "match"
    }
  },
  {
    "fullUrl" : "http://example.org/fhir/DocumentReference/discharge",
    "resource" : {
      "resourceType" : "DocumentReference",
      "id" : "discharge",
      "meta" : {
        "profile" : ["http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"]
      },
      "status" : "current",
      "type" : {
        "coding" : [{
          "system" : "http://loinc.org",
          "code" : "18842-5",
          "display" : "Discharge Summary"
        }],
        "text" : "Discharge Summary"
      },
      "category" : [{
        "coding" : [{
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
          "code" : "clinical-note",
          "display" : "Clinical Note"
        }],
        "text" : "Clinical Note"
      }],
      "subject" : {
        "reference" : "Patient/example",
        "display" : "Amy Shaw"
      },
      "date" : "2022-11-18T20:45:05Z",
      "author" : [{
        "reference" : "Practitioner/practitioner-1",
        "display" : "Ronald Bone, MD"
      }],
      "description" : "Ureteroscopy",
      "content" : [{
        "attachment" : {
          "contentType" : "application/pdf",
          "url" : "http://example.org/fhir/Binary/discharge-summary789.pdf"
        }
      }],
      "context" : {
        "period" : {
          "start" : "2019-03-01",
          "end" : "2019-03-03"
        }
      }
    },
    "search" : {
      "mode" : "match"
    }
  }]
}


```



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-documentreference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.23"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreDocumentReferenceProfile",
  "title" : "US Core DocumentReference Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core DocumentReference Profile inherits from the FHIR [DocumentReference](https://hl7.org/fhir/R4/documentreference.html) resource; refer to it for scope and usage definitions. This profile sets minimum expectations for searching and fetching patient documents including Clinical Notes using the DocumentReference resource.  It specifies which core elements, extensions, vocabularies, and value sets **SHALL** be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. Before reviewing this profile, implementers are encouraged to read the Clinical Notes Guidance to understand the overlap of the US Core DiagnosticReport Profile for Report and Note exchange and the US Core DocumentReference Profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference",
        "mustSupport" : false
      },
      {
        "id" : "DocumentReference.identifier",
        "path" : "DocumentReference.identifier",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.status",
        "path" : "DocumentReference.status",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/document-reference-status"
        }
      },
      {
        "id" : "DocumentReference.type",
        "path" : "DocumentReference.type",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet",
              "valueCanonical" : "http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-note-type"
            }
          ],
          "strength" : "required",
          "description" : "All LOINC  values whose SCALE is \"Doc\" in the LOINC database and the HL7 v3 Code System NullFlavor concept 'unknown'",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-type"
        }
      },
      {
        "id" : "DocumentReference.category",
        "path" : "DocumentReference.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.category:uscore",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "DocumentReference.category",
        "sliceName" : "uscore",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Categorization of document",
        "binding" : {
          "strength" : "required",
          "description" : "The US Core DocumentReferences Type Value Set is a \"starter set\" of categories supported for fetching and storing clinical notes. Note that other codes are permitted, see [Required Bindings When Slicing by Value Sets](general-requirements.html#required-bindings-when-slicing-by-valuesets)",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-category"
        }
      },
      {
        "id" : "DocumentReference.subject",
        "path" : "DocumentReference.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.date",
        "path" : "DocumentReference.date",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.author",
        "path" : "DocumentReference.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content",
        "path" : "DocumentReference.content",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment",
        "path" : "DocumentReference.content.attachment",
        "definition" : "The document and format referenced.",
        "comment" : "If there are multiple `DocumentReference.content` element repetitions, these **SHALL** all represent the same document in different format or attachment metadata. The content element **SHALL NOT** contain different versions of the same content. For version handling use multiple DocumentReferences with `DocumentReference.relatesTo`.",
        "constraint" : [
          {
            "key" : "us-core-6",
            "severity" : "error",
            "human" : "DocumentReference.content.attachment.url or DocumentReference.content.attachment.data or both SHALL be present.",
            "expression" : "url.exists() or data.exists()",
            "xpath" : "f:url or f:content"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.contentType",
        "path" : "DocumentReference.content.attachment.contentType",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.data",
        "path" : "DocumentReference.content.attachment.data",
        "min" : 0,
        "condition" : ["us-core-6"],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.url",
        "path" : "DocumentReference.content.attachment.url",
        "min" : 0,
        "condition" : ["us-core-6"],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.format",
        "path" : "DocumentReference.content.format",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-HL7FormatCodes|2.1.0"
        }
      },
      {
        "id" : "DocumentReference.context",
        "path" : "DocumentReference.context",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.encounter",
        "path" : "DocumentReference.context.encounter",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.period",
        "path" : "DocumentReference.context.period",
        "mustSupport" : true
      }
    ]
  }
}

```
