# US Core Condition Problems and Health Concerns Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Condition Problems and Health Concerns Profile**

## Resource Profile: US Core Condition Problems and Health Concerns Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreConditionProblemsHealthConcernsProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.18 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Condition Problems and Health Concerns Profile inherits from the FHIR[Condition](https://hl7.org/fhir/R4/condition.html)resource; refer to it for scope and usage definitions. US Core version 5.0.0 split the US Core Condition Profile into this profile and the US Core Condition Encounter Diagnosis Profile. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Problems**,**Health Concerns**, and**SDOH Problems/Health Concerns**Data Elements. It sets minimum expectations for the Condition resource to record, search, and fetch information about a condition, diagnosis, or another event, situation, issue, or clinical concept documented and categorized as a problem or health concern, including information about a Social Determinants of Health related condition. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for a Patient's current or historical problems and health concerns
* [Record or update](us-core-roadmap.md#future-candidate-requirements-under-consideration) a Patient's problems and health concerns

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Condition Must Have:**

1. a category code of "problem-list-item" or "health-concern"
1. a code that identifies the condition*
1. a patient

**Each Condition Must Support:**

1. a timestamp when the resource last changed*
1. a clinical status of the condition (e.g., active or resolved)
1. a verification status
1. a date of diagnosis*
1. abatement date (in other words, date of resolution or remission)
1. a date when recorded*

**Additional USCDI Requirements:**

These [Additional USCDI Requirements](must-support.md#additional-uscdi-requirements) elements are not Mandatory or Must Support but are required for ASTP Health IT certification testing and are included in the formal definition of the profile and the Condition examples.

1. additional health status/assessment categories*
1. a recorder*

*see guidance below

**Profile Specific Implementation Guidance:**

* For Encounter Diagnosis, use the [US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md).
* *The `Condition.code` has an **additional binding** of "[current](https://hl7.org/fhir/R5/terminologies.html#binding)" and a base "preferred" binding. 
* For the conformance rules on the current binding for coded data, review [this section](general-requirements.md#current-binding-for-coded-elements) in the General Requirements page.
* USCDI's applicable vocabulary standards for Problems/Health Concerns are SNOMED CT and ICD-10-CM. 
* The [US Core Condition Codes](ValueSet-us-core-condition-code.md) only supports ICD-9-CM for historical purposes. When using ICD codes, only **non-header** ICD-10-CM codes **SHOULD** be used.
 
 
* See the [Screening and Assessments](screening-and-assessments.md) guidance page for more information when exchanging Social Determinants of Health (SDOH) Problems/Health Concerns.
* *The category of "problem-list-item" or "health-concern" is required, and, at a minimum, Certifying Systems **SHALL** support, a category of "sdoh", **SHOULD** support the other [US Core Simple Observation Category](ValueSet-us-core-simple-observation-category.md) codes, and **MAY** support other categories. 
* If the category is "problem-list-item", `Condition.clinicalStatus` **SHOULD** be present.
 
* *There is no single element in Condition that represents the date of diagnosis. It may be the [assertedDate Extension](http://hl7.org/fhir/R4/extension-condition-asserteddate.html), `Condition.onsetDateTime`, or `Condition.recordedDate`. 
* Although all three are marked as Must Support, the Server is not required to support all.
* A Server **SHALL** support `Condition.recordedDate`. 
* A Server **SHALL** support at least one of [assertedDate Extension](http://hl7.org/fhir/R4/extension-condition-asserteddate.html) and `Condition.onsetDateTime`. A Server may support both, which means they support all 3 locations.
* The Client application **SHALL** support all three elements
 
 
* * See the US Core General Guidance page for [Searching Using lastUpdated](general-guidance.md#searching-using-lastupdated). Updates to `.meta.lastUpdated` **SHOULD** reflect: 
* New problems and health concerns
* Changes in the clinical status or verifications status of problems or health concerns
 

* *The profile elements `Condition.asserter and Condition.recorder` communicate the [individual level provenance](basic-provenance.md#individual-level-provenance) author data corresponding to the U.S. Core Data for Interoperability (USCDI) Provenance Author Data Elements.

**Usages:**

* Refer to this Profile: [US Core Encounter Profile](StructureDefinition-us-core-encounter.md)
* Examples for this Profile: [Condition/condition-SDOH-example](Condition-condition-SDOH-example.md), [Condition/condition-duodenal-ulcer](Condition-condition-duodenal-ulcer.md) and [Condition/health-concern-example](Condition-health-concern-example.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-condition-problems-health-concerns)

**Changes since version 7.0.0:**

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-condition-problems-health-concerns.csv), [Excel](StructureDefinition-us-core-condition-problems-health-concerns.xlsx), [Schematron](StructureDefinition-us-core-condition-problems-health-concerns.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to problems and health concern data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/Condition.rs`
* [granular scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#finer-grained-resource-constraints-using-search-parameters): `<patient|user|system>/Condition.rs?category=http://terminology.hl7.org/CodeSystem/condition-category|problem-list-item`
* [granular scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#finer-grained-resource-constraints-using-search-parameters): `<patient|user|system>/Condition.rs?category=http://hl7.org/fhir/us/core/CodeSystem/condition-category|health-concern`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support searching for all conditions including problems, health concerns, and encounter diagnosis for a patient using the**[`patient`](SearchParameter-us-core-condition-patient.md)**search parameter:`GET [base]/Condition?patient={Type/}[id]`Example:
1. GET [base]/Condition?patient=1137192
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`category`](SearchParameter-us-core-condition-category.md)**search parameters:`GET [base]/Condition?patient={Type/}[id]&category={system|}[code]`Example:
1. GET [base]/Condition?patient=1032702&category=problem-list-item
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient and category = "problem-list-item". ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`clinical-status`](SearchParameter-us-core-condition-clinical-status.md)**search parameters:`GET [base]/Condition?patient={Type/}[id]&clinical-status=http://terminology.hl7.org/CodeSystem/condition-clinical|active,http://terminology.hl7.org/CodeSystem/condition-clinical|recurrance,http://terminology.hl7.org/CodeSystem/condition-clinical|remission`Example:
1. GET [base]/Condition?patient=1032702&clinical-status=http://terminology.hl7.org/CodeSystem/condition-clinical|active,http://terminology.hl7.org/CodeSystem/condition-clinical|recurrance,http://terminology.hl7.org/CodeSystem/condition-clinical|remission
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient and all "active" statuses (active,relapse,remission). This will**exclude**Conditions with no`clinicalStatus`specified. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`category`](SearchParameter-us-core-condition-category.md)**and**[`clinical-status`](SearchParameter-us-core-condition-clinical-status.md)**search parameters:`GET [base]/Condition?patient={Type/}[id]&category={system|}[code]&clinical-status=http://terminology.hl7.org/CodeSystem/condition-clinical|active,http://terminology.hl7.org/CodeSystem/condition-clinical|recurrance,http://terminology.hl7.org/CodeSystem/condition-clinical|remission`Example:
1. GET [base]/Condition?patient=1032702&category=problem-list-item&clinical-status=http://terminology.hl7.org/CodeSystem/condition-clinical|active,http://terminology.hl7.org/CodeSystem/condition-clinical|recurrance,http://terminology.hl7.org/CodeSystem/condition-clinical|remission
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient and category = "problem-list-item" for all "active" statuses (active,relapse,remission). This will**exclude**Conditions with no`clinicalStatus`specified. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`category`](SearchParameter-us-core-condition-category.md)**and**[`encounter`](SearchParameter-us-core-condition-encounter.md)**search parameters:`GET [base]/Condition?patient={Type/}[id]&category={system|}[code]&encounter={Type/}[id]`Example:
1. GET [base]/Condition?patient=1032702&category=problem-list-item&encounter=Encounter/1036
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient, encounter, and category = "problem-list-item". ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`code`](SearchParameter-us-core-condition-code.md)**search parameters:`GET [base]/Condition?patient={Type/}[id]&code={system|}[code]`Example:
1. GET [base]/Condition?patient=1032702&code=http://snomed.info/sct|51868009
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient and code. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`onset-date`](SearchParameter-us-core-condition-onset-date.md)**search parameters:
* including support for these `onset-date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `onset-date` (e.g.`onset-date=[date]&onset-date=[date]]&...`)
`GET [base]/Condition?patient={Type/}[id]&onset-date={gt|lt|ge|le}[date]{&onset-date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Condition?patient=555580&onset-date=ge2018-01-14
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient and date. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`asserted-date`](SearchParameter-us-core-condition-asserted-date.md)**search parameters:
* including support for these `asserted-date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `asserted-date` (e.g.`asserted-date=[date]&asserted-date=[date]]&...`)
`GET [base]/Condition?patient={Type/}[id]&asserted-date={gt|lt|ge|le}[date]{&asserted-date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Condition?patient=555580&asserted-date=ge2018-01-14
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient and date. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`recorded-date`](SearchParameter-us-core-condition-recorded-date.md)**search parameters:
* including support for these `recorded-date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `recorded-date` (e.g.`recorded-date=[date]&recorded-date=[date]]&...`)
`GET [base]/Condition?patient={Type/}[id]&recorded-date={gt|lt|ge|le}[date]{&recorded-date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Condition?patient=555580&recorded-date=ge2018-01-14
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient and date. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`abatement-date`](SearchParameter-us-core-condition-abatement-date.md)**search parameters:
* including support for these `abatement-date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `abatement-date` (e.g.`abatement-date=[date]&abatement-date=[date]]&...`)
`GET [base]/Condition?patient={Type/}[id]&abatement-date={gt|lt|ge|le}[date]{&abatement-date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Condition?patient=555580&abatement-date=ge2018-01-14
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient and date. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-condition-patient.md)**and**[`_lastUpdated`](SearchParameter-us-core-condition-lastupdated.md)**search parameters:
* including support for these `_lastUpdated` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `_lastUpdated` (e.g.`_lastUpdated=[date]&_lastUpdated=[date]]&...`)
`GET [base]/Condition?patient={Type/}[id]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Condition?patient=1032702&_lastUpdated=ge2024-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Condition resources for the specified patient and _lastUpdated. See the US Core General Guidance page for[Searching Using lastUpdated](general-guidance.md#searching-using-lastupdated). ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-condition-problems-health-concerns",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.18"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreConditionProblemsHealthConcernsProfile",
  "title" : "US Core Condition Problems and Health Concerns Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Condition Problems and Health Concerns Profile inherits from the FHIR [Condition](https://hl7.org/fhir/R4/condition.html) resource; refer to it for scope and usage definitions. US Core version 5.0.0 split the US Core Condition Profile into this profile and the US Core Condition Encounter Diagnosis Profile. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)  *Problems*, *Health Concerns*, and *SDOH Problems/Health Concerns* Data Elements. It sets minimum expectations for the Condition resource to record, search, and fetch information about a condition, diagnosis, or another event, situation, issue, or clinical concept documented and categorized as a problem or health concern, including information about a Social Determinants of Health related condition. It specifies which core elements, extensions,  vocabularies, and value sets **SHALL** be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Condition"
          }
        ]
      },
      {
        "id" : "Condition.meta",
        "path" : "Condition.meta",
        "mustSupport" : true
      },
      {
        "id" : "Condition.meta.lastUpdated",
        "path" : "Condition.meta.lastUpdated",
        "short" : "When the resource last changed",
        "mustSupport" : true
      },
      {
        "id" : "Condition.extension:assertedDate",
        "path" : "Condition.extension",
        "sliceName" : "assertedDate",
        "short" : "Date the condition was first asserted",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/condition-assertedDate"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-clinical"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Condition.clinicalStatus"
          }
        ]
      },
      {
        "id" : "Condition.verificationStatus",
        "path" : "Condition.verificationStatus",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-ver-status"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Condition.verificationStatus"
          }
        ]
      },
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "category codes",
        "min" : 1,
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Condition.category"
          }
        ]
      },
      {
        "id" : "Condition.category:us-core",
        "path" : "Condition.category",
        "sliceName" : "us-core",
        "short" : "problem-list-item | health-concern",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Note that other codes are permitted, see [Required Bindings When Slicing by Value Sets](general-requirements.html#required-bindings-when-slicing-by-valuesets)",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-problem-or-health-concern"
        }
      },
      {
        "id" : "Condition.category:screening-assessment",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.category",
        "sliceName" : "screening-assessment",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: USCDI Health Status/Assessments Data Class",
        "definition" : "Categories that a provider may use in their workflow to classify that this Condition is related to a USCDI Health Status/Assessments Data Class.",
        "requirements" : "Used for filtering condition",
        "mustSupport" : false,
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "us-core-screening-assessment-observation-category"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "minimum"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/core/ValueSet/us-core-screening-assessment-observation-category"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "codes that any conformant certifying system SHALL support to help identify the type of USCDI Health Status Assessment data class' data elements being reported."
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "USCDI Health Status/Assessments Data Elements"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "required",
          "description" : "Note that other codes are permitted, see [Required Bindings When Slicing by Value Sets](general-requirements.html#required-bindings-when-slicing-by-valuesets)",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-simple-observation-category"
        }
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "us-core-condition-code-current"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "current"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code-current"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "US Core uses the current additional binding for encoding newly recorded, non-legacy problem list items, health concerns and diagnosis"
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "Required for new records"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "Valueset to describe the actual problem experienced by the patient",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Condition.code"
          }
        ]
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Condition.patient"
          }
        ]
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Age"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.abatement[x]",
        "path" : "Condition.abatement[x]",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Age"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.recordedDate",
        "path" : "Condition.recordedDate",
        "mustSupport" : true
      },
      {
        "id" : "Condition.recorder",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.recorder",
        "short" : "𝗔𝗗𝗗𝗜𝗧𝗜𝗢𝗡𝗔𝗟 𝗨𝗦𝗖𝗗𝗜: Who recorded the condition",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  }
}

```
