# Lipemic Serum Specimen Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Lipemic Serum Specimen Example**

## Example Specimen: Lipemic Serum Specimen Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Specimen Profileversion: null8.0.1)](StructureDefinition-us-core-specimen.md)

**identifier**: `http://acme.com/labs/accession-ids`/20241105-00124

**accessionIdentifier**: `http://acme.com/labs/accession-ids`/20241105-00124

**type**: Serum sample

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

### Containers

| | |
| :--- | :--- |
| - | **Type** |
| * | Serum Separator Tube |

**condition**: Lipemic



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "example-serum-lipemic",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-specimen|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://acme.com/labs/accession-ids",
      "value" : "20241105-00124"
    }
  ],
  "accessionIdentifier" : {
    "system" : "http://acme.com/labs/accession-ids",
    "value" : "20241105-00124"
  },
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "119364003",
        "display" : "Serum sample"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0487",
        "code" : "SER",
        "display" : "Serum"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "container" : [
    {
      "type" : {
        "text" : "Serum Separator Tube"
      }
    }
  ],
  "condition" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "118127007",
          "display" : "Specimen lipemic"
        }
      ],
      "text" : "Lipemic"
    }
  ]
}

```
