# ServiceRequest Food Pantry Referral Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest Food Pantry Referral Example**

## Example ServiceRequest: ServiceRequest Food Pantry Referral Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core ServiceRequest Profileversion: null8.0.1)](StructureDefinition-us-core-servicerequest.md)

**status**: Active

**intent**: Order

**category**: Social Determinants Of Health/Social Service Procedure

**code**: Food Pantry Referral

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**occurrence**: 2021-11-20

**authoredOn**: 2021-11-12 10:59:38-0800

**requester**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "foodpantry-referral",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|8.0.1"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        },
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "410606002",
          "display" : "Social service procedure"
        }
      ],
      "text" : "Social Determinants Of Health/Social Service Procedure"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "467771000124109",
        "display" : "Assistance with application for food pantry program"
      }
    ],
    "text" : "Food Pantry Referral"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "occurrenceDateTime" : "2021-11-20",
  "authoredOn" : "2021-11-12T10:59:38-08:00",
  "requester" : {
    "reference" : "Practitioner/practitioner-1"
  }
}

```
