# ServiceRequest Chest XRay Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest Chest XRay Example**

## Example ServiceRequest: ServiceRequest Chest XRay Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core ServiceRequest Profileversion: null8.0.1)](StructureDefinition-us-core-servicerequest.md)

**status**: Active

**intent**: Order

**category**: Imaging Order

**code**: Portable XR Chest Views

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: [inpatient encounter](Encounter-1036.md)

**occurrence**: 2024-10-13

**authoredOn**: 2024-10-13 10:59:38-0800

**requester**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**reasonCode**: Bicycle accident



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "chest-xray",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|8.0.1"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "363679005",
          "display" : "Imaging (procedure)"
        }
      ],
      "text" : "Imaging Order"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "30746-2",
        "display" : "Portable XR Chest Views"
      }
    ],
    "text" : "Portable XR Chest Views"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/1036",
    "display" : "inpatient encounter"
  },
  "occurrenceDateTime" : "2024-10-13",
  "authoredOn" : "2024-10-13T10:59:38-08:00",
  "requester" : {
    "reference" : "Practitioner/practitioner-1"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "386663009",
          "display" : "Bicycle accident (event)"
        }
      ],
      "text" : "Bicycle accident"
    }
  ]
}

```
