# ServiceRequest CBC Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest CBC Example**

## Example ServiceRequest: ServiceRequest CBC Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core ServiceRequest Profileversion: null8.0.1)](StructureDefinition-us-core-servicerequest.md)

**status**: Active

**intent**: Order

**category**: Laboratory Order

**code**: CBC

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: [Office Visit](Encounter-example-1.md)

**authoredOn**: 2024-10-13 10:59:38-0800

**requester**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**reasonCode**: Vegan's anemia



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "cbc",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|8.0.1"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "108252007",
          "display" : "Laboratory procedure (procedure)"
        }
      ],
      "text" : "Laboratory Order"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "58410-2",
        "display" : "CBC panel - Blood by Automated count"
      }
    ],
    "text" : "CBC"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "authoredOn" : "2024-10-13T10:59:38-08:00",
  "requester" : {
    "reference" : "Practitioner/practitioner-1"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "234360003",
          "display" : "Vegan's anemia (disorder)"
        }
      ],
      "text" : "Vegan's anemia"
    }
  ]
}

```
