# USCoreObservationCode - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **USCoreObservationCode**

## SearchParameter: USCoreObservationCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-code | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreObservationCode |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.40.69 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
**The code of the observation type**
NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements: 
* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
 
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. 

**id** us-core-observation-code

**url** : **http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-code** 

**name** : USCoreObservationCode

**derivedFrom** : http://hl7.org/fhir/SearchParameter/clinical-code

**status** : active

**date** : 11/17/2024

**publisher** : HL7 International - Cross-Group Projects

**contact** : http://www.hl7.org/Special/committees/cgp

**jurisdiction** : United States of America (the) (Details : {urn:iso:std:iso:3166 code 'US' = 'United States of America', given as 'United States of America (the)'}) 

**code** : `code` 

**base** :Observation

**type** : token

**expression** : `Observation.code` 

**xpath** : `f:AllergyIntolerance/f:code|f:AllergyIntolerance/f:reaction/f:substance|f:Condition/f:code|f:DeviceRequest/f:codeCodeableConcept|f:DiagnosticReport/f:code|f:FamilyMemberHistory/f:condition/f:code|f:List/f:code|f:Medication/f:code|f:MedicationAdministration/f:medicationCodeableConcept|f:MedicationDispense/f:medicationCodeableConcept|f:MedicationRequest/f:medicationCodeableConcept|f:MedicationStatement/f:medicationCodeableConcept|f:Observation/f:code|f:Procedure/f:code|f:ServiceRequest/f:code` 

**xpathUsage** : normal

**multipleOr** : True (Conformance Expectation = SHOULD)

**multipleAnd** : True ( Conformance Expectation = MAY)



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "us-core-observation-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-code",
  "version" : "8.0.1",
  "name" : "USCoreObservationCode",
  "derivedFrom" : "http://hl7.org/fhir/SearchParameter/clinical-code",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-11-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "**The code of the observation type**  \nNOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the [Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation) to define additional expectations for the following SearchParameter elements:\n- `multipleAnd`\n- `multipleOr`\n- `comparator`\n- `modifier`\n- `chain`\n\nIt **SHALL NOT** be used as a search parameter for search. Servers and Clients **SHOULD** use the standard FHIR SearchParameter.\n",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "code" : "code",
  "base" : ["Observation"],
  "type" : "token",
  "expression" : "Observation.code",
  "xpathUsage" : "normal",
  "multipleOr" : true,
  "_multipleOr" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "SHOULD"
      }
    ]
  },
  "multipleAnd" : true,
  "_multipleAnd" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  }
}

```
