# Questionnaire Hunger Vital Sign (HVS) Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Questionnaire Hunger Vital Sign (HVS) Example**

## Questionnaire: Questionnaire Hunger Vital Sign (HVS) Example (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/Questionnaire/hunger-vital-sign-example | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HungerVitalSignExample |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.35.4 | |
| **Copyright/Legal**: This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. Copyright © 2010 Dr. Erin Hager and Dr. Anna Quigg and the Children's HealthWatch research team (http://www.childrenshealthwatch.org) used with permission. | |



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "hunger-vital-sign-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire"
    ]
  },
  "url" : "http://hl7.org/fhir/us/core/Questionnaire/hunger-vital-sign-example",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.35.4"
    }
  ],
  "version" : "8.0.1",
  "name" : "HungerVitalSignExample",
  "title" : "Hunger Vital Sign Example",
  "status" : "active",
  "experimental" : true,
  "subjectType" : ["Patient"],
  "date" : "2023-03-31",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license.  Copyright © 2010 Dr. Erin Hager and Dr. Anna Quigg and the Children's HealthWatch research team (http://www.childrenshealthwatch.org) used with permission.",
  "code" : [
    {
      "system" : "http://loinc.org",
      "code" : "88121-9",
      "display" : "Hunger Vital Sign [HVS]"
    }
  ],
  "item" : [
    {
      "linkId" : "/88122-7",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "88122-7",
          "display" : "Within the past 12 months we worried whether our food would run out before we got money to buy more"
        }
      ],
      "text" : "Within the past 12 months we worried whether our food would run out before we got money to buy more",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA28397-0",
            "display" : "Often true"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6729-3",
            "display" : "Sometimes true"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA28398-8",
            "display" : "Never true"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA15775-2",
            "display" : "Don't know/refused"
          }
        }
      ]
    },
    {
      "linkId" : "/88123-5",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "88123-5",
          "display" : "Within the past 12 months the food we bought just didn't last and we didn't have money to get more"
        }
      ],
      "text" : "Within the past 12 months the food we bought just didn't last and we didn't have money to get more",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA28397-0",
            "display" : "Often true"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6729-3",
            "display" : "Sometimes true"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA28398-8",
            "display" : "Never true"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA15775-2",
            "display" : "Don't know/refused"
          }
        }
      ]
    },
    {
      "linkId" : "/88124-3",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "88124-3",
          "display" : "Food insecurity risk [HVS]"
        }
      ],
      "text" : "Food insecurity risk",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA19952-3",
            "display" : "At risk"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA19983-8",
            "display" : "No risk"
          }
        }
      ],
      "item" : [
        {
          "linkId" : "/88124-3-help",
          "text" : "An answer of \"often true\" or \"sometimes true\" to either or both of the Hunger Vital Sign™ questions identifies a patient as at risk for food insecurity (FI).",
          "type" : "display"
        }
      ]
    }
  ]
}

```
