# Tobacco, Alcohol, Prescription medications, and other Substance use screen (TAPS) Questionnaire Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Tobacco, Alcohol, Prescription medications, and other Substance use screen (TAPS) Questionnaire Example**

## Questionnaire: Tobacco, Alcohol, Prescription medications, and other Substance use screen (TAPS) Questionnaire Example (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/Questionnaire/TAPS | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:TAPS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.35.2 | |
| **Copyright/Legal**: This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. The TAPS Tool was developed by the National Institute on Drug Abuse (NIDA) https://nida.nih.gov. As a federally funded (NIH) tool, the TAPS-1 is considered public domain in the U.S | |



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "TAPS",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire"
    ]
  },
  "url" : "http://hl7.org/fhir/us/core/Questionnaire/TAPS",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.35.2"
    }
  ],
  "version" : "8.0.1",
  "name" : "TAPS",
  "title" : "Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS]",
  "status" : "active",
  "experimental" : true,
  "subjectType" : ["Patient"],
  "date" : "2023-08-14",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. The TAPS Tool was developed by the National Institute on Drug Abuse (NIDA) https://nida.nih.gov. As a federally funded (NIH) tool, the TAPS-1 is considered public domain in the U.S",
  "code" : [
    {
      "system" : "http://loinc.org",
      "code" : "96841-2",
      "display" : "Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS]"
    }
  ],
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "drop-down",
                "display" : "Drop down"
              }
            ],
            "text" : "Drop down"
          }
        }
      ],
      "linkId" : "/96842-0",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "96842-0",
          "display" : "How often have you used any tobacco product in past 12 months"
        }
      ],
      "text" : "How often have you used any tobacco product in past 12 months",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18934-2",
            "display" : "Daily or almost daily"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18891-4",
            "display" : "Weekly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18876-5",
            "display" : "Monthly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18933-4",
            "display" : "Less than monthly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6270-8",
            "display" : "Never"
          }
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "drop-down",
                "display" : "Drop down"
              }
            ],
            "text" : "Drop down"
          }
        }
      ],
      "linkId" : "/88037-7",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "88037-7",
          "display" : "How often have you had five or more drinks in one day during the past year [Reported]"
        }
      ],
      "text" : "How often have you had five or more drinks in one day during the past year [Reported]",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18934-2",
            "display" : "Daily or almost daily"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18891-4",
            "display" : "Weekly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18876-5",
            "display" : "Monthly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18933-4",
            "display" : "Less than monthly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6270-8",
            "display" : "Never"
          }
        }
      ],
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "help",
                    "display" : "Help-Button"
                  }
                ],
                "text" : "Help-Button"
              }
            }
          ],
          "linkId" : "/88037-7-help",
          "text" : "Some measures (like electronic Clinical Quality Measure (eCQM) used by CMS) define \"risky drinker\" differently based on sex: 4 or more drinks per day for women and 5 or more drinks per day for men. The LOINC for 4 or more drinks per day is [LOINC: 75889-6].",
          "type" : "display"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "drop-down",
                "display" : "Drop down"
              }
            ],
            "text" : "Drop down"
          }
        }
      ],
      "linkId" : "/75889-6",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "75889-6",
          "display" : "How often have you had four or more drinks in one day during the past year [Reported]"
        }
      ],
      "text" : "How often have you had four or more drinks in one day during the past year [Reported]",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18934-2",
            "display" : "Daily or almost daily"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18891-4",
            "display" : "Weekly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18876-5",
            "display" : "Monthly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18933-4",
            "display" : "Less than monthly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6270-8",
            "display" : "Never"
          }
        }
      ],
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "help",
                    "display" : "Help-Button"
                  }
                ],
                "text" : "Help-Button"
              }
            }
          ],
          "linkId" : "/75889-6-help",
          "text" : "A question asked to determine if the patient is considered a 'risky drinker'. This term was created for, but not limited in use to, an electronic Clinical Quality Measure (eCQM) to be used in the CMS EHR Incentive Program for Meaningful Use. The eCQM allows for multiple ways to screen for alcohol misuse, including AUDIT-C [LOINC: 75626-2] or one of two questions that assess whether the patient consumes alcohol [LOINC: 75855-7] and the frequency of heavy drinking days (this LOINC). The LOINC for five (5) or more drinks per day is [LOINC: 88037-7].",
          "type" : "display"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "drop-down",
                "display" : "Drop down"
              }
            ],
            "text" : "Drop down"
          }
        }
      ],
      "linkId" : "/96843-8",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "96843-8",
          "display" : "How often have you used illegal or recreational drugs in past 12 months"
        }
      ],
      "text" : "How often have you used illegal or recreational drugs in past 12 months",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18934-2",
            "display" : "Daily or almost daily"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18891-4",
            "display" : "Weekly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18876-5",
            "display" : "Monthly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18933-4",
            "display" : "Less than monthly"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6270-8",
            "display" : "Never"
          }
        }
      ]
    },
    {
      "linkId" : "/96844-6",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "96844-6",
          "display" : "How often have you used any prescription medications just for the feeling, more than prescribed or that were not prescribed for you in past 12 months [TAPS]"
        }
      ],
      "text" : "How often have you used any prescription medications just for the feeling, more than prescribed or that were not prescribed for you in past 12 months [TAPS]",
      "type" : "string",
      "required" : false
    }
  ]
}

```
