# Procedure Defibrillator Implant Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure Defibrillator Implant Example**

## Example Procedure: Procedure Defibrillator Implant Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Procedure Profileversion: null8.0.1)](StructureDefinition-us-core-procedure.md)

**identifier**: [Uniform Resource Identifier (URI)](http://terminology.hl7.org/5.5.0/NamingSystem-uri.html)/urn:uuid:b2a737f2-2fdb-49c1-b097-dac173d07aff

**status**: Completed

**code**: Insertion or replacement of permanent implantable defibrillator system with transvenous lead(s), single or dual chamber

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**encounter**: [Office Visit](Encounter-example-1.md)

**performed**: 2019-03-26 12:55:26-0700 --> 2019-03-26 13:25:26-0700

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Practitioner Ronald Bone](Practitioner-practitioner-1.md) |

**reasonCode**: Ventricular fibrillation

### FocalDevices

| | |
| :--- | :--- |
| - | **Manipulated** |
| * | [Device: status = active; manufacturer = ACME Biomedical; expirationDate = 2022-01-01; lotNumber = M320; serialNumber = AC221; modelNumber = 1.0; type = Defibrillator, device](Device-udi-2.md) |



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "defib-implant",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:uuid:b2a737f2-2fdb-49c1-b097-dac173d07aff"
    }
  ],
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://www.ama-assn.org/go/cpt",
        "code" : "33249"
      }
    ],
    "text" : "Insertion or replacement of permanent implantable defibrillator system with transvenous lead(s), single or dual chamber"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "performedPeriod" : {
    "start" : "2019-03-26T12:55:26-07:00",
    "end" : "2019-03-26T13:25:26-07:00"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/practitioner-1"
      }
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/sid/icd-10-cm",
          "code" : "I49.01",
          "display" : "Ventricular fibrillation"
        }
      ],
      "text" : "Ventricular fibrillation"
    }
  ],
  "focalDevice" : [
    {
      "manipulated" : {
        "reference" : "Device/udi-2"
      }
    }
  ]
}

```
