# Practitioner Pharmacist Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner Pharmacist Example**

## Example Practitioner: Practitioner Pharmacist Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Practitioner Profileversion: null8.0.1)](StructureDefinition-us-core-practitioner.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/3412549073

**name**: Dispenser Douglas 

**address**: 1015 HEALTHCARE DR AMHERST MA 01002 (work)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "practitioner-pharmacist",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "3412549073"
    }
  ],
  "name" : [
    {
      "family" : "Douglas",
      "given" : ["Dispenser"],
      "prefix" : ["PharmD"]
    }
  ],
  "address" : [
    {
      "use" : "work",
      "line" : ["1015 HEALTHCARE DR"],
      "city" : "AMHERST",
      "state" : "MA",
      "postalCode" : "01002"
    }
  ]
}

```
