# Organization Holy Healthcare Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization Holy Healthcare Example**

## Example Organization: Organization Holy Healthcare Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Organization Profileversion: null8.0.1)](StructureDefinition-us-core-organization.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/1234567893

**active**: true

**type**: Provider

**name**: Holy Healthcare

**telecom**: ph: (+1) 555-555-5555, [hq@holyhealthcare.org](mailto:hq@holyhealthcare.org)

**address**: 100 MANAGING ORGANIZATION AVE Amherst MA 01002 USA 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "holy-healthcare",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1234567893"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "prov"
        }
      ],
      "text" : "Provider"
    }
  ],
  "name" : "Holy Healthcare",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(+1) 555-555-5555"
    },
    {
      "system" : "email",
      "value" : "hq@holyhealthcare.org"
    }
  ],
  "address" : [
    {
      "line" : ["100 MANAGING ORGANIZATION AVE"],
      "city" : "Amherst",
      "state" : "MA",
      "postalCode" : "01002",
      "country" : "USA"
    }
  ]
}

```
