# Organization Acme Payer Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization Acme Payer Example**

## Example Organization: Organization Acme Payer Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Organization Profileversion: null8.0.1)](StructureDefinition-us-core-organization.md)

**identifier**: [National Association of Insurance Commissioners (NAIC) Company Codes](http://terminology.hl7.org/7.0.0/NamingSystem-NAICCompanyCodes.html)/55555

**active**: true

**type**: Payer

**name**: Acme Health Plan

**telecom**: ph: (+1) 555-555-5555, [hq@acme.org](mailto:hq@acme.org)

**address**: 100 INSURANCE AVE AMHERST MA 01002 USA 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "acme-payer",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:oid:2.16.840.1.113883.6.300",
      "value" : "55555"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "pay"
        }
      ],
      "text" : "Payer"
    }
  ],
  "name" : "Acme Health Plan",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(+1) 555-555-5555"
    },
    {
      "system" : "email",
      "value" : "hq@acme.org"
    }
  ],
  "address" : [
    {
      "line" : ["100 INSURANCE AVE"],
      "city" : "AMHERST",
      "state" : "MA",
      "postalCode" : "01002",
      "country" : "USA"
    }
  ]
}

```
