# Organization Acme Lab Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization Acme Lab Example**

## Example Organization: Organization Acme Lab Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Organization Profileversion: null8.0.1)](StructureDefinition-us-core-organization.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/1144221847, [Clinical Laboratory Improvement Amendments](http://terminology.hl7.org/5.5.0/NamingSystem-CLIA.html)/12D4567890

**active**: true

**type**: Healthcare Provider

**name**: Acme Labs

**telecom**: ph: (+1) 734-677-7777, [hq@acme.org](mailto:hq@acme.org)

**address**: 3300 WASHTENAW AVE STE 227 AMHERST MA 01002 USA 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "acme-lab",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1144221847"
    },
    {
      "system" : "urn:oid:2.16.840.1.113883.4.7",
      "value" : "12D4567890"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "prov",
          "display" : "Healthcare Provider"
        }
      ]
    }
  ],
  "name" : "Acme Labs",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(+1) 734-677-7777"
    },
    {
      "system" : "email",
      "value" : "hq@acme.org"
    }
  ],
  "address" : [
    {
      "line" : ["3300 WASHTENAW AVE STE 227"],
      "city" : "AMHERST",
      "state" : "MA",
      "postalCode" : "01002",
      "country" : "USA"
    }
  ]
}

```
