# Xray Chest Findings Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xray Chest Findings Example**

## Example Observation: Xray Chest Findings Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Clinical Result Profileversion: null8.0.1)](StructureDefinition-us-core-observation-clinical-result.md)

**status**: Final

**category**: Imaging

**code**: Findings

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: ER Visit

**effective**: 2019-02-03 19:43:30+0000

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: LINES AND TUBES: None.\n LUNGS AND PLEURA:\n Clear lungs. Normal pulmonary vascularity.\n No pleural effusion.\n No pneumothorax.\n HEART, MEDIASTINUM AND HILA:\n Heart is normal in size.\n Normal mediastinal and hilar contour.\n BONES AND SOFT TISSUES:\n No acute abnormality.\n



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "xray-chest-findings",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "imaging",
          "display" : "Imaging"
        }
      ],
      "text" : "Imaging"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "18782-3",
        "display" : "Radiology Study observation (narrative)"
      }
    ],
    "text" : "Findings"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "display" : "ER Visit"
  },
  "effectiveDateTime" : "2019-02-03T19:43:30+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueString" : "LINES AND TUBES: None.\\n LUNGS AND PLEURA:\\n Clear lungs. Normal pulmonary vascularity.\\n No pleural effusion.\\n No pneumothorax.\\n HEART, MEDIASTINUM AND HILA:\\n Heart is normal in size.\\n Normal mediastinal and hilar contour.\\n BONES AND SOFT TISSUES:\\n No acute abnormality.\\n"
}

```
