# Temperature Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Temperature Example**

## Example Observation: Temperature Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Body Temperature Profileversion: null8.0.1)](StructureDefinition-us-core-body-temperature.md)

**status**: Final

**category**: Vital Signs

**code**: temperature

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: GP Visit

**effective**: 1999-07-02

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 36.55556 Cel(Details: UCUM codeCel = 'Cel')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "temperature",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-temperature|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8310-5",
        "display" : "Body temperature"
      }
    ],
    "text" : "temperature"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "display" : "GP Visit"
  },
  "effectiveDateTime" : "1999-07-02",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 36.55556,
    "unit" : "Cel",
    "system" : "http://unitsofmeasure.org",
    "code" : "Cel"
  }
}

```
