# Simple Observation SDOH Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Simple Observation SDOH Example**

## Example Observation: Simple Observation SDOH Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Simple Observation Profileversion: null8.0.1)](StructureDefinition-us-core-simple-observation.md)

**status**: Final

**category**: SDOH

**code**: Transport too expensive

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2021-05-10 21:56:54+0000

**performer**: [Dr. Ronald Bone](Practitioner-practitioner-1.md)

**value**: true



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "simple-observation-sdoh",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "160695008",
        "display" : "Transport too expensive"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2021-05-10T21:56:54.671Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr. Ronald Bone"
    }
  ],
  "valueBoolean" : true
}

```
