# Simple Observation Disability Status Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Simple Observation Disability Status Example**

## Example Observation: Simple Observation Disability Status Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Simple Observation Profileversion: null8.0.1)](StructureDefinition-us-core-simple-observation.md)

**status**: Final

**category**: Disability Status

**code**: Depression severity

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-11-27 19:22:02+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**value**: Moderate

**derivedFrom**: [Observation PHQ-9 quick depression assessment panel [Reported.PHQ]](Observation-PHQ9-panel-example-44249-1.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "simple-observation-disability-status",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "disability-status",
          "display" : "Disability Status"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "94023-9",
        "display" : "Depression severity"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-11-27T19:22:02Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA6751-7",
        "display" : "Moderate"
      }
    ],
    "text" : "Moderate"
  },
  "derivedFrom" : [
    {
      "reference" : "Observation/PHQ9-panel-example-44249-1"
    }
  ]
}

```
