# Observation SatO2 FiO2 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation SatO2 FiO2 Example**

## Example Observation: Observation SatO2 FiO2 Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Pulse Oximetry Profileversion: null8.0.1)](StructureDefinition-us-core-pulse-oximetry.md)

**identifier**: `http://example.org/FHIR/observation/identifiers`/o1223435-10

**status**: Final

**category**: Vital Signs

**code**: Oxygen saturation in Arterial blood

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2014-12-05 09:30:10+0100

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 95 %(Details: UCUM code% = '%')

**interpretation**: Normal

**device**: Acme Pulse Oximeter 2000

### ReferenceRanges

| | | |
| :--- | :--- | :--- |
| - | **Low** | **High** |
| * | 90 %(Details: UCUM code% = '%') | 99 %(Details: UCUM code% = '%') |

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Inhaled oxygen flow rate | 6 liters/min(Details: UCUM codeL/min = 'L/min') |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "satO2-fiO2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-pulse-oximetry|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/FHIR/observation/identifiers",
      "value" : "o1223435-10"
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "2708-6",
        "display" : "Oxygen saturation in Arterial blood"
      },
      {
        "system" : "http://loinc.org",
        "code" : "59408-5",
        "display" : "Oxygen saturation in Arterial blood by Pulse oximetry"
      },
      {
        "system" : "urn:iso:std:iso:11073:10101",
        "code" : "150456",
        "display" : "MDC_PULS_OXIM_SAT_O2"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2014-12-05T09:30:10+01:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 95,
    "unit" : "%",
    "system" : "http://unitsofmeasure.org",
    "code" : "%"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ],
      "text" : "Normal"
    }
  ],
  "device" : {
    "display" : "Acme Pulse Oximeter 2000"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 90,
        "unit" : "%",
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      },
      "high" : {
        "value" : 99,
        "unit" : "%",
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      }
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "3151-8",
            "display" : "Inhaled oxygen flow rate"
          }
        ],
        "text" : "Inhaled oxygen flow rate"
      },
      "valueQuantity" : {
        "value" : 6,
        "unit" : "liters/min",
        "system" : "http://unitsofmeasure.org",
        "code" : "L/min"
      }
    }
  ]
}

```
