# Pregnancy Status Observation Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pregnancy Status Observation Example**

## Example Observation: Pregnancy Status Observation Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Pregnancy Status Profileversion: null8.0.1)](StructureDefinition-us-core-observation-pregnancystatus.md)

**status**: Final

**category**: Social History

**code**: Pregnancy Status

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2022-08-24 10:39:52+0000

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: Pregnant



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "pregnancy-status",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancystatus|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "82810-3",
        "display" : "Pregnancy status"
      }
    ],
    "text" : "Pregnancy Status"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2022-08-24T10:39:52+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "77386006",
        "display" : "Pregnant"
      }
    ],
    "text" : "Pregnant"
  }
}

```
